/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.TemplateApplyScopeServiceHelper;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.plugin.AfterTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.core.validate.AbstractTemplateValidator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.MultiValueMap;

public class TemplateValidator
extends AbstractTemplateValidator {
    private static final Log LOGGER = LogFactory.getLog(TemplateValidator.class);
    private final String templateNumber;
    private final String firstSheetName;
    private final String pageMainEntityNum;
    private List<HRImportPlugin> templatePlugins;
    private String extParam;
    private DynamicObject tpl;

    public TemplateValidator(String firstSheetName, String templateNumber, List<HRImportPlugin> templatePlugins, String extParam, DynamicObject tpl, String pageMainEntityNum) {
        this.firstSheetName = firstSheetName;
        this.templateNumber = templateNumber;
        this.templatePlugins = templatePlugins;
        this.extParam = extParam;
        this.tpl = tpl;
        this.pageMainEntityNum = pageMainEntityNum;
    }

    @ExcludeFromJacocoGeneratedReport
    public String validate(MultiValueMap<String, Map<Integer, String>> data, DynamicObject tplDy) {
        DynamicObject dynamicObject;
        QFilter qFilter;
        StringBuilder errMsg = new StringBuilder();
        if (tplDy == null) {
            this.addErrMsg("0", errMsg, this.firstSheetName, 1, Lists.newArrayList((Object[])new String[]{this.templateNumber}));
            return errMsg.toString();
        }
        if (!tplDy.getBoolean("enable")) {
            this.addErrMsg("-6", errMsg, this.firstSheetName, 1, Lists.newArrayList((Object[])new String[]{this.templateNumber}));
            return errMsg.toString();
        }
        Map tplFieldConfig = HIESUtil.getTplFieldConfig((DynamicObject)this.tpl);
        if (!this.pageMainEntityNum.equals(tplDy.getString("entity.number"))) {
            ArrayList errInfo = Lists.newArrayList();
            errInfo.add(this.templateNumber);
            this.addErrMsg("-3", errMsg, "", 0, errInfo);
            return errMsg.toString();
        }
        if (!"full".equalsIgnoreCase(tplDy.getString("source")) && (qFilter = TemplateApplyScopeServiceHelper.getCurrentUserTemplate()) != null && (dynamicObject = HRBaseServiceHelper.create((String)"hies_diaetplconf").queryOriginalOne("id", qFilter.and(new QFilter("number", "=", (Object)this.templateNumber)))) == null) {
            ArrayList errInfo = Lists.newArrayList();
            errInfo.add(this.templateNumber);
            this.addErrMsg("-4", errMsg, "", 0, errInfo);
            return errMsg.toString();
        }
        DynamicObjectCollection fieldEntryCollection = tplDy.getDynamicObjectCollection("tpltreeentryentity");
        Map<Long, String> idToField = fieldEntryCollection.stream().filter(field -> StringUtils.isNotBlank((CharSequence)field.getString("fieldnumber"))).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("fieldnumber"), (k1, k2) -> k1));
        Map<String, Set<String>> entityToNonField = fieldEntryCollection.stream().filter(field -> field.getBoolean("isfield") && field.getBoolean("isimport")).collect(Collectors.groupingBy(dy -> dy.getString("childentity"), Collectors.mapping(nonFieldDy -> idToField.getOrDefault(nonFieldDy.getLong("pid"), nonFieldDy.getString("childentity")), Collectors.toSet())));
        LOGGER.info("TemplateValidator.validate(),entityToNonField:{}", entityToNonField);
        Map<String, Set<String>> entityToMustFillNonField = fieldEntryCollection.stream().filter(field -> field.getBoolean("isfield") && field.getBoolean("isimport") && field.getBoolean("ismustinput")).collect(Collectors.groupingBy(dy -> dy.getString("childentity"), Collectors.mapping(nonFieldDy -> idToField.getOrDefault(nonFieldDy.getLong("pid"), nonFieldDy.getString("childentity")), Collectors.toSet())));
        LOGGER.info("TemplateValidator.validate(),entityToMustFillNonField:{}", entityToMustFillNonField);
        Map<String, List<DynamicObject>> entityToFields = fieldEntryCollection.stream().filter(field -> field.getBoolean("isfield")).collect(Collectors.groupingBy(dy -> dy.getString("childentity")));
        DynamicObjectCollection entityRelationCollection = tplDy.getDynamicObjectCollection("entityrelation");
        HashSet relationFieldList = Sets.newHashSetWithExpectedSize((int)(entityRelationCollection.size() * 2));
        entityRelationCollection.forEach(dy -> {
            if (!StringUtils.isBlank((CharSequence)dy.getString("relationleftprop"))) {
                relationFieldList.add(dy.getString("relationleftprop"));
            }
            if (!StringUtils.isBlank((CharSequence)dy.getString("relationrightprop"))) {
                relationFieldList.add(dy.getString("relationrightprop"));
            }
        });
        Map<String, List<String>> relationFieldGroup = relationFieldList.stream().collect(Collectors.groupingBy(key -> key.substring(0, key.indexOf(46))));
        HashMap entityFields = Maps.newHashMapWithExpectedSize((int)6);
        for (Map.Entry sheetDatas : data.entrySet()) {
            List sheetData = (List)sheetDatas.getValue();
            Map curSheetEntityMap = (Map)sheetData.get(0);
            List<String> curSheetEntityList = this.getCurSheetEntityList(curSheetEntityMap);
            String curEntityNumber = curSheetEntityList.get(0);
            Collection sheetFieldCollection = ((Map)sheetData.get(3)).values();
            entityFields.put(curEntityNumber, sheetFieldCollection);
        }
        HashMap ignoreValidateMap = Maps.newHashMapWithExpectedSize((int)6);
        String errMsg0 = this.fireBeforeTemplateValidationEvent(entityFields, ignoreValidateMap);
        if (StringUtils.isNotEmpty((CharSequence)errMsg0)) {
            return errMsg0;
        }
        boolean nonTemplateFlag = true;
        for (Map.Entry sheetDatas : data.entrySet()) {
            boolean flag = this.validateRowData(tplDy, errMsg, entityToNonField, entityToMustFillNonField, entityToFields, relationFieldGroup, sheetDatas, ignoreValidateMap, tplFieldConfig);
            if (!nonTemplateFlag || flag) continue;
            nonTemplateFlag = false;
        }
        if (nonTemplateFlag) {
            ArrayList errInfo = Lists.newArrayList();
            errInfo.add("error");
            this.addErrMsg("-1", errMsg, StringUtils.join((Iterable)data.keySet(), (String)","), 0, errInfo);
        }
        return this.fireAfterTemplateValidateEvent(entityFields, errMsg.toString());
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean validateRowData(DynamicObject tplDy, StringBuilder errMsg, Map<String, Set<String>> entityToNonField, Map<String, Set<String>> entityToMustFillNonField, Map<String, List<DynamicObject>> entityToFields, Map<String, List<String>> relationFieldGroup, Map.Entry<String, List<Map<Integer, String>>> sheetDatas, Map<String, List<String>> ignoreValidateMap, Map<String, Map<String, DynamicObject>> tplFieldConfig) {
        ArrayList errInfo = Lists.newArrayList();
        String sheetName = sheetDatas.getKey();
        List<Map<Integer, String>> sheetData = sheetDatas.getValue();
        Map<Integer, String> curSheetEntityMap = sheetData.get(0);
        List<String> curSheetEntityList = this.getCurSheetEntityList(curSheetEntityMap);
        LOGGER.info("TemplateValidator.validateRowData(),curSheetEntityList:{}", curSheetEntityList);
        String curEntityNumber = curSheetEntityList.get(0);
        boolean isFirstSheet = curEntityNumber.equalsIgnoreCase(tplDy.getString("entity.number"));
        if (sheetData.size() < 4) {
            errInfo.add(sheetName);
            this.addErrMsg("-2", errMsg, sheetName, isFirstSheet ? 6 : 5, errInfo);
            return false;
        }
        Collection<String> sheetFieldCollection = sheetData.get(3).values();
        List ignoreValidateList = ignoreValidateMap.getOrDefault(curEntityNumber, new ArrayList());
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)curEntityNumber);
        Map allFields = mainType.getAllFields();
        boolean isLocalTemplate = "localupload".equalsIgnoreCase(this.tpl.getString("tplgenmode"));
        if (!"MESS".equalsIgnoreCase(tplDy.getString("entitytype"))) {
            List<String> relationField;
            List<String> importFieldList;
            boolean flag;
            Set<String> nonFields = entityToNonField.get(curEntityNumber);
            curSheetEntityList.forEach(entityNum -> {
                if (nonFields == null || !nonFields.contains(entityNum)) {
                    errInfo.add(entityNum);
                }
            });
            this.addErrMsg("1", errMsg, sheetName, isFirstSheet ? 2 : 1, errInfo);
            boolean bl = flag = errInfo.size() > 0;
            if (flag) {
                return false;
            }
            if (entityToMustFillNonField.get(curEntityNumber) != null && entityToMustFillNonField.get(curEntityNumber).size() > curSheetEntityList.size()) {
                entityToMustFillNonField.get(curEntityNumber).removeAll(curSheetEntityList);
                this.addErrMsg("11", errMsg, sheetName, isFirstSheet ? 2 : 1, (Collection<String>)entityToMustFillNonField.get(curEntityNumber));
                return false;
            }
            List bdFields = allFields.values().stream().filter(iDataEntityProperty -> iDataEntityProperty instanceof BasedataProp || iDataEntityProperty instanceof MulBasedataProp).collect(Collectors.toList());
            if (entityToFields.get(curEntityNumber) != null) {
                entityToFields.get(curEntityNumber).stream().filter(dy -> dy.getBoolean("ismustinput") && dy.getBoolean("isimport")).forEach(mustInputFieldDy -> {
                    String mustInputField = mustInputFieldDy.getString("fieldnumber");
                    IDataEntityProperty fieldProp = (IDataEntityProperty)allFields.get(mustInputField);
                    String bdFormat = mustInputFieldDy.getString("imptattr");
                    String fieldSuffix = this.getFieldSuffix(bdFormat, fieldProp);
                    if (this.hasMustFillFieldContains(fieldSuffix, sheetFieldCollection, mustInputField)) {
                        String mustInputFieldName = fieldProp.getDisplayName().getLocaleValue();
                        errInfo.add(mustInputField.concat(fieldSuffix).concat("\uff08").concat(mustInputFieldName).concat("\uff09"));
                    }
                });
                this.addErrMsg("2", errMsg, sheetName, isFirstSheet ? 5 : 4, errInfo);
            }
            if (null != (importFieldList = this.getImportFieldsList(entityToFields, curEntityNumber)) && !isLocalTemplate) {
                sheetFieldCollection.forEach(field -> {
                    if (ignoreValidateList.contains(field)) {
                        return;
                    }
                    String bdFormat = "";
                    DynamicObject fieldDy = (DynamicObject)((Map)tplFieldConfig.get(curEntityNumber)).get(MethodUtil.getLevelOneKey((String)field));
                    if (fieldDy != null) {
                        bdFormat = fieldDy.getString("imptattr");
                    }
                    if (this.hasReversalContains((Collection<String>)nonFields, bdFields, bdFormat, (Collection<String>)importFieldList, (String)field, (IDataEntityProperty)allFields.get(MethodUtil.getLevelOneKey((String)field)))) {
                        errInfo.add(field);
                    }
                });
                this.addErrMsg("3", errMsg, sheetName, isFirstSheet ? 5 : 4, errInfo);
            }
            if (null != (relationField = relationFieldGroup.get(curEntityNumber))) {
                relationField.forEach(field -> {
                    String fieldSuffix;
                    String replaceFirst = field.replaceFirst(curEntityNumber + ".", "");
                    IDataEntityProperty fieldProp = (IDataEntityProperty)allFields.get(replaceFirst);
                    String bdFormat = "";
                    DynamicObject fieldDy = (DynamicObject)((Map)tplFieldConfig.get(curEntityNumber)).get(MethodUtil.getLevelOneKey((String)field));
                    if (fieldDy != null) {
                        bdFormat = fieldDy.getString("imptattr");
                    }
                    if (this.hasMustFillFieldContains(fieldSuffix = this.getFieldSuffix(bdFormat, fieldProp), sheetFieldCollection, replaceFirst)) {
                        if (allFields.get(replaceFirst) == null) {
                            errInfo.add(replaceFirst);
                        } else {
                            String mustInputFieldName = ((IDataEntityProperty)allFields.get(replaceFirst)).getDisplayName().getLocaleValue();
                            errInfo.add(replaceFirst.concat("\uff08").concat(mustInputFieldName).concat("\uff09"));
                        }
                    }
                });
            }
            this.addErrMsg("4", errMsg, sheetName, isFirstSheet ? 5 : 4, errInfo);
        } else {
            ArrayList nonFieldsSet = Lists.newArrayListWithExpectedSize((int)16);
            String tempEntityNumber = curEntityNumber;
            for (String entityNum2 : curSheetEntityList) {
                if (entityToNonField.containsKey(entityNum2)) {
                    tempEntityNumber = entityNum2;
                    Set<String> set = entityToMustFillNonField.get(entityNum2);
                    if (set != null) {
                        nonFieldsSet.addAll((Collection)entityToMustFillNonField.get(entityNum2));
                    }
                    nonFieldsSet.remove(entityNum2);
                    continue;
                }
                if (entityToNonField.get(tempEntityNumber) == null || !entityToNonField.get(tempEntityNumber).contains(entityNum2)) {
                    errInfo.add(entityNum2);
                    continue;
                }
                nonFieldsSet.remove(entityNum2);
            }
            boolean flag = errInfo.size() > 0;
            this.addErrMsg("1", errMsg, sheetName, 2, errInfo);
            if (flag) {
                return false;
            }
            if (nonFieldsSet.size() > 0) {
                this.addErrMsg("11", errMsg, sheetName, isFirstSheet ? 2 : 1, nonFieldsSet);
                return false;
            }
            Map<String, Set<String>> importFieldsMap = this.getImportFieldsMap(entityToNonField, sheetData, curSheetEntityMap, curEntityNumber);
            entityToFields.forEach((key, value) -> {
                MainEntityType mainType2 = EntityMetadataCache.getDataEntityType((String)key);
                Map allFields2 = mainType2.getAllFields();
                value.stream().filter(dy -> dy.getBoolean("ismustinput") && dy.getBoolean("isimport")).forEach(field -> {
                    String mustInputField = field.getString("fieldnumber");
                    IDataEntityProperty fieldProp = (IDataEntityProperty)allFields2.get(mustInputField);
                    String bdFormat = field.getString("imptattr");
                    String fieldSuffix = this.getFieldSuffix(bdFormat, fieldProp);
                    if (this.hasMustFillFieldContains(fieldSuffix, (Collection)importFieldsMap.get(key), mustInputField)) {
                        errInfo.add(mustInputField);
                    }
                });
            });
            this.addErrMsg("2", errMsg, sheetName, 5, errInfo);
            importFieldsMap.forEach((key, value) -> {
                if (entityToNonField.get(key) == null || isLocalTemplate) {
                    return;
                }
                List<IDataEntityProperty> bdFields = this.getBDFields((String)key);
                List<String> collect = this.getImportFieldsList(entityToFields, (String)key);
                if (collect == null) {
                    return;
                }
                value.forEach(field -> {
                    if (ignoreValidateList.contains(field)) {
                        return;
                    }
                    String bdFormat = "";
                    DynamicObject fieldDy = (DynamicObject)((Map)tplFieldConfig.get(curEntityNumber)).get(MethodUtil.getLevelOneKey((String)field));
                    if (fieldDy != null) {
                        bdFormat = fieldDy.getString("imptattr");
                    }
                    if (this.hasReversalContains((Collection)entityToNonField.get(key), bdFields, bdFormat, (Collection<String>)collect, (String)field, (IDataEntityProperty)allFields.get(MethodUtil.getLevelOneKey((String)field)))) {
                        errInfo.add(field);
                    }
                });
            });
            this.addErrMsg("3", errMsg, sheetName, 5, errInfo);
            relationFieldGroup.forEach((key, value) -> value.forEach(field -> {
                if (importFieldsMap.get(key) != null && !((Set)importFieldsMap.get(key)).contains(field.replaceFirst(key + ".", ""))) {
                    errInfo.add(field);
                }
            }));
            this.addErrMsg("4", errMsg, sheetName, 5, errInfo);
        }
        while (sheetData.get(sheetData.size() - 1).size() == 0) {
            sheetData.remove(sheetData.size() - 1);
        }
        return StringUtils.isBlank((CharSequence)errMsg) && (sheetData.size() <= 6 || sheetData.subList(6, sheetData.size()).stream().noneMatch(map -> map.size() > 0));
    }

    private List<String> getImportFieldsList(Map<String, List<DynamicObject>> entityToFields, String curEntityNumber) {
        if (entityToFields.get(curEntityNumber) == null) {
            return null;
        }
        return entityToFields.get(curEntityNumber).stream().filter(dy -> dy.getBoolean("isimport")).map(field -> field.getString("fieldnumber")).collect(Collectors.toList());
    }

    private List<String> getCurSheetEntityList(Map<Integer, String> curSheetEntityMap) {
        if (curSheetEntityMap == null) {
            return new ArrayList<String>();
        }
        ArrayList<Map.Entry<Integer, String>> toSort = new ArrayList<Map.Entry<Integer, String>>(curSheetEntityMap.entrySet());
        toSort.sort(Map.Entry.comparingByKey());
        ArrayList curSheetEntityList = Lists.newArrayListWithCapacity((int)curSheetEntityMap.size());
        for (Map.Entry entry : toSort) {
            String splitValue = HIESUtil.getSplitValue((String)((String)entry.getValue()));
            curSheetEntityList.add(splitValue);
        }
        return curSheetEntityList;
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, Set<String>> getImportFieldsMap(Map<String, Set<String>> entityToNonField, List<Map<Integer, String>> sheetData, Map<Integer, String> curSheetEntityMap, String curEntityNumber) {
        Map<Integer, String> sheetFieldRowData = sheetData.get(3);
        int colCount = Integer.parseInt(sheetData.get(5).get(0));
        HashMap<String, List> entityToColIndex = new HashMap<String, List>();
        ArrayList<Integer> colIndexRange = new ArrayList<Integer>(colCount);
        String lastEntity = curEntityNumber;
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            String curEntityNum = HIESUtil.getSplitValue((String)curSheetEntityMap.get(colIndex));
            if (entityToNonField.containsKey(curEntityNum)) {
                entityToColIndex.put(lastEntity, colIndexRange);
                lastEntity = curEntityNum;
                colIndexRange = new ArrayList(colCount - colIndex);
            }
            colIndexRange.add(colIndex);
        }
        entityToColIndex.put(lastEntity, colIndexRange);
        HashMap<String, Set<String>> importFieldsMap = new HashMap<String, Set<String>>();
        entityToColIndex.forEach((key, value) -> {
            HashSet set = new HashSet();
            value.forEach(ob -> set.add(sheetFieldRowData.get(ob)));
            set.remove(null);
            importFieldsMap.put((String)key, set);
        });
        return importFieldsMap;
    }

    private String fireBeforeTemplateValidationEvent(Map<String, Collection<String>> entityFields, Map<String, List<String>> ignoreValidateMap) {
        BeforeTemplateValidateEventArgs args = new BeforeTemplateValidateEventArgs(this.extParam);
        args.setEntityFields(entityFields);
        HRImpPluginEngine.fireImptPluginEvent(this.templatePlugins, "beforeTemplateValidate", (AbstractEventArgs)args);
        ignoreValidateMap.putAll(args.getIgnoreValidateMap() == null ? new HashMap() : args.getIgnoreValidateMap());
        return args.getErrorMsg();
    }

    private String fireAfterTemplateValidateEvent(Map<String, Collection<String>> entityFields, String errorMsg) {
        AfterTemplateValidateEventArgs args = new AfterTemplateValidateEventArgs(this.extParam);
        args.setEntityFields(entityFields);
        args.setErrorMsg(errorMsg);
        HRImpPluginEngine.fireImptPluginEvent(this.templatePlugins, "afterTemplateValidate", (AbstractEventArgs)args);
        return args.getErrorMsg();
    }
}

