/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate.dto;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.cache.EHcacheDiskCacheManager;
import kd.hr.hies.common.cache.NettyOutJVMHeapManager;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.dto.Pair;
import kd.hr.hies.common.util.TextCompressUtil;

public class BaseDataContainer {
    private static final Log LOGGER = LogFactory.getLog(BaseDataContainer.class);
    private ReentrantLock createLock = new ReentrantLock();
    private ConcurrentHashMap<String, DynamicObjectType> basedataSelectType;
    private ConcurrentHashMap<String, ConcurrentHashMap<Object, List<Object>>> basedataTable;
    private ConcurrentHashMap<String, ConcurrentHashMap<Object, Object>> basedataIdMap;
    private ConcurrentHashMap<String, ConcurrentHashMap<Object, Object>> refBillIdMap;
    private ConcurrentHashMap<Object, DynamicObject> existsEntityDyMap;
    private ConcurrentHashMap<String, Map<Object, Object>> validateFailedBillDataFieldVaues;
    private Map<String, List<Long>> permBUMap;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, Set<Long>>> dataRulePermBasedataTable;
    private ConcurrentHashMap<String, ConcurrentHashMap<Long, List<Long>>> controlledBDPermTable;
    private ConcurrentHashMap<String, Map<Object, Boolean>> mainOrgPerm;
    private ConcurrentHashMap<String, Long> adminDivisionMap;
    private AtomicInteger byteDyCount = new AtomicInteger(0);
    private AtomicInteger byteDyLength = new AtomicInteger(0);
    private AtomicInteger outJVMHeapCount = new AtomicInteger(0);
    private AtomicInteger diskCacheCount = new AtomicInteger(0);
    private int outJVMHeapUseSize;
    private NettyOutJVMHeapManager outJVMHeapManager;
    private EHcacheDiskCacheManager diskCacheManager;

    public BaseDataContainer() {
        this.basedataSelectType = new ConcurrentHashMap(16);
        this.basedataTable = new ConcurrentHashMap(16);
        this.basedataIdMap = new ConcurrentHashMap(16);
        this.refBillIdMap = new ConcurrentHashMap(16);
        this.permBUMap = Maps.newConcurrentMap();
        this.dataRulePermBasedataTable = new ConcurrentHashMap(16);
        this.controlledBDPermTable = new ConcurrentHashMap(16);
        this.existsEntityDyMap = new ConcurrentHashMap(16);
        this.validateFailedBillDataFieldVaues = new ConcurrentHashMap(16);
        this.mainOrgPerm = new ConcurrentHashMap(16);
        this.adminDivisionMap = new ConcurrentHashMap(16);
    }

    public Map<Object, List<DynamicObject>> getBaseDataDyMap(String entityNumber, String baseEntityId, String fieldId) {
        String key = entityNumber + "&" + baseEntityId + "&" + fieldId;
        ConcurrentHashMap<Object, List<Object>> map = this.basedataTable.get(key);
        if (ObjectUtils.isEmpty(map)) {
            return null;
        }
        HashMap tmpMap = Maps.newHashMapWithExpectedSize((int)map.size());
        map.forEach((ke, val) -> tmpMap.put(ke, this.getBaseDataDy(entityNumber, baseEntityId, fieldId, ke)));
        return tmpMap;
    }

    public List<DynamicObject> getBaseDataDy(String entityNumber, String baseEntityId, String fieldId, Object importValue) {
        String key = entityNumber + "&" + baseEntityId + "&" + fieldId;
        ConcurrentHashMap<Object, List<Object>> map = this.basedataTable.get(key);
        if (map == null) {
            return null;
        }
        List<Object> list = map.get(importValue);
        if (!ObjectUtils.isEmpty(list)) {
            Object obj = list.get(0);
            if (obj instanceof DynamicObject) {
                return this.objectToDynamicObject(key, list, "dy", importValue);
            }
            if (obj instanceof byte[]) {
                return this.objectToDynamicObject(key, list, "byte", importValue);
            }
            if (obj instanceof Pair) {
                return this.objectToDynamicObject(key, list, "pair", importValue);
            }
            if (obj instanceof String) {
                return this.objectToDynamicObject(key, list, "disk", importValue);
            }
        }
        return null;
    }

    public void addBaseDataDy(String entityNumber, String baseEntityId, String fieldId, Object importValue, List<DynamicObject> newDynamicObjects) {
        if (newDynamicObjects == null || newDynamicObjects.size() == 0) {
            return;
        }
        String key = entityNumber + "&" + baseEntityId + "&" + fieldId;
        ConcurrentHashMap map = this.basedataTable.get(key);
        if (map == null) {
            map = this.basedataTable.computeIfAbsent(key, val -> new ConcurrentHashMap(16));
        }
        HashMap tempMap = Maps.newHashMapWithExpectedSize((int)newDynamicObjects.size());
        List<Object> objects = this.dynamicObjectToObject(newDynamicObjects, tempMap, key);
        map.put(importValue, objects);
        tempMap.forEach((pkid, obj) -> this.addBasedataIdMap(key, pkid, obj));
    }

    public DynamicObject getBasedataIdMap(String entityNumber, String baseEntityId, String fieldId, Object id) {
        if (baseEntityId == null) {
            return null;
        }
        String key = entityNumber + "&" + baseEntityId + "&" + fieldId;
        ConcurrentHashMap<Object, Object> map = this.basedataIdMap.get(key);
        if (map == null) {
            return null;
        }
        Object obj = map.get(id);
        List<DynamicObject> dys = null;
        if (obj instanceof DynamicObject) {
            dys = this.objectToDynamicObject(key, Collections.singletonList(obj), "dy", id);
        } else if (obj instanceof byte[]) {
            dys = this.objectToDynamicObject(key, Collections.singletonList(obj), "byte", id);
        } else if (obj instanceof Pair) {
            dys = this.objectToDynamicObject(key, Collections.singletonList(obj), "pair", id);
        } else if (obj instanceof String) {
            dys = this.objectToDynamicObject(key, Collections.singletonList(obj), "disk", id);
        }
        if (dys != null && dys.size() > 0) {
            return dys.get(0);
        }
        return null;
    }

    private void addBasedataIdMap(String key, Object id, Object value) {
        ConcurrentHashMap map = this.basedataIdMap.get(key);
        if (map == null) {
            map = this.basedataIdMap.computeIfAbsent(key, val -> new ConcurrentHashMap(16));
        }
        map.put((Object)id, (Object)value);
    }

    public List<Long> getPermBU(String entityId) {
        return this.permBUMap.get(entityId);
    }

    public void setPermBU(String entityNumber, List<Long> permBU) {
        this.permBUMap.put(entityNumber, permBU);
    }

    public Set<Long> getDataRulePermBasedata(String parentEntityNum, String baseDataEntityNum, String fieldNum) {
        ConcurrentHashMap<String, Set<Long>> map = this.dataRulePermBasedataTable.get(parentEntityNum);
        if (map == null) {
            return null;
        }
        return map.get(baseDataEntityNum + "#" + fieldNum);
    }

    public void addDataRulePermBasedata(String parentEntityNum, String baseDataEntityNum, String fieldNum, Set<Long> dataRulePermBasedata) {
        ConcurrentHashMap map = this.dataRulePermBasedataTable.get(parentEntityNum);
        if (map == null) {
            map = this.dataRulePermBasedataTable.computeIfAbsent(parentEntityNum, val -> new ConcurrentHashMap(16));
        }
        map.put(baseDataEntityNum + "#" + fieldNum, dataRulePermBasedata);
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<String, Set<Long>>> getAllDataRulePermBasedata() {
        return this.dataRulePermBasedataTable;
    }

    public List<Long> getControlledBDPermTable(String entityNumber, Long useOrgId) {
        ConcurrentHashMap<Long, List<Long>> map = this.controlledBDPermTable.get(entityNumber);
        if (map == null) {
            return null;
        }
        return map.get(useOrgId);
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<Long, List<Long>>> getAllControlledBDPermTable() {
        return this.controlledBDPermTable;
    }

    public void setControlledBDPermTable(String entityNumber, Long useOrgId, List<Long> controlledBD) {
        ConcurrentHashMap map = this.controlledBDPermTable.get(entityNumber);
        if (map == null) {
            map = this.controlledBDPermTable.computeIfAbsent(entityNumber, val -> new ConcurrentHashMap(16));
        }
        map.put((Long)useOrgId, controlledBD);
    }

    public Map<Object, DynamicObject> getExistsEntityDyMap() {
        return this.existsEntityDyMap;
    }

    public void addExistsEntityDyMap(Map<Object, DynamicObject> existsEntityDyMap) {
        this.existsEntityDyMap.putAll(existsEntityDyMap);
    }

    public ConcurrentHashMap<String, Map<Object, Object>> getValidateFailedBillDataFieldVaues() {
        return this.validateFailedBillDataFieldVaues;
    }

    public void setValidateFailedBillDataFieldVaues(ConcurrentHashMap<String, Map<Object, Object>> validateFailedBillDataFieldVaues) {
        this.validateFailedBillDataFieldVaues = validateFailedBillDataFieldVaues;
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<Object, List<Object>>> getBasedataTable() {
        return this.basedataTable;
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<Object, Object>> getBasedataIdMap() {
        return this.basedataIdMap;
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<Object, Object>> getRefBillIdMap() {
        return this.refBillIdMap;
    }

    public ConcurrentHashMap<String, Map<Object, Boolean>> getMainOrgPerm() {
        return this.mainOrgPerm;
    }

    public void setMainOrgPerm(ConcurrentHashMap<String, Map<Object, Boolean>> mainOrgPerm) {
        this.mainOrgPerm = mainOrgPerm;
    }

    public Map<String, Long> getAdminDivisionMap() {
        return this.adminDivisionMap;
    }

    public void setAdminDivisionMap(ConcurrentHashMap<String, Long> adminDivisionMap) {
        this.adminDivisionMap = adminDivisionMap;
    }

    public void addBasedataSelectType(String key, DynamicObjectType type) {
        this.basedataSelectType.put(key, type);
    }

    public AtomicInteger getByteDyCount() {
        return this.byteDyCount;
    }

    public AtomicInteger getByteDyLength() {
        return this.byteDyLength;
    }

    public int getOutJVMHeapUseSize() {
        return this.outJVMHeapUseSize;
    }

    public AtomicInteger getOutJVMHeapCount() {
        return this.outJVMHeapCount;
    }

    public NettyOutJVMHeapManager getOutJVMHeapManager() {
        return this.outJVMHeapManager;
    }

    public EHcacheDiskCacheManager getDiskCacheManager() {
        return this.diskCacheManager;
    }

    public AtomicInteger getDiskCacheCount() {
        return this.diskCacheCount;
    }

    private List<DynamicObject> objectToDynamicObject(String key, List<Object> sources, String type, Object id) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(sources.size());
        if ("dy".equals(type)) {
            sources.forEach(obj -> result.add((DynamicObject)obj));
        } else if ("byte".equals(type)) {
            sources.forEach(obj -> {
                try {
                    String str = TextCompressUtil.decompress((byte[])((byte[])obj));
                    Object dy = DataEntitySerializer.deSerializerFromString((String)str, (IDataEntityType)((IDataEntityType)this.basedataSelectType.get(key)));
                    result.add((DynamicObject)dy);
                }
                catch (Throwable e) {
                    LOGGER.error(e);
                }
            });
        } else if ("pair".equals(type)) {
            sources.forEach(pair -> {
                String str = this.outJVMHeapManager.get((Pair)pair);
                Object dy = DataEntitySerializer.deSerializerFromString((String)str, (IDataEntityType)((IDataEntityType)this.basedataSelectType.get(key)));
                result.add((DynamicObject)dy);
            });
        } else if ("disk".equals(type)) {
            sources.forEach(item -> {
                String str = this.diskCacheManager.get((String)item);
                Object dy = DataEntitySerializer.deSerializerFromString((String)str, (IDataEntityType)((IDataEntityType)this.basedataSelectType.get(key)));
                result.add((DynamicObject)dy);
            });
        }
        return result;
    }

    private List<Object> dynamicObjectToObject(List<DynamicObject> sources, Map<Object, Object> tempMap, String key) {
        ArrayList<Object> result = new ArrayList<Object>(sources.size());
        ConcurrentHashMap map = this.basedataTable.computeIfAbsent(key, val -> new ConcurrentHashMap(16));
        if (map.size() < MCConfigConstant.getF7CacheMaxCount()) {
            sources.forEach(obj -> {
                result.add(obj);
                tempMap.put(obj.getPkValue(), obj);
            });
        } else {
            this.createNettyOutJVMHeapManager();
            sources.forEach(obj -> {
                this.addBasedataSelectType(key, obj.getDynamicObjectType());
                String str = DataEntitySerializer.serializerToString((Object)obj);
                Pair put = this.outJVMHeapManager.put(str);
                if (put != null) {
                    result.add(put);
                    tempMap.put(obj.getPkValue(), put);
                    this.outJVMHeapCount.getAndIncrement();
                    this.outJVMHeapUseSize = this.outJVMHeapManager.getPutPos();
                } else {
                    try {
                        byte[] bytes = TextCompressUtil.compress((String)str);
                        result.add(bytes);
                        tempMap.put(obj.getPkValue(), bytes);
                        this.byteDyCount.getAndIncrement();
                        this.byteDyLength.getAndAdd(bytes.length);
                    }
                    catch (Throwable e2) {
                        LOGGER.error(e2);
                    }
                }
            });
        }
        return result;
    }

    private void createNettyOutJVMHeapManager() {
        if (this.outJVMHeapManager != null) {
            return;
        }
        try {
            this.createLock.lock();
            if (this.outJVMHeapManager == null) {
                this.outJVMHeapManager = new NettyOutJVMHeapManager();
            }
        }
        finally {
            this.createLock.unlock();
        }
    }

    private void createEHcacheDiskCacheManager() throws IOException {
        if (this.diskCacheManager != null) {
            return;
        }
        try {
            this.createLock.lock();
            if (this.diskCacheManager == null) {
                this.diskCacheManager = new EHcacheDiskCacheManager();
            }
        }
        finally {
            this.createLock.unlock();
        }
    }
}

