/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.EmailEdit;
import kd.bos.form.field.TelephoneEdit;
import kd.bos.form.field.TimeEdit;
import kd.bos.form.field.TimeRangeEdit;
import kd.bos.i18n.api.telephone.TelephoneService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hies.common.util.ExcelStyleUtil;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ThreeFunction;
import org.apache.commons.lang3.math.NumberUtils;

public class ValidatorUtils {
    private static final Log LOGGER = LogFactory.getLog(ValidatorUtils.class);
    private static final Pattern emailPattern = Pattern.compile("^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+\\.[a-zA-Z0-9_-]+$");
    private static final Pattern emailPatternCN = Pattern.compile("^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+\\.[a-zA-Z0-9_-]+\\.[a-zA-Z0-9_-]+$");
    private static final Pattern integerPattern = Pattern.compile("[1-9]+[0-9]*");
    private final RuntimeException checkFailComException;
    private DecimalFormat longFormat;
    private DecimalFormat bigDecimalFormat;
    private Map<Function<IDataEntityProperty, Boolean>, ThreeFunction<String, String, IDataEntityProperty, Object>> instanceofMap = Maps.newLinkedHashMapWithExpectedSize((int)16);

    public static boolean isInteger(String str) {
        return integerPattern.matcher(str).matches();
    }

    public ValidatorUtils() {
        this.checkFailComException = new RuntimeException();
        this.longFormat = new DecimalFormat();
        this.longFormat.setParseIntegerOnly(true);
        this.bigDecimalFormat = new DecimalFormat();
        this.bigDecimalFormat.setParseBigDecimal(true);
        this.instanceofMap.put(prop -> prop instanceof BooleanProp, (ThreeFunction<String, String, IDataEntityProperty, Object>)((ThreeFunction)(value, dataFormat, prop) -> {
            if (HIESUtil.getBoolMap((String)String.valueOf(value)).booleanValue()) {
                return Boolean.TRUE;
            }
            if (HIESUtil.getBooleanOfFalse((String)String.valueOf(value)).booleanValue()) {
                return Boolean.FALSE;
            }
            throw this.checkFailComException;
        }));
        this.instanceofMap.put(prop -> prop instanceof LongProp, (ThreeFunction<String, String, IDataEntityProperty, Object>)((ThreeFunction)(value, dataFormat, prop) -> this.parseLong((String)value, (String)dataFormat)));
        this.instanceofMap.put(prop -> prop instanceof BigIntProp, (ThreeFunction<String, String, IDataEntityProperty, Object>)((ThreeFunction)(value, dataFormat, prop) -> this.parseLong((String)value, (String)dataFormat)));
        this.instanceofMap.put(prop -> prop instanceof IntegerProp, (ThreeFunction<String, String, IDataEntityProperty, Object>)((ThreeFunction)(value, dataFormat, prop) -> this.parseLong((String)value, (String)dataFormat)));
        this.instanceofMap.put(prop -> prop instanceof DecimalProp, (ThreeFunction<String, String, IDataEntityProperty, Object>)((ThreeFunction)(value, dataFormat, prop) -> this.parseBigDecimal((String)value, (String)dataFormat)));
        this.instanceofMap.put(prop -> prop instanceof DateTimeProp, (ThreeFunction<String, String, IDataEntityProperty, Object>)((ThreeFunction)(value, dataFormat, prop) -> {
            try {
                if (DatePattern.YYYY_MM_DD.getValue().equalsIgnoreCase((String)dataFormat)) {
                    return new Timestamp(DateUtils.parseDate((String)value).getTime());
                }
                if (DatePattern.YYYY.getValue().equalsIgnoreCase((String)dataFormat)) {
                    if (value.length() > 4 || !ValidatorUtils.isInteger(value)) {
                        throw this.checkFailComException;
                    }
                    return new Timestamp(DateUtils.parseDate((String)value, (DatePattern)DatePattern.YYYY).getTime());
                }
                if (DatePattern.YYYY_MM.getValue().equalsIgnoreCase((String)dataFormat)) {
                    if (value.length() > 8) {
                        throw this.checkFailComException;
                    }
                    return new Timestamp(DateUtils.parseDate2YYYYMM((String)value).getTime());
                }
            }
            catch (ParseException ex) {
                throw this.checkFailComException;
            }
            try {
                if (prop instanceof DateProp) {
                    return new Timestamp(DateUtils.parseDate((String)value).getTime());
                }
                return new Timestamp(DateUtils.parseDateTime((String)value).getTime());
            }
            catch (ParseException ex) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)dataFormat);
                    simpleDateFormat.setLenient(false);
                    return new Timestamp(simpleDateFormat.parse((String)value).getTime());
                }
                catch (ParseException parseException) {
                    throw this.checkFailComException;
                }
            }
        }));
        this.instanceofMap.put(prop -> prop instanceof TimeProp, (ThreeFunction<String, String, IDataEntityProperty, Object>)((ThreeFunction)(value, dataFormat, prop) -> {
            try {
                dataFormat = StringUtils.isBlank((CharSequence)dataFormat) ? "HH:mm:ss" : dataFormat;
                return new SimpleDateFormat((String)dataFormat).parse((String)value).toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
            }
            catch (ParseException parseException) {
                throw this.checkFailComException;
            }
        }));
    }

    private Number parseBigDecimal(String val, String dataFormat) {
        if (StringUtils.isBlank((CharSequence)dataFormat)) {
            dataFormat = "#,##0.00";
        }
        if (!NumberUtils.isCreatable((String)(val = val.replace(",", "")))) {
            throw this.checkFailComException;
        }
        try {
            return this.bigDecimalFormat.parse(val);
        }
        catch (Exception ex) {
            throw this.checkFailComException;
        }
    }

    private Number parseLong(String val, String dataFormat) {
        if (StringUtils.isBlank((CharSequence)dataFormat)) {
            dataFormat = "#,##0";
        }
        if (!NumberUtils.isCreatable((String)(val = val.replace(",", "")))) {
            throw this.checkFailComException;
        }
        try {
            return this.longFormat.parse(val);
        }
        catch (Exception ex) {
            throw this.checkFailComException;
        }
    }

    public void formatValidate(JSONObject data, List<String> errCollect, IDataEntityProperty property, Map<String, String> marksMap) {
        if (data.get((Object)property.getName()) == null) {
            return;
        }
        for (Map.Entry<Function<IDataEntityProperty, Boolean>, ThreeFunction<String, String, IDataEntityProperty, Object>> entry : this.instanceofMap.entrySet()) {
            if (!entry.getKey().apply(property).booleanValue()) continue;
            try {
                String mark = marksMap.get(property.getName());
                if (StringUtils.isBlank((CharSequence)mark)) {
                    if (property instanceof DateProp) {
                        mark = ExcelStyleUtil.getDefaultMask((String)"date");
                    } else if (property instanceof DateTimeProp) {
                        mark = ExcelStyleUtil.getDefaultMask((String)"datetime");
                    } else if (property instanceof TimeProp) {
                        mark = ExcelStyleUtil.getDefaultMask((String)"time");
                    }
                }
                data.put(property.getName(), entry.getValue().apply((Object)data.getString(property.getName()), (Object)mark, (Object)property));
            }
            catch (RuntimeException runtimeException) {
                errCollect.add(data.getString(property.getName()));
            }
            break;
        }
    }

    public static void checkEmailFormat(String emailNumber, List<String> errEmailCollect) {
        if (!emailPattern.matcher(emailNumber).matches() && !emailPatternCN.matcher(emailNumber).matches()) {
            errEmailCollect.add(emailNumber);
        }
    }

    public static void checkTelFormat(String telephone, List<String> errTelephoneCollect, Map<String, String> getCountryToAreaCode) {
        String telephoneStr;
        String areaCode;
        if (telephone.contains("-") && telephone.split("-").length > 1) {
            String[] telephoneArray = telephone.split("-");
            areaCode = getCountryToAreaCode.get(telephoneArray[0]);
            telephoneStr = telephoneArray[1];
        } else {
            areaCode = getCountryToAreaCode.get(RequestContext.get().getLang().getLocale().getCountry());
            telephoneStr = telephone;
        }
        TelephoneService service = (TelephoneService)ServiceFactory.getService(TelephoneService.class);
        Map result = service.verifyTelephoneNumberFormat(telephoneStr, new String[]{areaCode});
        if (!Boolean.parseBoolean((String)result.get("code"))) {
            errTelephoneCollect.add("\"" + telephone + "\"" + ((String)result.get("message")).replace("\u3002", ""));
        }
    }

    public static void getControlsFromContains(List<Control> contains, List<String> allTelephoneControls, List<String> allEmailControls, Map<String, String> allDateRangeControls, Map<String, String> allTimeRangeControls, Map<String, ControlAp<?>> fieldApMap, Map<String, String> marks) {
        contains.forEach(control -> {
            if (control instanceof TelephoneEdit) {
                allTelephoneControls.add(control.getKey());
            } else if (control instanceof EmailEdit) {
                allEmailControls.add(control.getKey());
            } else if (control instanceof DateRangeEdit) {
                allDateRangeControls.put(((DateRangeEdit)control).getStartDateFieldKey(), ((DateRangeEdit)control).getEndDateFieldKey());
                String mask = ExcelStyleUtil.getMask((Map)fieldApMap, (IDataEntityProperty)((DateRangeEdit)control).getProperty());
                marks.put(((DateRangeEdit)control).getStartDateFieldKey(), mask);
                marks.put(((DateRangeEdit)control).getEndDateFieldKey(), mask);
            } else if (control instanceof TimeRangeEdit) {
                allTimeRangeControls.put(((TimeRangeEdit)control).getStartDateFieldKey(), ((TimeRangeEdit)control).getEndDateFieldKey());
                marks.put(control.getKey(), ExcelStyleUtil.getMask((Map)fieldApMap, (IDataEntityProperty)((TimeRangeEdit)control).getProperty()));
            } else if (control instanceof DateEdit) {
                marks.put(control.getKey(), ExcelStyleUtil.getMask((Map)fieldApMap, (IDataEntityProperty)((DateEdit)control).getProperty()));
            } else if (control instanceof DateTimeEdit) {
                marks.put(control.getKey(), ExcelStyleUtil.getMask((Map)fieldApMap, (IDataEntityProperty)((DateTimeEdit)control).getProperty()));
            } else if (control instanceof TimeEdit) {
                marks.put(control.getKey(), ExcelStyleUtil.getMask((Map)fieldApMap, (IDataEntityProperty)((TimeEdit)control).getProperty()));
            } else if (control instanceof Container) {
                ValidatorUtils.getControlsFromContains(((Container)control).getItems(), allTelephoneControls, allEmailControls, allDateRangeControls, allTimeRangeControls, fieldApMap, marks);
            }
        });
    }
}

