/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.formplugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.IBasedataField;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hies.business.TemplateApplyScopeServiceHelper;
import kd.hr.hies.business.TemplateServiceHelper;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.templateConf.TemplateConfService;
import kd.hr.impt.mservice.api.ITemplateService;
import org.apache.commons.collections4.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class DiaeTplSelectPlugin
extends HRDataBaseList {
    private static Log log = LogFactory.getLog(DiaeTplSelectPlugin.class);
    private static final String IMPORT_TYPE_KEY = "importtype";
    private static final String IMPORT_TYPE_NEW = "new";
    private static final String IMPORT_TYPE_UPDATE = "update";
    private static final String IMPORT_TYPE_UPDATEANDNEW = "updateandnew";
    private static final String IMPORT_TYPE_DELETE = "delete";
    private int billDataCount;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", IMPORT_TYPE_KEY});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object formId = this.getView().getFormShowParameter().getCustomParam("formId");
        BillList billList = (BillList)this.getView().getControl("billlistap");
        List list = billList.getQueryFilterParameter().getQFilters();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        list.addAll(listShowParameter.getListFilterParameter().getQFilters());
        QFilter currentUserRightTpt = TemplateApplyScopeServiceHelper.getCurrentUserTemplate();
        if (currentUserRightTpt != null) {
            list.add(currentUserRightTpt);
        }
        QFilter filter = new QFilter("entity.id", "=", formId);
        filter.and("tmpltype", "=", (Object)"IMPT");
        list.add(filter);
        list.add(new QFilter("source", "in", Arrays.asList("normal", "external", "")));
        list.add(HRQFilterHelper.buildEnable());
        HRBaseServiceHelper tplHelper = new HRBaseServiceHelper("hies_diaetplseleenti");
        log.info("QFilter_list={}", (Object)list.toString());
        DynamicObject[] tplSeArray = tplHelper.query("id,number,importtype", list.toArray(new QFilter[list.size()]));
        if (tplSeArray == null || tplSeArray.length == 0) {
            ArrayList<QFilter> list2 = new ArrayList<QFilter>(10);
            if (currentUserRightTpt != null) {
                list2.add(currentUserRightTpt);
            }
            list2.add(filter);
            list2.add(new QFilter("source", "in", Collections.singletonList("full")));
            log.info("QFilter_list2={}", (Object)((Object)list2).toString());
            tplSeArray = tplHelper.query("id,number,importtype", list2.toArray(new QFilter[list2.size()]));
        }
        this.processImportType(tplSeArray);
    }

    private void processImportType(DynamicObject[] tplSeArray) {
        boolean showNew = false;
        boolean showUpdate = false;
        boolean showNewAndUpd = false;
        boolean showDelete = false;
        block12: for (DynamicObject tplSe : tplSeArray) {
            switch (tplSe.getString(IMPORT_TYPE_KEY)) {
                case "new": {
                    showNew = true;
                    continue block12;
                }
                case "update": {
                    showUpdate = true;
                    continue block12;
                }
                case "updateandnew": {
                    showNewAndUpd = true;
                    continue block12;
                }
                case "delete": {
                    showDelete = true;
                    continue block12;
                }
            }
        }
        log.info("query_template hies_diaetplseleenti size:{},radadd:{},radupdate:{},radupandadd:{},raddelete:{}", new Object[]{tplSeArray.length, showNew, showUpdate, showNewAndUpd, showDelete});
        this.getView().setVisible(Boolean.valueOf(showNew), new String[]{"radadd"});
        this.getView().setVisible(Boolean.valueOf(showUpdate), new String[]{"radupdate"});
        this.getView().setVisible(Boolean.valueOf(showNewAndUpd), new String[]{"radupandadd"});
        this.getView().setVisible(Boolean.valueOf(showDelete), new String[]{"raddelete"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList list = (BillList)this.getControl("billlistap");
        list.getView().setVisible(Boolean.valueOf(false), new String[]{"enable"});
        list.getView().setVisible(Boolean.valueOf(false), new String[]{"entity.name"});
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        LinkedList<IListColumn> deletes = new LinkedList<IListColumn>();
        for (IListColumn iListColumn : columns) {
            if (!"entity.name".equals(iListColumn.getListFieldKey()) && !"enable".equals(iListColumn.getListFieldKey())) continue;
            deletes.add(iListColumn);
        }
        deletes.forEach(co -> columns.remove(co));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void click(EventObject evt) {
        super.click(evt);
        FormShowParameter parentP = this.getView().getFormShowParameter();
        String formId = (String)parentP.getCustomParam("formId");
        boolean checkPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)parentP.getAppId(), (String)formId, (String)"4730fc9f000003ae");
        if (!checkPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5bfc\u5165\u6743\u9650\uff0c\u5982\u9700\u5bfc\u5165\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRImportStartPlugin_10", (String)"hrmp-hies-import", (Object[])new Object[0]));
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        if (!"btnok".equals(key)) return;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection listSelectedData = listView.getSelectedRows();
        if (listSelectedData.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u677f\u3002", (String)"DiaeTplSelectPlugin_1", (String)"hrmp-hies-import", (Object[])new Object[0]));
            return;
        }
        DynamicObject tpl = TemplateConfService.load(listSelectedData.get(0).getPrimaryKeyValue());
        Map<String, Map<String, Object>> entityNeedDownFiled = this.getEntityNeedDownFiled(tpl);
        if (entityNeedDownFiled == null || entityNeedDownFiled.size() == 0) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)3);
            map.put("formId", this.getView().getFormShowParameter().getFormId());
            map.put("appId", this.getView().getFormShowParameter().getAppId());
            map.put("importPlugin", this.getView().getFormShowParameter().getCustomParam("importPlugin"));
            map.put("extParam", this.getView().getFormShowParameter().getCustomParam("extParam"));
            String routeAppId = MethodUtil.getRouteAppId((String)((String)this.getView().getFormShowParameter().getCustomParam("ServiceAppId")));
            Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hr.impt.servicehelper", (String)routeAppId, (String)ITemplateService.class.getSimpleName(), (String)"genPreView", (Object[])new Object[]{tpl, map});
            if (result.isSuccess()) {
                this.getView().download((String)result.getData());
                this.getView().close();
                return;
            }
            this.getView().showErrorNotification(result.getMsg());
            return;
        }
        String openPage = "hies_diaedatadown";
        String tplscope = tpl.getString("tplscope");
        String custompageval = tpl.getString("custompageval");
        if ("custom".equalsIgnoreCase(tplscope) && StringUtils.isNotEmpty((CharSequence)custompageval)) {
            openPage = custompageval;
        }
        FormShowParameter lsp = new FormShowParameter();
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setFormId(openPage);
        lsp.setCustomParam("entityNeedDownFiled", (Object)SerializationUtils.toJsonString(entityNeedDownFiled));
        lsp.setCustomParam("tplId", listSelectedData.get(0).getPrimaryKeyValue());
        lsp.setCustomParam("formId", (Object)formId);
        lsp.setCustomParam("importPlugin", this.getView().getFormShowParameter().getCustomParam("importPlugin"));
        lsp.setCustomParam("extParam", this.getView().getFormShowParameter().getCustomParam("extParam"));
        this.getView().showForm(lsp);
    }

    public void packageData(PackageDataEvent e) {
        Object pkValue;
        List attachments;
        AbstractColumnDesc columnDesc;
        String fieldKey;
        super.packageData(e);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (this.billDataCount == 0) {
            this.billDataCount = billList.getListModel().getBillDataCount();
        }
        if (this.billDataCount == 1) {
            ListSelectedRowCollection collection = new ListSelectedRowCollection();
            collection.add((Object)new ListSelectedRow(e.getRowData().getPkValue()));
            billList.putSelectedRows(collection);
        }
        if ((fieldKey = (columnDesc = (AbstractColumnDesc)e.getSource()).getFieldKey()).equalsIgnoreCase("listoperationcolumnap") && CollectionUtils.isEmpty((Collection)(attachments = AttachmentServiceHelper.getAttachments((String)"hies_diaetplconf", (Object)(pkValue = e.getRowData().getPkValue()), (String)"attachmentpanelap")))) {
            List operationColItems = (List)e.getFormatValue();
            for (OperationColItem item : operationColItems) {
                item.setVisible(false);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        long pkId;
        List attachments;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("donothing_downattach".equals(formOperate.getOperateKey()) && CollectionUtils.isNotEmpty((Collection)(attachments = AttachmentServiceHelper.getAttachments((String)"hies_diaetplconf", (Object)(pkId = ((Long)args.getListSelectedData().get(0).getPrimaryKeyValue()).longValue()), (String)"attachmentpanelap")))) {
            try {
                String downUrl = ImportFileUtil.downloadRenameFile((String)((String)((Map)attachments.get(0)).get("url")), (String)((String)((Map)attachments.get(0)).get("name")));
                this.getView().download(downUrl);
            }
            catch (IOException e) {
                log.error((Throwable)e);
                this.getView().download((String)((Map)attachments.get(0)).get("url"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
    }

    public void setFilter(SetFilterEvent e) {
        Object formId = this.getView().getFormShowParameter().getCustomParam("formId");
        LinkedList<QFilter> list = new LinkedList<QFilter>();
        QFilter currentUserRightTpt = TemplateApplyScopeServiceHelper.getCurrentUserTemplate();
        if (currentUserRightTpt != null) {
            list.add(currentUserRightTpt);
        }
        QFilter filter = new QFilter("entity.id", "=", formId);
        filter.and("tmpltype", "=", (Object)"IMPT");
        list.add(filter);
        String importtype = this.getPageCache().get(IMPORT_TYPE_KEY);
        if (StringUtils.isEmpty((CharSequence)importtype)) {
            importtype = this.getDefaultSelected(filter, list);
            this.getModel().setValue(IMPORT_TYPE_KEY, (Object)importtype);
            this.getView().updateView(IMPORT_TYPE_KEY);
        }
        list.add(new QFilter(IMPORT_TYPE_KEY, "=", (Object)importtype));
        list.add(new QFilter("source", "in", Arrays.asList("normal", "external", "")));
        list.add(HRQFilterHelper.buildEnable());
        e.setCustomQFilters(list);
        e.setOrderBy("number desc");
    }

    private String getDefaultSelected(QFilter qFilter, List<QFilter> currentUserRightTpl) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hies_diaetplconf");
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)(currentUserRightTpl.size() + 3));
        qFilters.addAll(currentUserRightTpl);
        qFilters.add(qFilter);
        qFilters.add(new QFilter(IMPORT_TYPE_KEY, "!=", (Object)IMPORT_TYPE_DELETE));
        qFilters.add(new QFilter("source", "in", Arrays.asList("normal", "external", "")));
        qFilters.add(HRQFilterHelper.buildEnable());
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("id,importtype", qFilters.toArray(new QFilter[qFilters.size()]));
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            this.getPageCache().put("isShowFullTpl", "true");
            return IMPORT_TYPE_UPDATEANDNEW;
        }
        Map listMap = dynamicObjects.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getString(IMPORT_TYPE_KEY))).collect(Collectors.groupingBy(item -> item.getString(IMPORT_TYPE_KEY), Collectors.toList()));
        if (listMap != null && listMap.size() > 0) {
            Optional first = listMap.keySet().stream().findFirst();
            return (String)first.get();
        }
        return IMPORT_TYPE_NEW;
    }

    private Map<String, Map<String, Object>> getEntityNeedDownFiled(DynamicObject tpldy) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        if (!IMPORT_TYPE_NEW.equalsIgnoreCase(tpldy.getString(IMPORT_TYPE_KEY))) {
            return map;
        }
        String mainEntityNumber = tpldy.getString("entity.number");
        HashMap firstMap = Maps.newHashMapWithExpectedSize((int)10);
        map.put(mainEntityNumber, firstMap);
        MainEntityType mianEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityNumber);
        DynamicObjectCollection condtreeentryentity = tpldy.getDynamicObjectCollection("condentryentity");
        List mainEntitys = condtreeentryentity.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getString("downconditionval"))).collect(Collectors.toList());
        for (DynamicObject item2 : mainEntitys) {
            String condnumber = item2.getString("condnumber");
            String downconditionval = item2.getString("downconditionval");
            DynamicProperty property = mianEntityType.getProperty(condnumber);
            IBasedataField prop = (IBasedataField)property;
            if (downconditionval.equalsIgnoreCase(condnumber)) {
                firstMap.put(condnumber, this.fillAttrInfo(condnumber, prop.getBaseEntityId(), prop.getDisplayName().getLocaleValue()));
                continue;
            }
            String[] split = StringUtils.split((String)downconditionval, (String)",");
            HashMap<String, Map<String, Object>> childVal = (HashMap<String, Map<String, Object>>)firstMap.get(condnumber);
            if (childVal == null) {
                childVal = new HashMap<String, Map<String, Object>>(16);
                firstMap.put(condnumber, childVal);
            }
            MainEntityType childEntityType = EntityMetadataCache.getDataEntityType((String)prop.getBaseEntityId());
            for (String it : split) {
                DynamicProperty property2 = childEntityType.getProperty(it);
                IBasedataField prop2 = (IBasedataField)property2;
                childVal.put(it, this.fillAttrInfo(it, prop2.getBaseEntityId(), prop.getDisplayName() + "." + prop2.getDisplayName().getLocaleValue()));
            }
        }
        if (firstMap.size() > 0) {
            return map;
        }
        return null;
    }

    private Map<String, Object> fillAttrInfo(String key, String id, String name) {
        HashMap itemVal = Maps.newHashMapWithExpectedSize((int)3);
        itemVal.put("key", key);
        itemVal.put("id", id);
        itemVal.put("name", name);
        return itemVal;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (IMPORT_TYPE_KEY.equals(e.getProperty().getName())) {
            this.getPageCache().put(IMPORT_TYPE_KEY, (String)this.getModel().getValue(IMPORT_TYPE_KEY));
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.getSelectedRows().clear();
            billList.refresh();
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs evt) {
        final IFormView view = this.getView();
        final FormShowParameter showParameter = view.getFormShowParameter();
        evt.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                String formId;
                DynamicObjectCollection data = super.getData(start, limit);
                if (data.isEmpty() && StringUtils.isNotBlank((CharSequence)(formId = (String)showParameter.getCustomParam("formId")))) {
                    String uniqueVal;
                    DynamicObject fullTemplate;
                    String importtype = (String)view.getModel().getValue(DiaeTplSelectPlugin.IMPORT_TYPE_KEY);
                    String isShowFullTpl = view.getPageCache().get("isShowFullTpl");
                    if (DiaeTplSelectPlugin.IMPORT_TYPE_UPDATEANDNEW.equalsIgnoreCase(importtype) && "true".equals(isShowFullTpl) && Objects.nonNull(fullTemplate = TemplateServiceHelper.getFullTemplate((String)formId, (String)(uniqueVal = (String)showParameter.getCustomParam("mainentityuniqueval")), (String)"IMPT"))) {
                        DynamicObject obj = data.addNew();
                        HRDynamicObjectUtils.copy((DynamicObject)fullTemplate, (DynamicObject)obj);
                        obj.set("name", (Object)ResManager.loadKDString((String)"\u5168\u91cf\u6a21\u677f", (String)"DiaeTplSelectPlugin_0", (String)"hrmp-hies-import", (Object[])new Object[0]));
                        obj.set("number", (Object)formId);
                        obj.set("id", fullTemplate.getPkValue());
                    }
                }
                return data;
            }
        });
    }
}

