/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.formplugin;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

@ExcludeFromJacocoGeneratedReport
public class TemplateGenTypePlugin
extends HRDataBaseEdit
implements ClickListener {
    private static final String SYS_GEN = "flexpanel_sys";
    private static final String LOC_GEN = "flexpanel_loc";
    private static final String BTN_OK = "btnok";
    private static final String TEMPLATE_TYPE = "temptype";
    private static final String IS_IMPORT = "isImport";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SYS_GEN, LOC_GEN});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeBGColour((Container)this.getControl(SYS_GEN), (Container)this.getControl(LOC_GEN));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (BTN_OK.equals(operate.getOperateKey())) {
            String tempType = (String)this.getModel().getValue(TEMPLATE_TYPE);
            if (StringUtils.isEmpty((CharSequence)tempType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u751f\u6210\u65b9\u5f0f\u3002", (String)"TemplateGenTypePlugin_0", (String)"hrmp-hies-import", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String isImport = (String)this.getView().getFormShowParameter().getCustomParams().get(IS_IMPORT);
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)2);
            returnData.put(IS_IMPORT, isImport);
            returnData.put(TEMPLATE_TYPE, tempType);
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        Control container = (Control)evt.getSource();
        String panelKey = container.getKey();
        if (!SYS_GEN.equals(panelKey) && !LOC_GEN.equals(panelKey)) {
            return;
        }
        Container anotherContainer = SYS_GEN.equals(panelKey) ? (Container)this.getControl(LOC_GEN) : (Container)this.getControl(SYS_GEN);
        this.changeBGColour((Container)container, anotherContainer);
    }

    private void changeBGColour(Container choosePanel, Container anotherPanel) {
        HashMap<String, HashMap> map = new HashMap<String, HashMap>();
        HashMap borderMap = Maps.newHashMapWithExpectedSize((int)4);
        borderMap.put("r", "2px_solid_themeColor");
        borderMap.put("b", "2px_solid_themeColor");
        borderMap.put("t", "2px_solid_themeColor");
        borderMap.put("l", "2px_solid_themeColor");
        HashMap styleMap = Maps.newHashMapWithExpectedSize((int)1);
        styleMap.put("b", borderMap);
        map.put("s", styleMap);
        choosePanel.setCustomProperties(map);
        this.getView().updateControlMetadata(choosePanel.getKey(), map);
        this.getModel().setValue(TEMPLATE_TYPE, (Object)choosePanel.getKey());
        HashMap<String, HashMap> mapAnother = new HashMap<String, HashMap>();
        HashMap anotherBorderMap = Maps.newHashMapWithExpectedSize((int)4);
        anotherBorderMap.put("r", "1px_solid_#d9d9d9");
        anotherBorderMap.put("b", "1px_solid_#d9d9d9");
        anotherBorderMap.put("t", "1px_solid_#d9d9d9");
        anotherBorderMap.put("l", "1px_solid_#d9d9d9");
        HashMap anotherStyleMap = Maps.newHashMapWithExpectedSize((int)1);
        anotherStyleMap.put("b", anotherBorderMap);
        mapAnother.put("s", anotherStyleMap);
        anotherPanel.setCustomProperties(mapAnother);
        this.getView().updateControlMetadata(anotherPanel.getKey(), mapAnother);
    }
}

