/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.formplugin.fieldstyle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.report.ReportView;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.FieldStyleServiceHelper;
import kd.hr.impt.common.LocalCacheHelper;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class FieldStyleFormPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log LOGGER = LogFactory.getLog(FieldStyleFormPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        String operationKey = ((Button)evt.getSource()).getOperationKey();
        if (operationKey != null && operationKey.equals("btnok")) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            JSONObject fields = (JSONObject)JSON.parse((String)customParams.get("entityFieldMap").toString());
            JSONObject returnData = new JSONObject();
            JSONObject fieldStyle = new JSONObject();
            JSONObject fieldOrder = new JSONObject();
            JSONObject fieldMerge = new JSONObject();
            if (fields != null) {
                for (Map.Entry entry : fields.entrySet()) {
                    String tabPageKey = ((JSONObject)entry.getKey()).getString("tabPageKey");
                    String pageId = (String)LocalCacheHelper.getLocalCache().get(this.getView().getFormShowParameter().getRootPageId() + tabPageKey);
                    LOGGER.info("FieldStyleFormPlugin.returnDataToParent(),pageId:{}", (Object)pageId);
                    FormView tabView = (FormView)SessionManager.getCurrent().getViewNoPlugin(pageId);
                    if (!(tabView instanceof ReportView)) continue;
                    LOGGER.info("FieldStyleFormPlugin.returnDataToParent(),customParams:{}", (Object)tabView.getPageCache().get("customParams"));
                    fieldStyle.put(tabPageKey, (Object)JSONObject.parseObject((String)tabView.getPageCache().get(tabPageKey)));
                    String fieldOrderString = tabView.getPageCache().get(tabPageKey + "#order");
                    LOGGER.info("FieldStyleFormPlugin.returnDataToParent(),tabPageKey:{},fieldOrderString:{}", (Object)tabPageKey, (Object)fieldOrderString);
                    if (StringUtils.isBlank((CharSequence)fieldOrderString)) {
                        fieldOrder.put(tabPageKey, (Object)JSONObject.toJSONString((Object)FieldStyleServiceHelper.getStoredFields((JSONObject)((JSONObject)tabView.getFormShowParameter().getCustomParams().get("fields")))));
                    } else {
                        fieldOrder.put(tabPageKey, (Object)fieldOrderString);
                    }
                    Object merge = ((ReportView)tabView).getQueryParam().getCustomParam().get("fieldmerge");
                    if (merge instanceof JSONObject) {
                        fieldMerge.put(tabPageKey, (Object)merge.toString());
                        continue;
                    }
                    fieldMerge.put(tabPageKey, merge);
                }
            }
            returnData.put("fieldstyle", (Object)fieldStyle);
            returnData.put("fieldorder", (Object)fieldOrder);
            returnData.put("fieldmerge", (Object)fieldMerge);
            LOGGER.info("FieldStyleFormPlugin.returnDataToParent(),returnData:{}", (Object)returnData);
            this.getView().returnDataToParent((Object)returnData);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        LOGGER.info("FieldStyleFormPlugin.afterCreateNewData(),customParams:{}", (Object)customParams);
        Map fields = (Map)JSONObject.parseObject((String)customParams.get("entityFieldMap").toString(), LinkedHashMap.class);
        if (fields != null) {
            Container container = (Container)this.getView().getControl("tabap");
            Iterator iterator = fields.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry stringObjectEntry;
                Map.Entry entry = stringObjectEntry = iterator.next();
                String tabPageKey = ((JSONObject)entry.getKey()).getString("tabPageKey");
                String tabPageName = ((JSONObject)entry.getKey()).getString("tabPageName");
                TabPageAp tabPageAp = new TabPageAp();
                tabPageAp.setId("tab_" + tabPageKey);
                tabPageAp.setKey("tab_" + tabPageKey);
                tabPageAp.setName(new LocaleString(tabPageName));
                container.addControls(Collections.singletonList(tabPageAp.createControl()));
                HashMap param = Maps.newHashMapWithExpectedSize((int)1);
                param.put("formId", "hies_tplfieldstyle");
                param.put("entityNumber", tabPageKey);
                param.put("entityName", tabPageName);
                param.put("fields", entry.getValue());
                param.put("tmpltype", customParams.get("tmpltype"));
                param.put("fieldstyle", customParams.get("fieldstyle"));
                if (customParams.get("fieldmerge") != null && StringUtils.isNotBlank((CharSequence)customParams.get("fieldmerge").toString())) {
                    param.put("fieldmerge", JSONObject.parseObject((String)customParams.get("fieldmerge").toString()).getString(tabPageKey));
                }
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter((Map)param);
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey("tab_" + tabPageKey);
                showParameter.setCustomParam("bos_reportConcurrencyQueryLimit", (Object)"false");
                showParameter.setCustomParam("bos_reportConcurrencyExportLimit", (Object)"false");
                this.getView().showForm(showParameter);
            }
        }
    }
}

