/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.formplugin.fieldstyle;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.impt.formplugin.fieldstyle.MyInput;

@ExcludeFromJacocoGeneratedReport
public class FieldStyleReportListDataPlugin
extends AbstractReportListDataPlugin {
    private String[] fieldList;
    private Map<String, String> mergeFieldList = new LinkedHashMap<String, String>();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        Map customParam = reportQueryParam.getCustomParam();
        JSONObject fieldsJson = (JSONObject)customParam.get("fields");
        Object mergeFields = customParam.get("fieldmerge");
        if (mergeFields != null) {
            this.mergeFieldList = (Map)JSONObject.parseObject((String)mergeFields.toString(), LinkedHashMap.class);
        }
        this.fieldList = new String[fieldsJson.size()];
        Map.Entry[] fieldMap = new Map.Entry[fieldsJson.size()];
        fieldsJson.entrySet().forEach(entry -> {
            JSONObject value = (JSONObject)entry.getValue();
            this.fieldList[value.getIntValue((String)"seq") - 1] = (String)entry.getKey();
            fieldMap[value.getIntValue((String)"seq") - 1] = Maps.immutableEntry((Object)value.getString("fieldname"), (Object)value.getString("fieldcontent"));
        });
        Algo algo = Algo.create((String)"FieldStyleReportListDataPlugin_query()");
        return algo.createDataSet(new Input[]{new MyInput(fieldMap, this.fieldList)});
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportColumn firstReportColumn = new ReportColumn();
        firstReportColumn.setCaption(new LocaleString(""));
        firstReportColumn.setFieldKey("header");
        firstReportColumn.setFieldType("text");
        firstReportColumn.setFreeze(true);
        firstReportColumn.setWidth(new LocaleString("80px"));
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setBackColor("#E5E5E5");
        columnStyle.setTextAlign("center");
        columnStyle.setFontSize(14);
        columnStyle.setForeColor("#212121");
        firstReportColumn.setStyle(columnStyle);
        columns.add((AbstractReportColumn)firstReportColumn);
        HashSet<String> addedField = new HashSet<String>();
        for (String fieldKey : this.fieldList) {
            if (addedField.contains(fieldKey)) continue;
            Optional<Map.Entry> any = this.mergeFieldList.entrySet().stream().filter(ob -> ((String)ob.getKey()).split(",")[0].equals(fieldKey)).findAny();
            if (any.isPresent()) {
                Map.Entry entry = any.get();
                String[] mergeFields = ((String)entry.getKey()).split(",");
                ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
                reportColumnGroup.setCaption(new LocaleString((String)entry.getValue()));
                reportColumnGroup.setFieldKey("group_" + (String)entry.getKey());
                for (String mergeField : mergeFields) {
                    ReportColumn reportColumn = new ReportColumn();
                    reportColumn.setCaption(new LocaleString("\u2261"));
                    reportColumn.setFieldKey(mergeField);
                    reportColumn.setFieldType("text");
                    reportColumnGroup.getChildren().add(reportColumn);
                    addedField.add(mergeField);
                }
                columns.add((AbstractReportColumn)reportColumnGroup);
                continue;
            }
            ReportColumn reportColumn = new ReportColumn();
            reportColumn.setCaption(new LocaleString("\u2261"));
            reportColumn.setFieldKey(fieldKey);
            reportColumn.setFieldType("text");
            if (this.fieldList.length == 1) {
                reportColumn.setWidth(new LocaleString("310px"));
            }
            columns.add((AbstractReportColumn)reportColumn);
            addedField.add(fieldKey);
        }
        return columns;
    }
}

