/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.formplugin.plugindemo;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.plugin.AfterInitContextArgs;
import kd.hr.impt.common.plugin.AfterParseBillDataEventArgs;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.AfterValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.BeforeLoadEntityEventArgs;
import kd.hr.impt.common.plugin.BeforeQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.formplugin.sittest.ControlCusFieldMustInputValidatorHandler;
import kd.hr.impt.formplugin.sittest.ControlFieldMustInputValidatorHandler;
import kd.hr.impt.formplugin.sittest.DoubleMustInputValidateHandler;

@ExcludeFromJacocoGeneratedReport
public class DemoImportIgnoreFieldPlugin
extends HRDataBaseList
implements HRImportPlugin {
    private boolean hasHis = false;
    public static final String ENTITY_NAME = "jnc_course";
    public static final String ENTITY_FIELD = "textfield";
    public static final String CUS_FIELD = "cusfield";
    public static final String CONTROL_FLAG = "controlFlag";

    @Override
    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        List<ExportHeaderWriterFormat> headerWriterFormats = args.getHeaderWriterFormats();
        headerWriterFormats.forEach(x -> {
            if (!ENTITY_NAME.equals(x.getEnityName())) {
                return;
            }
            x.getFields().add(CONTROL_FLAG);
            if (CollectionUtils.isNotEmpty((Collection)x.getNext())) {
                x.getNext().forEach(n -> n.setStartColNumber(n.getStartColNumber() + 2));
            }
        });
    }

    @Override
    public void beforeTemplateValidate(BeforeTemplateValidateEventArgs args) {
        HashMap<String, List<String>> ignoreValidateMap = new HashMap<String, List<String>>();
        LinkedList<String> list = new LinkedList<String>();
        list.add(CONTROL_FLAG);
        list.add(CUS_FIELD);
        ignoreValidateMap.put(ENTITY_NAME, list);
        args.setIgnoreValidateMap(ignoreValidateMap);
    }

    @Override
    public void afterParseBillData(AfterParseBillDataEventArgs args) {
        JSONObject obj = args.getData().getData();
        if (obj != null) {
            String number = obj.getJSONObject(ENTITY_NAME).getString("number");
            obj.getJSONObject(ENTITY_NAME).put("number", (Object)(number + "_777"));
        }
    }

    @Override
    public void beforeValidate(BeforeValidateEventArgs args) {
        args.getBillDatas().forEach(data -> {
            JSONObject obj = data.getData();
            String number = obj.getJSONObject(ENTITY_NAME).getString("number");
            obj.getJSONObject(ENTITY_NAME).put("number", (Object)(number + "_777"));
        });
    }

    @Override
    public void beforeInitValidator(BeforeInitValidatorEventArgs args) {
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, new ControlFieldMustInputValidatorHandler());
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, new ControlCusFieldMustInputValidatorHandler());
        args.setValidator(ValidatorEnum.MUST_FILL_IN_VALIDATOR, new DoubleMustInputValidateHandler());
    }

    private List<ImportBillData> validateColumnA(List<ImportBillData> dataList, ImportLog importLog) {
        return null;
    }

    public void doDataUnique(BeforeLoadEntityEventArgs args) {
        List<ImportBillData> billDataList = args.getBillDatas();
        List<QFilter> qFilterList = args.getqFilters();
        if (billDataList == null || qFilterList == null || billDataList.size() != qFilterList.size()) {
            return;
        }
        for (int i = 0; i < qFilterList.size(); ++i) {
            QFilter qFilter = qFilterList.get(i);
            ImportBillData billData = billDataList.get(i);
            qFilter.and(new QFilter("age", "=", billData.getData().getJSONObject(ENTITY_NAME).get((Object)"agenumber")));
        }
    }

    @Override
    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        Object[] filters = args.getFilters();
        if (ArrayUtils.isEmpty((Object[])filters)) {
            return;
        }
        block0: for (Object filter : filters) {
            if ("iscurrentversion".equals(filter.getProperty())) {
                filter.__setProperty("1");
                filter.__setValue((Object)1);
                this.hasHis = true;
                break;
            }
            List nests = filter.getNests(false);
            for (QFilter.QFilterNest nest : nests) {
                QFilter filter1 = nest.getFilter();
                if (!"iscurrentversion".equals(filter1.getProperty())) continue;
                filter1.__setProperty("1");
                filter1.__setValue((Object)1);
                this.hasHis = true;
                break block0;
            }
        }
        args.setFilters((QFilter[])filters);
    }

    @Override
    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        if (!this.hasHis) {
            return;
        }
        Object[] datas = args.getDatas();
        if (ArrayUtils.isEmpty((Object[])datas)) {
            return;
        }
        List collect = Arrays.stream(datas).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(item -> item.getString("number") + ";" + item.getString("name")))), ArrayList::new));
        DynamicObject[] dynamicObjects = new DynamicObject[]{(DynamicObject)collect.get(0)};
        args.setDatas(dynamicObjects);
    }

    public void beforeDispatchData(AfterValidateEventArgs args) {
        args.getExtParams();
    }

    @Override
    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
    }

    @Override
    public void afterInitContext(AfterInitContextArgs args) {
        args.setDisableRepeatDataValidator(true);
    }
}

