/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.formplugin.plugindemo;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.plugin.AfterParseBillDataEventArgs;
import kd.hr.impt.common.plugin.AfterValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.BeforeLoadEntityEventArgs;
import kd.hr.impt.common.plugin.BeforeTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.formplugin.sittest.ControlCusFieldMustInputValidatorHandler;
import kd.hr.impt.formplugin.sittest.ControlFieldMustInputValidatorHandler;
import kd.hr.impt.formplugin.sittest.DoubleMustInputValidateHandler;

@ExcludeFromJacocoGeneratedReport
public class DemoImportPlugin
extends HRDataBaseList
implements HRImportPlugin {
    private static final String ENTITY_NAME = "kdtest_00042laotan";
    public static final String ENTITY_FIELD = "textfield";
    public static final String CUS_FIELD = "cusfield";
    public static final String CONTROL_FLAG = "controlFlag";

    @Override
    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        List<ExportHeaderWriterFormat> headerWriterFormats = args.getHeaderWriterFormats();
        headerWriterFormats.forEach(x -> {
            if (!ENTITY_NAME.equals(x.getEnityName())) {
                return;
            }
            x.getFields().add(CONTROL_FLAG);
            if (CollectionUtils.isNotEmpty((Collection)x.getNext())) {
                x.getNext().forEach(n -> n.setStartColNumber(n.getStartColNumber() + 2));
            }
        });
    }

    @Override
    public void beforeTemplateValidate(BeforeTemplateValidateEventArgs args) {
        HashMap<String, List<String>> ignoreValidateMap = new HashMap<String, List<String>>();
        LinkedList<String> list = new LinkedList<String>();
        list.add(CONTROL_FLAG);
        list.add(CUS_FIELD);
        ignoreValidateMap.put(ENTITY_NAME, list);
        args.setIgnoreValidateMap(ignoreValidateMap);
    }

    public void afterParseData(AfterParseBillDataEventArgs args) {
        JSONObject obj = args.getData().getData();
        if (obj != null) {
            int age = Integer.parseInt(String.valueOf(obj.getJSONObject(ENTITY_NAME).get((Object)"agenumber")));
            obj.getJSONObject(ENTITY_NAME).put("age", (Object)age);
        }
    }

    public void beforeValidateModel(BeforeValidateEventArgs args) {
        String userContent = args.getExtParams();
        args.getBillDatas().forEach(data -> {
            if (!HRStringUtils.isEmpty((String)userContent)) {
                data.getData().getJSONObject(ENTITY_NAME).put("largetextfield", (Object)userContent);
            }
        });
    }

    @Override
    public void beforeInitValidator(BeforeInitValidatorEventArgs args) {
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, new ControlFieldMustInputValidatorHandler());
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, new ControlCusFieldMustInputValidatorHandler());
        args.setValidator(ValidatorEnum.MUST_FILL_IN_VALIDATOR, new DoubleMustInputValidateHandler());
    }

    private List<ImportBillData> validateColumnA(List<ImportBillData> dataList, ImportLog importLog) {
        return null;
    }

    public void doDataUnique(BeforeLoadEntityEventArgs args) {
        List<ImportBillData> billDataList = args.getBillDatas();
        List<QFilter> qFilterList = args.getqFilters();
        if (billDataList == null || qFilterList == null || billDataList.size() != qFilterList.size()) {
            return;
        }
        for (int i = 0; i < qFilterList.size(); ++i) {
            QFilter qFilter = qFilterList.get(i);
            ImportBillData billData = billDataList.get(i);
            qFilter.and(new QFilter("age", "=", billData.getData().getJSONObject(ENTITY_NAME).get((Object)"agenumber")));
        }
    }

    public void beforeDispatchData(AfterValidateEventArgs args) {
        args.getExtParams();
    }

    @Override
    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
    }
}

