/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.business.templateConf;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;

public class EntryTplApplyScopeServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(EntryTplApplyScopeServiceHelper.class);
    private static final String FIELD_STRUCT_LONG_NUMBER = "structlongnumber";

    public static QFilter getCurrentUserTemplate() {
        try {
            Long currentUserId = UserServiceHelper.getCurrentUserId();
            long mainOrgId = UserServiceHelper.getUserMainOrgId((long)currentUserId);
            Set roles = PermissionServiceHelper.getRolesByUser((Long)currentUserId);
            return EntryTplApplyScopeServiceHelper.getTemplateQFilter(currentUserId, roles, mainOrgId, true);
        }
        catch (Exception e) {
            LOGGER.error("TemplateApplyScopeServiceHelper getCurrentUserTemplate error", (Throwable)e);
            return null;
        }
    }

    public static QFilter getTemplateQFilter(long userId, Set<String> roles, long orgId, boolean isIncludeFullTpl) throws Exception {
        LOGGER.info("TemplateApplyScopeServiceHelper getTemplateQFilter parameter,userId:{},roles:{},orgId:{}", new Object[]{userId, roles, orgId});
        HRBaseServiceHelper baseDataListHelper = new HRBaseServiceHelper("hies_entry_tpl");
        HashSet templateIds = Sets.newHashSetWithExpectedSize((int)16);
        Set<Object> globalTemplate = new HashSet(16);
        globalTemplate = isIncludeFullTpl ? EntryTplApplyScopeServiceHelper.getGlobalTemplate(baseDataListHelper) : EntryTplApplyScopeServiceHelper.getGlobalTemplateExFullTpl(baseDataListHelper);
        templateIds.addAll(globalTemplate);
        LOGGER.info("userId:{},GlobalTemplate:{}", (Object)userId, globalTemplate);
        Set<Long> userScopeTemplate = EntryTplApplyScopeServiceHelper.getUserScopeTemplate(baseDataListHelper, userId);
        LOGGER.info("userId:{},userScopeTemplate:{}", (Object)userId, userScopeTemplate);
        templateIds.addAll(userScopeTemplate);
        Set<Long> roleScopeTemplate = EntryTplApplyScopeServiceHelper.getRoleScopeTemplate(baseDataListHelper, roles);
        LOGGER.info("userId:{},roleScopeTemplate:{}", (Object)userId, roleScopeTemplate);
        templateIds.addAll(roleScopeTemplate);
        Set<Long> orgScopeTemplate = EntryTplApplyScopeServiceHelper.getOrgScopeTemplate(baseDataListHelper, orgId);
        LOGGER.info("userId:{},orgScopeTemplate:{}", (Object)userId, orgScopeTemplate);
        templateIds.addAll(orgScopeTemplate);
        Set<Long> orgRoleScopeTemplate = EntryTplApplyScopeServiceHelper.getOrgRoleTemplate(baseDataListHelper, roles, orgId);
        templateIds.addAll(orgRoleScopeTemplate);
        LOGGER.info("userId:{},orgRoleScopeTemplate:{}", (Object)userId, orgRoleScopeTemplate);
        LOGGER.info("userId:{},templateIds:{}", (Object)userId, (Object)templateIds);
        return new QFilter("id", "in", (Object)templateIds);
    }

    @ExcludeFromJacocoGeneratedReport
    private static Set<Long> getOrgRoleTemplate(HRBaseServiceHelper baseDataListHelper, Set<String> roles, long orgId) {
        DynamicObject[] orgRoleTplDys;
        HashSet<Long> templateIds = new HashSet<Long>(16);
        String orgRoleAlgoKey = EntryTplApplyScopeServiceHelper.class.getName() + ".getTemplateQFilter";
        DataSet orgRoleTplIds = DB.queryDataSet((String)orgRoleAlgoKey, (DBRoute)new DBRoute("hmp"), (String)"select fid from t_hies_diaetplroleorg");
        HashSet<Long> orgRoleTplIdSet = new HashSet<Long>(16);
        while (orgRoleTplIds.hasNext()) {
            Row row = orgRoleTplIds.next();
            orgRoleTplIdSet.add(row.getLong("fid"));
        }
        QFilter orgRoleTplFilter = new QFilter("id", "in", orgRoleTplIdSet);
        QFilter[] orgRoleTplFilterArray = new QFilter[]{orgRoleTplFilter};
        for (DynamicObject dynamicObject : orgRoleTplDys = baseDataListHelper.query("id,orgrolelist,orgrole,orgrolenumber,isincludesuborgrole", orgRoleTplFilterArray)) {
            DynamicObjectCollection orgRoleList = dynamicObject.getDynamicObjectCollection("orgrolelist");
            for (DynamicObject orgRole : orgRoleList) {
                HashSet<Long> adminOrgIds = new HashSet<Long>(orgRoleList.size());
                Long org = (Long)((DynamicObject)orgRole.get("orgrolenumber")).get("id");
                String role = (String)((DynamicObject)orgRole.get("orgrole")).get("id");
                adminOrgIds.add(org);
                boolean isincludesuborg = orgRole.getBoolean("isincludesuborgrole");
                if (isincludesuborg) {
                    Set<Long> subAdminOrgList = EntryTplApplyScopeServiceHelper.getSubAdminOrgList(adminOrgIds, Boolean.TRUE);
                    adminOrgIds.addAll(subAdminOrgList);
                }
                if (!adminOrgIds.contains(orgId) || !roles.contains(role)) continue;
                templateIds.add(dynamicObject.getLong("id"));
            }
        }
        return templateIds;
    }

    private static Set<Long> getOrgScopeTemplate(HRBaseServiceHelper baseDataListHelper, long orgId) {
        DynamicObject[] tplDys;
        HashSet<Long> templateIds = new HashSet<Long>(16);
        String algoKey = EntryTplApplyScopeServiceHelper.class.getName() + ".getTemplateQFilter";
        DataSet hrTplIds = DB.queryDataSet((String)algoKey, (DBRoute)new DBRoute("hmp"), (String)"select fid from t_hies_diaetplorg");
        HashSet<Long> hrTplIdSet = new HashSet<Long>(16);
        while (hrTplIds.hasNext()) {
            Row row = hrTplIds.next();
            hrTplIdSet.add(row.getLong("fid"));
        }
        QFilter tplFilter = new QFilter("id", "in", hrTplIdSet);
        QFilter[] tplFilterArray = new QFilter[]{tplFilter};
        for (DynamicObject dynamicObject : tplDys = baseDataListHelper.query("id,orglist,org,isincludesuborg", tplFilterArray)) {
            DynamicObjectCollection orglist = dynamicObject.getDynamicObjectCollection("orglist");
            HashSet<Long> adminOrgIds = new HashSet<Long>(orglist.size());
            for (DynamicObject org : orglist) {
                adminOrgIds.add((Long)((DynamicObject)org.get("org")).get("id"));
                boolean isincludesuborg = org.getBoolean("isincludesuborg");
                if (!isincludesuborg) continue;
                Set<Long> subAdminOrgList = EntryTplApplyScopeServiceHelper.getSubAdminOrgList(adminOrgIds, Boolean.TRUE);
                adminOrgIds.addAll(subAdminOrgList);
            }
            if (!adminOrgIds.contains(orgId)) continue;
            templateIds.add(dynamicObject.getLong("id"));
        }
        return templateIds;
    }

    private static Set<Long> getRoleScopeTemplate(HRBaseServiceHelper baseDataListHelper, Set<String> roles) {
        QFilter roleIdFilter = new QFilter("rolelist.role", "in", roles);
        QFilter[] idFilterArray = new QFilter[]{roleIdFilter};
        DynamicObject[] roleDys = baseDataListHelper.query("id", idFilterArray);
        return Arrays.stream(roleDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    private static Set<Long> getUserScopeTemplate(HRBaseServiceHelper baseDataListHelper, long userId) {
        QFilter userIdFilter = new QFilter("userlist.user", "=", (Object)userId);
        QFilter[] userIdFilterArray = new QFilter[]{userIdFilter};
        DynamicObject[] userDys = baseDataListHelper.query("id", userIdFilterArray);
        return Arrays.stream(userDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    private static Set<Long> getGlobalTemplate(HRBaseServiceHelper baseDataListHelper) {
        QFilter globalFilter = new QFilter("allocationpolicy", "=", (Object)"0");
        QFilter[] globalFilterArray = new QFilter[]{globalFilter};
        DynamicObject[] ids = baseDataListHelper.query("id", globalFilterArray);
        return Arrays.stream(ids).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    private static Set<Long> getGlobalTemplateExFullTpl(HRBaseServiceHelper baseDataListHelper) {
        QFilter globalFilter = new QFilter("allocationpolicy", "=", (Object)"0");
        QFilter qFilter = new QFilter("source", "in", Arrays.asList("normal", ""));
        QFilter[] globalFilterArray = new QFilter[]{globalFilter, qFilter};
        DynamicObject[] ids = baseDataListHelper.query("id", globalFilterArray);
        return Arrays.stream(ids).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    @ExcludeFromJacocoGeneratedReport
    public static Set<Long> getSubAdminOrgList(Set<Long> orgIds, Boolean isEnabled) {
        QFilter[] filters;
        QFilter orgIdFilter = new QFilter("adminorg.id", "in", orgIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] longNumberDys = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").query(FIELD_STRUCT_LONG_NUMBER, new QFilter[]{orgIdFilter, currentFilter, dataStatusFilter});
        HashSet subOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        if (Objects.isNull(longNumberDys) || longNumberDys.length == 0) {
            return subOrgIds;
        }
        EntryTplApplyScopeServiceHelper.initLongNumberParams(orgIdFilter, longNumberDys);
        if (isEnabled.booleanValue()) {
            QFilter enableFilter = new QFilter("adminorg.enable", "=", (Object)"1");
            filters = new QFilter[]{orgIdFilter, enableFilter, currentFilter};
        } else {
            filters = new QFilter[]{orgIdFilter, currentFilter};
        }
        DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryColl("adminorg.id adminorg", filters, null);
        int size = dyColl.size();
        for (int i = 0; i < size; ++i) {
            subOrgIds.add(((DynamicObject)dyColl.get(i)).getLong("adminorg"));
        }
        return subOrgIds;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void initLongNumberParams(QFilter orgIdFilter, DynamicObject[] longNumberDys) {
        List longNumList = Arrays.stream(longNumberDys).map(it -> it.getString(FIELD_STRUCT_LONG_NUMBER)).sorted().collect(Collectors.toList());
        LOGGER.info("initLongNumberParams_before,count:{}", (Object)longNumList.size());
        HashSet longNumSet = Sets.newHashSetWithExpectedSize((int)longNumberDys.length);
        for (String longNumber : longNumList) {
            if (!HRStringUtils.isNotEmpty((String)longNumber)) continue;
            if (!longNumSet.stream().noneMatch(longNumber::startsWith)) continue;
            longNumSet.add(longNumber);
        }
        if (longNumSet.size() > 0) {
            LOGGER.info("initLongNumberParams_after,count:{}", (Object)longNumSet.size());
            for (String longNum : longNumSet) {
                QFilter longNumberFilter = new QFilter(FIELD_STRUCT_LONG_NUMBER, "like", (Object)(longNum + "!" + "%"));
                orgIdFilter.or(longNumberFilter);
            }
        }
    }
}

