/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.common.plugin.expt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hies.common.util.HIESUtil;
import kd.hrmp.hies.entry.business.DefaultEntryExportPluginService;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.AfterLoadUserPluginEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.HREntryExportPlugin;
import kd.hrmp.hies.entry.common.plugin.expt.UserEntryExportPluginEngine;
import kd.hrmp.hies.entry.core.init.EntryExportContext;

public class UserEntryExportPluginUtil {
    private static final Log logger = LogFactory.getLog(UserEntryExportPluginUtil.class);

    public static List<HREntryExportPlugin> getHREntryExportPlugin(String opPlugins, String tplPlugins, EntryExportContext entryExportContext) {
        List<String> defaultPlugins = DefaultEntryExportPluginService.getDefaultPlugins(entryExportContext.getEntityId());
        logger.info("getHREntryExportPlugin_entityId:{} defaultPlugins:{} opPlugins:{}", new Object[]{entryExportContext.getEntityId(), defaultPlugins, opPlugins});
        List<HREntryExportPlugin> userPluginInstances = UserEntryExportPluginUtil.initPlugin(HIESUtil.getGlobalPlugins(), defaultPlugins, opPlugins, tplPlugins, HREntryExportPlugin.class);
        if (CollectionUtils.isNotEmpty(userPluginInstances)) {
            List<HREntryExportPlugin> copyUserPluginInstances = userPluginInstances.stream().collect(Collectors.toList());
            AfterLoadUserPluginEventArgs args = new AfterLoadUserPluginEventArgs(entryExportContext);
            args.setUserPlugin(userPluginInstances);
            UserEntryExportPluginEngine.fireUserPluginEvent(copyUserPluginInstances, "afterLoadUserPlugin", (EntryAbstractEventArgs)args);
        }
        return userPluginInstances;
    }

    private static <T> List<T> initPlugin(String globalPlugins, List<String> defaultPlugins, String opPlugins, String tplPlugins, Class<T> cls) {
        JSONArray jsonArray;
        LinkedList userPluginInstances = new LinkedList();
        LinkedList userPluginClassList = new LinkedList();
        if (StringUtils.isNotEmpty((CharSequence)globalPlugins)) {
            jsonArray = JSONObject.parseArray((String)globalPlugins);
            jsonArray.stream().map(obj -> (JSONObject)obj).filter(jsonObject -> jsonObject.getBooleanValue("Enabled")).map(jsonObject -> jsonObject.getString("ClassName")).distinct().forEach(classPath -> UserEntryExportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (CollectionUtils.isNotEmpty(defaultPlugins)) {
            defaultPlugins.forEach(classPath -> UserEntryExportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (StringUtils.isNotEmpty((CharSequence)opPlugins)) {
            Arrays.stream(opPlugins.split(",")).distinct().forEach(classPath -> UserEntryExportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (StringUtils.isNotEmpty((CharSequence)tplPlugins)) {
            jsonArray = JSONObject.parseArray((String)tplPlugins);
            jsonArray.stream().map(obj -> (JSONObject)obj).filter(jsonObject -> jsonObject.getBooleanValue("Enabled")).map(jsonObject -> jsonObject.getString("ClassName")).distinct().forEach(classPath -> UserEntryExportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        return userPluginInstances;
    }

    private static <T> void setPluginInstance(List<T> userPluginInstances, List<String> userPluginClassList, String classPath, Class<T> cls) {
        if (StringUtils.isEmpty((CharSequence)classPath)) {
            return;
        }
        if (userPluginClassList.contains(classPath)) {
            return;
        }
        userPluginClassList.add(classPath);
        try {
            Object instance = TypesContainer.createInstance((String)classPath);
            if (cls.getSimpleName().equalsIgnoreCase(HREntryExportPlugin.class.getSimpleName()) && instance instanceof HREntryExportPlugin) {
                userPluginInstances.add(instance);
            }
        }
        catch (Throwable ex) {
            logger.error("setPluginInstances {} createInstance error.", (Object)classPath, (Object)ex);
        }
    }
}

