/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.common.plugin.impt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystemException;
import java.util.Map;
import java.util.UUID;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hrmp.hies.entry.common.plugin.impt.EntryImportBaseEventArgs;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.io.FileUtils;

@SdkPublic(scriptName="\u4e0a\u4f20\u5bfc\u5165\u6587\u4ef6\u540e\u4e8b\u4ef6")
public class AfterUploadFileEventArgs
extends EntryImportBaseEventArgs {
    private static final long serialVersionUID = 8418257698272259499L;
    private static final Log LOGGER = LogFactory.getLog(AfterUploadFileEventArgs.class);
    private String sourceFileServerUrl;
    private String filename;
    private String localPath;
    private Map<String, String> newFileInfo;

    public AfterUploadFileEventArgs(String extParams, String entityId, String entryKey, IFormView formView, String tplType) {
        super(extParams, entityId, entryKey, formView, tplType);
    }

    public String getSourceFileServerUrl() {
        return this.sourceFileServerUrl;
    }

    public void setSourceFileServerUrl(String sourceFileServerUrl) {
        this.sourceFileServerUrl = sourceFileServerUrl;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Map<String, String> getNewFileInfo() {
        return this.newFileInfo;
    }

    public void setNewFileInfo(Map<String, String> newFileInfo) {
        this.newFileInfo = newFileInfo;
    }

    public InputStream getSourceFileInputStream() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        return service.getInputStream(this.sourceFileServerUrl);
    }

    public OutputStream getOutputStream() throws IOException {
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
        this.localPath = tempFile.getPath();
        return FileUtils.openOutputStream((File)tempFile);
    }

    public Map<String, String> uploadFile() throws Exception {
        this.newFileInfo = ImportFileUtil.uploadFile((String)this.filename, (String)this.localPath);
        this.deleteLocalFile();
        return this.newFileInfo;
    }

    private void deleteLocalFile() {
        try {
            ImportFileUtil.deleteLocalTempFile((String)this.localPath);
        }
        catch (FileSystemException e) {
            LOGGER.info("file can't delete.");
        }
        catch (Throwable e) {
            LOGGER.error(e);
        }
    }
}

