/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.common.plugin.impt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterBackFillDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterF7MatchedEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterInitContextArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterInitContextDto;
import kd.hrmp.hies.entry.common.plugin.impt.AfterLoadUserPluginEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterParseBillDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterTemplateValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterUploadFileEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeBackFillDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeCreateHeaderColumnEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeCreateTemplateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeInitValidatorEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeShowTemplateSelectListEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeTemplateValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImportPlugin;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import kd.hrmp.hies.entry.core.init.EntryImportStarter;

public class HREntryImpPluginEngine {
    private static Log log = LogFactory.getLog(HREntryImpPluginEngine.class);
    private static final Map<String, BiConsumer<List<HREntryImportPlugin>, EntryAbstractEventArgs>> imptPluginMappings = new HashMap<String, BiConsumer<List<HREntryImportPlugin>, EntryAbstractEventArgs>>(){
        private static final long serialVersionUID = -2968592180970395648L;
        {
            this.put("afterLoadUserPlugin", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterLoadUserPlugin((AfterLoadUserPluginEventArgs)((Object)params))));
            this.put("afterUploadFile", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterUploadFile((AfterUploadFileEventArgs)((Object)params))));
            this.put("beforeShowTemplateSelectList", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeShowTemplateSelectList((BeforeShowTemplateSelectListEventArgs)((Object)params))));
            this.put("afterInitContext", (plugins, params) -> {
                for (HREntryImportPlugin userImportPlugin : plugins) {
                    AfterInitContextDto dto = (AfterInitContextDto)((Object)params);
                    EntryImportContext importContext = dto.getImportContext();
                    AfterInitContextArgs args = new AfterInitContextArgs(dto.getImportContext());
                    args.setUniqueFields(importContext.getUniqueFields());
                    args.setF7formatCfg(importContext.getF7formatCfg());
                    userImportPlugin.afterInitContext(args);
                    importContext.setUniqueFields(args.getUniqueFields());
                    importContext.setF7formatCfg(args.getF7formatCfg());
                    importContext.setIgnoreValidateField(args.getIgnoreValidateField());
                }
            });
            this.put("beforeTemplateValidate", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeTemplateValidate((BeforeTemplateValidateEventArgs)((Object)params))));
            this.put("afterTemplateValidate", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterTemplateValidate((AfterTemplateValidateEventArgs)((Object)params))));
            this.put("beforeCreateTemplate", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeCreateTemplate((BeforeCreateTemplateEventArgs)((Object)params))));
            this.put("beforeCreateHeaderColumn", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeCreateHeaderColumn((BeforeCreateHeaderColumnEventArgs)((Object)params))));
            this.put("afterParseBillData", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterParseBillData((AfterParseBillDataEventArgs)((Object)params))));
            this.put("beforeValidate", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeValidate((BeforeValidateEventArgs)((Object)params))));
            this.put("beforeInitValidator", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeInitValidator((BeforeInitValidatorEventArgs)((Object)params))));
            this.put("beforeQueryRefBd", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeQueryRefBd((BeforeQueryRefBdEventArgs)((Object)params))));
            this.put("AfterQueryRefBd", (plugins, params) -> {
                for (HREntryImportPlugin userImportPlugin : plugins) {
                    userImportPlugin.afterQueryRefBd((AfterQueryRefBdEventArgs)((Object)params));
                }
            });
            this.put("AfterF7Matched", (plugins, params) -> {
                for (HREntryImportPlugin userImportPlugin : plugins) {
                    userImportPlugin.afterF7Matched((AfterF7MatchedEventArgs)((Object)params));
                }
            });
            this.put("afterValidate", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterValidate((AfterValidateEventArgs)((Object)params))));
            this.put("beforeBackFillData", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeBackFillData((BeforeBackFillDataEventArgs)((Object)params))));
            this.put("afterBackFillData", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterBackFillData((AfterBackFillDataEventArgs)((Object)params))));
        }
    };

    public static void fireImptPluginEvent(EntryImportStarter importStart, String eventMethod, EntryAbstractEventArgs params) {
        List<HREntryImportPlugin> userPluginInstances = importStart.getImportContext().getUserPluginInstances();
        if (CollectionUtils.isEmpty(userPluginInstances)) {
            return;
        }
        long start = System.currentTimeMillis();
        imptPluginMappings.get(eventMethod).accept(userPluginInstances, params);
        long spense = System.currentTimeMillis() - start;
        if (spense > 100L) {
            log.info("fireImptPluginEvent_expense:" + spense);
        }
    }

    public static void fireImptPluginEvent(List<HREntryImportPlugin> userPluginInstances, String eventMethod, EntryAbstractEventArgs params) {
        if (CollectionUtils.isEmpty(userPluginInstances)) {
            return;
        }
        long start = System.currentTimeMillis();
        imptPluginMappings.get(eventMethod).accept(userPluginInstances, params);
        long spense = System.currentTimeMillis() - start;
        if (spense > 100L) {
            log.info("fireImptPluginEvent_expense:" + spense);
        }
    }
}

