/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.common.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.util.MethodUtil;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import org.apache.commons.lang3.StringUtils;

public class EntryImportUtil {
    private static Log LOGGER = LogFactory.getLog(EntryImportUtil.class);

    public static void triggerTerminate(String taskId) {
        LOGGER.info("EntryImportUtil_triggerTerminate() taskId:{},thread name:{}", (Object)taskId, (Object)Thread.currentThread().getName());
        IHRAppCache cache = HRAppCache.get((String)"hies");
        cache.put(MethodUtil.getTaskCachePath((String)taskId, (String)ImportCacheKeyType.IMPORT, (String)"status"), (Object)"stop");
    }

    public static Map<String, Object> readImportTaskMsg(String taskId, String type) {
        IHRAppCache cache1 = HRAppCache.get((String)"hies");
        Map data = (Map)cache1.get(MethodUtil.getTaskCachePath((String)taskId, (String)ImportCacheKeyType.IMPORT, (String)type), Map.class);
        return data;
    }

    public static void getAllBDFieldKeys(Collection<IDataEntityProperty> properties, Set<String> allKeys, Set<String> allMulKeys, Set<String> allRefBillFieldKeys) {
        for (IDataEntityProperty property : properties) {
            if (property instanceof BasedataProp) {
                allKeys.add(property.getName());
                continue;
            }
            if (property instanceof MulBasedataProp) {
                allMulKeys.add(property.getName());
                continue;
            }
            if (property instanceof RefBillProp) {
                allRefBillFieldKeys.add(property.getName());
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            DataEntityPropertyCollection entryProperties = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
            EntryImportUtil.getAllBDFieldKeys((Collection<IDataEntityProperty>)entryProperties, allKeys, allMulKeys, allRefBillFieldKeys);
        }
    }

    public static String getF7ImptBaseDataFormat(EntryImportContext importContext, String key) {
        String baseDataFormat = importContext.getDefaultBaseinfoformat();
        if (importContext.getTplType().equals("config")) {
            DynamicObject fieldDy = importContext.getTplFieldConfig().get(key);
            if (fieldDy == null) {
                return "number";
            }
            baseDataFormat = StringUtils.isBlank((CharSequence)fieldDy.getString("imptattr")) ? "number" : fieldDy.getString("imptattr");
        } else {
            baseDataFormat = importContext.getF7formatCfg().getOrDefault(key, importContext.getDefaultBaseinfoformat());
        }
        return baseDataFormat;
    }
}

