/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.parse;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.core.parse.SheetHandler;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.xml.sax.SAXException;

public class EntryExcelImptFailedSheetHandler
extends SheetHandler {
    private static final Log LOGGER = LogFactory.getLog(EntryExcelImptFailedSheetHandler.class);
    private final EntryImportContext importContext;
    private final SXSSFWorkbook sxssfWorkbook;
    private final Map<String, SXSSFSheet> sheetsMap = new HashMap<String, SXSSFSheet>();
    private final Map<Integer, CellStyle> stylesMap = new HashMap<Integer, CellStyle>();
    private final Map<String, SXSSFRow> nameRowsMap = new HashMap<String, SXSSFRow>();
    private int curErrorLineNum;
    private int fieldNameIndex = 4;

    public EntryExcelImptFailedSheetHandler(EntryImportContext importContext) {
        this.importContext = importContext;
        this.sxssfWorkbook = new SXSSFWorkbook(5000);
        this.hasErrorRow = importContext.isHasErrorRow();
        this.curErrorLineNum = importContext.getStartRowNum() - 1;
        this.initStylesMap(this.sxssfWorkbook, this.stylesMap);
    }

    public void handleRow(SheetHandler.ParsedRow currentRow) {
        this.initBook(this.sxssfWorkbook, this.sheetsMap, this.stylesMap, currentRow, false);
    }

    public void handleSheet(SheetHandler.ParsedRow parsedRow, SXSSFWorkbook workbook, SXSSFSheet sxssfSheet, Map<Integer, CellStyle> stylesMap, boolean isAllData) {
        int currRowNum = parsedRow.getRowNum();
        int errStartLinr = this.curErrorLineNum;
        if (currRowNum == 0) {
            this.handleMergeCells(sxssfSheet, this.importContext.getMergeCellList().get(this.getCurrentSheetName()), this.hasErrorRow, true);
            this.handleDataColStyle(workbook, sxssfSheet, stylesMap, this.hasErrorRow);
        }
        if (currRowNum == this.fieldNameIndex) {
            SXSSFRow curRow = this.getRow(sxssfSheet, currRowNum);
            curRow.setHidden(Boolean.valueOf(parsedRow.isHideRow()));
            this.nameRowsMap.put(this.getCurrentSheetName(), curRow);
            if (!this.hasErrorRow) {
                SXSSFCell cell = curRow.createCell(0);
                cell.setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)HiesEntryRes.ExcelImportFailedSheetHandler_0.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                sxssfSheet.setColumnWidth(0, 12800);
            }
        } else if (currRowNum > errStartLinr) {
            ImportLog importLog = this.importContext.getImportLog();
            ConcurrentHashMap errorLog = (ConcurrentHashMap)importLog.getRowErrors().get(this.getCurrentSheetName());
            int curLine = this.writeErrCell(sxssfSheet, stylesMap, currRowNum, errorLog, parsedRow);
            if (curLine < 0) {
                return;
            }
            currRowNum = curLine;
        }
        this.handleCorrectRow(parsedRow, workbook, sxssfSheet, stylesMap, currRowNum, false);
    }

    private int writeErrCell(SXSSFSheet sheet, Map<Integer, CellStyle> stylesMap, int currRowNum, ConcurrentHashMap<Integer, ImportRowErrorLog> errorLog, SheetHandler.ParsedRow parsedRow) {
        ImportRowErrorLog rowErrLog;
        ImportRowErrorLog importRowErrorLog = rowErrLog = errorLog == null ? null : errorLog.get(currRowNum + 1);
        if (rowErrLog != null) {
            String mergeLogStr;
            if (rowErrLog.getMsg().length() > 4000) {
                mergeLogStr = rowErrLog.getMsg().substring(0, 3996);
                mergeLogStr = mergeLogStr.concat("...");
            } else {
                mergeLogStr = rowErrLog.getMsg();
            }
            SXSSFRow curRow = this.getRow(sheet, ++this.curErrorLineNum);
            curRow.setHidden(Boolean.valueOf(parsedRow.isHideRow()));
            SXSSFCell cell = this.getCell(curRow);
            currRowNum = this.curErrorLineNum;
            cell.setCellValue(mergeLogStr);
            cell.setCellStyle(stylesMap.get(-1));
            return currRowNum;
        }
        return -1;
    }

    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
        this.handleValidations(cellValidations, this.sheetsMap);
    }

    public void handleSheetComments(Map<String, CommentsTable> comments) {
        this.handleSheetComments(this.sxssfWorkbook, this.nameRowsMap, 4);
        if (comments != null) {
            comments.clear();
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        XSSFSheet sheet = this.sxssfWorkbook.getXSSFWorkbook().getSheet(this.getCurrentSheetName());
        if (sheet != null) {
            CTWorksheet ctSheet = this.sxssfWorkbook.getXSSFWorkbook().getSheet(this.getCurrentSheetName()).getCTWorksheet();
            String ref = HIESUtil.tranDecimalToBase26((int)(this.hasErrorRow ? this.getColCount() : this.getColCount() + 1));
            ctSheet.getDimension().setRef("A1:".concat(ref).concat(String.valueOf(this.getRowCount())));
        }
        String lastsheet = (String)this.getAllSheetNames().get(this.getAllSheetNames().size() - 1);
        if (this.getCurrentSheetName().equals(lastsheet)) {
            this.ignoreSheet(this.sxssfWorkbook);
            try {
                this.generateFileUrl(this.sxssfWorkbook);
                this.writeUrlCache();
            }
            catch (IOException ioException) {
                LOGGER.error("EntryExcelImptFailedSheetHandler_endDocument() ioException:{}", (Object)ioException.getMessage());
            }
        }
    }

    private void writeUrlCache() {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        HashMap customData = Maps.newHashMapWithExpectedSize((int)2);
        customData.put("errorFileData", this.importContext.getErrorFileForErrorData());
        cache.put(MethodUtil.getTaskCachePath((String)String.valueOf(this.importContext.getTaskid()), (String)ImportCacheKeyType.IMPORT, (String)"urls"), (Object)customData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFileUrl(SXSSFWorkbook workbook) throws IOException {
        File temp = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
        try (FileOutputStream fos = new FileOutputStream(temp);
             FileInputStream fis = new FileInputStream(temp);){
            workbook.write((OutputStream)fos);
            String firstFileName = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_", (String)HiesEntryRes.ExcelImportFailedSheetHandler_6.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]);
            LocalDate now = LocalDate.now();
            String fileName = firstFileName.concat(this.importContext.getFileName().split("\\.")[0]).concat("_").concat(String.format("%02d%02d", now.getMonthValue(), now.getDayOfMonth())).concat(".xlsx");
            RequestContext rc = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)this.importContext.getServiceAppId(), (String)(this.importContext.getMainFormId() + UUID.randomUUID().toString()), (String)fileName);
            String uploadUrl = FileServiceFactory.getAttachmentFileService().upload(new FileItem(fileName, path, (InputStream)fis));
            this.importContext.setErrorFileForErrorData(uploadUrl);
        }
        finally {
            workbook.dispose();
            workbook.close();
            try {
                ImportFileUtil.deleteLocalTempFile((String)temp.getPath());
            }
            catch (Throwable e) {
                LOGGER.error(e);
            }
        }
    }
}

