/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.parse;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.core.parse.SheetHandler;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterParseBillDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImpPluginEngine;
import kd.hrmp.hies.entry.common.util.EntryImportUtil;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import kd.hrmp.hies.entry.core.init.EntryImportStarter;

public class EntryImptSheetHandler
extends SheetHandler {
    private static final Log LOGGER = LogFactory.getLog(EntryImptSheetHandler.class);
    private final Map<String, Set<Integer>> entryToColNum = new HashMap<String, Set<Integer>>();
    private String setNullIdentify = "";
    private Map<Integer, String> fieldNumRow;
    private Set<String> allBaseDataFieldKeys = new HashSet<String>();
    private Set<String> allMulBaseDataFieldKeys = new HashSet<String>();
    private Set<String> allRefBillFieldKeys = new HashSet<String>();
    private int billIndex = 1;
    private int startIndex = 0;
    private int endIndex = 0;
    private JSONObject data;
    private EntryImportStarter entryImportStarter;
    private String curMainEntityNum;

    public EntryImptSheetHandler(EntryImportStarter entryImportStarter) {
        this.entryImportStarter = entryImportStarter;
        String setNullIdentify = entryImportStarter.getImportContext().getSetNullIdentify();
        if (StringUtils.isNotEmpty((CharSequence)setNullIdentify)) {
            this.setNullIdentify = setNullIdentify;
        }
    }

    public void handleRow(SheetHandler.ParsedRow currentRow) {
        int currRowNum = currentRow.getRowNum();
        try {
            int dataIndex = this.entryImportStarter.getImportContext().getStartRowNum() - 1;
            if (currRowNum == 0) {
                this.curMainEntityNum = this.entryImportStarter.getImportContext().getMainFormId();
                EntryImportUtil.getAllBDFieldKeys(this.entryImportStarter.getImportContext().getEntryAllFields().values(), this.allBaseDataFieldKeys, this.allMulBaseDataFieldKeys, this.allRefBillFieldKeys);
                if (StringUtils.isEmpty((CharSequence)HIESUtil.getSplitValue((String)currentRow.get(Integer.valueOf(0))))) {
                    this.entryImportStarter.getImportContext().setHasErrorRow(true);
                }
            } else if (currRowNum == 1) {
                this.handleEntityRow(currentRow);
            } else if (currRowNum == 3) {
                this.fieldNumRow = currentRow.getData();
                int offSet = this.entryImportStarter.getImportContext().isHasErrorRow() ? 1 : 2;
                HashMap map = Maps.newHashMapWithExpectedSize((int)this.fieldNumRow.size());
                this.fieldNumRow.forEach((key, value) -> map.put(value, HIESUtil.tranDecimalToBase26((int)(key + offSet))));
                this.entryImportStarter.getImportContext().setCellIndexOfEntities(map);
            } else if (currRowNum == dataIndex) {
                int offSet = this.entryImportStarter.getImportContext().isHasErrorRow() ? 1 : 2;
                HashMap map = Maps.newHashMapWithExpectedSize((int)currentRow.getData().size());
                currentRow.getData().forEach((key, value) -> map.put(HIESUtil.tranDecimalToBase26((int)(key + offSet)), value));
                this.entryImportStarter.getImportContext().setCellNameIndexOfEntities(map);
            } else if (currRowNum > dataIndex) {
                this.handDataRow(currentRow);
                this.entryImportStarter.getImportContext().addParserCount();
            }
        }
        catch (Exception exception) {
            LOGGER.error("EntryImptSheetHandler.handleRow() error:", (Throwable)exception);
            throw exception;
        }
    }

    private void handleEntityRow(SheetHandler.ParsedRow row) {
        Map entityRowData = row.getData();
        Map int2Range = this.getIntegerSetMap(entityRowData);
        entityRowData.forEach((key, value) -> {
            String splitValue = HIESUtil.getSplitValue((String)value);
            Set integers = (Set)int2Range.get(key);
            if (this.entryToColNum.get(splitValue) != null) {
                integers.addAll((Collection)this.entryToColNum.get(splitValue));
            }
            this.entryToColNum.put(splitValue, integers);
        });
    }

    private void handDataRow(SheetHandler.ParsedRow row) {
        if (this.data != null && this.data.size() > 0) {
            this.endIndex = this.startIndex = row.getRowNum();
            ImportBillData importBillData = new ImportBillData(this.curMainEntityNum, this.data, this.getCurrentSheetName(), this.billIndex, this.startIndex, this.endIndex, null);
            importBillData.setOpType("updateandnew");
            AfterParseBillDataEventArgs args = new AfterParseBillDataEventArgs(this.entryImportStarter.getImportContext());
            args.setData(importBillData);
            HREntryImpPluginEngine.fireImptPluginEvent(this.entryImportStarter, "afterParseBillData", (EntryAbstractEventArgs)args);
            this.putToOutQueue(importBillData);
        }
        this.data = new JSONObject();
        for (Map.Entry entry : row.getData().entrySet()) {
            Integer index = (Integer)entry.getKey();
            if (this.entryImportStarter.getImportContext().isHasErrorRow() && index.longValue() == 0L) continue;
            Optional<Map.Entry> optional = this.entryToColNum.entrySet().stream().filter(key -> ((Set)key.getValue()).contains(index)).findFirst();
            String entityKey = optional.isPresent() ? (String)optional.get().getKey() : "";
            JSONObject fieldLevelMap = (JSONObject)this.data.computeIfAbsent((Object)entityKey, key -> new JSONObject());
            String fieldKey = this.fieldNumRow.get(index);
            if (StringUtils.isBlank((CharSequence)fieldKey)) continue;
            String rowValue = ((String)entry.getValue()).equals(this.setNullIdentify) ? null : (String)entry.getValue();
            this.rowConvertJson2(fieldLevelMap, fieldKey, rowValue);
        }
        this.endIndex = this.startIndex = row.getRowNum() + 1;
    }

    private void rowConvertJson2(JSONObject dataMap, String fieldKey, String rowValue) {
        EntryImportContext importContext = this.entryImportStarter.getImportContext();
        String baseDataFormat = EntryImportUtil.getF7ImptBaseDataFormat(importContext, MethodUtil.getLevelOneKey((String)fieldKey));
        if (fieldKey.contains(".")) {
            this.putMulLevelDataMap(fieldKey, rowValue, dataMap);
        } else if (this.allBaseDataFieldKeys.contains(MethodUtil.getLevelOneKey((String)fieldKey)) && "number_name".equalsIgnoreCase(baseDataFormat) && rowValue != null) {
            this.putBaseDataMap(rowValue, fieldKey, dataMap, importContext.getBdFieldMainPropName());
        } else if (this.allMulBaseDataFieldKeys.contains(MethodUtil.getLevelOneKey((String)fieldKey)) && "number_name".equalsIgnoreCase(baseDataFormat) && rowValue != null) {
            String[] splits = rowValue.split(",");
            Map<String, Object> fieldProName = importContext.getBdFieldMainPropName().get(MethodUtil.getLevelOneKey((String)fieldKey));
            String realName = (String)fieldProName.get("name");
            String realNumber = (String)fieldProName.get("number");
            JSONArray tempArray = new JSONArray();
            for (String split : splits) {
                String[] temp = split.split("##");
                JSONObject tempJson = new JSONObject();
                tempJson.put(realNumber, (Object)temp[0]);
                tempJson.put(realName, (Object)(temp.length > 1 ? temp[1] : ""));
                if (rowValue.contains("##")) {
                    tempJson.put("$bdSplit", (Object)"##");
                }
                tempArray.add((Object)tempJson);
            }
            dataMap.put(fieldKey, (Object)tempArray);
        } else if (this.allRefBillFieldKeys.contains(fieldKey) && rowValue != null) {
            JSONObject tempJson = new JSONObject();
            tempJson.put("billno", (Object)rowValue);
            dataMap.put(fieldKey, (Object)tempJson);
        } else {
            dataMap.put(fieldKey, (Object)rowValue);
        }
    }

    private void putBaseDataMap(String rowValue, String fieldKey, JSONObject dataMap, Map<String, Map<String, Object>> entityFieldProName) {
        if (rowValue == null) {
            dataMap.put(fieldKey, null);
        } else {
            Map<String, Object> fieldProName = entityFieldProName.get(MethodUtil.getLevelOneKey((String)fieldKey));
            String realName = (String)fieldProName.get("name");
            String realNumber = (String)fieldProName.get("number");
            String[] split = rowValue.split("##");
            JSONObject tempJson = new JSONObject();
            tempJson.put(realNumber, (Object)split[0]);
            tempJson.put(realName, (Object)(split.length > 1 ? split[1] : ""));
            if (rowValue.contains("##")) {
                tempJson.put("$bdSplit", (Object)"##");
            }
            dataMap.put(fieldKey, (Object)tempJson);
        }
    }

    private void putMulLevelDataMap(String fieldKey, String rowValue, JSONObject dataMap) {
        String[] split = fieldKey.split("\\.");
        String splitFirst = split[0];
        String splitSecond = split[1];
        if (this.allMulBaseDataFieldKeys.contains(splitFirst)) {
            if (rowValue == null) {
                dataMap.put(splitFirst, null);
            } else {
                JSONArray map = new JSONArray();
                Arrays.stream(rowValue.split(",")).forEach(array -> {
                    JSONObject temp = new JSONObject();
                    temp.put(splitSecond, array);
                    map.add((Object)temp);
                });
                JSONArray jobjs = (JSONArray)dataMap.get((Object)splitFirst);
                if (jobjs == null) {
                    dataMap.put(splitFirst, (Object)map);
                } else {
                    JSONObject temp = new JSONObject();
                    temp.put(splitSecond, (Object)rowValue);
                    jobjs.add((Object)temp);
                }
            }
        } else {
            if (this.allBaseDataFieldKeys.contains(MethodUtil.getLevelOneKey((String)fieldKey)) && rowValue == null) {
                dataMap.put(splitFirst, null);
                return;
            }
            JSONObject map = dataMap.containsKey((Object)splitFirst) ? dataMap.getJSONObject(splitFirst) : new JSONObject();
            map.put(splitSecond, (Object)rowValue);
            dataMap.put(split[0], (Object)map);
        }
    }

    public void endDocument() {
        if (this.data != null && this.data.size() > 0) {
            ImportBillData importBillData = new ImportBillData(this.curMainEntityNum, this.data, this.getCurrentSheetName(), this.billIndex, this.startIndex, this.endIndex, null);
            importBillData.setOpType("updateandnew");
            AfterParseBillDataEventArgs args = new AfterParseBillDataEventArgs(this.entryImportStarter.getImportContext());
            args.setData(importBillData);
            HREntryImpPluginEngine.fireImptPluginEvent(this.entryImportStarter, "afterParseBillData", (EntryAbstractEventArgs)args);
            this.putToOutQueue(importBillData);
            this.data = null;
        }
        this.setInterrupt(true);
    }

    private void putToOutQueue(ImportBillData data) {
        try {
            boolean result = this.entryImportStarter.getParserQueue().offer(data, 500L, TimeUnit.SECONDS);
            if (!result) {
                throw new KDBizException(new ErrorCode("906", ((Object)((Object)this)).getClass().getSimpleName() + "'s outQueue has full.and no retry times"), new Object[0]);
            }
            ++this.billIndex;
            this.entryImportStarter.getImportContext().addTotalBillCount(1);
        }
        catch (Throwable e) {
            LOGGER.error(e);
        }
    }
}

