/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.dto.BaseDataContainer;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import kd.hrmp.hies.entry.common.util.EntryImportUtil;
import kd.hrmp.hies.entry.core.validate.InnerEntryValidateHandler;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class EntryDataRuleBDPermValidator
extends InnerEntryValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(EntryDataRuleBDPermValidator.class);

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        BaseDataContainer baseDataContainer = this.getDataValidateParams().getBaseDataContainer();
        HashSet baseDataSet = new HashSet();
        baseDataContainer.getAllDataRulePermBasedata().values().forEach(item -> {
            Iterator iterator = item.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                baseDataSet.add(next.getKey());
            }
        });
        for (ImportBillData billData : billDataList) {
            billData.getData().values().forEach(json -> this.checkData(importLog, billData, baseDataContainer, baseDataSet, json));
        }
    }

    private void checkData(ImportLog importLog, ImportBillData billData, BaseDataContainer baseDataContainer, Set<String> baseDataSet, Object json) {
        ((JSONObject)json).values().forEach(bdJson -> {
            if (bdJson instanceof JSONObject && baseDataSet.contains(((JSONObject)bdJson).getString("$basedataentity"))) {
                this.checkBaseDataBD(importLog, billData, baseDataContainer, (JSONObject)bdJson);
            } else if (bdJson instanceof JSONArray && baseDataSet.contains(((JSONArray)bdJson).getJSONObject(0).getString("$basedataentity"))) {
                JSONArray basedataJsonArray = (JSONArray)bdJson;
                basedataJsonArray.forEach(jsonObject -> this.checkBaseDataBD(importLog, billData, baseDataContainer, (JSONObject)jsonObject));
            }
        });
    }

    private void checkBaseDataBD(ImportLog importLog, ImportBillData billData, BaseDataContainer baseDataContainer, JSONObject basedata) {
        Set dataRulePermBasedata;
        String fieldKey = MethodUtil.getLevelOneKey((String)basedata.getString("$basedataFieldKey"));
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, String>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(fieldKey, val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        if ((dataRulePermBasedata = baseDataContainer.getDataRulePermBasedata(billData.getMainEntityId(), basedata.getString("$basedataentity"), fieldKey)) != null && !dataRulePermBasedata.contains(basedata.getLong("id"))) {
            LOGGER.info("EntryDataRuleBDPermValidator.checkBaseDataBD(),baseDataNum:{},id:{}", (Object)basedata.getString("$basedataentity"), (Object)basedata.getLong("id"));
            String cellIndex = this.getCellIndex(basedata.getString("$basedataFieldKey"));
            Map<String, Map<String, Object>> bdFieldMainPropName = this.getDataValidateParams().getImportStarter().getImportContext().getBdFieldMainPropName();
            Map<String, Object> fieldMainPropName = bdFieldMainPropName.get(fieldKey);
            String baseDataFormat = EntryImportUtil.getF7ImptBaseDataFormat(this.getDataValidateParams().getImportStarter().getImportContext(), fieldKey);
            DataValidateServiceHelper.writeRowErrorLog((int)24, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), this.getPutWhereKey(basedata, baseDataFormat, fieldMainPropName, billData.getData(), this.getExtF7UniqueVal(fieldKey), (Map<String, String>)f7ExtUniqueValFieldMap)});
        }
    }

    private String[] getExtF7UniqueVal(String fieldNum) {
        Map<String, String> f7UniqueValMap = this.getDataValidateParams().getF7ExtUniqueValMap();
        if (!ObjectUtils.isEmpty(f7UniqueValMap)) {
            return StringUtils.split((String)f7UniqueValMap.get(fieldNum), (String)",");
        }
        return null;
    }
}

