/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.validate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import kd.hrmp.hies.entry.core.validate.InnerEntryValidateHandler;
import org.apache.commons.lang3.StringUtils;

public class EntryDataRulePermValidator
extends InnerEntryValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(EntryDataRulePermValidator.class);

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        EntryImportContext importContext = this.getDataValidateParams().getImportStarter().getImportContext();
        IDataModel model = importContext.getFormView().getModel();
        String mainFormId = importContext.getMainFormId();
        String bizAppId = DataValidateServiceHelper.getPermAppIdPkid((String)importContext.getAppId(), (String)mainFormId, (boolean)true);
        BOSExpression bosExpression = DataValidateServiceHelper.getDataRuleScript((String)((Long)model.getValue("id") == 0L ? "47156aff000000ac" : "4715a0df000000ac"), (String)mainFormId, (String)bizAppId);
        if ("1=1".equals(bosExpression.getExpression())) {
            return;
        }
        String dataRuleScript = bosExpression.getExpression();
        LOGGER.info("EntryDataRulePermValidator.validate_dataRuleScript:{}", (Object)dataRuleScript);
        if ("1!=1".equals(dataRuleScript)) {
            billDataList.forEach(billData -> DataValidateServiceHelper.writeRowErrorLog((int)11, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[0]));
        } else {
            Set vars = bosExpression.getVars();
            HashMap varValues = new HashMap(vars.size());
            LOGGER.info("EntryDataRulePermValidator_validate(),entityId:{},isError:{},bosExpression\uff1a{}", new Object[]{mainFormId, bosExpression.isError(), bosExpression.toString()});
            if (bosExpression.isError() || StringUtils.isBlank((CharSequence)bosExpression.toString())) {
                return;
            }
            HashSet nonVars = Sets.newHashSetWithExpectedSize((int)vars.size());
            vars.forEach(tempKey -> {
                if (tempKey.contains(".")) {
                    Object value = model.getValue(tempKey.split("\\.")[0]);
                    if (value instanceof DynamicObject) {
                        varValues.put(tempKey, ((DynamicObject)value).get(tempKey.split("\\.")[1]));
                    } else {
                        nonVars.add(tempKey);
                    }
                } else {
                    Object value = model.getValue(tempKey);
                    if (value != null) {
                        varValues.put(tempKey, value);
                    } else {
                        nonVars.add(tempKey);
                    }
                }
            });
            LOGGER.info("EntryDataRulePermValidator.validate_varValues:{}", varValues);
            billDataList.forEach(billData -> {
                billData.getData().entrySet().forEach(entry2 -> this.containsKey(nonVars, varValues, (Map.Entry<String, Object>)entry2));
                if (!((Boolean)FormulaEngine.execExcelFormula((Expr)bosExpression.getExpr(), (Map)varValues)).booleanValue()) {
                    DataValidateServiceHelper.writeRowErrorLog((int)11, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[0]);
                }
            });
        }
    }

    private void containsKey(Set<String> vars, Map<String, Object> varValues, Map.Entry<String, Object> entry) {
        vars.forEach(tempKey -> {
            if (tempKey.equalsIgnoreCase((String)entry.getKey())) {
                varValues.put((String)tempKey, entry.getValue());
            } else if (tempKey.contains(".")) {
                String[] split = tempKey.split("\\.");
                if (split[0].equalsIgnoreCase((String)entry.getKey())) {
                    varValues.put((String)tempKey, ((JSONObject)entry.getValue()).get((Object)split[1]));
                } else {
                    JSONObject jsonObject = ((JSONObject)entry.getValue()).getJSONObject(split[0]);
                    if (jsonObject == null) {
                        return;
                    }
                    varValues.put((String)tempKey, jsonObject.get((Object)split[1]));
                }
            }
        });
    }
}

