/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.IFormView;
import kd.bos.form.container.FormRoot;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.ExcelStyleUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.dto.BaseDataContainer;
import kd.hr.impt.core.validate.util.ValidatorUtils;
import kd.hrmp.hies.entry.common.enu.EntryValidatorEnum;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeInitValidatorEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImpPluginEngine;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import kd.hrmp.hies.entry.core.init.EntryImportStarter;
import kd.hrmp.hies.entry.core.validate.AbstractEntryValidateHandler;
import kd.hrmp.hies.entry.core.validate.EntryDataValidateParams;
import kd.hrmp.hies.entry.core.validate.InnerEntryValidateHandler;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.MultiValueMap;

public class EntryDataValidateManager
implements Callable<String> {
    private static final Log LOGGER = LogFactory.getLog(EntryDataValidateManager.class);
    private EntryImportStarter importStarter;
    private String name = "EntryDataValidateManager_";
    private EntryDataValidateParams dataValidateParams;
    private MultiValueMap<EntryValidatorEnum, AbstractEntryValidateHandler> customValidateHandlers = null;
    private boolean isEnableDataRuleValidator = false;

    public EntryDataValidateManager(EntryImportStarter importStarter, String name) {
        this.importStarter = importStarter;
        this.name = this.name + name;
    }

    @Override
    public String call() throws Exception {
        String result = null;
        try {
            MethodUtil.syncRequestTraceId((Object)this.importStarter.getImportContext().getRc());
            result = this.doBusiness();
        }
        catch (Throwable exception) {
            LOGGER.error("EntryDataValidateManager-call() error:", exception);
            this.importStarter.end(true, true, exception);
        }
        finally {
            LOGGER.info("{},notifyWhenEnd", (Object)this.name);
            this.importStarter.notifyWhenEnd();
        }
        return result;
    }

    private String doBusiness() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        while (!this.importStarter.isStoped()) {
            LinkedList<Object> billDataList = new LinkedList<ImportBillData>();
            int currBatchIndex = this.importStarter.drainDataFromParseQueue(billDataList);
            if (currBatchIndex == -1) {
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error("EntryDataValidateManager has been interrupted.", (Throwable)interruptedException);
                }
            } else {
                this.handleAndStore(billDataList, currBatchIndex);
            }
            if (!this.importStarter.isEnd()) continue;
            while ((currBatchIndex = this.importStarter.drainDataFromParseQueue(billDataList = new LinkedList())) != -1) {
                this.handleAndStore(billDataList, currBatchIndex);
            }
            break block2;
        }
        return null;
    }

    private void handleAndStore(List<ImportBillData> billDataList, int currBatchIndex) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (billDataList.isEmpty()) {
            return;
        }
        LOGGER.info("EntryDataValidateManager.handleAndStore,billDataList size;{}", (Object)billDataList.size());
        BeforeValidateEventArgs args0 = new BeforeValidateEventArgs(this.importStarter.getImportContext());
        args0.setBillDatas(billDataList);
        HREntryImpPluginEngine.fireImptPluginEvent(this.importStarter, "beforeValidate", (EntryAbstractEventArgs)args0);
        this.beforeValidate();
        this.dataValidateParams.setF7ExtUniqueValMap(args0.getF7ExtUniqueValMap());
        this.dataValidateParams.setF7ExtUniqueValFieldMap(args0.getF7ExtUniqueValFieldMap());
        this.handleBatchData(billDataList);
        AfterValidateEventArgs args = new AfterValidateEventArgs(this.importStarter.getImportContext());
        args.setBillDatas(billDataList);
        HREntryImpPluginEngine.fireImptPluginEvent(this.importStarter, "afterValidate", (EntryAbstractEventArgs)args);
        this.importStarter.putToSuccessDataList(currBatchIndex, billDataList);
        LOGGER.info("EntryDataValidateManager.handleAndStore,succeed billDataList size;{}", (Object)billDataList.size());
    }

    private void beforeValidate() {
        List collect;
        EntryImportContext importContext = this.importStarter.getImportContext();
        this.dataValidateParams = new EntryDataValidateParams();
        this.dataValidateParams.setIgnoreValidateField(importContext.getIgnoreValidateField());
        this.dataValidateParams.setBaseDataContainer(new BaseDataContainer());
        this.dataValidateParams.setOrgMap(importContext.getOrgMap());
        this.dataValidateParams.setCellIndexOfEntities(importContext.getCellIndexOfEntities());
        this.dataValidateParams.setCellNameIndexOfEntities(importContext.getCellNameIndexOfEntities());
        this.dataValidateParams.setImportStarter(this.importStarter);
        HashMap<String, List<IDataEntityProperty>> entity2MustFillInFields = new HashMap<String, List<IDataEntityProperty>>();
        Map<String, IDataEntityProperty> fields = this.importStarter.getImportContext().getEntryAllFields();
        if (importContext.getTplType().equals("config")) {
            DynamicObject tplDy = importContext.getTpl();
            DynamicObjectCollection fieldEntryCollection = tplDy.getDynamicObjectCollection("tpltreeentryentity");
            String mainEntity = tplDy.getString("entity.number");
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)mainEntity);
            Map allFieldsOfEntities = mainType.getAllFields();
            Map allEntities = mainType.getAllEntities();
            collect = fieldEntryCollection.stream().filter(field -> field.getBoolean("isfield") && field.getBoolean("ismustinput") && field.getBoolean("isimport")).map(field2 -> {
                if (field2.getBoolean("iscusfield")) {
                    TextProp textProp = new TextProp();
                    textProp.setName(field2.getString("fieldnumber"));
                    return textProp;
                }
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFieldsOfEntities.get(field2.getString("fieldnumber"));
                if (iDataEntityProperty == null && field2.getString("fieldnumber").equals(importContext.getEntryKey().concat(".id"))) {
                    iDataEntityProperty = ((EntityType)allEntities.get(importContext.getEntryKey())).getProperty("id");
                }
                return iDataEntityProperty;
            }).collect(Collectors.toList());
        } else {
            collect = fields.values().stream().filter(consumer -> {
                if (consumer instanceof MulBasedataProp) {
                    return ((MulBasedataProp)consumer).isMustInput();
                }
                if (consumer instanceof BasedataProp) {
                    return ((BasedataProp)consumer).isMustInput();
                }
                if (consumer instanceof RefBillProp) {
                    return ((RefBillProp)consumer).isMustInput();
                }
                return ((FieldProp)consumer).isMustInput();
            }).collect(Collectors.toList());
        }
        entity2MustFillInFields.put(this.importStarter.getImportContext().getEntryKey(), collect);
        this.dataValidateParams.setEntity2MustFillInFields(entity2MustFillInFields);
        if ("config".equals(importContext.getTplType())) {
            this.dataValidateParams.setTplFieldDefValue(this.getTplFieldDefValue(importContext.getTpl()));
        }
        this.dataValidateParams.setCountryToAreaCode(ImportServiceHelper.getCountries());
        IFormView mainEntityFormView = importContext.getFormView();
        List contains = ((FormRoot)mainEntityFormView.getRootControl()).getItems();
        ArrayList<String> allTelephoneControls = new ArrayList<String>();
        ArrayList<String> allEmailControls = new ArrayList<String>();
        HashMap<String, String> allTimeRangeControls = new HashMap<String, String>();
        HashMap<String, String> allDateRangeControls = new HashMap<String, String>();
        HashMap<String, String> marks = new HashMap<String, String>();
        Map fieldApMap = ExcelStyleUtil.getFieldControlApMap((String)mainEntityFormView.getEntityId());
        ValidatorUtils.getControlsFromContains((List)contains, allTelephoneControls, allEmailControls, allDateRangeControls, allTimeRangeControls, (Map)fieldApMap, marks);
        this.dataValidateParams.addNeedFormatTelFields(allTelephoneControls);
        this.dataValidateParams.addNeedFormatEmailFields(allEmailControls);
        this.dataValidateParams.setDateRangeFields(allDateRangeControls);
        this.dataValidateParams.setTimeRangeFields(allTimeRangeControls);
        this.dataValidateParams.setMarksMap(marks);
        BeforeInitValidatorEventArgs beforeInitValidatorEventArgs = new BeforeInitValidatorEventArgs(this.importStarter.getImportContext());
        beforeInitValidatorEventArgs.setEnableDataRuleValidator(this.isEnableDataRuleValidator);
        HREntryImpPluginEngine.fireImptPluginEvent(this.importStarter, "beforeInitValidator", (EntryAbstractEventArgs)beforeInitValidatorEventArgs);
        this.customValidateHandlers = beforeInitValidatorEventArgs.getAbstractValidateHandler();
        this.isEnableDataRuleValidator = beforeInitValidatorEventArgs.isEnableDataRuleValidator();
    }

    protected void handleBatchData(List<ImportBillData> billDataList) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList toSort = Lists.newArrayList((Object[])EntryValidatorEnum.values());
        toSort.sort(Comparator.comparing(EntryValidatorEnum::getOrder));
        for (EntryValidatorEnum validator : toSort) {
            AbstractEntryValidateHandler validateHandler = null;
            LinkedList<AbstractEntryValidateHandler> list = new LinkedList<AbstractEntryValidateHandler>();
            if (!StringUtils.isBlank((CharSequence)validator.getClassName()) && (validator.getOrder() != 4 || this.isEnableDataRuleValidator)) {
                Class<?> validatorClass = Class.forName(validator.getClassName());
                validateHandler = (AbstractEntryValidateHandler)validatorClass.newInstance();
            }
            if (this.customValidateHandlers != null && this.customValidateHandlers.get((Object)validator) != null) {
                List tempList = (List)this.customValidateHandlers.get((Object)validator);
                boolean has = tempList.stream().anyMatch(x -> x.getValidatorOrderEnum() == ValidatorOrderEnum.REPLACE || x.getValidatorOrderEnum() == ValidatorOrderEnum.IGNORE);
                if (!has && validateHandler != null) {
                    list.add(validateHandler);
                }
                list.addAll(tempList);
                tempList.sort(Comparator.comparing(AbstractEntryValidateHandler::getValidatorOrderEnum));
            } else if (validateHandler != null) {
                list.add(validateHandler);
            }
            list.forEach(validatorTemp -> {
                if (this.importStarter.isStoped()) {
                    return;
                }
                long start = System.currentTimeMillis();
                if (validatorTemp instanceof InnerEntryValidateHandler) {
                    InnerEntryValidateHandler handler = (InnerEntryValidateHandler)validatorTemp;
                    handler.setCustomParams(this.dataValidateParams);
                    validatorTemp.validate(billDataList, this.importStarter.getImportContext().getImportLog());
                } else if (validatorTemp.getValidatorOrderEnum() != ValidatorOrderEnum.IGNORE) {
                    validatorTemp.validate(billDataList, this.importStarter.getImportContext().getImportLog());
                }
                long spense = System.currentTimeMillis() - start;
                LOGGER.info(validatorTemp.getClass().getSimpleName() + "_validator_end.cost=" + spense);
            });
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private JSONObject getTplFieldDefValue(DynamicObject tpl) {
        JSONObject result = new JSONObject();
        DynamicObjectCollection templateEntry = tpl.getDynamicObjectCollection("tpltreeentryentity");
        Map<Long, String> idToEntity = templateEntry.stream().filter(dy -> !dy.getBoolean("isfield")).collect(Collectors.toMap(dy1 -> dy1.getLong("id"), dy2 -> dy2.getString("fieldnumber"), (x1, x2) -> x1));
        Map entityToFields = templateEntry.stream().filter(dy -> !dy.getBoolean("isimport") && !dy.getBoolean("iscusfield") && StringUtils.isNotBlank((CharSequence)dy.getString("defvalprop"))).collect(Collectors.groupingBy(item -> item.getString("childentity"), Collectors.toList()));
        if (entityToFields.size() == 0) {
            return result;
        }
        String entityKey = tpl.getString("entity.number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        Map allFields = dataEntityType.getAllFields();
        for (Map.Entry entry : entityToFields.entrySet()) {
            entry.getValue().forEach(dy -> {
                String entityKeyTemp = (String)idToEntity.get(dy.getLong("pid"));
                JSONObject mapTemp = (JSONObject)result.getOrDefault((Object)entityKeyTemp, (Object)new JSONObject());
                String fieldNumber = dy.getString("fieldnumber");
                String defVal = dy.getString("defvalprop");
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldNumber);
                if (defVal.contains("$dynamicFlag_")) {
                    mapTemp.put(fieldNumber, (Object)defVal);
                } else if (property instanceof LongProp || property instanceof BigIntProp) {
                    mapTemp.put(fieldNumber, (Object)Long.valueOf(defVal));
                } else if (property instanceof IntegerProp) {
                    mapTemp.put(fieldNumber, (Object)Integer.valueOf(defVal));
                } else if (property instanceof DecimalProp) {
                    mapTemp.put(fieldNumber, (Object)new BigDecimal(defVal));
                } else if (property instanceof MuliLangTextProp) {
                    mapTemp.put(fieldNumber, (Object)JSONObject.parseObject((String)defVal));
                } else if (property instanceof DateTimeProp) {
                    mapTemp.put(fieldNumber, (Object)new Timestamp(Long.parseLong(defVal)));
                } else if (property instanceof TimeProp) {
                    mapTemp.put(fieldNumber, (Object)LocalTime.ofSecondOfDay(Long.parseLong(defVal)));
                } else if (property instanceof MulComboProp) {
                    String[] split;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String key : split = defVal.split(",")) {
                        ((ComboProp)property).getComboItems().forEach(valueMapItem -> {
                            if (valueMapItem.getValue().equals(key)) {
                                stringBuilder.append(valueMapItem.getName().getLocaleValue()).append(",");
                            }
                        });
                    }
                    mapTemp.put(fieldNumber, (Object)stringBuilder.toString());
                } else if (property instanceof ComboProp) {
                    ((ComboProp)property).getComboItems().forEach(valueMapItem -> {
                        if (valueMapItem.getValue().equals(defVal)) {
                            mapTemp.put(fieldNumber, (Object)valueMapItem.getName().getLocaleValue());
                        }
                    });
                } else if (property instanceof BasedataProp) {
                    JSONObject jsonObject = new JSONObject();
                    String basedataId = ((BasedataProp)property).getBaseEntityId();
                    HRBaseServiceHelper helper = new HRBaseServiceHelper(basedataId);
                    DynamicObject singleDy = null;
                    Object id = defVal;
                    try {
                        id = Long.parseLong(defVal);
                        singleDy = helper.loadSingle(id);
                    }
                    catch (NumberFormatException e) {
                        singleDy = helper.loadSingle(id);
                    }
                    if (singleDy != null) {
                        Map<String, Map<String, Object>> entityBdFieldMainPropName = this.importStarter.getImportContext().getBdFieldMainPropName();
                        Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(property.getName());
                        String realNumber = (String)bdFieldMainPropName.get("number");
                        String realName = (String)bdFieldMainPropName.get("name");
                        jsonObject.put("number", (Object)singleDy.getString(realNumber));
                        jsonObject.put("name", (Object)singleDy.getString(realName));
                        jsonObject.put("$basedataentity", (Object)basedataId);
                        jsonObject.put("$basedataBelongEntity", (Object)entityKey);
                        this.dataValidateParams.getBaseDataContainer().addBaseDataDy(entityKey, basedataId, property.getName(), (Object)singleDy.getString(realNumber), Collections.singletonList(singleDy));
                    }
                    jsonObject.put("id", id);
                    mapTemp.put(fieldNumber, (Object)jsonObject);
                } else if (property instanceof MulBasedataProp) {
                    JSONArray jsonArray = new JSONArray();
                    Object[] split = (Object[])ConvertUtils.convert((String[])defVal.split(","), Object.class);
                    String basedataId = ((MulBasedataProp)property).getBaseEntityId();
                    DynamicObject[] dynamicObjects = new HRBaseServiceHelper(basedataId).loadDynamicObjectArray(split);
                    if (dynamicObjects != null) {
                        Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
                            Map<String, Map<String, Object>> entityBdFieldMainPropName = this.importStarter.getImportContext().getBdFieldMainPropName();
                            Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(property.getName());
                            String realNumber = (String)bdFieldMainPropName.get("number");
                            String realName = (String)bdFieldMainPropName.get("name");
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("number", (Object)dynamicObject.getString(realNumber));
                            jsonObject.put("name", (Object)dynamicObject.getString(realName));
                            jsonObject.put("$basedataentity", (Object)basedataId);
                            jsonObject.put("$basedataBelongEntity", (Object)entityKey);
                            jsonObject.put("id", dynamicObject.get("id"));
                            jsonArray.add((Object)jsonObject);
                            this.dataValidateParams.getBaseDataContainer().addBaseDataDy(entityKey, basedataId, property.getName(), (Object)dynamicObject.getString(realNumber), Collections.singletonList(dynamicObject));
                        });
                    }
                    mapTemp.put(fieldNumber, (Object)jsonArray);
                } else {
                    mapTemp.put(fieldNumber, (Object)defVal);
                }
                result.put(entityKeyTemp, (Object)mapTemp);
            });
        }
        return result;
    }
}

