/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.validate;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import kd.hrmp.hies.entry.core.validate.InnerEntryValidateHandler;

public final class EntryFieldControlValidator
extends InnerEntryValidateHandler {
    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        for (ImportBillData billData : billDataList) {
            billData.getData().forEach((key, value) -> {
                Set<String> nonFieldPerm = this.getDataValidateParams().getNonFieldPermMap((String)key);
                if (nonFieldPerm == null || nonFieldPerm.size() == 0) {
                    return;
                }
                this.getErrCollect(importLog, billData, (JSONObject)value, nonFieldPerm);
            });
        }
    }

    private void getErrCollect(ImportLog importLog, ImportBillData billData, JSONObject rowJSON, Collection<String> nonFieldPerm) {
        nonFieldPerm.forEach(field -> {
            if (rowJSON.containsKey(field)) {
                String cellIndex = this.getCellIndex((String)field);
                DataValidateServiceHelper.writeRowErrorLog((int)4, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex)});
            }
        });
    }
}

