/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.validate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import kd.hr.impt.core.validate.util.ValidatorUtils;
import kd.hrmp.hies.entry.core.validate.InnerEntryValidateHandler;
import org.apache.commons.lang3.ObjectUtils;

public final class EntryFormatValidator
extends InnerEntryValidateHandler {
    private ValidatorUtils validatorUtils = new ValidatorUtils();

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billDataList.get(0).getMainEntityId());
        Map allEntities = entityType.getAllEntities();
        Map<String, String> marksMap = this.getDataValidateParams().getMarksMap();
        for (ImportBillData billData : billDataList) {
            billData.getData().forEach((key, value) -> this.iterateProp(importLog, billData, ((EntityType)allEntities.get(key)).getProperties(), (JSONObject)value, marksMap));
        }
    }

    private void iterateProp(ImportLog importLog, ImportBillData billData, DataEntityPropertyCollection properties, JSONObject data, Map<String, String> marksMap) {
        ArrayList errorCollect = Lists.newArrayListWithCapacity((int)16);
        for (IDataEntityProperty property : properties) {
            String cellIndex;
            String fieldKey = MethodUtil.getLevelOneKey((String)property.getName());
            Object keyValue = data.get((Object)property.getName());
            if (Objects.isNull(keyValue)) continue;
            List<String> ignoreValidateField = this.getDataValidateParams().getIgnoreValidateField();
            if (this.getDataValidateParams().getNeedFormatTelFields().contains(property.getName())) {
                errorCollect.clear();
                ValidatorUtils.checkTelFormat((String)((String)keyValue), (List)errorCollect, this.getDataValidateParams().getCountryToAreaCode());
                if (errorCollect.size() <= 0 || CollectionUtils.isNotEmpty(ignoreValidateField) && ignoreValidateField.contains(fieldKey)) continue;
                cellIndex = this.getCellIndex(property.getName());
                DataValidateServiceHelper.writeRowErrorLog((int)1, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{cellIndex, errorCollect.get(0)});
                continue;
            }
            if (this.getDataValidateParams().getNeedFormatEmailFields().contains(property.getName())) {
                errorCollect.clear();
                ValidatorUtils.checkEmailFormat((String)((String)keyValue), (List)errorCollect);
                if (errorCollect.size() <= 0 || CollectionUtils.isNotEmpty(ignoreValidateField) && ignoreValidateField.contains(fieldKey)) continue;
                cellIndex = this.getCellIndex(property.getName());
                DataValidateServiceHelper.writeRowErrorLog((int)2, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), keyValue});
                continue;
            }
            errorCollect.clear();
            this.validatorUtils.formatValidate(data, (List)errorCollect, property, marksMap);
            if (errorCollect.size() > 0) {
                if (CollectionUtils.isNotEmpty(ignoreValidateField) && ignoreValidateField.contains(fieldKey)) continue;
                cellIndex = this.getCellIndex(property.getName());
                DataValidateServiceHelper.writeRowErrorLog((int)3, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), keyValue});
            } else {
                this.checkFieldValueRange(data, billData, importLog, property, data.get((Object)property.getName()));
            }
            this.checkTextFieldLength(importLog, billData, data, property, keyValue);
            this.checkMulComboField(importLog, billData, data, property, keyValue);
        }
    }

    private void checkMulComboField(ImportLog importLog, ImportBillData billData, JSONObject data, IDataEntityProperty property, Object keyValue) {
        HashMap comboItems = new HashMap(16);
        if (property instanceof ComboProp) {
            HashMap<String, String> itmes = new HashMap<String, String>(16);
            comboItems.put(property.getName(), itmes);
            ComboProp temp = (ComboProp)property;
            for (ValueMapItem item : temp.getComboItems()) {
                itmes.put(item.getName().getLocaleValue(), item.getValue());
            }
            boolean isValidCombo = true;
            if (!comboItems.isEmpty() && comboItems.containsKey(property.getName())) {
                Map fieldVal = (Map)comboItems.get(property.getName());
                String comboVal = keyValue.toString();
                if (comboVal.contains("\uff0c")) {
                    isValidCombo = this.checkComboValue(fieldVal, comboVal, "\uff0c");
                } else if (comboVal.contains(",")) {
                    isValidCombo = this.checkComboValue(fieldVal, comboVal, ",");
                } else {
                    Object returnVal = fieldVal.get(keyValue);
                    if (ObjectUtils.isEmpty(returnVal)) {
                        isValidCombo = false;
                    }
                }
            }
            if (!isValidCombo) {
                String cellIndex = this.getCellIndex(property.getName());
                DataValidateServiceHelper.writeRowErrorLog((int)22, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), this.optimizeTipsValue(keyValue.toString())});
            }
        }
    }

    private boolean checkComboValue(Map<String, Object> fieldVal, String comboVal, String dot) {
        String[] split;
        for (String str : split = comboVal.split(dot)) {
            String val = (String)fieldVal.get(str);
            if (!Objects.isNull(val)) continue;
            return false;
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkFieldValueRange(JSONObject data, ImportBillData billData, ImportLog importLog, IDataEntityProperty property, Object value) {
        if (Objects.isNull(value)) {
            return;
        }
        if (property instanceof DecimalProp) {
            if (!((DecimalProp)property).checkScope(value)) {
                String cellIndex = this.getCellIndex(property.getName());
                DataValidateServiceHelper.writeRowErrorLog((int)25, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)data.getIntValue("$excelIndex"), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), this.optimizeTipsValue(value.toString()), ((DecimalProp)property).getDataScope()});
                return;
            }
            if (value != null) {
                Pattern pattern;
                Matcher matcher;
                String valueTemp = String.valueOf(value);
                int integerPlaces = ((DecimalProp)property).getPrecision() - ((DecimalProp)property).getScale();
                int decimalPlaces = ((DecimalProp)property).getScale();
                if (integerPlaces == 0 && decimalPlaces == 0) {
                    return;
                }
                if (valueTemp.contains("E")) {
                    valueTemp = new BigDecimal(valueTemp).toPlainString();
                }
                if (!(matcher = (pattern = decimalPlaces > 0 ? Pattern.compile("^[-+]?([0-9]{1," + integerPlaces + "})+[.]+([0-9]{1," + decimalPlaces + "})$|^[-+]?[0-9]{1," + integerPlaces + "}$") : Pattern.compile("^[-+]?[0-9]{1," + integerPlaces + "}$")).matcher(valueTemp)).matches()) {
                    String cellIndex = this.getCellIndex(property.getName());
                    DataValidateServiceHelper.writeRowErrorLog((int)28, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)data.getIntValue("$excelIndex"), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), this.optimizeTipsValue(value.toString()), integerPlaces, decimalPlaces});
                }
            }
        }
    }

    private void checkTextFieldLength(ImportLog importLog, ImportBillData billData, JSONObject data, IDataEntityProperty property, Object keyValue) {
        if (Objects.isNull(keyValue)) {
            return;
        }
        if (property.getName().endsWith("tag") && ((TextProp)property).getMaxLenth() == 0 && ((TextProp)property).getMinLenth() == 0) {
            return;
        }
        List<String> ignoreValidateField = this.getDataValidateParams().getIgnoreValidateField();
        if (property instanceof MuliLangTextProp) {
            int maxLenth = ((TextProp)property).getMaxLenth();
            int minLenth = ((TextProp)property).getMinLenth();
            data.getJSONObject(property.getName()).forEach((fieldKey, fieldValue) -> {
                if (Objects.isNull(fieldValue)) {
                    return;
                }
                if (fieldValue.toString().length() > maxLenth || fieldValue.toString().length() < minLenth) {
                    if (CollectionUtils.isNotEmpty((Collection)ignoreValidateField) && ignoreValidateField.contains(MethodUtil.getLevelOneKey((String)fieldKey))) {
                        return;
                    }
                    String cellIndex = this.getCellIndex(property.getName().concat(".").concat((String)fieldKey));
                    DataValidateServiceHelper.writeRowErrorLog((int)21, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), this.optimizeTipsValue(fieldValue.toString()), "[".concat(String.valueOf(minLenth)).concat(",").concat(String.valueOf(maxLenth)).concat("]")});
                }
            });
        } else if (property instanceof TextProp) {
            int maxLenth = ((TextProp)property).getMaxLenth();
            int minLenth = ((TextProp)property).getMinLenth();
            if (keyValue.toString().length() > maxLenth || keyValue.toString().length() < minLenth) {
                if (CollectionUtils.isNotEmpty(ignoreValidateField) && ignoreValidateField.contains(MethodUtil.getLevelOneKey((String)property.getName()))) {
                    return;
                }
                String cellIndex = this.getCellIndex(property.getName());
                DataValidateServiceHelper.writeRowErrorLog((int)21, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), this.optimizeTipsValue(keyValue.toString()), "[".concat(String.valueOf(minLenth)).concat(",").concat(String.valueOf(maxLenth)).concat("]")});
            }
        }
    }

    private String optimizeTipsValue(String fieldValue) {
        if (fieldValue.length() > 30) {
            fieldValue = fieldValue.substring(0, 30).concat("...");
        }
        return fieldValue;
    }
}

