/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.formplugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.util.ExcelUtil;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hrmp.hies.entry.business.ExportEntryDataHelper;
import kd.hrmp.hies.entry.business.templateConf.EntryTemplateConfService;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeShowTemplateSelectListEventArgs;
import kd.hrmp.hies.entry.common.util.EntryExportUtil;
import kd.hrmp.hies.entry.mservice.api.IEntryService;
import kd.hrmp.hies.entry.mservice.api.IEntryTemplateService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HREntryExportPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(HREntryExportPlugin.class);
    private final String HR_EXP_ENTRY_TASKID = "hr_exp_entry_taskId";
    private static final String KEY_PROGRESSBAR = "progressbarap";

    public void onProgress(ProgressEvent progressEvent) {
        this.dealOnProgress(progressEvent);
    }

    private void dealOnProgress(ProgressEvent evt) {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        Map result = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getExpTaskId(), (String)ImportCacheKeyType.EXPORT, (String)"result"), Map.class);
        String status = (String)cache.get(MethodUtil.getTaskCachePath((String)this.getExpTaskId(), (String)ImportCacheKeyType.EXPORT, (String)"status"), String.class);
        if ("stop".equals(status)) {
            this.getView().close();
            return;
        }
        if (result != null) {
            evt.setProgress(99);
            this.stopBar();
            String msg = String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\uff0c\u603b\u8ba1%1$s\u6761\u6570\u636e", (String)HiesEntryRes.HREntryExportPlugin_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), result.get("total"));
            if (result.get("timeRemaining") != null) {
                int timeRemaining = Integer.parseInt(String.valueOf(result.get("timeRemaining")));
                if (timeRemaining == 0) {
                    timeRemaining = 1;
                }
                if (timeRemaining > 0) {
                    int minute = timeRemaining / 60;
                    int second = timeRemaining % 60;
                    StringBuilder sb = new StringBuilder();
                    sb.append(ResManager.loadKDString((String)"\u5171\u8017\u65f6\uff1a", (String)HiesEntryRes.HREntryExportPlugin_4.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                    if (minute > 0) {
                        sb.append(minute).append(ResManager.loadKDString((String)"\u5206", (String)HiesEntryRes.HREntryExportPlugin_3.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                    }
                    if (second > 0) {
                        sb.append(second).append(ResManager.loadKDString((String)"\u79d2", (String)HiesEntryRes.HREntryExportPlugin_5.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                    }
                    Label time = (Label)this.getView().getControl("remainingtime");
                    time.setText(sb.toString());
                    evt.setProgress(100);
                }
            }
            Label mainTitle = (Label)this.getView().getControl("maintitle");
            mainTitle.setText(msg);
            this.getView().setVisible(Boolean.TRUE, new String[]{"close"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel"});
            String surl = String.valueOf(result.get("url"));
            this.getModel().setValue("exportfilenameurl", (Object)surl);
            String url = this.getDownloadUrl(surl);
            this.initDownLoadFileText();
            if (HRStringUtils.isNotEmpty((String)url)) {
                this.getView().download(url);
            }
            Label progressLab = (Label)this.getView().getControl("progress");
            progressLab.setText("100%");
            if (result.getOrDefault("sysTerminator", false).booleanValue()) {
                String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u5f02\u5e38\uff01traceId:%s \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HREntryExportPlugin_7", (String)"hrmp-hies-entry", (Object[])new Object[0]), this.getPageCache().get("taskTraceId"));
                this.getView().showErrorNotification(tip);
            }
        } else {
            Map data = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getExpTaskId(), (String)ImportCacheKeyType.EXPORT, (String)"processing"), Map.class);
            if (null != data) {
                int progress = (Integer)data.get("progress");
                Label progressLab = (Label)this.getView().getControl("progress");
                progressLab.setText(progress + "%");
                evt.setProgress(progress);
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel", "close", "exportfilename"});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        HIESUtil.removeTaskKey((String)this.getExpTaskId(), (String)ImportCacheKeyType.EXPORT);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView currView = this.getView();
        Map customParams = currView.getFormShowParameter().getCustomParams();
        String entryKey = ExportEntryDataHelper.getEntryKey(customParams);
        this.getPageCache().put("entryKey", entryKey);
        DynamicObject[] objects = EntryTemplateConfService.getEnabledTplByEntryKey((String)customParams.get("formId"), entryKey);
        if (ObjectUtils.isNotEmpty((Object)objects)) {
            this.openSelectTplList();
            this.getPageCache().put("needSelectTpl", "true");
        } else {
            this.startTask(false);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btncancel".equals(key)) {
            IHRAppCache cache = HRAppCache.get((String)"hies");
            cache.put(MethodUtil.getTaskCachePath((String)this.getExpTaskId(), (String)ImportCacheKeyType.EXPORT, (String)"status"), (Object)"stop");
            String msg = ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f", (String)HiesEntryRes.HREntryExportPlugin_2.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
        } else if ("exportfilename".equals(key)) {
            String url = this.getDownloadUrl((String)this.getModel().getValue("exportfilenameurl"));
            this.getView().download(url);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)"selectTpl", (CharSequence)closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() != null) {
                Object returnData = closedCallBackEvent.getReturnData();
                this.getPageCache().put("tplpkid", String.valueOf(returnData));
                this.startTask(true);
            } else {
                this.getView().close();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
    }

    private void startTask(boolean isCfgTpl) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String formId = (String)customParams.get("formId");
        String entryKey = this.getPageCache().get("entryKey");
        int startRowNum = 4;
        if (!isCfgTpl) {
            Pair multiLevelHeaderBOPair = MethodUtil.parseTableLayout((String)formId, (String)entryKey, null);
            Integer tableLayoutLevel = (Integer)multiLevelHeaderBOPair.getRight();
            if (tableLayoutLevel > 3) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u652f\u6301\u4e09\u7ea7\u4ee5\u4e0a\u8868\u5934\u5bfc\u5165\u5bfc\u51fa\u3002", (String)HiesEntryRes.HREntryExportPlugin_6.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                this.getView().close();
                return;
            }
            startRowNum = tableLayoutLevel > 1 ? startRowNum + tableLayoutLevel - 1 : startRowNum;
        }
        customParams.put("startRowNum", startRowNum);
        this.setExpTaskId();
        this.getView().setVisible(Boolean.FALSE, new String[]{"close"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"btncancel"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"exportfilename"});
        this.startBar();
        EntryGrid grid = (EntryGrid)this.getView().getParentView().getControl(entryKey);
        IFormView parentView = MethodUtil.getViewNoPlugin((String)this.getView().getFormShowParameter().getParentPageId());
        int totalRow = parentView.getModel().getEntryRowCount(entryKey);
        if (grid.getEntryState().getSelectedRows().length > 0) {
            totalRow = grid.getEntryState().getSelectedRows().length;
        }
        Label exportFileName = (Label)this.getView().getControl("exportfilename");
        String sheetName = ExportEntryDataHelper.getEntryName(entryKey, parentView.getModel());
        String entityName = parentView.getModel().getDataEntityType().getDisplayName().getLocaleValue();
        String tplpkid = this.getPageCache().get("tplpkid");
        String downLoadFileName = EntryExportUtil.getExptFileName(isCfgTpl ? "config" : "current", sheetName, entityName, null, tplpkid, false);
        exportFileName.setText(downLoadFileName + ".xlsx");
        final HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("taskPkId", this.getExpTaskId());
        params.put("tplpkid", tplpkid);
        params.put("totalRow", totalRow);
        params.put("sheetName", sheetName);
        params.put("entryKey", entryKey);
        params.put("downLoadFileName", downLoadFileName);
        params.put("customParams", JSONObject.toJSONString((Object)customParams));
        params.put("pageId", this.getView().getFormShowParameter().getParentPageId());
        params.put("requestContext", SerializationUtils.toJsonString((Object)RequestContext.get()));
        LOGGER.info("startExportExcel_");
        final RequestContext requestContext = RequestContext.get();
        this.getPageCache().put("taskTraceId", requestContext.getTraceId());
        final String routeAppId = MethodUtil.getRouteAppId((String)this.getView().getFormShowParameter().getServiceAppId());
        ThreadPools.executeOnce((String)("startExportExcel_" + System.currentTimeMillis()), (Runnable)new Runnable(){

            @Override
            public void run() {
                MethodUtil.syncRequestTraceId((Object)requestContext);
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.warn(interruptedException.getMessage());
                }
                LOGGER.info("before_invokeService_startExportExcel");
                Object ret = DispatchServiceHelper.invokeService((String)"kd.hrmp.hies.entry.servicehelper", (String)routeAppId, (String)IEntryService.class.getSimpleName(), (String)"startExportExcel", (Object[])new Object[]{params});
            }
        });
    }

    private void initDownLoadFileText() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"exportfilename"});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", "#5582F3");
        this.getView().updateControlMetadata("exportfilename", map);
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.stop();
    }

    private String getExpTaskId() {
        return this.getView().getPageCache().get("hr_exp_entry_taskId");
    }

    private void setExpTaskId() {
        this.getView().getPageCache().put("hr_exp_entry_taskId", this.getView().getPageId());
    }

    private void openSelectTplList() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setFormId("hies_entrytplexptselect");
        lsp.setBillFormId("hies_entrytplselectenti");
        lsp.setShowTitle(false);
        lsp.setHasRight(true);
        lsp.setLookUp(true);
        lsp.setMultiSelect(false);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectTpl"));
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        lsp.setCustomParam("formId", showParameter.getCustomParam("formId"));
        lsp.setCustomParam("ListName", showParameter.getCustomParam("ListName"));
        lsp.setCustomParam("importPlugin", showParameter.getCustomParam("importPlugin"));
        lsp.setCustomParam("ServiceAppId", (Object)showParameter.getServiceAppId());
        lsp.setCustomParam("pageId", (Object)this.getView().getPageId());
        lsp.setCustomParam("entryKey", (Object)this.getPageCache().get("entryKey"));
        HashMap params = Maps.newHashMapWithExpectedSize((int)6);
        params.put("showFormId", lsp.getFormId());
        params.put("showBillFormId", lsp.getBillFormId());
        params.put("formId", showParameter.getCustomParam("formId"));
        params.put("hr_entryId", showParameter.getCustomParam("hr_entryId"));
        params.put("entryKey", this.getPageCache().get("entryKey"));
        params.put("importPlugin", showParameter.getCustomParam("importPlugin"));
        params.put("pageId", this.getView().getPageId());
        String routeAppId = MethodUtil.getRouteAppId((String)this.getView().getFormShowParameter().getServiceAppId());
        Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hrmp.hies.entry.servicehelper", (String)routeAppId, (String)IEntryTemplateService.class.getSimpleName(), (String)"beforeShowTemplateSelectListEvent", (Object[])new Object[]{params});
        if (result.isSuccess()) {
            BeforeShowTemplateSelectListEventArgs args = (BeforeShowTemplateSelectListEventArgs)((Object)result.getData());
            if (args.getqFilterListStr() != null) {
                LinkedList<QFilter> qFilterList = new LinkedList<QFilter>();
                args.getqFilterListStr().forEach(item -> qFilterList.add(QFilter.fromSerializedString((String)item)));
                args.setqFilterList(qFilterList);
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                listFilterParameter.setQFilters(args.getqFilterList());
                lsp.setListFilterParameter(listFilterParameter);
            }
            this.getView().showForm((FormShowParameter)lsp);
        } else {
            this.getView().showErrorNotification(result.getMsg());
        }
    }

    private String getDownloadUrl(String surl) {
        return ExcelUtil.getDownloadUrl((String)surl, (String)this.getView().getEntityId(), (String)"4730fc9f000004ae");
    }
}

