/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.formplugin;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.NetAddressUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.util.ExcelUtil;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportTaskClick;
import kd.hrmp.hies.entry.business.ExportEntryDataHelper;
import kd.hrmp.hies.entry.business.templateConf.EntryTemplateConfService;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeShowTemplateSelectListEventArgs;
import kd.hrmp.hies.entry.common.util.EntryImportUtil;
import kd.hrmp.hies.entry.core.init.EntryExcelImportTask;
import kd.hrmp.hies.entry.mservice.api.IEntryService;
import kd.hrmp.hies.entry.mservice.api.IEntryTemplateService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HREntryImportStartPlugin
extends HRDataBaseEdit
implements UploadListener,
ProgresssListener,
HyperLinkClickListener {
    private static final Log LOGGER = LogFactory.getLog(HREntryImportStartPlugin.class);
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String PROGRESSBARAPVALI = "progressbarapvali";
    private static final String FILE_SERVER_URL = "serverUrl";
    private static final String CHECK_TEMPLATE_CALLBACK = "checkTemplate_callBack";
    private static final String CONCURRENT = "concurrent";
    private static final String CURRENT_STATUS = "currentStatus";
    private static final String INIT = "init";
    private static final String UPLOAD = "upload";
    private static final String SELECT_MODLE = "selectModle";
    private static final String VALIDATE = "validate";
    private static final String VALIDATE_FAILED = "validateFailed";
    private static final String INSTORE = "instore";
    private static final String FINISHED = "finished";
    private static final String TERMINATOR = "terminator";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btndowntpl", "btnstart", "btnreupload", "btndownerror", "btnstop", "lblfilename1", "lblfilename3", "lblfilename5", "lblfilename6"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("fileupload");
        attachmentPanel.addUploadListener((UploadListener)this);
        Button btnreupload = (Button)this.getView().getControl("btnreupload");
        btnreupload.addUploadListener((UploadListener)this);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
        ProgressBar barvali = (ProgressBar)this.getView().getControl(PROGRESSBARAPVALI);
        barvali.addProgressListener((ProgresssListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.statusControlDisplay(INIT);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entryKey = ExportEntryDataHelper.getEntryKey(customParams);
        this.getPageCache().put("entryKey", entryKey);
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btndowntpl": {
                IFormView currView = this.getView();
                Map customParams = currView.getFormShowParameter().getCustomParams();
                LOGGER.info("HREntryImportStartPlugin customParams:{}", (Object)customParams);
                String entryKey = this.getPageCache().get("entryKey");
                DynamicObject[] objects = EntryTemplateConfService.getEnabledTplByEntryKey((String)customParams.get("formId"), entryKey);
                if (ObjectUtils.isNotEmpty((Object)objects)) {
                    this.openSelectTplList();
                    break;
                }
                String formId = (String)customParams.get("formId");
                int startRowNum = 4;
                Pair multiLevelHeaderBOPair = MethodUtil.parseTableLayout((String)formId, (String)entryKey, null);
                Integer tableLayoutLevel = (Integer)multiLevelHeaderBOPair.getRight();
                if (tableLayoutLevel > 3) {
                    this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u652f\u6301\u4e09\u7ea7\u4ee5\u4e0a\u8868\u5934\u5bfc\u5165\u5bfc\u51fa\u3002", (String)HiesEntryRes.HREntryImportStartPlugin_3.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                    this.getView().close();
                    return;
                }
                startRowNum = tableLayoutLevel > 1 ? startRowNum + tableLayoutLevel - 1 : startRowNum;
                customParams.put("startRowNum", startRowNum);
                customParams.put("entryKey", entryKey);
                customParams.put("extParam", this.getModel().getValue("extparam"));
                customParams.put("defaultBaseinfoFormat", this.getDefaultBaseinfoformat());
                customParams.put("appId", currView.getFormShowParameter().getAppId());
                String routeAppId = MethodUtil.getRouteAppId((String)this.getView().getFormShowParameter().getServiceAppId());
                Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hrmp.hies.entry.servicehelper", (String)routeAppId, (String)IEntryService.class.getSimpleName(), (String)"downLoadCurrentTemplate", (Object[])new Object[]{customParams});
                if (!result.isSuccess()) {
                    this.getView().showErrorNotification(result.getMsg());
                    break;
                }
                this.getView().download((String)result.getData());
                break;
            }
            case "btnstart": {
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("fileupload");
                List attachmentData = attachmentPanel.getAttachmentData();
                if (CollectionUtils.isEmpty((Collection)attachmentData)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)HiesEntryRes.HREntryImportStartPlugin_4.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                    return;
                }
                Date starttime = new Date();
                this.getModel().setValue("starttime", (Object)starttime.getTime());
                this.startImportTask();
                this.statusControlDisplay(INSTORE);
                ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
                bar.start();
                bar.setPercent(0);
                Label lblprogress = (Label)this.getControl("lblprogress");
                lblprogress.setText("0%");
                break;
            }
            case "lblreupload": 
            case "btnreupload": {
                this.reUpload();
                break;
            }
            case "btnstop": {
                LOGGER.info("EntryImportUtil_btnstop");
                EntryImportUtil.triggerTerminate(this.getTaskId());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u901a\u77e5\u7cfb\u7edf\u7ec8\u6b62\u5bfc\u5165\u3002", (String)HiesEntryRes.HREntryImportStartPlugin_5.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                break;
            }
            case "btndownloadallreport": {
                String url = this.getDownloadUrl(this.getPageCache().get("uploadId"));
                this.getView().download(url);
                break;
            }
            case "btndownerror": {
                this.downErrorFile();
                break;
            }
            case "lblfilename1": 
            case "lblfilename3": 
            case "lblfilename5": 
            case "lblfilename6": {
                String url2 = this.getDownloadUrl(this.getPageCache().get("uploadId"));
                this.getView().download(url2);
                break;
            }
        }
    }

    private void downErrorFile() {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        Map customData = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskId(), (String)ImportCacheKeyType.IMPORT, (String)"urls"), Map.class);
        if (customData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u7ed3\u679c\u62a5\u544a\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)HiesEntryRes.HREntryImportStartPlugin_6.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)customData.get("errorFileData")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u7ed3\u679c\u62a5\u544a\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)HiesEntryRes.HREntryImportStartPlugin_6.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            return;
        }
        String url = this.getDownloadUrl((String)customData.get("errorFileData"));
        this.getView().download(url);
    }

    private String getTaskPKId() {
        return this.getPageCache().get("import_taskPKid");
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("import_taskPKid")) {
            return (String)this.getView().getFormShowParameter().getCustomParam("import_taskPKid");
        }
        return this.getPageCache().get("import_taskPKid");
    }

    private void startImportTask() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map params = showParameter.getCustomParams();
        String routeAppId = MethodUtil.getRouteAppId((String)showParameter.getServiceAppId());
        this.constructCustomParams(showParameter.getAppId(), params);
        Object tplpkid = this.getModel().getValue("tplpkid");
        int startRowNum = 5;
        if (ObjectUtils.isEmpty((Object)tplpkid)) {
            String entryKey;
            String formId = (String)params.get("formId");
            Pair multiLevelHeaderBOPair = MethodUtil.parseTableLayout((String)formId, (String)(entryKey = this.getPageCache().get("entryKey")), null);
            Integer tableLayoutLevel = (Integer)multiLevelHeaderBOPair.getRight();
            if (tableLayoutLevel > 3) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u652f\u6301\u4e09\u7ea7\u4ee5\u4e0a\u8868\u5934\u5bfc\u5165\u5bfc\u51fa\u3002", (String)HiesEntryRes.HREntryImportStartPlugin_3.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                this.getView().close();
                return;
            }
            startRowNum = tableLayoutLevel > 1 ? 5 + tableLayoutLevel - 1 : startRowNum;
        }
        params.put("startRowNum", startRowNum);
        JobInfo job = new JobInfo();
        job.setAppId(routeAppId);
        job.setJobType(JobType.REALTIME);
        job.setName((String)this.getModel().getValue("filename"));
        job.setId("hr_entry_import_" + System.currentTimeMillis());
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setTaskClassname(EntryExcelImportTask.class.getName());
        job.setParams(params);
        job.setRunByLang(Lang.get());
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)job);
        job.getParams().put("taskPkId", taskId);
        params.put("taskid", taskId);
        params.put("taskPkId", taskId);
        this.getPageCache().put("import_taskPKid", taskId);
        if (HRStringUtils.isNotEmpty((String)taskId)) {
            JobFormInfo jobFormInfo = new JobFormInfo(job);
            jobFormInfo.setCanBackground(true);
            jobFormInfo.setCanStop(true);
            jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
            jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
            jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
            if (this.getView().getFormShowParameter().getCloseCallBack() != null) {
                jobFormInfo.setCloseCallBack(this.getView().getFormShowParameter().getCloseCallBack());
            } else {
                CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.plugin.expt.ExportCallBack", "background_actionid");
                jobFormInfo.setCloseCallBack(closeCallBack);
            }
            jobFormInfo.setClickClassName(ImportTaskClick.class.getName());
            this.putJobFormInfo(jobFormInfo);
        }
    }

    private void constructCustomParams(String appId, Map<String, Object> params) {
        params.put("appId", appId);
        params.put("taskClassname", EntryExcelImportTask.class.getName());
        params.put("oprtype", OprType.IMPORT.getValue());
        params.put("tplpkid", this.getModel().getValue("tplpkid"));
        params.put("totalRow", this.getModel().getValue("totalrow"));
        params.put("fileUrl", this.getModel().getValue(FILE_SERVER_URL));
        params.put("fileuploadid", this.getModel().getValue("fileuploadid"));
        params.put("fileLocalUrl", this.getModel().getValue("filelocalpath"));
        params.put("fileName", this.getModel().getValue("filename"));
        params.put("fileSize", this.getModel().getValue("filesize"));
        params.put("requestContext", RequestContext.get());
        params.put("sourceIp", NetAddressUtils.getLocalIpAddress());
        String extparam = (String)this.getModel().getValue("extparam");
        params.put("extParam", StringUtils.isBlank((CharSequence)extparam) ? null : extparam);
        params.put("userStartTime", this.getModel().getValue("starttime"));
        params.put("userRealStartTime", System.currentTimeMillis());
        Map threadPoolKeyInfo = MethodUtil.getThreadPoolKeyInfo((String)"RealtimeExecutor");
        params.put("RealtimeExecutor", threadPoolKeyInfo);
        params.put("effectSheetNames", this.getPageCache().get("effectSheetNames"));
        IDataModel model = this.getView().getParentView().getModel();
        Map<String, Long> orgMap = EntityMetadataCache.getDataEntityType((String)this.getView().getParentView().getEntityId()).getProperties().stream().filter(property -> property instanceof OrgProp).collect(Collectors.toMap(IMetadata::getName, key -> {
            Object value = model.getValue(key.getName());
            if (Objects.isNull(value)) {
                return 0L;
            }
            String id = ((DynamicObject)value).getString("id");
            return Long.parseLong(id);
        }));
        params.put("orgMap", orgMap);
        String entryKey = this.getPageCache().get("entryKey");
        params.put("entryKey", entryKey);
        String parentPageId = (String)params.get("pageId");
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        params.put("entryName", ExportEntryDataHelper.getEntryName(entryKey, parentView.getModel()));
        params.put("defaultBaseinfoFormat", this.getDefaultBaseinfoformat());
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove("import_jobforminfo");
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put("import_jobforminfo", str);
        }
    }

    private void reUpload() {
        AttachmentPanel attachmentPanel1 = (AttachmentPanel)this.getView().getControl("fileupload");
        List attachmentDataList = attachmentPanel1.getAttachmentData();
        if (CollectionUtils.isNotEmpty((Collection)attachmentDataList)) {
            for (Map map : attachmentDataList) {
                attachmentPanel1.remove(map);
            }
        }
        IDataModel model = this.getModel();
        model.setValue("filename", (Object)"");
        model.setValue("filesize", (Object)0);
        model.setValue("filelocalpath", (Object)"");
        model.setValue(FILE_SERVER_URL, (Object)"");
        model.setValue("fileuploadid", (Object)"");
        model.setValue("clientUrl", (Object)"");
        this.statusControlDisplay(INIT);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        hyperLinkClickEvent.getFieldName();
        this.statusControlDisplay(INIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String localPath;
            String filesize;
            String filename;
            block16: {
                filename = "";
                try {
                    if (urls[0] instanceof Map) {
                        Map map = (Map)urls[0];
                        String url = (String)map.get("url");
                        filename = (String)map.get("name");
                        filesize = String.valueOf(map.get("size"));
                        long mb = Integer.parseInt(filesize) / 0x100000;
                        if (mb >= 10L) {
                            String msg = ResManager.loadKDString((String)"\u6587\u4ef6%1$s\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u9009\u62e910MB\u4ee5\u4e0b\u7684\u6587\u4ef6\u4e0a\u4f20\u3002", (String)HiesEntryRes.HREntryImportStartPlugin_7.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]);
                            this.getView().showErrorNotification(String.format(Locale.ROOT, msg, filename));
                            return;
                        }
                        try {
                            localPath = ImportFileUtil.downloadTempFile((String)url);
                            break block16;
                        }
                        catch (Exception e) {
                            LOGGER.error((Throwable)e);
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u7a33\u5b9a\u5bfc\u81f4\u4e34\u65f6\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"HRImportStartPlugin_11", (String)"hrmp-hies-import", (Object[])new Object[0]));
                            return;
                        }
                    }
                    String url = String.valueOf(urls[0]);
                    if (url.lastIndexOf("/") != -1) {
                        filename = url.substring(url.lastIndexOf("/") + 1);
                    }
                    localPath = ImportFileUtil.downloadFile((String)url);
                    File file = new File(localPath);
                    filesize = String.valueOf(file.length());
                }
                catch (IOException ioException) {
                    LOGGER.error((Throwable)ioException);
                    this.getView().showErrorNotification(ioException.getMessage());
                    return;
                }
            }
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)filename);
            model.setValue("filesize", (Object)filesize);
            model.setValue("filelocalpath", (Object)localPath);
            this.displayFilename(filename);
            try {
                String serverUrl;
                Map ret = ImportFileUtil.uploadFile((String)filename, (String)localPath);
                model.setValue(FILE_SERVER_URL, ret.get(FILE_SERVER_URL));
                model.setValue("fileuploadid", ret.get("uploadId"));
                model.setValue("clientUrl", ret.get("clientUrl"));
                this.getView().getPageCache().put("uploadId", (String)ret.get("uploadId"));
                String routeAppId = MethodUtil.getRouteAppId((String)this.getView().getFormShowParameter().getServiceAppId());
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                Map customParams = showParameter.getCustomParams();
                customParams.put("extParam", this.getModel().getValue("extparam"));
                customParams.put(FILE_SERVER_URL, ret.get(FILE_SERVER_URL));
                customParams.put("filename", filename);
                customParams.put("entryKey", this.getPageCache().get("entryKey"));
                Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hrmp.hies.entry.servicehelper", (String)routeAppId, (String)IEntryService.class.getSimpleName(), (String)"afterUploadFileEvent", (Object[])new Object[]{customParams});
                Map newFileInfo = null;
                if (result.isSuccess() && ObjectUtils.isNotEmpty((Object)result.getData()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(serverUrl = (String)(newFileInfo = (Map)result.getData()).get(FILE_SERVER_URL)))) {
                    model.setValue(FILE_SERVER_URL, (Object)serverUrl);
                    model.setValue("fileuploadid", newFileInfo.get("uploadId"));
                    model.setValue("clientUrl", newFileInfo.get("clientUrl"));
                    this.getView().getPageCache().put("uploadId", (String)newFileInfo.get("uploadId"));
                }
            }
            catch (Throwable e) {
                LOGGER.error("", e);
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
            finally {
                this.deleteLocalFile();
            }
            try {
                this.checkTemplate();
            }
            catch (Throwable exception) {
                LOGGER.error(exception);
                this.deleteLocalFile();
                HIESUtil.showMessage((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u6821\u9a8c\u5f02\u5e38\u3002", (String)HiesEntryRes.HREntryImportStartPlugin_0.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), (String)exception.getMessage(), (ConfirmCallBackListener)new ConfirmCallBackListener(CHECK_TEMPLATE_CALLBACK, (IFormPlugin)this));
                this.statusControlDisplay(INIT);
                return;
            }
            this.statusControlDisplay(UPLOAD);
        }
    }

    private void deleteLocalFile() {
        try {
            ImportFileUtil.deleteLocalTempFile((String)((String)this.getModel().getValue("filelocalpath")));
        }
        catch (FileSystemException e) {
            LOGGER.info("file can't delete.");
        }
        catch (Throwable e) {
            LOGGER.error(e);
        }
    }

    private void displayFilename(String filename) {
        Label lblfilename1 = (Label)this.getControl("lblfilename1");
        Label lblfilename3 = (Label)this.getControl("lblfilename3");
        Label lblfilename4 = (Label)this.getControl("lblfilename4");
        Label lblfilename5 = (Label)this.getControl("lblfilename5");
        Label lblfilename6 = (Label)this.getControl("lblfilename6");
        Label lblfilename7 = (Label)this.getControl("lblfilename7");
        lblfilename1.setText(filename);
        lblfilename3.setText(filename);
        lblfilename4.setText(filename);
        lblfilename5.setText(filename);
        lblfilename6.setText(filename);
        lblfilename7.setText(filename);
    }

    private void dealOnProgressForVali(ProgressEvent evt) {
        Label lblvalidateprocess1 = (Label)this.getControl("lblvalidateprocess1");
        Label lblvalidateprocess2 = (Label)this.getControl("lblvalidateprocess2");
        IHRAppCache cache = HRAppCache.get((String)"hies");
        Map data = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"processing"), Map.class);
        if (data == null) {
            return;
        }
        String validaterFinished = data.getOrDefault("validaterFinished", "false");
        Integer finishedValidateBillCount = Integer.parseInt(data.getOrDefault("finishedValidateBillCount", "0"));
        Integer successedValidateBillCount = Integer.parseInt(data.getOrDefault("successedValidateBillCount", "0"));
        Integer totalBillCount = Integer.parseInt(data.getOrDefault("totalBillCount", "0"));
        if ("true".equalsIgnoreCase(validaterFinished)) {
            evt.setProgress(99);
            this.stopProcesser(VALIDATE);
            if (successedValidateBillCount.equals(totalBillCount)) {
                if (VALIDATE.equalsIgnoreCase(this.getPageCache().get(CURRENT_STATUS))) {
                    this.statusControlDisplay(INSTORE);
                }
            } else {
                this.stopProcesser(INSTORE);
                this.statusControlDisplay(VALIDATE_FAILED);
                Label lblfailcount3 = (Label)this.getControl("lblfailcount3");
                lblfailcount3.setText(String.valueOf(totalBillCount - successedValidateBillCount));
                Label lbtotalcount3 = (Label)this.getControl("lbtotalcount3");
                lbtotalcount3.setText(String.valueOf(totalBillCount));
                if (successedValidateBillCount > 0) {
                    Label lblsuccesscount3 = (Label)this.getControl("lblsuccesscount3");
                    lblsuccesscount3.setText(String.valueOf(successedValidateBillCount));
                } else {
                    this.statusControlDisplay("noSuccessBill");
                }
                Label lblespensem3 = (Label)this.getControl("lblespensem3");
                Label lblespenses3 = (Label)this.getControl("lblespenses3");
                Long starttime = (Long)this.getModel().getValue("starttime");
                long expense = System.currentTimeMillis() - starttime;
                String minite = String.valueOf((expense /= 1000L) / 60L);
                String second = String.valueOf(expense % 60L);
                lblespensem3.setText(minite);
                if ("0".equalsIgnoreCase(minite)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexmini4"});
                }
                lblespenses3.setText(second);
            }
        } else if (finishedValidateBillCount > 0) {
            int progress = (int)(finishedValidateBillCount.floatValue() / (float)totalBillCount.intValue() * 100.0f);
            if (progress >= 100) {
                progress = 99;
            }
            evt.setProgress(progress);
            lblvalidateprocess1.setText("(" + finishedValidateBillCount + "/" + totalBillCount + ")");
            lblvalidateprocess2.setText(progress + "%");
            Label lblremainingm1 = (Label)this.getControl("lblremainingm1");
            Label lblremainings1 = (Label)this.getControl("lblremainings1");
            Integer validateTimeRemaining = (Integer)data.get("validateTimeRemaining");
            if (validateTimeRemaining != null && validateTimeRemaining > 0) {
                this.statusControlDisplay("hasValidateTimeRemaining");
                String minite = String.valueOf(validateTimeRemaining / 60);
                String second = String.valueOf(validateTimeRemaining % 60);
                lblremainingm1.setText(minite);
                lblremainings1.setText(second);
                if ("0".equalsIgnoreCase(minite)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexmini1"});
                }
            }
        }
    }

    private void dealOnProgress(ProgressEvent evt) {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        Map result = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"result"), Map.class);
        if (result != null) {
            Boolean sysTerminator = (Boolean)result.get("sysTerminator");
            if (Boolean.TRUE.equals(sysTerminator)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)HiesEntryRes.HREntryImportStartPlugin_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            }
            evt.setProgress(99);
            String userHasTerminator = (String)result.get("userHasTerminator");
            LOGGER.info("dealOnProgress.result != null");
            this.stopProcesser(INSTORE);
            if ("true".equals(userHasTerminator)) {
                this.statusControlDisplay(TERMINATOR);
            } else {
                this.statusControlDisplay(FINISHED);
            }
            this.displayResultData(result);
            Object needReport = result.get("needReport");
            Object entryKey = result.get("entryKey");
            if (Objects.nonNull(entryKey)) {
                this.getView().getParentView().updateView(entryKey.toString());
                this.getView().sendFormAction(this.getView().getParentView());
            }
            if (Boolean.parseBoolean(String.valueOf(needReport))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btndownerror"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefail2"});
            }
        } else {
            Map data = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"processing"), Map.class);
            if (data == null) {
                return;
            }
            Integer progress = (Integer)data.get("progress");
            if (progress == null) {
                progress = 0;
            }
            if (progress >= 100) {
                progress = 99;
            }
            evt.setProgress(progress.intValue());
            this.displayInfo(data);
        }
    }

    public void onProgress(ProgressEvent evt) {
        ProgressBar source = (ProgressBar)evt.getSource();
        try {
            if (PROGRESSBARAPVALI.equalsIgnoreCase(source.getKey())) {
                this.dealOnProgressForVali(evt);
            } else if (PROGRESSBARAP.equalsIgnoreCase(source.getKey())) {
                this.dealOnProgress(evt);
            }
        }
        catch (Throwable e) {
            LOGGER.error("dealOnProgress_exception.", e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u5f02\u5e38\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)HiesEntryRes.HREntryImportStartPlugin_2.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
        }
    }

    private void displayInfo(Map<String, Object> data) {
        Integer progress = (Integer)data.get("progress");
        Label lblprogress = (Label)this.getControl("lblprogress");
        lblprogress.setText(progress + "%");
        String finishedBillCount = (String)data.get("finishedBillCount");
        String totalBillCount = (String)data.get("totalRowCount");
        if (StringUtils.isNotBlank((CharSequence)finishedBillCount) && Integer.parseInt(finishedBillCount) > 0) {
            String sta = this.getPageCache().get(CURRENT_STATUS);
            if (!INSTORE.equalsIgnoreCase(sta)) {
                this.statusControlDisplay(INSTORE);
            }
            Label lblinstorevalue = (Label)this.getControl("lblinstorevalue");
            lblinstorevalue.setText("(" + finishedBillCount.concat("/").concat(totalBillCount) + ")");
        }
        Label lblremainingm = (Label)this.getControl("lblremainingm");
        Label lblremainings = (Label)this.getControl("lblremainings");
        Integer timeRemaining = (Integer)data.get("timeRemaining");
        if (timeRemaining != null && timeRemaining > 0) {
            this.statusControlDisplay("hasTimeRemaining");
            String minite = String.valueOf(timeRemaining / 60);
            String second = String.valueOf(timeRemaining % 60);
            lblremainingm.setText(minite);
            lblremainings.setText(second);
            if ("0".equalsIgnoreCase(minite)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexmini"});
                if ("0".equals(second)) {
                    lblremainings.setText("1");
                }
            }
        }
        this.getView().getPageCache().put("totalBillCount", totalBillCount);
    }

    private void removeAttachmentPanel(IFormView view) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("fileupload");
        List attachmentData = attachmentPanel.getAttachmentData();
        if (attachmentData.size() > 0) {
            attachmentPanel.remove((Map)attachmentData.get(0));
        }
    }

    private void displayResultData(Map<String, Object> result) {
        Label lblespense2 = (Label)this.getControl("lblespensem2");
        Label lblespense3 = (Label)this.getControl("lblespenses2");
        Label lblespensem = (Label)this.getControl("lblespensem1");
        Label lblespenses = (Label)this.getControl("lblespenses1");
        String userEndTime = (String)result.get("userEndTime");
        if (StringUtils.isNotBlank((CharSequence)userEndTime)) {
            Date endTime = new Date(Long.parseLong(userEndTime));
            Label lblendtime1 = (Label)this.getControl("lblespensem2");
            lblendtime1.setText(HRDateTimeUtils.defaultDateString((Date)endTime));
            Long starttime = (Long)this.getModel().getValue("starttime");
            long expense = endTime.getTime() - starttime;
            if (StringUtils.isNotBlank((Object)expense)) {
                String minite = String.valueOf((expense /= 1000L) / 60L);
                String second = String.valueOf(expense % 60L);
                if (HRStringUtils.equals((String)"0", (String)minite)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexmini3", "lblresultstatics56"});
                }
                lblespense2.setText(minite);
                lblespensem.setText(minite);
                if (HRStringUtils.equals((String)"0", (String)second)) {
                    lblespenses.setText("1");
                    lblespense3.setText("1");
                } else {
                    lblespenses.setText(second);
                    lblespense3.setText(second);
                }
            }
        }
        String successedBillCount = String.valueOf(result.get("successedBillCount"));
        String totalBillCount = String.valueOf(result.get("totalBillCount"));
        int lostCount = Integer.parseInt(totalBillCount) - Integer.parseInt(successedBillCount == null ? "0" : successedBillCount);
        Label lblsuccesscount = (Label)this.getControl("lblsuccesscount2");
        Label lblfailcount = (Label)this.getControl("lblfailcount2");
        Label lbtotalcount = (Label)this.getControl("lbtotalcount2");
        if (HRStringUtils.isNotEmpty((String)successedBillCount) && HRStringUtils.isNotEmpty((String)totalBillCount)) {
            lblsuccesscount.setText(successedBillCount);
            lblfailcount.setText(String.valueOf(lostCount));
            lbtotalcount.setText(totalBillCount);
        }
        String finishedBillCount = String.valueOf(result.get("finishedBillCount"));
        String userHasTerminator = (String)result.get("userHasTerminator");
        if ("true".equals(userHasTerminator)) {
            this.statusControlDisplay(TERMINATOR);
            if (HRStringUtils.isNotEmpty((String)successedBillCount) && HRStringUtils.equals((String)successedBillCount, (String)"0")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap161"});
            }
            successedBillCount = Optional.ofNullable(successedBillCount).orElse("0");
            int errorCount = Integer.parseInt(finishedBillCount) - Integer.parseInt(successedBillCount);
            if (errorCount == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1611"});
            } else {
                lblfailcount.setText(String.valueOf(errorCount));
            }
            Label lblterminatorcount = (Label)this.getControl("lblterminatorcount");
            Label total = (Label)this.getControl("lbtotalcount1");
            total.setText(totalBillCount);
            int count = Integer.parseInt(totalBillCount) - Integer.parseInt(finishedBillCount);
            lblterminatorcount.setText(String.valueOf(count));
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        HIESUtil.removeTaskKey((String)this.getTaskId(), (String)ImportCacheKeyType.IMPORT);
        try {
            ImportFileUtil.deleteLocalTempFile((String)((String)this.getModel().getValue("filelocalpath")));
        }
        catch (Throwable e) {
            LOGGER.error(e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (messageboxclosedevent.getCallBackId().equalsIgnoreCase(CHECK_TEMPLATE_CALLBACK)) {
            this.removeAttachmentPanel(this.getView());
        }
    }

    private void stopProcesser(String type) {
        if (INSTORE.equals(type)) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
            bar.stop();
        } else if (VALIDATE.equals(type)) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAPVALI);
            bar.stop();
        }
    }

    private void statusControlDisplay(String type) {
        LOGGER.info("statusControlDisplay=" + type);
        switch (type) {
            case "init": {
                Label lblprogress = (Label)this.getControl("lblprogress");
                lblprogress.setText("0%");
                Label lblinstorevalue = (Label)this.getControl("lblinstorevalue");
                lblinstorevalue.setText("");
                Label lblvalidateprocess1 = (Label)this.getControl("lblvalidateprocess1");
                lblvalidateprocess1.setText("");
                Label lblvalidateprocess2 = (Label)this.getControl("lblvalidateprocess2");
                lblvalidateprocess2.setText("0%");
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefleupload", "lblremainingtip", "lblremainingtip1", "flexmini", "flexmini2", "flexmini3", "flexmini4", "flefail1", "flefail2", "flefailed", "flefail3", "flesuccess1", "flesuccess2", "flesuccess3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flestate", "fleremaintime", "lblinstorevalue", "fleremaintime1"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"radserial", "radconcurrent"});
                this.getModel().setValue("model", (Object)CONCURRENT);
                this.getModel().setValue(FILE_SERVER_URL, (Object)"");
                this.removeAttachmentPanel(this.getView());
                this.getPageCache().put(CURRENT_STATUS, INIT);
                break;
            }
            case "upload": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flefinishedupload", "btndownstep", "btnreupload", "btnstart"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "fleselectmodel", "flevalidata", "flevalidata2", "fleinstore", "flestop", "flefinished", "btnupstep", "btnstop", "btnbackground", "btndownerror", "btndownall", "flevalidatefail"});
                this.getPageCache().put(CURRENT_STATUS, UPLOAD);
                break;
            }
            case "selectModle": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "fleselectmodel", "btnupstep", "btnstart"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "flevalidata", "flevalidata2", "fleinstore", "flestop", "flefinished", "btndownstep", "btnstop", "btnbackground", "flevalidatefail", "btndownerror", "btndownall", "btnreupload"});
                this.getPageCache().put(CURRENT_STATUS, SELECT_MODLE);
                String needRelationInStore = this.getPageCache().get("needRelationInStore");
                if (!"true".equals(needRelationInStore)) break;
                this.getView().setEnable(Boolean.FALSE, new String[]{"radserial", "radconcurrent"});
                this.getModel().setValue("model", (Object)"serial");
                break;
            }
            case "validate": {
                String model = (String)this.getModel().getValue("model");
                String canSee = CONCURRENT.equalsIgnoreCase(model) ? "flevalidata" : "flevalidata2";
                String canNotSee = CONCURRENT.equalsIgnoreCase(model) ? "flevalidata2" : "flevalidata";
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", canSee, "btnstop", "btnbackground"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "fleinstore", canNotSee, "flestop", "flefinished", "btndownstep", "btnupstep", "btnstart", "flevalidatefail", "btndownerror", "btndownall", "btnreupload"});
                this.getPageCache().put(CURRENT_STATUS, VALIDATE);
                if (CONCURRENT.equalsIgnoreCase(model)) break;
                this.startProcesser();
                break;
            }
            case "instore": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "fleinstore", "btnstop", "btnbackground", "lblinstorevalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata", "flevalidata2", "flestop", "flefinished", "btndownstep", "btnupstep", "btnstart", "flevalidatefail", "btndownerror", "btndownall", "btnreupload"});
                this.getPageCache().put(CURRENT_STATUS, INSTORE);
                break;
            }
            case "finished": {
                this.stopProcesser(VALIDATE);
                this.stopProcesser(INSTORE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flefinished", "btndownall", "btnreupload", "flefinished2"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata", "flevalidata2", "flestop", "fleinstore", "btndownstep", "btnupstep", "btnstart", "flevalidatefail", "btnstop", "btnbackground", "flefailed"});
                this.getPageCache().put(CURRENT_STATUS, FINISHED);
                break;
            }
            case "terminator": {
                this.stopProcesser(VALIDATE);
                this.stopProcesser(INSTORE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flestop", "btnreupload", "btndownall"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata", "flevalidata2", "flefinished", "fleinstore", "btndownstep", "btnupstep", "btnstart", "flevalidatefail", "btnstop", "btnbackground", "btndownerror"});
                this.getPageCache().put(CURRENT_STATUS, TERMINATOR);
                break;
            }
            case "validateFailed": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "btndownerror", "btndownall", "btnreupload", "flevalidatefail"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata", "flevalidata2", "flestop", "fleinstore", "btndownstep", "btnupstep", "btnstart", "flefinished2", "btnstop", "btnbackground", "flefailed", "flefinished"});
                this.getPageCache().put(CURRENT_STATUS, VALIDATE_FAILED);
                break;
            }
            case "noSuccessBill": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefail1", "flefail2", "flefailed", "flefail3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flesuccess1", "flesuccess2", "btndownall", "flefinished2", "flesuccess3"});
                break;
            }
            case "nofailBill": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flesuccess1", "flesuccess2", "flesuccess3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefail1", "flefail2", "flefail3", "btndownerror", "btndownall"});
                break;
            }
            case "hasTimeRemaining": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fleremaintime"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"lblremainingtip"});
                break;
            }
            case "hasValidateTimeRemaining": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fleremaintime1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"lblremainingtip1"});
                break;
            }
        }
    }

    private void startProcesser() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.setPercent(0);
        bar.start();
    }

    private void checkTemplate() throws Exception {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        String formId = (String)customParams.get("formId");
        String importPlugin = (String)showParameter.getCustomParam("importPlugin");
        String extParam = (String)this.getModel().getValue("extparam");
        String pageId = (String)showParameter.getCustomParam("pageId");
        String entryKey = this.getPageCache().get("entryKey");
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("pageId", pageId);
        params.put("extParam", extParam);
        params.put("importPlugin", importPlugin);
        params.put("formId", formId);
        params.put("entryKey", entryKey);
        params.put("serverPath", this.getModel().getValue(FILE_SERVER_URL));
        params.put("defautBaseinfoformat", this.getDefaultBaseinfoformat());
        int startRowNum = 5;
        Pair multiLevelHeaderBOPair = MethodUtil.parseTableLayout((String)formId, (String)entryKey, null);
        Integer tableLayoutLevel = (Integer)multiLevelHeaderBOPair.getRight();
        if (tableLayoutLevel > 3) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u652f\u6301\u4e09\u7ea7\u4ee5\u4e0a\u8868\u5934\u5bfc\u5165\u5bfc\u51fa\u3002", (String)HiesEntryRes.HREntryImportStartPlugin_3.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        startRowNum = tableLayoutLevel > 1 ? startRowNum + tableLayoutLevel - 1 : startRowNum;
        params.put("startRowNum", startRowNum);
        String routeAppId = MethodUtil.getRouteAppId((String)this.getView().getFormShowParameter().getServiceAppId());
        Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hrmp.hies.entry.servicehelper", (String)routeAppId, (String)IEntryTemplateService.class.getSimpleName(), (String)"templateValidate", (Object[])new Object[]{params});
        if (!result.isSuccess()) {
            throw new Exception(result.getMsg());
        }
        Map ret = (Map)result.getData();
        Object tplpkid = ret.get("tplpkid");
        this.getModel().setValue("totalrow", ret.get("totalrow"));
        this.getModel().setValue("tplpkid", tplpkid);
        this.getPageCache().put("effectSheetNames", (String)ret.get("effectSheetNames"));
    }

    private String getDefaultBaseinfoformat() {
        return "number_name";
    }

    private void openSelectTplList() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setFormId("hies_entrytplselect");
        lsp.setBillFormId("hies_entrytplselectenti");
        lsp.setShowTitle(false);
        lsp.setHasRight(true);
        lsp.setLookUp(true);
        lsp.setMultiSelect(false);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        lsp.setCustomParam("formId", showParameter.getCustomParam("formId"));
        lsp.setCustomParam("ListName", showParameter.getCustomParam("ListName"));
        lsp.setCustomParam("importPlugin", showParameter.getCustomParam("importPlugin"));
        lsp.setCustomParam("extParam", this.getModel().getValue("extparam"));
        lsp.setCustomParam("ServiceAppId", (Object)showParameter.getServiceAppId());
        lsp.setCustomParam("pageId", (Object)this.getView().getPageId());
        lsp.setCustomParam("entryKey", (Object)this.getPageCache().get("entryKey"));
        HashMap params = Maps.newHashMapWithExpectedSize((int)6);
        params.put("showFormId", lsp.getFormId());
        params.put("showBillFormId", lsp.getBillFormId());
        params.put("formId", showParameter.getCustomParam("formId"));
        params.put("hr_entryId", showParameter.getCustomParam("hr_entryId"));
        params.put("entryKey", this.getPageCache().get("entryKey"));
        params.put("importPlugin", showParameter.getCustomParam("importPlugin"));
        params.put("pageId", this.getView().getPageId());
        String routeAppId = MethodUtil.getRouteAppId((String)this.getView().getFormShowParameter().getServiceAppId());
        Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hrmp.hies.entry.servicehelper", (String)routeAppId, (String)IEntryTemplateService.class.getSimpleName(), (String)"beforeShowTemplateSelectListEvent", (Object[])new Object[]{params});
        if (result.isSuccess()) {
            BeforeShowTemplateSelectListEventArgs args = (BeforeShowTemplateSelectListEventArgs)((Object)result.getData());
            if (args.getqFilterListStr() != null) {
                LinkedList<QFilter> qFilterList = new LinkedList<QFilter>();
                args.getqFilterListStr().forEach(item -> qFilterList.add(QFilter.fromSerializedString((String)item)));
                args.setqFilterList(qFilterList);
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                listFilterParameter.setQFilters(args.getqFilterList());
                lsp.setListFilterParameter(listFilterParameter);
            }
            this.getView().showForm((FormShowParameter)lsp);
        } else {
            this.getView().showErrorNotification(result.getMsg());
        }
    }

    private String getDownloadUrl(String surl) {
        return ExcelUtil.getDownloadUrl((String)surl, (String)this.getView().getEntityId(), (String)"4730fc9f000003ae");
    }
}

