/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.mservice;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.util.ExcelStyleUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hrmp.hies.entry.business.ExportEntryDataHelper;
import kd.hrmp.hies.entry.business.template.EntryExcelCurrentTplGenerator;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterUploadFileEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeCreateHeaderColumnEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeCreateTemplateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImpPluginEngine;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImportPlugin;
import kd.hrmp.hies.entry.common.plugin.impt.UserEntryImportPluginUtil;
import kd.hrmp.hies.entry.common.util.EntryExportUtil;
import kd.hrmp.hies.entry.core.init.EntryExportContext;
import kd.hrmp.hies.entry.core.init.EntryExportStarter;
import kd.hrmp.hies.entry.mservice.api.IEntryService;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class EntryServiceImpl
implements IEntryService {
    private static final Log log = LogFactory.getLog(EntryServiceImpl.class);

    @Override
    public Result downLoadCurrentTemplate(Map<String, Object> params) {
        Result result = new Result();
        result.setSuccess(true);
        try {
            log.info("downLoadCurrentTemplate_params:" + JSONObject.toJSONString(params));
            String entryKey = (String)params.get("entryKey");
            if (StringUtils.isEmpty((CharSequence)entryKey)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u64cd\u4f5c\u53c2\u6570\u3002", (String)HiesEntryRes.EntryServiceImpl_0.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            }
            log.info("downLoadCurrentTemplate_entryKey:{}", (Object)entryKey);
            String entityId = (String)params.get("formId");
            String baseinfoformat = (String)params.get("defaultBaseinfoFormat");
            IFormView parentView = MethodUtil.initFormView((String)((String)params.get("pageId")));
            List<HREntryImportPlugin> hrTemplatePlugin = UserEntryImportPluginUtil.getHREntryImportPlugin((String)params.get("importPlugin"), null, (String)params.get("extParam"), null, entityId, entryKey, parentView, parentView.getModel(), "current");
            BeforeCreateTemplateEventArgs args = new BeforeCreateTemplateEventArgs((String)params.get("extParam"), entityId, entryKey, parentView, "current");
            args.setF7formatCfg(Maps.newHashMapWithExpectedSize((int)6));
            HREntryImpPluginEngine.fireImptPluginEvent(hrTemplatePlugin, "beforeCreateTemplate", (EntryAbstractEventArgs)args);
            List<KeyValue> captions = ExportEntryDataHelper.getExpHeader(params, parentView, baseinfoformat, args.getF7formatCfg());
            BeforeCreateHeaderColumnEventArgs args1 = new BeforeCreateHeaderColumnEventArgs((String)params.get("extParam"), entityId, entryKey, parentView, "current");
            args1.setHeaderWriterFormats(captions);
            HREntryImpPluginEngine.fireImptPluginEvent(hrTemplatePlugin, "beforeCreateHeaderColumn", (EntryAbstractEventArgs)args1);
            HasPermOrgResult hasPermOrg = ImportServiceHelper.getEntityHasPermOrg((String)entityId, (String)((String)params.get("ServiceAppId")));
            HashMap mapParam = Maps.newHashMapWithExpectedSize((int)3);
            mapParam.put("userPlugins", hrTemplatePlugin);
            mapParam.put("source", "preView");
            String entityName = parentView.getModel().getDataEntityType().getDisplayName().getLocaleValue();
            String entryName = ExportEntryDataHelper.getEntryName(entryKey, parentView.getModel());
            String fileName = EntryExportUtil.getExptFileName("current", entryName, entityName, null, null, true);
            Object startRowNum = params.get("startRowNum");
            EntryExcelCurrentTplGenerator exporter = new EntryExcelCurrentTplGenerator(ExportEntryDataHelper.getEntryName(entryKey, parentView.getModel()), captions, ObjectUtils.isEmpty((Object)startRowNum) ? 4 : (Integer)startRowNum, true, entityId, fileName, parentView, (String)params.get("appId"));
            exporter.setExportSheetStyle(ExcelStyleUtil.getGlobalSheetStyle((Set)Sets.newHashSet((Object[])new String[]{entityId}), (SXSSFWorkbook)exporter.getWb()));
            exporter.setEntryKey(entryKey);
            exporter.setMapParam(mapParam);
            exporter.setHasPermOrg(hasPermOrg);
            exporter.setEntryExpStarter(new EntryExportContext());
            String url = exporter.generateEntryImportExcelTemplate(entryKey, params, parentView, null, baseinfoformat, args.getDisplayBdSheets(), args.getF7formatCfg());
            result.setData((Object)url);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            result.setSuccess(false);
            result.setCode("999");
            result.setMsg(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result startExportExcel(Map<String, Object> params) {
        Result result = new Result();
        result.setSuccess(true);
        HashMap resultInfo = Maps.newHashMapWithExpectedSize((int)16);
        EntryExportContext context = new EntryExportContext();
        EntryExportStarter starter = new EntryExportStarter(context);
        try {
            starter.initContext(params);
            if ("current".equals(context.getTplType())) {
                starter.startCurrentTpl(resultInfo);
            } else if ("config".equals(context.getTplType())) {
                starter.startConfigTpl(resultInfo);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            resultInfo.put("sysTerminator", true);
            result.setSuccess(false);
            result.setCode("999");
            result.setMsg(e.getMessage());
        }
        finally {
            IHRAppCache cache = HRAppCache.get((String)"hies");
            String taskCachePath = MethodUtil.getTaskCachePath((String)context.getTaskId(), (String)ImportCacheKeyType.EXPORT, (String)"result");
            cache.put(taskCachePath, (Object)resultInfo);
        }
        return result;
    }

    @Override
    public Result afterUploadFileEvent(Map<String, Object> params) {
        Result result = new Result();
        result.setSuccess(true);
        try {
            log.info("afterUploadFileEvent_params:" + JSONObject.toJSONString(params));
            String entryKey = (String)params.get("entryKey");
            String entityId = (String)params.get("formId");
            String extParam = (String)params.get("extParam");
            String filename = (String)params.get("filename");
            String serverUrl = (String)params.get("serverUrl");
            IFormView parentView = MethodUtil.initFormView((String)((String)params.get("pageId")));
            AfterUploadFileEventArgs args = new AfterUploadFileEventArgs(extParam, entityId, entryKey, parentView, "current");
            args.setSourceFileServerUrl(serverUrl);
            args.setFilename(filename);
            List<HREntryImportPlugin> hrTemplatePlugin = UserEntryImportPluginUtil.getHREntryImportPlugin((String)params.get("importPlugin"), null, (String)params.get("extParam"), null, entityId, entryKey, parentView, parentView.getModel(), "current");
            HREntryImpPluginEngine.fireImptPluginEvent(hrTemplatePlugin, "afterUploadFile", (EntryAbstractEventArgs)args);
            result.setData(args.getNewFileInfo());
        }
        catch (Throwable e) {
            log.error(e);
            result.setSuccess(false);
            result.setCode("999");
            result.setMsg(e.getMessage());
        }
        return result;
    }
}

