/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.mservice;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.ReflectUtil;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.util.MethodUtil;
import kd.hrmp.hies.entry.business.template.EntryExcelCfgTplGenerator;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeShowTemplateSelectListEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImpPluginEngine;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImportPlugin;
import kd.hrmp.hies.entry.common.plugin.impt.UserEntryImportPluginUtil;
import kd.hrmp.hies.entry.core.validate.util.EntryTemplateUtils;
import kd.hrmp.hies.entry.mservice.api.IEntryTemplateService;

public class EntryTemplateService
implements IEntryTemplateService {
    private static Log log = LogFactory.getLog(EntryTemplateService.class);

    @Override
    public Result genPreView(DynamicObject templateData, Map<String, Object> mapParam) {
        Result result = new Result();
        result.setSuccess(true);
        try {
            String url = EntryExcelCfgTplGenerator.genPreView(templateData, mapParam);
            result.setData((Object)url);
        }
        catch (Throwable e) {
            log.error(e);
            result.setSuccess(false);
            result.setCode("999");
            result.setMsg(e.getMessage());
        }
        return result;
    }

    @Override
    public Result templateValidate(Map<String, Object> params) {
        Result result = new Result();
        result.setSuccess(true);
        try {
            Map<String, Object> ret = EntryTemplateUtils.checkTemplate(params);
            result.setData(ret);
            String msg = (String)ret.get("msg");
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                result.setCode("999");
                result.setSuccess(false);
                result.setMsg(msg);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            result.setSuccess(false);
            result.setCode("999");
            result.setMsg(e.getMessage());
        }
        return result;
    }

    @Override
    public Result beforeShowTemplateSelectListEvent(Map<String, Object> params) {
        Result result = new Result();
        result.setSuccess(true);
        try {
            String extParam = (String)params.get("extParam");
            String entityId = (String)params.get("formId");
            String entryKey = (String)params.get("entryKey");
            if (StringUtils.isEmpty((CharSequence)entryKey)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u64cd\u4f5c\u53c2\u6570\u3002", (String)HiesEntryRes.EntryTemplateService_0.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            }
            log.info("HREntryImportStartPlugin entryKey:{}", (Object)entryKey);
            IFormView parentView = MethodUtil.initFormView((String)((String)params.get("pageId")));
            BeforeShowTemplateSelectListEventArgs args = new BeforeShowTemplateSelectListEventArgs(extParam, entityId, entryKey, parentView, "config");
            args.setShowFormId((String)params.get("showFormId"));
            args.setShowBillFormId((String)params.get("showBillFormId"));
            Object opPlugin = params.get("importPlugin");
            List<HREntryImportPlugin> hrImportPlugin = UserEntryImportPluginUtil.getHREntryImportPlugin((String)opPlugin, null, extParam, null, entityId, entryKey, parentView, parentView.getModel(), "config");
            HREntryImpPluginEngine.fireImptPluginEvent(hrImportPlugin, "beforeShowTemplateSelectList", (EntryAbstractEventArgs)args);
            LinkedList qfilterstr = new LinkedList();
            if (args.getqFilterList() != null) {
                args.getqFilterList().forEach(item -> qfilterstr.add(item.toSerializedString()));
                ReflectUtil.invoke((Object)((Object)args), (String)"setqFilterListStr", (Object[])new Object[]{qfilterstr});
                args.getqFilterList().clear();
            }
            args.setFormView(null);
            args.setDataModel(null);
            result.setData((Object)args);
        }
        catch (Throwable e) {
            log.error(e);
            result.setSuccess(false);
            result.setCode("999");
            result.setMsg(e.getMessage());
        }
        return result;
    }
}

