/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.business;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.util.ExcelUtil;
import kd.hr.hies.common.util.MethodUtil;

public class ExportCallBack
implements ICloseCallBack {
    private static final Log LOGGER = LogFactory.getLog(ExportCallBack.class);

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getView() == null) {
            return;
        }
        if (e.getReturnData() == null) {
            return;
        }
        Map returnData = (Map)e.getReturnData();
        if (!returnData.containsKey("taskinfo")) {
            return;
        }
        String str = (String)returnData.get("taskinfo");
        if (StringUtils.isBlank((CharSequence)str)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)str, TaskInfo.class);
        Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
        String url = this.waiteResult((String)data.get("taskPkId"), e.getView());
        if (StringUtils.isNotBlank((CharSequence)url)) {
            e.getView().download(url);
        }
    }

    private String waiteResult(String taskPkid, IFormView view) {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        try {
            for (int i = 0; i < 6; ++i) {
                Map result = (Map)cache.get(MethodUtil.getTaskCachePath((String)taskPkid, (String)ImportCacheKeyType.EXPORT, (String)"result"), Map.class);
                if (result != null && result.containsKey("filePatch")) {
                    String url = (String)result.get("filePatch");
                    if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                    return ExcelUtil.getDownloadUrl((String)url, (String)view.getEntityId(), (String)"4730fc9f000004ae");
                }
                TimeUnit.MILLISECONDS.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
        }
        return null;
    }
}

