/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.business;

import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.lang.Lang;
import kd.hr.expt.common.enu.HiesExportRes;

public class ExportProgressHelper {
    public static final String BTN_TOBACKGROUD = "tobackgroud";
    public static final String CTRL_SHOWHISTORY = "showhistory";
    public static final String CTRL_MAIN_TITLE = "maintitle";
    public static final String CTRL_FILENAME = "exportfilename";
    public static final String CTRL_REMAINING_TIME = "remainingtime";
    public static final String CTRL_TIPS = "tips";
    public static final String CTRL_PROGRESS = "progress";
    public static final String VECTOR_SUCCESS = "sucvector";
    static Lang startLanguage = Lang.get();

    private static TextInfo init(String fileName) {
        return new TextInfo().init(fileName);
    }

    public static void initText(IFormView view, String fileName) {
        ExportProgressHelper.setControlText(view, ExportProgressHelper.init(fileName));
        view.setVisible(Boolean.FALSE, new String[]{VECTOR_SUCCESS, "close"});
    }

    private static TextInfo progress(String curExecuteNum, String totalNum, String remainingTime, int progress) {
        return new TextInfo().progress(curExecuteNum, totalNum, remainingTime, progress);
    }

    public static void progressText(IFormView view, String curExecuteNum, String totalNum, String remainingTime, int progress) {
        ExportProgressHelper.setControlText(view, ExportProgressHelper.progress(curExecuteNum, totalNum, remainingTime, progress));
    }

    private static TextInfo complete(String totalNum, String totalCostTime) {
        return new TextInfo().complete(totalNum, totalCostTime);
    }

    public static void completeText(IFormView view, String totalNum, String totalCostTime) {
        ExportProgressHelper.setControlText(view, ExportProgressHelper.complete(totalNum, totalCostTime));
        view.setEnable(Boolean.TRUE, new String[]{CTRL_FILENAME});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", "#5582F3");
        view.updateControlMetadata(CTRL_FILENAME, map);
        view.setVisible(Boolean.FALSE, new String[]{CTRL_TIPS, CTRL_PROGRESS, "btncancel", BTN_TOBACKGROUD});
        view.setVisible(Boolean.TRUE, new String[]{VECTOR_SUCCESS, "close"});
    }

    public static void setControlText(IFormView view, TextInfo textInfo) {
        Label title = (Label)view.getControl(CTRL_MAIN_TITLE);
        ExportProgressHelper.setControlText(title, textInfo.getMainTitle());
        title = (Label)view.getControl(CTRL_FILENAME);
        String fileName = textInfo.getFileName();
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            ExportProgressHelper.setControlText(title, textInfo.getFileName());
            view.setEnable(Boolean.FALSE, new String[]{CTRL_FILENAME});
        }
        title = (Label)view.getControl(CTRL_REMAINING_TIME);
        ExportProgressHelper.setControlText(title, textInfo.getRemainingTime());
        title = (Label)view.getControl(CTRL_PROGRESS);
        ExportProgressHelper.setControlText(title, textInfo.getProgress());
        title = (Label)view.getControl(CTRL_TIPS);
        ExportProgressHelper.setControlText(title, textInfo.getTips());
        title = (Label)view.getControl(CTRL_SHOWHISTORY);
        ExportProgressHelper.setControlText(title, textInfo.getHistory());
    }

    private static void setControlText(Label title, String msg) {
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            title.setText(msg);
        }
    }

    public static class TextInfo {
        String mainTitle = "";
        String fileName = "";
        String remainingTime = "";
        String tips = "";
        String progress = "";
        String history = "";

        private boolean isNotStartLanguage() {
            return StringUtils.isBlank((CharSequence)this.mainTitle) || !Lang.get().equals((Object)startLanguage);
        }

        private TextInfo init(String fileName) {
            this.fileName = String.format(ResManager.loadKDString((String)"%s", (String)HiesExportRes.ExportProgressHelper_1.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), fileName);
            this.initMainTitle();
            this.initTips();
            this.initHistory();
            if (this.isNotStartLanguage()) {
                TextInfo initTextInfo = new TextInfo();
                initTextInfo.setFileName(this.fileName);
                initTextInfo.setMainTitle(this.mainTitle);
                initTextInfo.setTips(this.tips);
                initTextInfo.setHistory(this.history);
                return initTextInfo;
            }
            return this;
        }

        private TextInfo progress(String curExecuteNum, String totalNum, String remainingTime, int progress) {
            if (StringUtils.isNotBlank((CharSequence)curExecuteNum) && StringUtils.isNotBlank((CharSequence)totalNum)) {
                this.mainTitle = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u6570\u636e\u2026 (%1$s/%2$s)", (String)HiesExportRes.ExportProgressHelper_2.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), curExecuteNum, totalNum);
            }
            if (StringUtils.isNotBlank((CharSequence)remainingTime)) {
                this.remainingTime = String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u65f6\u957f\uff1a %s", (String)HiesExportRes.ExportProgressHelper_3.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), remainingTime);
            }
            if (progress > 0) {
                this.progress = progress + "%";
            }
            return this;
        }

        private TextInfo complete(String totalNum, String totalCostTime) {
            this.mainTitle = String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\uff0c\u603b\u8ba1%1$s\u6761\u6570\u636e", (String)HiesExportRes.ExportProgressHelper_4.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), totalNum);
            this.remainingTime = String.format(ResManager.loadKDString((String)"\u5171\u8017\u65f6 %s", (String)HiesExportRes.ExportProgressHelper_5.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), totalCostTime);
            this.tips = "";
            this.progress = "";
            return this;
        }

        public String getMainTitle() {
            return this.mainTitle;
        }

        private void initMainTitle() {
            this.mainTitle = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u6570\u636e\u2026", (String)HiesExportRes.ExportProgressHelper_6.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), new Object[0]);
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getRemainingTime() {
            return this.remainingTime;
        }

        private void initRemainingTime() {
            this.remainingTime = ResManager.loadKDString((String)"\u9884\u8ba1\u65f6\u957f\uff1a\u6b63\u5728\u8ba1\u7b97", (String)HiesExportRes.ExportProgressHelper_7.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]);
        }

        public String getTips() {
            return this.tips;
        }

        public void initTips() {
            this.tips = ResManager.loadKDString((String)"\u82e5\u5bfc\u51fa\u65f6\u95f4\u8fc7\u957f\uff0c\u53ef\u8f6c\u5165\u540e\u53f0\u3002\u8f6c\u5165\u540e\uff0c\u53ef\u524d\u5f80\u201cHR\u901a\u7528\u670d\u52a1>HR\u5bfc\u5165\u5bfc\u51fa>\u5bfc\u5165\u5bfc\u51fa\u51fa\u8bb0\u5f55\u201d\u67e5\u770b\u8fdb\u5ea6\u4e0e\u4e0b\u8f7d\u6587\u4ef6\u3002", (String)"ExportProgressHelper_8", (String)"hrmp-hies-export", (Object[])new Object[0]);
        }

        public String getProgress() {
            return this.progress;
        }

        public void initProgress() {
            this.progress = "0%";
        }

        public void setMainTitle(String mainTitle) {
            this.mainTitle = mainTitle;
        }

        public void setTips(String tips) {
            this.tips = tips;
        }

        public String getHistory() {
            return this.history;
        }

        public void setHistory(String history) {
            this.history = history;
        }

        private void initHistory() {
            this.history = ResManager.loadKDString((String)"\u5386\u53f2\u5bfc\u51fa\u8bb0\u5f55", (String)HiesExportRes.ExportProgressHelper_9.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]);
        }
    }
}

