/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.business.template;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.list.ListColumnType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.expt.common.dto.WriteDataByListContext;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.export.ExportSheetStyle;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportByListDataWriter {
    private static final Log log = LogFactory.getLog(ExportByListDataWriter.class);
    private WriteDataByListContext context;
    private int totalOffset = 0;
    private List<List<Object>> dataRows;

    public ExportByListDataWriter(List<List<Object>> dataRows, WriteDataByListContext context) {
        this.context = context;
        this.dataRows = dataRows;
    }

    public void write() {
        for (List<Object> row : this.dataRows) {
            if (this.context.isShowSeq()) {
                row.set(0, this.context.getSeq().incrementAndGet());
            }
            this.totalOffset = 0;
            int rowCount = this.context.getCurrentWriteRowIndex();
            this.writeLine(this.context.getFieldCaptions(), row, ++rowCount);
            this.context.setCurrentWriteRowIndex(rowCount);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void writeLine(List<KeyValue> captions, List<Object> row, int r) {
        for (int i = 0; i < captions.size(); ++i) {
            boolean isDynamicTextList;
            if (row.size() <= this.totalOffset) continue;
            KeyValue colInfo = captions.get(i);
            Object value = row.get(this.totalOffset);
            boolean bl = isDynamicTextList = colInfo.extend != null && ((Integer)colInfo.extend[0]).intValue() == ListColumnType.DynamicTextList.getValue();
            if (colInfo.value instanceof KeyValue && !isDynamicTextList) {
                if (colInfo.extend != null && ((Integer)colInfo.extend[0]).intValue() == ListColumnType.MergeColumn.getValue()) {
                    this.creatValueCell(value, colInfo.extend, r);
                    continue;
                }
                this.writeLine((List)((KeyValue)colInfo.value).value, row, r);
                continue;
            }
            this.creatValueCell(value, colInfo.extend, r);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void creatValueCell(Object value, Object[] extend, int r) {
        String val;
        SXSSFWorkbook wb = this.context.getWb();
        ExportSheetStyle styles = this.context.getStyles();
        SXSSFSheet sheet = this.context.getSheet();
        if (StringUtils.isBlank((Object)value)) {
            ExportByListDataWriter.createCell(wb, ExportByListDataWriter.getRow(sheet, r), this.totalOffset++, styles.getContentTextStyle()).setCellValue("");
            return;
        }
        if (extend != null && extend.length >= 3) {
            if (extend[0].equals(2)) {
                if (value instanceof NumberPrecision || value instanceof Map) {
                    BigDecimal decimal;
                    Map<String, Integer> dataMap = new HashMap();
                    if (value instanceof NumberPrecision) {
                        NumberPrecision numberPrecisionVal = (NumberPrecision)value;
                        decimal = numberPrecisionVal.getResult();
                        if (decimal == null) {
                            decimal = new BigDecimal(0);
                        }
                        dataMap.put("sign", (Integer)((Object)numberPrecisionVal.getSign()));
                        dataMap.put("precision", numberPrecisionVal.getPrecision());
                        dataMap.put("showSign", (Integer)((Object)Boolean.valueOf(numberPrecisionVal.isShowSign())));
                        dataMap.put("groupingUsed", (Integer)((Object)Boolean.valueOf(numberPrecisionVal.isGroupingUsed())));
                        dataMap.put("stripTrailingZeros", (Integer)((Object)Boolean.valueOf(numberPrecisionVal.isStripTrailingZeros())));
                    } else {
                        dataMap = (Map)value;
                        decimal = new BigDecimal(MapUtils.getString(dataMap, (Object)"result", (String)"0"));
                    }
                    CellStyle contentDecimalStyle = styles.getContentDecimalStyle(wb, dataMap);
                    String val2 = ((DecimalFormat)styles.getDecimalFormats().get(contentDecimalStyle.getDataFormatString())).format(decimal);
                    ExportByListDataWriter.createCell(wb, ExportByListDataWriter.getRow(sheet, r), this.totalOffset++, contentDecimalStyle).setCellValue(val2);
                    return;
                }
                if (value instanceof BigDecimal) {
                    ExportByListDataWriter.createCell(wb, ExportByListDataWriter.getRow(sheet, r), this.totalOffset++, styles.getContentDecimalStyle(wb, null)).setCellValue(((BigDecimal)value).doubleValue());
                    return;
                }
                ExportByListDataWriter.createCell(wb, ExportByListDataWriter.getRow(sheet, r), this.totalOffset++, styles.getContentTextStyle()).setCellValue(value.toString());
                return;
            }
            if (extend[0].equals(3)) {
                try {
                    String val3;
                    if (value instanceof Long) {
                        Date datetime = new Date((Long)value);
                        val3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datetime);
                    } else {
                        val3 = value.toString();
                    }
                    ExportByListDataWriter.createCell(wb, ExportByListDataWriter.getRow(sheet, r), this.totalOffset++, styles.getContentDefaultDatetimeStyle()).setCellValue(val3);
                }
                catch (Exception e) {
                    ExportByListDataWriter.createCell(wb, ExportByListDataWriter.getRow(sheet, r), this.totalOffset++, styles.getContentDefaultDateStyle()).setCellValue(value.toString());
                }
                return;
            }
        }
        String string = value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : (val = value == null ? "" : value.toString());
        if (val.length() > Short.MAX_VALUE) {
            val = val.substring(0, 32766);
        }
        ExportByListDataWriter.createCell(wb, ExportByListDataWriter.getRow(sheet, r), this.totalOffset++, styles.getContentTextStyle()).setCellValue(val);
    }

    public static SXSSFRow getRow(SXSSFSheet sheet, int r) {
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    protected static SXSSFCell createCell(SXSSFWorkbook wb, SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }
}

