/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.common.plugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.plugin.AfterInitContextArgs;
import kd.hr.expt.common.plugin.AfterInitContextDto;
import kd.hr.expt.common.plugin.AfterLoadUserPluginEventArgs;
import kd.hr.expt.common.plugin.AfterQueryDataEventArgs;
import kd.hr.expt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.expt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.expt.common.plugin.BeforeQueryPrimaryKeysEventArgs;
import kd.hr.expt.common.plugin.BeforeQueryRefBdEventArgs;
import kd.hr.expt.common.plugin.BeforeShowConfirmMessageEventArgs;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.AbstractEventArgs;

public class UserExportPluginEngine {
    private static Log log = LogFactory.getLog(UserExportPluginEngine.class);
    @ExcludeFromJacocoGeneratedReport
    private static Map<String, BiConsumer<List<HRExportPlugin>, AbstractEventArgs>> actionMappings = new HashMap<String, BiConsumer<List<HRExportPlugin>, AbstractEventArgs>>(){
        private static final long serialVersionUID = 7205964639915037565L;
        {
            this.put("afterLoadUserPlugin", (plugins, params) -> plugins.forEach((? super T userExportPlugin) -> userExportPlugin.afterLoadUserPlugin((AfterLoadUserPluginEventArgs)((Object)params))));
            this.put("beforeShowConfirmMessage", (plugins, params) -> plugins.forEach((? super T userExportPlugin) -> userExportPlugin.beforeShowConfirmMessage((BeforeShowConfirmMessageEventArgs)((Object)params))));
            this.put("beforeQueryPrimaryKeys", (plugins, params) -> plugins.forEach((? super T userExportPlugin) -> userExportPlugin.beforeQueryPrimaryKeys((BeforeQueryPrimaryKeysEventArgs)((Object)params))));
            this.put("afterQueryData", (plugins, params) -> plugins.forEach((? super T userExportPlugin) -> userExportPlugin.afterQueryData((AfterQueryDataEventArgs)((Object)params))));
            this.put("beforeCreateHeaderColumn", (plugins, params) -> plugins.forEach((? super T userExportPlugin) -> userExportPlugin.beforeCreateHeaderColumn((BeforeCreateHeaderColumnEventArgs)((Object)params))));
            this.put("beforeQueryRefBd", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeQueryRefBd((BeforeQueryRefBdEventArgs)((Object)params))));
            this.put("AfterQueryRefBd", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterQueryRefBd((AfterQueryRefBdEventArgs)((Object)params))));
            this.put("beforeWriteData", (plugins, params) -> plugins.forEach((? super T userExportPlugin) -> userExportPlugin.beforeWriteData((BeforeWriteDataEventArgs)((Object)params))));
            this.put("afterInitContext", (plugins, params) -> {
                for (HRExportPlugin userExportPlugin : plugins) {
                    AfterInitContextDto dto = (AfterInitContextDto)((Object)params);
                    ExportContext exportContext = dto.getExportContext();
                    AfterInitContextArgs args = new AfterInitContextArgs(exportContext);
                    args.setSerialModel(exportContext.isSerialModel());
                    args.setFileName(exportContext.getFileName());
                    args.setQueyStandExpense((Integer)exportContext.getExtOption().get("queryStandexpense"));
                    args.setFilterToSelectByList((Boolean)exportContext.getExtOption().get("isFilterToSelectByList"));
                    args.setAllowUseTempTableBySelect((Boolean)exportContext.getExtOption().get("allowUseTempTableBySelect"));
                    args.setSplitExcelMaxRowCount((Integer)exportContext.getExtOption().get("splitExcelMaxRowCount"));
                    args.setCusQueryMaxThread(exportContext.getCusQueryMaxThread());
                    userExportPlugin.afterInitContext(args);
                    exportContext.setSerialModel(args.isSerialModel());
                    exportContext.setFileName(args.getFileName());
                    exportContext.getExtOption().put("queryStandexpense", args.getQueyStandExpense());
                    exportContext.getExtOption().put("isFilterToSelectByList", args.getFilterToSelectByList());
                    exportContext.getExtOption().put("allowUseTempTableBySelect", args.getAllowUseTempTableBySelect());
                    exportContext.getExtOption().put("splitExcelMaxRowCount", args.getSplitExcelMaxRowCount());
                    exportContext.setCusQueryMaxThread(args.getCusQueryMaxThread());
                }
            });
        }
    };

    @ExcludeFromJacocoGeneratedReport
    public static void fireUserPluginEvent(ExportStart exportStart, String eventMethod, AbstractEventArgs params) {
        List<HRExportPlugin> userPluginInstances = exportStart.getExportContext().getUserPluginInstances();
        if (CollectionUtils.isEmpty(userPluginInstances)) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            actionMappings.get(eventMethod).accept(userPluginInstances, params);
        }
        catch (Throwable e) {
            exportStart.getMonitor().addOtherTotalCount("pluginExceptionCount", 1);
            throw e;
        }
        finally {
            long spense = System.currentTimeMillis() - start;
            if (spense > 100L) {
                exportStart.getMonitor().addExpenseStatistics(eventMethod, (Long)spense, false);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void fireUserPluginEvent(List<HRExportPlugin> userPluginInstances, String eventMethod, AbstractEventArgs params) {
        if (CollectionUtils.isEmpty(userPluginInstances)) {
            return;
        }
        long start = System.currentTimeMillis();
        actionMappings.get(eventMethod).accept(userPluginInstances, params);
        long spense = System.currentTimeMillis() - start;
        if (spense > 100L) {
            log.info("fireUserPluginEvent_expense:" + spense);
        }
    }
}

