/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.list.BillList;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.expt.common.dto.TplInfo;
import kd.hr.expt.common.enu.HiesExportRes;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.business.TemplateServiceHelper;
import kd.hr.hies.common.dto.TaskInfo;
import kd.hr.hies.common.util.MetaMenuUtil;
import org.apache.commons.lang3.StringUtils;

public class ExportUtil {
    public static final String FORMID_EXPORTDATA_PROGRESS = "hies_exportdataprogress";
    private static final String PAGE_HIES_ENTITYENCRYPTCONF = "hies_entityencryptconf";
    private static final String PAGE_HIES_ENTITYENCRYPTPWDCONF = "hies_entityencryptpwdconf";
    private static final String EXPORT_PARAMETER = "ExportParameter";
    private static final String CUSTPARAM_ENTITY_PWD = "pwdport";

    public static BillList cloneBillList(BillList source) throws Throwable {
        BillList clone = (BillList)source.clone();
        Field field = clone.getClass().getDeclaredField("listModel");
        ReflectionUtils.makeAccessible((Field)field);
        Method method = clone.getClass().getDeclaredMethod("createListModel", new Class[0]);
        ReflectionUtils.makeAccessible((Method)method);
        Object invoke = method.invoke((Object)clone, new Object[0]);
        field.set(clone, invoke);
        return clone;
    }

    public static boolean isEntityEncrypt(String entityNumber, Long tplPkId) {
        if (ObjectUtils.isEmpty((Object)tplPkId)) {
            String modelType = MetaMenuUtil.getModelType((String)entityNumber);
            if ("QueryListModel".equals(modelType)) {
                Set queryEntityNumbers = MetaMenuUtil.getQueryEntityNumbers((String)entityNumber);
                return ORM.create().exists(PAGE_HIES_ENTITYENCRYPTCONF, new QFilter[]{new QFilter("entity", "in", (Object)queryEntityNumbers)});
            }
            return ORM.create().exists(PAGE_HIES_ENTITYENCRYPTCONF, new QFilter[]{new QFilter("entity", "in", (Object)MetaMenuUtil.getAllEntityNumber((String)entityNumber))});
        }
        Set relationEntitys = TemplateServiceHelper.getRelationEntitys((Long)tplPkId);
        relationEntitys.add(entityNumber);
        return ORM.create().exists(PAGE_HIES_ENTITYENCRYPTCONF, new QFilter[]{new QFilter("entity", "in", (Object)MetaMenuUtil.getAllEntityNumber((Set)relationEntitys))});
    }

    public static void showProgressForm(TplInfo tplInfo, IFormView curView, String extParam, String entityNumber) {
        String excelName;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_EXPORTDATA_PROGRESS);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customParams = showParameter.getCustomParams();
        FormShowParameter curPageParameter = curView.getFormShowParameter();
        String yyyyMMddHHmmssSSS = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        long templateId = tplInfo.getTplPkId();
        if (templateId == -1L) {
            excelName = String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_%1$s_%2$s", (String)HiesExportRes.ExportUtil_1.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), curPageParameter.getCustomParam("entityname"), yyyyMMddHHmmssSSS.substring(4));
        } else {
            excelName = String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_%1$s_%2$s", (String)HiesExportRes.ExportUtil_2.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), tplInfo.getTplName(), yyyyMMddHHmmssSSS.substring(4));
            customParams.put("tplpkid", String.valueOf(templateId));
        }
        excelName = excelName.replace(" ", "_").replace("/", "_");
        customParams.put("exportFileName", excelName);
        customParams.put(CUSTPARAM_ENTITY_PWD, tplInfo.getEntityPwd());
        customParams.put("extParam", extParam);
        showParameter.setCustomParam("isCurrentList", (Object)(!"false".equals(curView.getPageCache().get("isCurrentList")) ? 1 : 0));
        IFormView parentView = curView.getViewNoPlugin(curView.getFormShowParameter().getParentPageId());
        ExportUtil.putPermissionInfo(showParameter, parentView.getPageCache());
        customParams.putAll(curPageParameter.getCustomParams());
        customParams.put("formId", entityNumber);
        parentView.showForm(showParameter);
        curView.sendFormAction(parentView);
    }

    public static void showEntityPwdForm(TplInfo tplInfo, IFormView curView, String extParam, String entityNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(PAGE_HIES_ENTITYENCRYPTPWDCONF);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("tplInfo", (Object)tplInfo);
        showParameter.setCustomParam("extParam", (Object)extParam);
        showParameter.setCustomParam("isCurrentList", (Object)(!"false".equals(curView.getPageCache().get("isCurrentList")) ? 1 : 0));
        IFormView parentView = curView.getViewNoPlugin(curView.getFormShowParameter().getParentPageId());
        ExportUtil.putPermissionInfo(showParameter, parentView.getPageCache());
        showParameter.getCustomParams().putAll(curView.getFormShowParameter().getCustomParams());
        showParameter.getCustomParams().put("formId", entityNumber);
        parentView.showForm(showParameter);
        curView.sendFormAction(parentView);
    }

    public static void putPermissionInfo(FormShowParameter showParameter, IPageCache parentPageCache) {
        showParameter.setCustomParam("BillTypeId", (Object)parentPageCache.get("BillTypeId"));
        showParameter.setCustomParam("ServiceAppId", (Object)parentPageCache.get("ServiceAppId"));
        showParameter.setCustomParam("CheckRightAppId", (Object)parentPageCache.get("CheckRightAppId"));
        showParameter.setCustomParam("BillFormId", (Object)parentPageCache.get("BillFormId"));
        showParameter.setCustomParam("ListName", (Object)parentPageCache.get("ListName"));
        showParameter.setCustomParam("OperateKey", (Object)parentPageCache.get("OperateKey"));
        showParameter.setCustomParam("PermissionItemId", (Object)parentPageCache.get("PermissionItemId"));
        showParameter.setCustomParam("RealPermissionEntityId", (Object)parentPageCache.get("RealPermissionEntityId"));
        showParameter.setCustomParam("MainOrgIds", (Object)parentPageCache.get("MainOrgIds"));
        showParameter.setCustomParam("OperateName", (Object)parentPageCache.get("OperateName"));
    }

    public static void updateRejectExportTask(Long taskPkid, String scheduleStatus, String extparam) {
        TaskInfo info = new TaskInfo();
        info.setId(taskPkid);
        info.setSchedulestatus(scheduleStatus);
        info.setExtparam(extparam);
        TaskInfoHelper.doUpdate((TaskInfo)info);
    }

    public static Object getDynamicObjectHrPersonId(DynamicObject dy, DynamicObject hrVirtualFieldRegister) {
        String persionField = "";
        DynamicObjectCollection entryentity = hrVirtualFieldRegister.getDynamicObjectCollection("entryentity");
        for (DynamicObject item : entryentity) {
            persionField = item.getString("leftalias");
        }
        persionField = StringUtils.substring((String)persionField, (int)0, (int)persionField.lastIndexOf("."));
        return dy.get(persionField + ".id");
    }
}

