/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.expt.common.dto.BaseExportBillData;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

public class ExportQueue<T extends BaseExportBillData> {
    private static Log log = LogFactory.getLog(ExportQueue.class);
    private String name;
    private LinkedBlockingQueue<T> queue;
    private ExportStart exportStart;

    public ExportQueue(String name, LinkedBlockingQueue<T> queue, ExportStart exportStart) {
        this.name = name;
        this.queue = queue;
        this.exportStart = exportStart;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LinkedBlockingQueue<T> getQueue() {
        return this.queue;
    }

    public void setQueue(LinkedBlockingQueue<T> queue) {
        this.queue = queue;
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean putOnceWithTimeOut(BaseExportBillData data) {
        try {
            boolean result = this.queue.offer(data, 10L, TimeUnit.SECONDS);
            if (!result) {
                this.exportStart.getMonitor().addQueueStatistics(this.name, 0, -1);
            } else {
                this.exportStart.getMonitor().addQueueStatistics(this.name, 1, this.queue.size());
            }
            return result;
        }
        catch (Throwable e) {
            log.error(e);
            return false;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean putOnce(BaseExportBillData data) {
        try {
            boolean result = this.queue.offer(data);
            if (!result) {
                this.exportStart.getMonitor().addQueueStatistics(this.name, 0, -1);
            } else {
                this.exportStart.getMonitor().addQueueStatistics(this.name, 1, this.queue.size());
            }
            return result;
        }
        catch (Throwable e) {
            log.error(e);
            return false;
        }
    }
}

