/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.convert;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.list.QueryResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.expt.business.template.ExportByListConvertWriteData;
import kd.hr.expt.common.dto.ListExportBillData;
import kd.hr.expt.common.dto.ListExportConvertData;
import kd.hr.expt.common.dto.WriteDataByListContext;
import kd.hr.expt.core.convert.ConvertDataDispatcher;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.MethodUtil;

public class ConvertDataByListTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(ConvertDataByListTask.class);
    private AtomicInteger childThreadMonitor;
    private WriteDataByListContext context;
    private ConvertDataDispatcher dispatcher;
    private ListExportBillData data;

    public ConvertDataByListTask(ListExportBillData data, WriteDataByListContext context, ConvertDataDispatcher dispatcher) {
        this.childThreadMonitor = dispatcher.getChildThreadMonitor();
        this.data = data;
        this.context = context;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExcludeFromJacocoGeneratedReport
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.dispatcher.getExportStart().getExportContext().getRc());
        log.info("{}_started.", (Object)ConvertDataByListTask.class.getSimpleName());
        try {
            ExportByListConvertWriteData writeData = new ExportByListConvertWriteData(this.data, this.context);
            List<List<Object>> formatRows = writeData.formatRows();
            ListExportConvertData convertData = new ListExportConvertData();
            convertData.setDataRows(formatRows);
            convertData.setEntityId(this.data.getEntityId());
            convertData.setBillDataCount(this.countBillData(this.data.getRows()));
            convertData.setRowDataPkIds(this.getRowDataPkIds(this.data.getRows()));
            int retryCount = 100;
            this.dispatcher.putToOutQueue(convertData, retryCount);
        }
        catch (Throwable e) {
            log.error(ConvertDataByListTask.class.getSimpleName() + "_call", e);
            this.dispatcher.getExportStart().writeErrorLog(e);
            this.dispatcher.interruptMainThread();
        }
        finally {
            if (this.dispatcher.getExportStart().getExportContext().isSerialModel()) {
                this.dispatcher.getSerialModelSemaphore().release();
            }
            this.dispatcher.getExportStart().getMonitor().addExpenseStatistics(ConvertDataByListTask.class, (Long)(System.currentTimeMillis() - start), false);
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }

    private int countBillData(QueryResult queryResult) {
        HashSet<Object> idSet = new HashSet<Object>(16);
        for (DynamicObject dy : queryResult.getCollection()) {
            idSet.add(dy.get("id"));
        }
        return idSet.size();
    }

    private Map<Integer, Map<String, Object>> getRowDataPkIds(QueryResult queryResult) {
        HashMap rowDataPkIds = Maps.newHashMapWithExpectedSize((int)queryResult.getCollection().size());
        int index = 1;
        for (DynamicObject dy : queryResult.getCollection()) {
            Map map = rowDataPkIds.computeIfAbsent(index, val -> Maps.newHashMapWithExpectedSize((int)3));
            map.put("default", dy.getPkValue());
            ++index;
        }
        return rowDataPkIds;
    }
}

