/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.init;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.QueryResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.hr.expt.business.ExportListHelper;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.ExportLog;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.expt.common.util.ExportUtil;
import kd.hr.expt.common.util.UserExportPluginUtil;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.expt.core.init.ExportTaskDispatcher;
import kd.hr.expt.core.monitor.Monitor;
import kd.hr.hbp.business.service.operatelog.OperateLogService;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.business.TaskService;
import kd.hr.hies.business.TemplateConfService;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.dto.TaskInfo;
import kd.hr.hies.common.enu.TaskResult;
import kd.hr.hies.common.enu.TaskState;
import kd.hr.hies.common.task.IEGlobalTaskUtil;
import kd.hr.hies.common.util.MethodUtil;

public class BigExcelExportTask
implements Callable<Object> {
    private static final Log logger = LogFactory.getLog(BigExcelExportTask.class);
    private AtomicInteger childThreadMonitor;
    private ExportTaskDispatcher dispatcher;
    private Map<String, Object> params;
    private boolean isNewView = false;

    public BigExcelExportTask(Map<String, Object> params, ExportTaskDispatcher dispatcher, AtomicInteger childThreadMonitor) {
        this.childThreadMonitor = childThreadMonitor;
        this.dispatcher = dispatcher;
        this.params = params;
    }

    /*
     * Loose catch block
     */
    @Override
    public Object call() throws Exception {
        block24: {
            this.childThreadMonitor.getAndIncrement();
            long start = System.currentTimeMillis();
            ExportContext exportContext = new ExportContext();
            exportContext.setRecoveryTask((Boolean)this.params.get("isRecoveryTask"));
            ExportStart exportStart = new ExportStart(exportContext);
            Long taskPkid = (Long)this.params.get("taskPkId");
            Monitor monitor = new Monitor(exportStart);
            exportStart.getWorkers().put(monitor.getName(), monitor);
            this.recordTraceLog(exportStart, this.params, start);
            Object sourceRc = this.params.remove("requestContext");
            if (sourceRc instanceof RequestContext) {
                RequestContext.set((RequestContext)((RequestContext)sourceRc));
            } else {
                RequestContext.set((RequestContext)((RequestContext)JSONObject.parseObject((String)sourceRc.toString(), RequestContext.class)));
            }
            MethodUtil.syncRequestTraceId((Object)RequestContext.get());
            ConcurrentHashMap<String, Object> other = exportStart.getMonitor().getExportTrace().getOther();
            other.put("traceId", RequestContext.get().getTraceId());
            logger.info("BigExcelExportTask_started!trace_id=" + RequestContext.get().getTraceId() + ",params=".concat(JSONObject.toJSONString(this.params)));
            exportContext.setRc(RequestContext.get());
            TaskService.updateTaskAFOOTStatus((Long)taskPkid);
            this.initGlobalSysParam(exportContext);
            exportContext.setExportLog(new ExportLog());
            exportContext.setExtOption(this.initExtOption(this.params));
            exportContext.setTaskPkId(taskPkid);
            String tplpkid = (String)this.params.get("tplpkid");
            if (StringUtils.isNotEmpty((CharSequence)tplpkid)) {
                exportContext.setTplPkid(Long.parseLong(tplpkid));
                exportContext.setTpl(TemplateConfService.load((Object)exportContext.getTplPkid()));
                exportContext.setHrVirtualFieldRegister(TemplateConfService.getHRVirtualEntityConfig((String)exportContext.getTpl().getString("queryentity.number")));
                exportContext.setTplHRVirtualFields(this.getTplHRVirtualField(exportContext.getTpl()));
                exportContext.setTplHRVirtualFieldAliasMap(this.getTplHRVirtualFieldAliasMap());
            }
            exportContext.setAppId((String)this.params.get("ServiceAppId"));
            String formId = (String)this.params.get("formId");
            exportContext.setMainFormId(formId);
            exportContext.setQueryEntityId((String)this.params.get("queryEntityId"));
            exportContext.setFileName((String)this.params.get("exportFileName"));
            exportContext.setExportModle((String)this.params.get("exportModle"));
            exportContext.setExportType((String)this.params.get("exportType"));
            exportContext.setCurrentList((Boolean)this.params.get("isCurrentList"));
            exportContext.setPwdport((String)this.params.get("pwdport"));
            String pageId = (String)this.params.get("pageId");
            exportContext.setPageId(pageId);
            exportContext.setFormView(this.initFormView(exportContext, (Map)this.params.get("recoveryInfo")));
            if (exportContext.isCurrentList()) {
                exportContext.setBillList(this.initBillList(exportContext.getFormView()));
                exportContext.setByListParam(this.initByListParam(exportContext));
                exportContext.setBillListClone(this.initBillListClone(exportContext.getBillList(), exportStart));
            }
            exportContext.setMainEntityType(MetadataServiceHelper.getDataEntityType((String)exportContext.getMainFormId()));
            if (!"ByList".equalsIgnoreCase(exportContext.getExportModle())) {
                exportContext.setTplQueryEntityType(this.getTplQueryEntityType(exportContext.getTpl()));
            }
            if (StringUtils.isNotEmpty((CharSequence)exportContext.getQueryEntityId()) && exportContext.isCurrentList()) {
                ExportListHelper exportListHelper = new ExportListHelper(exportStart);
                exportContext.setListFilters(exportListHelper.getListQueryBuilder().getFilters());
            }
            this.initUserPlugin(exportStart, (String)this.params.get("opPlugins"), (String)this.params.get("listPlugins"));
            exportContext.setAllPkIds(this.initAllPkid(exportStart));
            exportStart.start();
            IHRAppCache cache = HRAppCache.get((String)"hies");
            cache.put(MethodUtil.getTaskCachePath((String)String.valueOf(exportContext.getTaskPkId()), (String)ImportCacheKeyType.EXPORT, (String)"status"), (Object)"finished");
            try {
                exportContext.getExtOption().put("userEndTime", System.currentTimeMillis());
                this.collectAppCacheData(exportStart, start);
                IEGlobalTaskUtil.feedbackProgress((String)String.valueOf(exportContext.getTaskPkId()), (int)100, (String)ImportCacheKeyType.EXPORT);
                exportStart.getMonitor().addExpenseStatistics(BigExcelExportTask.class, (Long)(System.currentTimeMillis() - start), true);
                if (this.isNewView && exportContext.getFormView() != null) {
                    boolean ret = MethodUtil.releaseView((IFormView)exportContext.getFormView());
                    ConcurrentHashMap<String, Object> other2 = exportStart.getMonitor().getExportTrace().getOther();
                    other2.put("releaseView", ret);
                }
                TaskInfo info = this.saveTaskInfo(exportStart, start);
                logger.info(String.format("Systemerrlog-> %s", info.getSystemerrlog()));
                this.childThreadMonitor.getAndDecrement();
                this.dispatcher.getChildThreadSemaphore().release();
                OperateLogService.commonWriteLog((String)exportContext.getAppId(), (String)exportContext.getMainFormId(), (String)"bigExcelExport", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f00\u59cb\u5bfc\u51fa", "BigExcelExportTask_2", "hrmp-hies-export"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u51fa\u5b8c\u6210", "BigExcelExportTask_1", "hrmp-hies-export"), (String[])new String[0]);
            }
            catch (Throwable e) {
                logger.error("BigExcelExportTask_finally_error.", e);
            }
            break block24;
            catch (InterruptedException e) {
                block23: {
                    boolean sysTerminator = exportContext.isSysTerminator();
                    boolean userHasTerminator = exportContext.isUserHasTerminator();
                    exportStart.getMonitor().getExportTrace().getOther().put("sysTerminator", sysTerminator);
                    exportStart.getMonitor().getExportTrace().getOther().put("userHasTerminator", userHasTerminator);
                    if (sysTerminator || userHasTerminator && exportStart != null) {
                        exportStart.end();
                        IHRAppCache cache2 = HRAppCache.get((String)"hies");
                        cache2.put(MethodUtil.getTaskCachePath((String)String.valueOf(exportContext.getTaskPkId()), (String)ImportCacheKeyType.EXPORT, (String)"status"), (Object)"stop");
                        logger.info("BigExcelExportTask_user_normally_InterruptedException.");
                        break block23;
                    }
                    logger.error("BigExcelExportTask_InterruptedException.", (Throwable)e);
                }
                try {
                    exportContext.getExtOption().put("userEndTime", System.currentTimeMillis());
                    this.collectAppCacheData(exportStart, start);
                    IEGlobalTaskUtil.feedbackProgress((String)String.valueOf(exportContext.getTaskPkId()), (int)100, (String)ImportCacheKeyType.EXPORT);
                    exportStart.getMonitor().addExpenseStatistics(BigExcelExportTask.class, (Long)(System.currentTimeMillis() - start), true);
                    if (this.isNewView && exportContext.getFormView() != null) {
                        boolean ret = MethodUtil.releaseView((IFormView)exportContext.getFormView());
                        ConcurrentHashMap<String, Object> other3 = exportStart.getMonitor().getExportTrace().getOther();
                        other3.put("releaseView", ret);
                    }
                    TaskInfo info = this.saveTaskInfo(exportStart, start);
                    logger.info(String.format("Systemerrlog-> %s", info.getSystemerrlog()));
                    this.childThreadMonitor.getAndDecrement();
                    this.dispatcher.getChildThreadSemaphore().release();
                    OperateLogService.commonWriteLog((String)exportContext.getAppId(), (String)exportContext.getMainFormId(), (String)"bigExcelExport", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f00\u59cb\u5bfc\u51fa", "BigExcelExportTask_2", "hrmp-hies-export"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u51fa\u5b8c\u6210", "BigExcelExportTask_1", "hrmp-hies-export"), (String[])new String[0]);
                }
                catch (Throwable e2) {
                    logger.error("BigExcelExportTask_finally_error.", e2);
                }
            }
            catch (Throwable e2) {
                logger.error(e2);
                if (exportStart != null) {
                    exportStart.end();
                }
                exportStart.writeErrorLog(e2);
                exportStart.getExportContext().setSysTerminator(true);
                throw new KDException(new ErrorCode("001", "BigExcelExportTask_start failed."), "", e2);
                {
                    catch (Throwable throwable) {
                        try {
                            exportContext.getExtOption().put("userEndTime", System.currentTimeMillis());
                            this.collectAppCacheData(exportStart, start);
                            IEGlobalTaskUtil.feedbackProgress((String)String.valueOf(exportContext.getTaskPkId()), (int)100, (String)ImportCacheKeyType.EXPORT);
                            exportStart.getMonitor().addExpenseStatistics(BigExcelExportTask.class, (Long)(System.currentTimeMillis() - start), true);
                            if (this.isNewView && exportContext.getFormView() != null) {
                                boolean ret = MethodUtil.releaseView((IFormView)exportContext.getFormView());
                                ConcurrentHashMap<String, Object> other4 = exportStart.getMonitor().getExportTrace().getOther();
                                other4.put("releaseView", ret);
                            }
                            TaskInfo info = this.saveTaskInfo(exportStart, start);
                            logger.info(String.format("Systemerrlog-> %s", info.getSystemerrlog()));
                            this.childThreadMonitor.getAndDecrement();
                            this.dispatcher.getChildThreadSemaphore().release();
                            OperateLogService.commonWriteLog((String)exportContext.getAppId(), (String)exportContext.getMainFormId(), (String)"bigExcelExport", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f00\u59cb\u5bfc\u51fa", "BigExcelExportTask_2", "hrmp-hies-export"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u51fa\u5b8c\u6210", "BigExcelExportTask_1", "hrmp-hies-export"), (String[])new String[0]);
                        }
                        catch (Throwable e3) {
                            logger.error("BigExcelExportTask_finally_error.", e3);
                        }
                        throw throwable;
                    }
                }
            }
        }
        return null;
    }

    private IFormView initFormView(ExportContext exportContext, Map<String, Object> recoveryInfo) {
        IFormView view = SessionManager.getCurrent().getView(exportContext.getPageId());
        if (view == null && exportContext.isRecoveryTask()) {
            Object pageJson = recoveryInfo.get("pageJson");
            Object cacheMap = recoveryInfo.get("cacheMap");
            view = MethodUtil.recoveryView((String)((String)pageJson), (Map)((Map)JSONObject.parseObject((String)((String)cacheMap), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0])));
            this.isNewView = true;
        }
        if (view != null) {
            IFormController srv = (IFormController)view.getService(IFormController.class);
            srv.registerListener();
            return view;
        }
        return null;
    }

    private void initUserPlugin(ExportStart exportStart, String opPluginsstr, String listPluginstr) {
        ExportContext exportContext = exportStart.getExportContext();
        String templatePlugins = null;
        if (exportContext.getTpl() != null) {
            templatePlugins = exportContext.getTpl().getString("plugin");
        }
        String[] splitPl = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)listPluginstr)) {
            splitPl = StringUtils.split((String)listPluginstr, (String)",");
        }
        List<HRExportPlugin> listPlugins = UserExportPluginUtil.getListPlugin(Arrays.asList(splitPl));
        LinkedList<String> tplAllEntitys = new LinkedList<String>();
        if (exportContext.getTpl() == null) {
            tplAllEntitys.add(exportContext.getMainFormId());
        } else {
            tplAllEntitys = MethodUtil.getTplAllEntitys((DynamicObject)exportContext.getTpl());
        }
        List<HRExportPlugin> hrExportPlugin = UserExportPluginUtil.getHRExportPlugin(opPluginsstr, templatePlugins, listPlugins, (String)exportContext.getExtOption().get("extParam"), exportContext.getCustomParams(), tplAllEntitys);
        exportContext.setUserPluginInstances(hrExportPlugin);
    }

    private Map<String, Object> initByListParam(ExportContext exportContext) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        BillList billList = exportContext.getBillList();
        if (billList == null) {
            return map;
        }
        QueryResult queryResult = billList.queryBatchData(0, 1);
        exportContext.setExistFSeq(queryResult.getCollection().getDynamicObjectType().getProperty("fseq") != null);
        exportContext.setExistSeq(queryResult.getCollection().getDynamicObjectType().getProperty("seq") != null);
        if ("Select".equalsIgnoreCase(exportContext.getExportType())) {
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            map.put("selectedRows", selectedRows);
            HashMap temp = Maps.newHashMapWithExpectedSize((int)selectedRows.size());
            for (ListSelectedRow row : selectedRows) {
                temp.put(row.getPrimaryKeyValue(), null);
            }
            exportContext.setTotalBillCount(new AtomicInteger(temp.size()));
        } else {
            int realCount = billList.getListModel().getRealCount();
            map.put("realCount", realCount);
            if (StringUtils.isNotEmpty((CharSequence)exportContext.getQueryEntityId())) {
                exportContext.setTotalBillCount(new AtomicInteger(realCount));
            } else {
                exportContext.setTotalBillCount(new AtomicInteger(billList.getListModel().getBillDataCount()));
            }
        }
        return map;
    }

    private void collectAppCacheData(ExportStart exportStart, long start) {
        ExportContext exportContext = exportStart.getExportContext();
        int finishedBillCount = exportContext.getFinishedBillCount().get();
        int totalBillCount = exportContext.getTotalBillCount().get();
        long spense = System.currentTimeMillis() - start;
        Long startTime = (Long)exportContext.getExtOption().get("userStartTime");
        Long endTime = (Long)exportContext.getExtOption().get("userEndTime");
        HashMap customData = Maps.newHashMapWithExpectedSize((int)2);
        customData.put("spendTotalTime", String.valueOf(spense));
        customData.put("finishedBillCount", String.valueOf(finishedBillCount));
        customData.put("totalBillCount", String.valueOf(totalBillCount));
        customData.put("filePatch", exportContext.getFilePath());
        boolean userHasTerminator = exportContext.isUserHasTerminator();
        customData.put("userHasTerminator", userHasTerminator);
        boolean isSysTerminator = exportContext.isSysTerminator();
        customData.put("sysTerminator", String.valueOf(isSysTerminator));
        customData.put("userEndTime", String.valueOf(endTime));
        customData.put("totalCostStr", TaskInfoHelper.costTimeIgnoreMs((Long)endTime, (Long)startTime));
        IHRAppCache cache = HRAppCache.get((String)"hies");
        cache.put(MethodUtil.getTaskCachePath((String)String.valueOf(exportContext.getTaskPkId()), (String)ImportCacheKeyType.EXPORT, (String)"result"), (Object)customData);
    }

    private Map<String, Object> initExtOption(Map<String, Object> map) {
        HashMap<String, Object> option = new HashMap<String, Object>();
        option.put("userStartTime", map.get("userStartTime"));
        option.put("extParam", map.get("extParam"));
        option.put("queryStandexpense", MCConfigConstant.getStandExpense());
        option.put("isFilterToSelectByList", true);
        option.put("allowUseTempTableBySelect", false);
        option.put("splitExcelMaxRowCount", 0x100000);
        return option;
    }

    private BillList initBillList(IFormView view) {
        if (view == null) {
            return null;
        }
        BillList billList = (BillList)view.getControl("billlistap");
        if (billList == null) {
            return null;
        }
        IListModel listModel = billList.getListModel();
        if (listModel.getProvider() == null) {
            listModel.setFilterParameter(billList.generalFilterParameter());
            listModel.setNeedKeyFields(true);
            try {
                listModel.setListFields(billList.getListFields());
            }
            catch (KDBizException e) {
                logger.warn("\u53ef\u80fd\u5217\u8868\u5143\u6570\u636e\u5b58\u5728\u5df2\u7ecf\u88ab\u5220\u9664\u7684\u5b57\u6bb5\u5bfc\u81f4\u5f02\u5e38.", (Throwable)e);
            }
        }
        return billList;
    }

    private BillList initBillListClone(BillList billList, ExportStart exportStart) {
        if (!"ByList".equalsIgnoreCase(exportStart.getExportContext().getExportModle())) {
            return null;
        }
        try {
            long start = System.currentTimeMillis();
            BillList billListClone = ExportUtil.cloneBillList(billList);
            exportStart.getMonitor().addExpenseStatistics("initBillListClone", (Long)(System.currentTimeMillis() - start), true);
            return billListClone;
        }
        catch (Throwable throwable) {
            logger.error(throwable);
            exportStart.writeErrorLog(throwable);
            return null;
        }
    }

    private List<Object> initAllPkid(ExportStart exportStart) {
        ExportContext exportContext = exportStart.getExportContext();
        long start = System.currentTimeMillis();
        ExportListHelper exportListHelper = new ExportListHelper(exportStart);
        if (exportContext.getFormView() != null) {
            List<Object> allPkIds = exportContext.isCurrentList() ? exportListHelper.getAllPkIds() : exportListHelper.getAllPkIdsForNotCurrentList();
            exportStart.getMonitor().addExpenseStatistics("initAllPkid", (Long)(System.currentTimeMillis() - start), true);
            if (allPkIds.size() > 0) {
                exportContext.setTotalBillCount(new AtomicInteger(allPkIds.size()));
            }
            return allPkIds;
        }
        return null;
    }

    private TaskInfo saveTaskInfo(ExportStart exportStart, long start) {
        TaskInfo info = new TaskInfo();
        try {
            ExportContext exportContext = exportStart.getExportContext();
            info.setId(exportContext.getTaskPkId());
            info.setTotalamount(Integer.valueOf(exportContext.getTotalBillCount().get()));
            info.setSucamount(Integer.valueOf(exportContext.getFinishedBillCount().get()));
            int failCount = exportContext.getTotalBillCount().get() - exportContext.getFinishedBillCount().get();
            info.setFailamount(Integer.valueOf(failCount < 0 ? 0 : failCount));
            Long starttime = (Long)exportContext.getExtOption().get("userStartTime");
            Long endtime = (Long)exportContext.getExtOption().get("userEndTime");
            info.setEtime(new Date(endtime));
            info.setTotalcost(Integer.valueOf((int)(endtime - starttime)));
            info.setProgress(Integer.valueOf(100));
            info.setDownloadfileurl(exportContext.getFilePath());
            boolean sysTerminator = exportContext.isSysTerminator();
            boolean userHasTerminator = exportContext.isUserHasTerminator();
            if (sysTerminator || userHasTerminator) {
                info.setStatus(TaskState.TERMINATED);
            } else {
                info.setStatus(TaskState.FINISHED);
                if (info.getFailamount() == 0) {
                    info.setResult(TaskResult.SUCCESS);
                } else {
                    info.setResult(TaskResult.FAIL);
                }
            }
            if (userHasTerminator) {
                info.setInttime(new Date());
            }
            long spense = System.currentTimeMillis() - start;
            exportStart.getMonitor().addExpenseStatistics("total", (Long)spense, true);
            int finishedBillCount = exportStart.getExportContext().getFinishedBillCount().get();
            int totalBillCount = exportStart.getExportContext().getTotalBillCount().get();
            HashMap<String, Object> billCount = exportStart.getMonitor().getExportTrace().getBillCount();
            billCount.put("totalBillCount", totalBillCount);
            billCount.put("finishedBillCount", finishedBillCount);
            ConcurrentHashMap<String, Object> other = exportStart.getMonitor().getExportTrace().getOther();
            other.put("jvm", SerializationUtils.toJsonString(ManagementFactory.getRuntimeMXBean().getInputArguments()));
            exportStart.getMonitor().computeAverageExpense();
            info.setPerformancelog(exportStart.getMonitor().getPerformancelog());
            info.setSystemerrlog(SerializationUtils.toJsonString(exportContext.getExportLog().getErrorLogs()));
            StringBuilder str = new StringBuilder();
            exportContext.getUserPluginInstances().forEach(pl -> {
                str.append(pl.getClass().getName());
                str.append(",");
            });
            info.setPluginrunlog(str.toString());
            TaskInfoHelper.doUpdate((TaskInfo)info);
        }
        catch (Throwable e) {
            logger.error("saveTaskInfo_exception.", e);
        }
        return info;
    }

    private QueryEntityType getTplQueryEntityType(DynamicObject tpl) {
        MainEntityType entityType;
        String queryentity = tpl.getString("queryentity.number");
        if (StringUtils.isNotEmpty((CharSequence)queryentity) && (entityType = EntityMetadataCache.getDataEntityType((String)queryentity)) instanceof QueryEntityType) {
            return (QueryEntityType)entityType;
        }
        return null;
    }

    private void initGlobalSysParam(ExportContext context) {
        QFilter[] qFilters = null;
        DynamicObject sysparam = BusinessDataServiceHelper.loadSingle((String)"hies_diaesysparam", qFilters);
        context.setSysParam(sysparam);
        boolean isexptautofillpentry = sysparam.getBoolean("isexptautofillpentry");
        context.setFillParent(isexptautofillpentry);
    }

    private Map<String, DynamicObject> getTplHRVirtualField(DynamicObject tpl) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection objectCollection = tpl.getDynamicObjectCollection("tpltreeentryentity");
        for (DynamicObject dy : objectCollection) {
            if (!dy.getBoolean("isvirfield")) continue;
            map.put(dy.getString("fieldnumber"), dy);
        }
        return map;
    }

    private Map<String, String> getTplHRVirtualFieldAliasMap() {
        DynamicObject[] objects = TemplateConfService.getHRVirtualField();
        HashMap map = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject dy : objects) {
            String fieldnumber = dy.getString("fieldnumber");
            String fieldpath = dy.getString("fieldpath");
            map.put(fieldnumber, fieldpath);
        }
        return map;
    }

    private void recordTraceLog(ExportStart exportStart, Map map, long startTime) {
        ConcurrentHashMap<String, Object> other = exportStart.getMonitor().getExportTrace().getOther();
        other.put("taskExecuteTime", HRDateTimeUtils.format((Date)new Date(startTime)));
        other.put("sourceIp", map.getOrDefault("sourceIp", ""));
        other.put("excuteIp", NetAddressUtils.getLocalIpAddress());
        other.put("isRecoveryTask", this.params.get("isRecoveryTask"));
        other.put("taskPkId", map.get("taskPkId"));
        other.put("memoryConfig", MethodUtil.getMemoryConfig());
    }
}

