/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.init;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.expt.common.dto.BaseExportBillData;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.plugin.AfterInitContextDto;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.expt.core.ExportQueue;
import kd.hr.expt.core.ExportWorker;
import kd.hr.expt.core.convert.ConvertDataDispatcher;
import kd.hr.expt.core.monitor.Monitor;
import kd.hr.expt.core.monitor.Progresser;
import kd.hr.expt.core.monitor.Terminator;
import kd.hr.expt.core.monitor.TimeRemainingAnalyser;
import kd.hr.expt.core.query.QueryDispatcher;
import kd.hr.expt.core.write.WriteDataDispatcher;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import org.apache.commons.lang3.StringUtils;

public class ExportStart {
    private static Log log = LogFactory.getLog(ExportStart.class);
    public Object syncLock = new Object();
    private ExportContext exportContext;
    private ThreadPool pool = ThreadPools.newCachedThreadPool((String)(ExportStart.class.getName() + RequestContext.get().getTraceId()), (int)6, (int)15);
    private Map<String, ExportWorker> workers;
    private ExportQueue<BaseExportBillData> dataQueue;
    private ExportQueue<BaseExportBillData> convertQueue;
    private volatile boolean isStoped = false;
    private volatile boolean isMainThreadInterrupt = false;

    public ExportStart(ExportContext exportContext) {
        this.exportContext = exportContext;
        this.workers = Maps.newHashMapWithExpectedSize((int)10);
    }

    public ThreadPool getPool() {
        return this.pool;
    }

    public Map<String, ExportWorker> getWorkers() {
        return this.workers;
    }

    public boolean isMainThreadInterrupt() {
        return this.isMainThreadInterrupt;
    }

    public void setMainThreadInterrupt(boolean mainThreadInterrupt) {
        this.isMainThreadInterrupt = mainThreadInterrupt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        log.info("ExportStart_start.");
        this.initDataQueue();
        this.fireSetExportContextEvent();
        this.initImportStatus();
        int workerMaxThread = ExportStart.getConfigWorkerMaxThread(this);
        if ("ByList".equalsIgnoreCase(this.exportContext.getExportModle())) {
            workerMaxThread = 2;
        }
        QueryDispatcher queryDispatcher = new QueryDispatcher(this, workerMaxThread);
        Progresser progresser = new Progresser(this);
        TimeRemainingAnalyser timeRemainingAnalyser = new TimeRemainingAnalyser(this);
        ConvertDataDispatcher dataDispatcher = new ConvertDataDispatcher(this);
        WriteDataDispatcher writeDataDispatcher = new WriteDataDispatcher(this);
        writeDataDispatcher.getContextSemaphore().acquire();
        this.workers.put(progresser.getName(), progresser);
        this.workers.put(queryDispatcher.getName(), queryDispatcher);
        this.workers.put(dataDispatcher.getName(), dataDispatcher);
        this.workers.put(timeRemainingAnalyser.getName(), timeRemainingAnalyser);
        this.workers.put(writeDataDispatcher.getName(), writeDataDispatcher);
        this.pool.submit((Callable)this.getMonitor());
        this.pool.submit((Callable)queryDispatcher);
        this.pool.submit((Callable)progresser);
        this.pool.submit((Callable)timeRemainingAnalyser);
        this.pool.submit((Callable)dataDispatcher);
        this.pool.submit((Callable)writeDataDispatcher);
        Object object = this.syncLock;
        synchronized (object) {
            this.syncLock.wait();
        }
        this.end();
    }

    public void end() {
        this.isStoped = true;
        this.pool.close();
        log.info("ImportStart_normally_finished!");
    }

    private void initImportStatus() throws Exception {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        cache.put(MethodUtil.getTaskCachePath((String)String.valueOf(this.exportContext.getTaskPkId()), (String)ImportCacheKeyType.EXPORT, (String)"status"), (Object)"run");
        Terminator terminator = new Terminator(this);
        this.pool.submit((Callable)terminator);
        this.workers.put(terminator.getName(), terminator);
    }

    public void writeErrorLog(Throwable throwable) {
        try {
            String errorLog = HIESUtil.formatException((Throwable)throwable);
            List<String> errorLogs = this.getExportContext().getExportLog().getErrorLogs();
            if (errorLogs.size() > 5) {
                return;
            }
            this.getExportContext().getExportLog().getErrorLogs().add(errorLog);
        }
        catch (Throwable e) {
            log.error("ExportStart_writeErrorLog.", e);
        }
    }

    public Monitor getMonitor() {
        return (Monitor)this.workers.get(Monitor.class.getSimpleName());
    }

    public ExportQueue<BaseExportBillData> getDataQueue() {
        return this.dataQueue;
    }

    public void setDataQueue(ExportQueue<BaseExportBillData> dataQueue) {
        this.dataQueue = dataQueue;
    }

    public ExportQueue<BaseExportBillData> getConvertQueue() {
        return this.convertQueue;
    }

    public void setConvertQueue(ExportQueue<BaseExportBillData> convertQueue) {
        this.convertQueue = convertQueue;
    }

    public ExportContext getExportContext() {
        return this.exportContext;
    }

    public void setExportContext(ExportContext exportContext) {
        this.exportContext = exportContext;
    }

    public boolean isStoped() {
        return this.isStoped;
    }

    public void setStoped(boolean stoped) {
        this.isStoped = stoped;
    }

    private void fireSetExportContextEvent() {
        AfterInitContextDto dto = new AfterInitContextDto((String)this.exportContext.getExtOption().get("extParam"));
        dto.setExportContext(this.exportContext);
        UserExportPluginEngine.fireUserPluginEvent(this, "afterInitContext", (AbstractEventArgs)dto);
        ConcurrentHashMap<String, Object> other = this.getMonitor().getExportTrace().getOther();
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("serialModel", this.exportContext.isSerialModel());
        map.put("fileName", this.exportContext.getFileName());
        map.put("queryStandexpense", this.exportContext.getExtOption().get("queryStandexpense"));
        map.put("isFilterToSelectByList", this.exportContext.getExtOption().get("isFilterToSelectByList"));
        map.put("allowUseTempTableBySelect", this.exportContext.getExtOption().get("allowUseTempTableBySelect"));
        map.put("splitExcelMaxRowCount", this.exportContext.getExtOption().get("splitExcelMaxRowCount"));
        map.put("cusQueryMaxThread", this.exportContext.getCusQueryMaxThread());
        other.put("afterInitContextEventParams", map);
    }

    private void initDataQueue() {
        int sourceQueueSize = MCConfigConstant.getQueueSize();
        int queueSizeWithThread = MCConfigConstant.getWorkerMaxThread();
        int finalQueueSizeForData = 0;
        int finalQueueSizeForConvert = 0;
        if ("ByList".equalsIgnoreCase(this.exportContext.getExportModle())) {
            finalQueueSizeForData = queueSizeWithThread * 2;
            finalQueueSizeForConvert = queueSizeWithThread;
        } else if ("Tpl".equalsIgnoreCase(this.exportContext.getExportModle())) {
            finalQueueSizeForData = sourceQueueSize;
            finalQueueSizeForConvert = queueSizeWithThread;
        }
        this.dataQueue = new ExportQueue("dataQueue", new LinkedBlockingQueue(finalQueueSizeForData), this);
        this.convertQueue = new ExportQueue("convertQueue", new LinkedBlockingQueue(finalQueueSizeForConvert), this);
        this.getMonitor().addOtherTotalCount(this.dataQueue.getName() + "_size", finalQueueSizeForData);
        this.getMonitor().addOtherTotalCount(this.convertQueue.getName() + "_size", finalQueueSizeForConvert);
    }

    private static int getConfigWorkerMaxThread(ExportStart exportStart) {
        int count = MCConfigConstant.getWorkerMaxThread();
        String cusQueryMaxThread = exportStart.getExportContext().getCusQueryMaxThread();
        if (StringUtils.isNotEmpty((CharSequence)cusQueryMaxThread)) {
            switch (cusQueryMaxThread) {
                case "2": {
                    count = 2;
                    break;
                }
                case "3": {
                    count = 3;
                    break;
                }
            }
        }
        return count;
    }
}

