/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.init;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.hr.expt.common.util.ExportUtil;
import kd.hr.expt.core.init.BigExcelExportTask;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.TaskService;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.util.MethodUtil;

public class ExportTaskDispatcher {
    private static Log log = LogFactory.getLog(ExportTaskDispatcher.class);
    private static volatile ExportTaskDispatcher instance;
    protected AtomicInteger childThreadMonitor;
    protected Semaphore childThreadSemaphore;
    private static ThreadPool pool;

    private ExportTaskDispatcher() {
        pool = ThreadPools.newCachedThreadPool((String)(ExportTaskDispatcher.class.getSimpleName() + RequestContext.get().getTraceId()), (int)0, (int)MCConfigConstant.getTaskDispatcherMaxThread());
        this.childThreadMonitor = new AtomicInteger(0);
        this.childThreadSemaphore = new Semaphore(MCConfigConstant.getTaskDispatcherMaxThread());
        log.info("MCConfigConstant:" + JSONObject.toJSONString((Object)MCConfigConstant.getAllConfigInfo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExportTaskDispatcher getInstance() {
        if (instance != null) return instance;
        Class<ExportTaskDispatcher> clazz = ExportTaskDispatcher.class;
        synchronized (ExportTaskDispatcher.class) {
            if (instance != null) return instance;
            instance = new ExportTaskDispatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Semaphore getChildThreadSemaphore() {
        return this.childThreadSemaphore;
    }

    @ExcludeFromJacocoGeneratedReport
    public Result receivedNewTask(Map<String, Object> params) {
        Result result = new Result();
        long taskPKId = TaskService.saveTaskParams(params);
        result.setSuccess(true);
        result.setData((Object)taskPKId);
        params.put("taskPkId", taskPKId);
        params.put("isRecoveryTask", false);
        BigExcelExportTask task = new BigExcelExportTask(params, this, this.childThreadMonitor);
        boolean ret = MCConfigConstant.debugOffLineTask() ? false : this.submitWithTimeOut(task);
        if (!ret) {
            Map extParams = MethodUtil.getRecoveryViewParams((String)((String)params.get("pageId")));
            ExportUtil.updateRejectExportTask(taskPKId, "waiting", JSONObject.toJSONString((Object)extParams));
            result.setSuccess(false);
            result.setCode("900");
            result.setMsg(ResManager.loadKDString((String)"\u5bfc\u51fa\u4efb\u52a1\u540e\u53f0\u6b63\u5728\u8fd0\u884c\uff0c\u5b8c\u6210\u540e\uff0c\u53ef\u5728\u76d1\u63a7\u4e2d\u5fc3\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"ExportTaskDispatcher_0", (String)"hrmp-hies-export", (Object[])new Object[0]));
        }
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    public Result recoveryTask(Long taskPkid) {
        Result result = new Result();
        result.setSuccess(true);
        result.setData((Object)taskPkid);
        DynamicObject dynamicObject = TaskService.getSomeAttrsById((Long)taskPkid);
        String reqparam = dynamicObject.getString("reqparam");
        String extparam = dynamicObject.getString("extparam");
        int retrynum = dynamicObject.getInt("retrynum");
        if (StringUtils.isEmpty((String)extparam)) {
            result.setSuccess(false);
            TaskService.updateTaskExceptionFinished((Long)taskPkid, (int)(++retrynum), (String)"recoveryTask failed,extparam is empty.");
            return result;
        }
        Map extparamMap = (Map)JSONObject.parseObject((String)extparam, Map.class);
        Map reqparamMap = (Map)JSONObject.parseObject((String)reqparam, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        reqparamMap.put("taskPkId", taskPkid);
        HashMap recoveryMap = Maps.newHashMapWithExpectedSize((int)extparamMap.size());
        recoveryMap.put("pageJson", extparamMap.get("pageJson"));
        recoveryMap.put("cacheMap", extparamMap.get("cacheMap"));
        reqparamMap.put("recoveryInfo", recoveryMap);
        reqparamMap.put("isRecoveryTask", true);
        BigExcelExportTask task = new BigExcelExportTask(reqparamMap, this, this.childThreadMonitor);
        boolean ret = this.submitWithTimeOut(task);
        if (!ret) {
            result.setSuccess(false);
            result.setCode("900");
            result.setMsg(ResManager.loadKDString((String)"\u5bfc\u51fa\u4efb\u52a1\u540e\u53f0\u6b63\u5728\u8fd0\u884c\uff0c\u5b8c\u6210\u540e\uff0c\u53ef\u5728\u76d1\u63a7\u4e2d\u5fc3\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"ExportTaskDispatcher_0", (String)"hrmp-hies-export", (Object[])new Object[0]));
            TaskService.updateTaskRetryInfo((Long)taskPkid, (int)(++retrynum));
        } else {
            TaskService.updateTaskScheduleStatus((Long)taskPkid, (String)"started");
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    protected boolean submitWithTimeOut(Callable<Object> task) {
        try {
            if (this.childThreadSemaphore.tryAcquire(5L, TimeUnit.SECONDS)) {
                pool.submit(task);
                return true;
            }
            throw new KDException(new ErrorCode("900", "waiteHasFreePoolThread_timeout."), new Object[0]);
        }
        catch (Throwable e) {
            log.error(e);
            return false;
        }
    }
}

