/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.monitor;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.expt.core.ExportWorker;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.expt.core.monitor.TimeRemainingAnalyser;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.task.IEGlobalTaskUtil;
import kd.hr.hies.common.util.MethodUtil;

public class Progresser
extends ExportWorker {
    private static Log log = LogFactory.getLog(Progresser.class);
    private int lastProgressUpload;

    public Progresser(ExportStart exportStart) {
        super(Progresser.class.getSimpleName(), exportStart);
    }

    @Override
    public Object call() throws Exception {
        MethodUtil.syncRequestTraceId((Object)this.exportStart.getExportContext().getRc());
        log.info("Progresser_started.");
        while (!this.exportStart.isStoped() && !this.isEnd) {
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                int totalBillCount = this.exportStart.getExportContext().getTotalBillCount().get();
                float finishedBillCount = this.exportStart.getExportContext().getFinishedBillCount().floatValue();
                HashMap customData = Maps.newHashMapWithExpectedSize((int)2);
                customData.put("totalBillCount", String.valueOf(totalBillCount));
                customData.put("finishedBillCount", String.valueOf((int)finishedBillCount));
                TimeRemainingAnalyser timeRemainingAnalyser = (TimeRemainingAnalyser)this.exportStart.getWorkers().get(TimeRemainingAnalyser.class.getSimpleName());
                customData.put("timeRemaining", timeRemainingAnalyser.getTimeRemaining());
                int progressUpload = this.getAnalysisProgress(finishedBillCount, totalBillCount);
                customData.put("progress", progressUpload);
                String taskPKId = String.valueOf(this.exportStart.getExportContext().getTaskPkId());
                IHRAppCache cache = HRAppCache.get((String)"hies");
                cache.put(MethodUtil.getTaskCachePath((String)taskPKId, (String)ImportCacheKeyType.EXPORT, (String)"processing"), (Object)customData);
                if (progressUpload <= 0 || progressUpload == this.lastProgressUpload) continue;
                this.lastProgressUpload = progressUpload;
                IEGlobalTaskUtil.feedbackProgress((String)taskPKId, (int)progressUpload, (String)ImportCacheKeyType.EXPORT);
            }
            catch (Throwable e) {
                log.error("", e);
                this.exportStart.writeErrorLog(e);
            }
        }
        this.end();
        return null;
    }

    private int getAnalysisProgress(float finishedBillCount, int totalBillCount) {
        float progress = 0.0f;
        if (finishedBillCount > 0.0f) {
            progress = finishedBillCount / (float)totalBillCount * 100.0f;
        } else if (totalBillCount <= 1000) {
            progress = 50.0f;
        } else if (totalBillCount <= 2000) {
            progress = 40.0f;
        } else if (totalBillCount <= 3000) {
            progress = 30.0f;
        } else if (totalBillCount <= 4000) {
            progress = 20.0f;
        } else if (totalBillCount <= 5000) {
            progress = 10.0f;
        } else if (totalBillCount <= 6000) {
            progress = 5.0f;
        }
        if (progress < 1.0f) {
            progress = 1.0f;
        }
        return (int)progress;
    }
}

