/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.monitor;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.core.ExportWorker;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.expt.core.write.WriteDataDispatcher;
import kd.hr.hies.common.util.MethodUtil;

public class TimeRemainingAnalyser
extends ExportWorker {
    private static Log log = LogFactory.getLog(TimeRemainingAnalyser.class);
    private int timeRemaining;

    public int getTimeRemaining() {
        return this.timeRemaining;
    }

    public TimeRemainingAnalyser(ExportStart importStart) {
        super(TimeRemainingAnalyser.class.getSimpleName(), importStart);
    }

    @Override
    public Object call() throws Exception {
        MethodUtil.syncRequestTraceId((Object)this.exportStart.getExportContext().getRc());
        log.info(TimeRemainingAnalyser.class.getSimpleName() + "_started.");
        while (!this.exportStart.isStoped() && !this.isEnd) {
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                WriteDataDispatcher writeDataDispatcher = (WriteDataDispatcher)this.exportStart.getWorkers().get(WriteDataDispatcher.class.getSimpleName());
                Date startTime = writeDataDispatcher.getWriteStartTime();
                ExportContext importContext = this.exportStart.getExportContext();
                AtomicInteger finishedBillCount = importContext.getFinishedBillCount();
                if (startTime == null || finishedBillCount.get() == 0) continue;
                double avgSpense = (double)(System.currentTimeMillis() - startTime.getTime()) / (double)finishedBillCount.get();
                long remainTime = (long)((double)(importContext.getTotalBillCount().get() - finishedBillCount.get()) * avgSpense);
                this.timeRemaining = (int)(remainTime / 1000L);
            }
            catch (Throwable e) {
                log.error("", e);
                this.exportStart.writeErrorLog(e);
            }
        }
        this.end();
        return null;
    }
}

