/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.query;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

public class DataFlowSuggester {
    private int minBatchsize = 10000;
    private int maxBatchSize = 20000;
    private int workerMaxThread;
    private ExportStart exportStart;
    private List<Long> lastExpenseTimes = new ArrayList<Long>(10);
    private long avgExpenseTimes;
    private int suggestBatchSize = 1;
    private int suggestThreads = 1;
    private ReentrantLock lock = new ReentrantLock();

    public DataFlowSuggester(ExportStart exportStart, int workerMaxThread) {
        this.exportStart = exportStart;
        this.workerMaxThread = workerMaxThread;
        Object atb = exportStart.getExportContext().getExtOption().get("allowUseTempTableBySelect");
        Object fts = exportStart.getExportContext().getExtOption().get("isFilterToSelectByList");
        if (("Select".equalsIgnoreCase(exportStart.getExportContext().getExportType()) || Boolean.TRUE == fts) && Boolean.TRUE != atb) {
            int threshold = Integer.parseInt(System.getProperty("orm.opt.in.threshold", "2000"));
            if (threshold <= 0) {
                threshold = 1000;
            }
            this.maxBatchSize = threshold - 1;
            this.minBatchsize = this.maxBatchSize / 3;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void addExpenseTimes(Long expenseTimes) {
        Integer userQueryStandexpense = (Integer)this.exportStart.getExportContext().getExtOption().get("queryStandexpense");
        if (expenseTimes.intValue() > userQueryStandexpense) {
            this.exportStart.getMonitor().addOtherTotalCount("query_timeOut_count", 1);
        }
        if (this.lock.tryLock()) {
            try {
                if (this.lastExpenseTimes.size() >= 10) {
                    this.lastExpenseTimes.remove(0);
                }
                this.lastExpenseTimes.add(expenseTimes);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public int getSuggestBatchSize() {
        if (this.suggestBatchSize < this.minBatchsize) {
            this.suggestBatchSize = this.minBatchsize;
        }
        return this.suggestBatchSize;
    }

    public int getSuggestThreads() {
        if (this.suggestThreads < 1) {
            this.suggestThreads = 1;
        }
        return this.suggestThreads;
    }

    @ExcludeFromJacocoGeneratedReport
    public void runDataFlowSuggest() {
        if (this.lastExpenseTimes.size() == 0) {
            return;
        }
        this.computeAvgExpenseTime();
        Integer userQueryStandexpense = (Integer)this.exportStart.getExportContext().getExtOption().get("queryStandexpense");
        if (this.avgExpenseTimes > (long)userQueryStandexpense.intValue()) {
            if (this.suggestBatchSize >= 2) {
                this.suggestBatchSize = (int)((double)this.suggestBatchSize * 0.66);
            }
            if (this.suggestThreads >= 2) {
                this.suggestThreads = (int)((double)this.suggestThreads * 0.66);
            }
        } else {
            this.suggestBatchSize *= 2;
            if (this.suggestBatchSize > this.maxBatchSize) {
                this.suggestBatchSize = this.maxBatchSize;
            }
            this.suggestThreads = ++this.suggestThreads;
            if (this.suggestThreads > this.workerMaxThread) {
                this.suggestThreads = this.workerMaxThread;
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void initDataFlowSuggest(int totalRowCount) {
        if (totalRowCount <= 1000) {
            this.suggestThreads = 1;
            this.suggestBatchSize = 100;
        } else if (totalRowCount > 1000 && totalRowCount <= 10000) {
            this.suggestThreads = 2;
            this.suggestBatchSize = 1000;
        } else if (totalRowCount > 10000 && totalRowCount <= 100000) {
            this.suggestThreads = 3;
            this.suggestBatchSize = 10000;
        } else {
            this.suggestThreads = this.workerMaxThread;
            this.suggestBatchSize = this.maxBatchSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    private void computeAvgExpenseTime() {
        long total = 0L;
        this.lock.lock();
        try {
            for (Long item : this.lastExpenseTimes) {
                total += item.longValue();
            }
            this.avgExpenseTimes = total / (long)this.lastExpenseTimes.size();
        }
        finally {
            this.lock.unlock();
        }
    }
}

