/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.QueryResult;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.ListExportBillData;
import kd.hr.expt.common.plugin.AfterQueryDataEventArgs;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.expt.core.query.QueryDispatcher;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.MethodUtil;

public class DataLoadByListTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(DataLoadByListTask.class);
    private AtomicInteger childThreadMonitor;
    private QueryDispatcher dispatcher;
    private BillList billList;
    private int startIndex;
    private int suggestBatchSize;
    static AtomicInteger index = new AtomicInteger(0);

    public DataLoadByListTask(int startIndex, int suggestBatchSize, QueryDispatcher dispatcher, BillList billList) {
        this.childThreadMonitor = dispatcher.getChildThreadMonitor();
        this.startIndex = startIndex;
        this.suggestBatchSize = suggestBatchSize;
        this.dispatcher = dispatcher;
        this.billList = billList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.dispatcher.getExportStart().getExportContext().getRc());
        log.info("DataLoadByListTask_started.");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        ExportStart exportStart = this.dispatcher.getExportStart();
        QueryResult queryResult = null;
        List listFields = null;
        ExportContext exportContext = exportStart.getExportContext();
        try {
            ListExportBillData data = new ListExportBillData();
            data.setEntityId(exportContext.getMainFormId());
            long start1 = System.currentTimeMillis();
            Object fts = exportStart.getExportContext().getExtOption().get("isFilterToSelectByList");
            if ("Select".equalsIgnoreCase(exportContext.getExportType()) || Boolean.TRUE == fts) {
                Map<String, Object> byListParam = exportContext.getByListParam();
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)byListParam.get("selectedRows");
                ListSelectedRowCollection subRowSelection = new ListSelectedRowCollection();
                int endIndex = this.startIndex + this.suggestBatchSize;
                if (endIndex > selectedRows.size()) {
                    endIndex = selectedRows.size();
                }
                List subList = selectedRows.subList(this.startIndex, endIndex);
                for (ListSelectedRow selectRow : subList) {
                    subRowSelection.add((Object)selectRow);
                }
                listFields = this.billList.getListFields();
                start1 = System.currentTimeMillis();
                queryResult = this.billList.getSelectedRowDatas(listFields, subRowSelection);
                this.dispatcher.getExportStart().getMonitor().addOtherListData("byList_queryData", subRowSelection.size() + "(" + (System.currentTimeMillis() - start) + ")");
            } else {
                queryResult = this.billList.queryBatchData(this.startIndex, this.suggestBatchSize);
            }
            long spense = System.currentTimeMillis() - start1;
            this.dispatcher.getSuggester().addExpenseTimes(spense);
            Map<String, ListField> fieldMapping = DataLoadByListTask.buildFieldMapping(this.billList.getListModel().getProvider().getVisibleSelectFieldList());
            data.setFieldMapping(fieldMapping);
            AfterQueryDataEventArgs args = new AfterQueryDataEventArgs(exportContext);
            args.setDataList((List<DynamicObject>)queryResult.getCollection());
            UserExportPluginEngine.fireUserPluginEvent(this.dispatcher.getExportStart(), "afterQueryData", (AbstractEventArgs)args);
            if (args.getDataList() == null) {
                args.setDataList(new ArrayList<DynamicObject>(0));
            }
            data.setRows(queryResult);
            int retryCount = 100;
            this.dispatcher.putToOutQueue(data, retryCount);
        }
        catch (Throwable e) {
            log.error("DataLoadByListTask_call.", e);
            exportStart.writeErrorLog(e);
            this.dispatcher.interruptMainThread();
        }
        finally {
            if (exportStart.getExportContext().isSerialModel()) {
                this.dispatcher.getSerialModelSemaphore().release();
            } else {
                LinkedBlockingQueue queue = (LinkedBlockingQueue)this.dispatcher.getExtObject();
                queue.put(this.billList);
            }
            this.dispatcher.getExportStart().getMonitor().addExpenseStatistics(DataLoadByListTask.class, (Long)(System.currentTimeMillis() - start), false);
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }

    private static Map<String, ListField> buildFieldMapping(List<ListField> listFields) {
        HashMap<String, ListField> mapping = new HashMap<String, ListField>(16);
        for (ListField f : listFields) {
            mapping.put(f.getKey(), f);
        }
        return mapping;
    }
}

