/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.QueryEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.MEMSExportBillData;
import kd.hr.expt.common.dto.MESSExportBillData;
import kd.hr.expt.common.plugin.AfterQueryDataEventArgs;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.expt.core.query.QueryDispatcher;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.dto.Pair;
import kd.hr.hies.common.util.MethodUtil;

public class DataLoadByQueryCfgTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(DataLoadByQueryCfgTask.class);
    private List<Object> subPkids;
    private AtomicInteger childThreadMonitor;
    private QueryDispatcher dispatcher;

    public DataLoadByQueryCfgTask(List<Object> subPkids, QueryDispatcher dispatcher) {
        this.childThreadMonitor = dispatcher.getChildThreadMonitor();
        this.subPkids = subPkids;
        this.dispatcher = dispatcher;
    }

    public List<Object> getSubPkids() {
        return this.subPkids;
    }

    public AtomicInteger getChildThreadMonitor() {
        return this.childThreadMonitor;
    }

    public QueryDispatcher getDispatcher() {
        return this.dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExcludeFromJacocoGeneratedReport
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.dispatcher.getExportStart().getExportContext().getRc());
        log.info("DataLoadByTplTask_started.");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        ExportContext exportContext = this.dispatcher.getExportStart().getExportContext();
        DynamicObject tpl = exportContext.getTpl();
        String entitytype = tpl.getString("entitytype");
        String tmpltype = tpl.getString("tmpltype");
        String mainEntityId = exportContext.getMainEntityType().getName();
        try {
            QueryEntityType queryEntityType = exportContext.getTplQueryEntityType();
            List<String> entitys = this.getAllJoinEntitys(queryEntityType);
            LinkedList selectFields = new LinkedList();
            entitys.forEach(en -> {
                if (en.equals(mainEntityId)) {
                    selectFields.add("id");
                } else {
                    selectFields.add(en + ".id");
                }
            });
            long start1 = System.currentTimeMillis();
            Object[] qFilters = new QFilter[]{new QFilter("id", "in", this.subPkids)};
            LinkedList allQFilters = MethodUtil.arrayToList((Object[])exportContext.getListFilters());
            if (allQFilters == null) {
                allQFilters = new LinkedList();
            }
            allQFilters.addAll(MethodUtil.arrayToList((Object[])qFilters));
            DataSet queryDataSet = exportContext.getTplQueryEntityType().getQueryDataSet(String.join((CharSequence)",", selectFields), allQFilters.toArray(new QFilter[0]), "");
            LinkedList<Map<String, Map<Object, DynamicObject>>> dataList = new LinkedList<Map<String, Map<Object, DynamicObject>>>();
            HashMap dataItemMap = Maps.newHashMapWithExpectedSize((int)6);
            LinkedList<Map<String, List<Pair<Object, DynamicObject>>>> dataList2 = new LinkedList<Map<String, List<Pair<Object, DynamicObject>>>>();
            HashMap dataItemMap2 = Maps.newHashMapWithExpectedSize((int)6);
            HashMap entityIdsMap = Maps.newHashMapWithExpectedSize((int)6);
            Object lastId = null;
            while (queryDataSet.hasNext()) {
                Row next = queryDataSet.next();
                Object id = next.get("id");
                Set ids = entityIdsMap.computeIfAbsent(mainEntityId, val -> new HashSet(16));
                ids.add(id);
                if (!id.equals(lastId)) {
                    dataItemMap = Maps.newHashMapWithExpectedSize((int)6);
                    dataList.add(dataItemMap);
                    dataItemMap2 = Maps.newHashMapWithExpectedSize((int)6);
                    dataList2.add(dataItemMap2);
                    lastId = id;
                    Map objectMap = dataItemMap.computeIfAbsent(mainEntityId, val -> Maps.newHashMapWithExpectedSize((int)16));
                    objectMap.put(lastId, null);
                    List objectMap2 = dataItemMap2.computeIfAbsent(mainEntityId, val -> Lists.newLinkedList());
                    objectMap2.add(new Pair(lastId, null));
                }
                for (String entityId : entitys) {
                    Object entId;
                    if (entityId.equals(mainEntityId) || ObjectUtils.isEmpty((Object)(entId = next.get(entityId + ".id")))) continue;
                    Set childIds = entityIdsMap.computeIfAbsent(entityId, val -> new HashSet(16));
                    childIds.add(entId);
                    Map objectMap = dataItemMap.computeIfAbsent(entityId, val -> Maps.newHashMapWithExpectedSize((int)16));
                    objectMap.put(entId, null);
                    List objectMap2 = dataItemMap2.computeIfAbsent(entityId, val -> Lists.newLinkedList());
                    objectMap2.add(new Pair(entId, null));
                }
            }
            Map<Object, DynamicObject> loadDynamicObject = this.loadDynamicObject(entityIdsMap);
            long spense = System.currentTimeMillis() - start1;
            this.dispatcher.getSuggester().addExpenseTimes(spense);
            AfterQueryDataEventArgs args = new AfterQueryDataEventArgs(exportContext);
            if ("IMPT".equals(tmpltype)) {
                this.fillDynamicObject(loadDynamicObject, dataList);
                args.setQueryDataList(dataList);
            } else {
                this.fillDynamicObject2(loadDynamicObject, dataList2);
                args.setQueryDataList(this.transform(dataList2));
            }
            UserExportPluginEngine.fireUserPluginEvent(this.dispatcher.getExportStart(), "afterQueryData", (AbstractEventArgs)args);
            if (args.getQueryDataList() == null) {
                args.setQueryDataList(new ArrayList<Map<String, Map<Object, DynamicObject>>>(0));
            }
            int retryCount = 100;
            args.getQueryDataList().forEach(item -> {
                if ("MEMS".equalsIgnoreCase(entitytype)) {
                    item.forEach((key, val) -> {
                        MEMSExportBillData billData = new MEMSExportBillData();
                        billData.setData((DynamicObject)val.values().toArray()[0]);
                        billData.setEntityId((String)key);
                        if (!key.equals(mainEntityId)) {
                            exportContext.getTotalBillCount().getAndIncrement();
                        }
                        this.dispatcher.putToOutQueue(billData, retryCount);
                    });
                } else if ("MESS".equalsIgnoreCase(entitytype) && "IMPT".equals(tmpltype)) {
                    MESSExportBillData billData = new MESSExportBillData();
                    HashMap map = Maps.newHashMapWithExpectedSize((int)6);
                    item.forEach((key, val) -> map.put(key, val.values().toArray(new DynamicObject[0])));
                    billData.setEntityData(map);
                    billData.setEntityId(exportContext.getMainEntityType().getName());
                    this.dispatcher.putToOutQueue(billData, retryCount);
                }
            });
            if ("MESS".equalsIgnoreCase(entitytype) && "EXPT".equals(tmpltype)) {
                Map<String, Map<Object, DynamicObject>> tempMap = this.transformToMap(args.getQueryDataList());
                this.replaceDyForDataList(dataList2, tempMap);
                dataList2.forEach(item -> {
                    MESSExportBillData billData = new MESSExportBillData();
                    HashMap map = Maps.newHashMapWithExpectedSize((int)6);
                    item.forEach((key, val) -> {
                        ArrayList list = new ArrayList(val.size());
                        val.forEach(pair -> list.add(pair.getSecond()));
                        map.put(key, list.toArray(new DynamicObject[0]));
                    });
                    billData.setEntityData(map);
                    billData.setEntityId(exportContext.getMainEntityType().getName());
                    this.dispatcher.putToOutQueue(billData, retryCount);
                });
            }
        }
        catch (Throwable e) {
            log.error(e);
            this.dispatcher.getExportStart().writeErrorLog(e);
            this.dispatcher.interruptMainThread();
        }
        finally {
            this.dispatcher.getExportStart().getMonitor().addExpenseStatistics(DataLoadByQueryCfgTask.class, (Long)(System.currentTimeMillis() - start), false);
            if (this.dispatcher.getExportStart().getExportContext().isSerialModel()) {
                this.dispatcher.getSerialModelSemaphore().release();
            }
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }

    private Map<Object, DynamicObject> loadDynamicObject(Map<String, Set<Object>> entityIdsMap) {
        HashMap dysMap = Maps.newHashMapWithExpectedSize((int)16);
        entityIdsMap.forEach((key, val) -> {
            DynamicObject[] objectArray;
            HRBaseServiceHelper helper = new HRBaseServiceHelper(key);
            for (DynamicObject obj : objectArray = helper.loadDynamicObjectArray(val.toArray())) {
                dysMap.put(obj.getPkValue(), obj);
            }
        });
        return dysMap;
    }

    private void fillDynamicObject(Map<Object, DynamicObject> loadDynamicObject, List<Map<String, Map<Object, DynamicObject>>> dataList) {
        dataList.forEach(item -> item.forEach((key, val) -> val.keySet().forEach(id -> {
            DynamicObject object = val.computeIfAbsent(id, va -> (DynamicObject)loadDynamicObject.get(id));
        })));
    }

    private void fillDynamicObject2(Map<Object, DynamicObject> loadDynamicObject, List<Map<String, List<Pair<Object, DynamicObject>>>> dataList) {
        dataList.forEach(item -> item.forEach((key, val) -> val.forEach(pair -> pair.setSecond(loadDynamicObject.get(pair.getFirst())))));
    }

    private List<String> getAllJoinEntitys(QueryEntityType queryEntityType) {
        LinkedList<String> list = new LinkedList<String>();
        list.add(queryEntityType.getEntityAlias());
        queryEntityType.getJoinEntitys().forEach(en -> list.add(en.getAlias()));
        return list;
    }

    private List<Map<String, Map<Object, DynamicObject>>> transform(List<Map<String, List<Pair<Object, DynamicObject>>>> dataList) {
        ArrayList queryDataList = Lists.newArrayListWithCapacity((int)dataList.size());
        dataList.forEach(map -> {
            HashMap item = Maps.newHashMapWithExpectedSize((int)map.size());
            map.forEach((key, val) -> {
                HashMap childItem = Maps.newHashMapWithExpectedSize((int)val.size());
                val.forEach(va -> childItem.put(va.getFirst(), va.getSecond()));
                item.put(key, childItem);
            });
            queryDataList.add(item);
        });
        return queryDataList;
    }

    private Map<String, Map<Object, DynamicObject>> transformToMap(List<Map<String, Map<Object, DynamicObject>>> mapList) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)6);
        mapList.forEach(row -> row.forEach((key, val) -> {
            Map objectMap = map.computeIfAbsent(key, va -> Maps.newHashMapWithExpectedSize((int)16));
            objectMap.putAll(val);
        }));
        return map;
    }

    private void replaceDyForDataList(List<Map<String, List<Pair<Object, DynamicObject>>>> dataList, Map<String, Map<Object, DynamicObject>> tmpMap) {
        dataList.forEach(map -> map.forEach((key, val) -> {
            Map objectMap = (Map)tmpMap.get(key);
            val.forEach(va -> {
                if (!ObjectUtils.isEmpty((Object)objectMap)) {
                    DynamicObject dy = (DynamicObject)objectMap.get(va.getFirst());
                    va.setSecond((Object)dy);
                }
            });
        }));
    }
}

