/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.write;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.WriteDataByMEMSContext;
import kd.hr.expt.common.dto.WriteDataByMESSContext;
import kd.hr.expt.common.dto.WriteDataBySEContext;
import kd.hr.expt.common.dto.WriteDataContext;
import kd.hr.expt.core.write.WriteDataDispatcher;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.template.ExcelTemplateGenerate;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class ExcelGenerateTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(ExcelGenerateTask.class);
    private AtomicInteger childThreadMonitor;
    private WriteDataContext context;
    private WriteDataDispatcher dispatcher;

    public ExcelGenerateTask(WriteDataContext context, WriteDataDispatcher dispatcher) {
        this.childThreadMonitor = dispatcher.getChildThreadMonitor();
        this.context = context;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        ExportContext exportContext = this.context.getExportStart().getExportContext();
        MethodUtil.syncRequestTraceId((Object)exportContext.getRc());
        log.info("ExcelWriteByListTask_started.");
        try {
            this.writeHeaderRange(this.context);
            String localPath = this.saveLocalFile(this.context.getWb(), this.context.getFileName(), exportContext.getPwdport());
            this.context.setFileLocalPath(localPath);
            this.context.setHasgenFinished(true);
            if (StringUtils.isNotEmpty((String)this.context.getCusSheetfileLocalPath())) {
                ImportFileUtil.deleteLocalTempFile((String)this.context.getCusSheetfileLocalPath());
            }
        }
        catch (Throwable e) {
            log.error("ExcelWriteByListTask_call", e);
            this.dispatcher.getExportStart().writeErrorLog(e);
            this.dispatcher.interruptMainThread();
        }
        finally {
            this.dispatcher.getExportStart().getMonitor().addExpenseStatistics(ExcelGenerateTask.class, (Long)(System.currentTimeMillis() - start), false);
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }

    private void writeHeaderRange(WriteDataContext context) {
        if ("Tpl".equalsIgnoreCase(this.dispatcher.getExportStart().getExportContext().getExportModle())) {
            String entitytype;
            switch (entitytype = this.dispatcher.getExportStart().getExportContext().getTpl().getString("entitytype")) {
                case "SE": {
                    WriteDataBySEContext ctse = (WriteDataBySEContext)context;
                    XSSFSheet sheet1 = context.getWb().getXSSFWorkbook().getSheetAt(0);
                    CTWorksheet ctSheet1 = sheet1.getCTWorksheet();
                    ctSheet1.getDimension().setRef("A1:" + ExcelTemplateGenerate.getColumnLabel((int)ctse.getColumCount()) + ctse.getSheet().getPhysicalNumberOfRows());
                    break;
                }
                case "MESS": {
                    WriteDataByMESSContext ctmess = (WriteDataByMESSContext)context;
                    XSSFSheet sheet2 = context.getWb().getXSSFWorkbook().getSheetAt(0);
                    CTWorksheet ctSheet2 = sheet2.getCTWorksheet();
                    ctSheet2.getDimension().setRef("A1:" + ExcelTemplateGenerate.getColumnLabel((int)ctmess.getColumCount()) + ctmess.getSheet().getPhysicalNumberOfRows());
                    break;
                }
                case "MEMS": {
                    WriteDataByMEMSContext ctmems = (WriteDataByMEMSContext)context;
                    Map<String, SXSSFSheet> sheetMap = ctmems.getSheetMap();
                    log.info("ExcelGenerateTask.writeHeaderRange_getSheetColumCountMap():{},sheetMapKey:{}", ctmems.getSheetColumCountMap(), sheetMap.keySet());
                    for (Map.Entry<String, SXSSFSheet> next : sheetMap.entrySet()) {
                        SXSSFSheet ssheet = context.getWb().getSheet(next.getKey());
                        XSSFSheet sheet3 = context.getWb().getXSSFWorkbook().getSheet(next.getKey());
                        CTWorksheet ctSheet3 = sheet3.getCTWorksheet();
                        ctSheet3.getDimension().setRef("A1:" + ExcelTemplateGenerate.getColumnLabel((int)ctmems.getSheetColumCountMap().get(next.getKey())) + ssheet.getPhysicalNumberOfRows());
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    private String saveLocalFile(SXSSFWorkbook book, String fileName, String password) throws IOException {
        long start1 = System.currentTimeMillis();
        File file = null;
        OutputStream fos = null;
        try {
            file = new File(this.dispatcher.getTempDir(), fileName);
            fos = new FileOutputStream(file);
            book.write(fos);
        }
        finally {
            try {
                if (book != null) {
                    book.dispose();
                    book.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
                this.dispatcher.getExportStart().writeErrorLog(e);
            }
            this.dispatcher.getExportStart().getMonitor().addExpenseStatistics("generateExcelFile", (Long)(System.currentTimeMillis() - start1), true);
        }
        if (StringUtils.isNotEmpty((String)password)) {
            long start2 = System.currentTimeMillis();
            this.setPassword4OfficeFile(file.getPath(), this.dispatcher.getTempDir(), fileName, password);
            this.dispatcher.getExportStart().getMonitor().addExpenseStatistics("setPassword4OfficeFile", (Long)(System.currentTimeMillis() - start2), true);
        }
        return file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    private void setPassword4OfficeFile(String path, String dir, String fileName, String password) {
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        try (POIFSFileSystem fs = new POIFSFileSystem();){
            EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(password);
            String newFileName = String.valueOf(fileName.hashCode());
            File oldFile = new File(path);
            File newFile = new File(dir, newFileName);
            boolean ret = oldFile.renameTo(newFile);
            if (!ret) {
                throw new KDException(new ErrorCode("999", "setPassword4OfficeFile_oldFile.renameTo faild."), new Object[0]);
            }
            try {
                try (OPCPackage opc = OPCPackage.open((File)newFile, (PackageAccess)PackageAccess.READ_WRITE);
                     OutputStream os = enc.getDataStream(fs);){
                    opc.save(os);
                }
                var14_18 = null;
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    fs.writeFilesystem((OutputStream)fos);
                }
                catch (Throwable throwable) {
                    var14_18 = throwable;
                    throw throwable;
                }
            }
            finally {
                boolean ret2 = newFile.renameTo(oldFile);
                if (!ret2) {
                    log.error("setPassword4OfficeFile_newFile.renameTo faild.");
                }
            }
        }
        catch (Exception e) {
            log.error("setPwd_office_file ex :", (Throwable)e);
            this.dispatcher.getExportStart().writeErrorLog(e);
        }
    }
}

