/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.write;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.expt.business.template.ExportByListDataWriter;
import kd.hr.expt.common.dto.WriteDataByListContext;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.expt.core.write.WriteDataDispatcher;
import kd.hr.hbp.common.util.ReflectUtil;
import kd.hr.hies.business.excel.SheetStyle;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.MethodUtil;

public class ExcelWriteByListTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(ExcelWriteByListTask.class);
    private AtomicInteger childThreadMonitor;
    private WriteDataByListContext context;
    private List<List<Object>> dataRows;
    private Map<Integer, Map<String, Object>> rowDataPkIds;
    private int billDataCount;
    private WriteDataDispatcher dispatcher;

    public ExcelWriteByListTask(List<List<Object>> dataRows, Map<Integer, Map<String, Object>> rowDataPkIds, int billDataCount, WriteDataByListContext context, WriteDataDispatcher dispatcher) {
        this.childThreadMonitor = dispatcher.getChildThreadMonitor();
        this.context = context;
        this.dataRows = dataRows;
        this.rowDataPkIds = rowDataPkIds;
        this.billDataCount = billDataCount;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.context.getExportStart().getExportContext().getRc());
        log.info("ExcelWriteByListTask_started.");
        try {
            BeforeWriteDataEventArgs args = new BeforeWriteDataEventArgs(this.context.getExportStart().getExportContext());
            args.setSheetStyle((SheetStyle)ReflectUtil.newInstance(SheetStyle.class, (Object[])new Object[]{this.context.getWb()}));
            args.setListDataRows(this.dataRows);
            args.setFieldCaptions(this.context.getFieldCaptions());
            args.setRowDataPkIds(this.rowDataPkIds);
            UserExportPluginEngine.fireUserPluginEvent(this.context.getExportStart(), "beforeWriteData", (AbstractEventArgs)args);
            ExportByListDataWriter dataWriter = new ExportByListDataWriter(args.getListDataRows(), this.context);
            dataWriter.write();
            this.context.getExportStart().getExportContext().getFinishedBillCount().getAndAdd(this.billDataCount);
        }
        catch (Throwable e) {
            log.error("ExcelWriteByListTask_call", e);
            this.dispatcher.getExportStart().writeErrorLog(e);
            this.dispatcher.interruptMainThread();
        }
        finally {
            this.dispatcher.getExportStart().getMonitor().addExpenseStatistics(ExcelWriteByListTask.class.getSimpleName(), (Long)(System.currentTimeMillis() - start), false);
            this.context.getSemaphore().release();
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }
}

