/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.write;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import kd.hr.expt.common.dto.BaseExportBillData;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.ListExportConvertData;
import kd.hr.expt.common.dto.TplExportConvertData;
import kd.hr.expt.common.dto.WriteDataByListContext;
import kd.hr.expt.common.dto.WriteDataByMEMSContext;
import kd.hr.expt.common.dto.WriteDataByMESSContext;
import kd.hr.expt.common.dto.WriteDataBySEContext;
import kd.hr.expt.common.dto.WriteDataContext;
import kd.hr.expt.core.ExportWorker;
import kd.hr.expt.core.convert.ConvertDataDispatcher;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.expt.core.write.ExcelGenerateTask;
import kd.hr.expt.core.write.ExcelWriteByListTask;
import kd.hr.expt.core.write.ExcelWriteByTplTask;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.constant.HIESConstant;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;

public class WriteDataDispatcher
extends ExportWorker {
    private static Log log = LogFactory.getLog(WriteDataDispatcher.class);
    private int splitExcelMaxRowCount = 0x100000;
    private final String ERROR_TIMEOUT = "WriteDataDispatcher_task_timeout.";
    private Date writeStartTime;
    private List<WriteDataContext> contextList;
    private Semaphore contextSemaphore = new Semaphore(1);
    private String tempDir = Files.createTempDir().getPath();

    public WriteDataDispatcher(ExportStart exportStart) {
        super(WriteDataDispatcher.class.getSimpleName(), exportStart, exportStart.getConvertQueue(), null, true, MCConfigConstant.getWorkerMaxThread());
        Object count = exportStart.getExportContext().getExtOption().get("splitExcelMaxRowCount");
        if (count != null) {
            this.splitExcelMaxRowCount = (Integer)count;
        }
    }

    public Date getWriteStartTime() {
        return this.writeStartTime;
    }

    public Semaphore getContextSemaphore() {
        return this.contextSemaphore;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExcludeFromJacocoGeneratedReport
    public Object call() throws Exception {
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.exportStart.getExportContext().getRc());
        log.info("WriteDataDispatcher_started.");
        ExportContext exportContext = this.exportStart.getExportContext();
        try {
            this.waiteContext();
        }
        catch (Throwable e) {
            log.error(e);
            this.exportStart.writeErrorLog(e);
            super.interruptMainThread();
        }
        while (!this.exportStart.isStoped() && !this.isEnd) {
            try {
                BaseExportBillData data;
                List<BaseExportBillData> tempBilldatas;
                WriteDataContext currentContext;
                if ("ByList".equalsIgnoreCase(exportContext.getExportModle())) {
                    currentContext = null;
                    for (WriteDataContext ctx : this.contextList) {
                        if (ctx.isHasDataFinished()) continue;
                        currentContext = ctx;
                    }
                    tempBilldatas = this.getBatchData(1);
                    if (tempBilldatas.size() == 0) continue;
                    if (currentContext != null && currentContext.getSemaphore().tryAcquire(20L, TimeUnit.MINUTES)) {
                        WriteDataByListContext listCurrentContext;
                        data = (ListExportConvertData)tempBilldatas.get(0);
                        if (this.writeStartTime == null) {
                            this.writeStartTime = new Date();
                        }
                        if ((listCurrentContext = (WriteDataByListContext)currentContext).getCurrentWriteRowIndex() + ((ListExportConvertData)data).getDataRows().size() > this.splitExcelMaxRowCount) {
                            WriteDataContext nextContext = this.startNextContextWrite(currentContext);
                            listCurrentContext = (WriteDataByListContext)nextContext;
                        }
                        super.submitWithTimeOut(new ExcelWriteByListTask(((ListExportConvertData)data).getDataRows(), ((ListExportConvertData)data).getRowDataPkIds(), ((ListExportConvertData)data).getBillDataCount(), listCurrentContext, this));
                        continue;
                    }
                    this.throwTimeException();
                    continue;
                }
                currentContext = null;
                for (WriteDataContext ctx : this.contextList) {
                    if (ctx.isHasDataFinished()) continue;
                    currentContext = ctx;
                }
                tempBilldatas = this.getBatchData(1);
                if (tempBilldatas.size() == 0) continue;
                if (currentContext != null && currentContext.getSemaphore().tryAcquire(20L, TimeUnit.MINUTES)) {
                    String entitytype;
                    data = (TplExportConvertData)tempBilldatas.get(0);
                    if (this.writeStartTime == null) {
                        this.writeStartTime = new Date();
                    }
                    boolean needSplitFile = false;
                    switch (entitytype = exportContext.getTpl().getString("entitytype")) {
                        case "SE": {
                            WriteDataBySEContext seCurrentContext = (WriteDataBySEContext)currentContext;
                            if (seCurrentContext.getCurrentWriteRowIndex() + ((TplExportConvertData)data).getDataRows().size() <= this.splitExcelMaxRowCount) break;
                            needSplitFile = true;
                            break;
                        }
                        case "MEMS": {
                            WriteDataByMEMSContext memsCurrentContext = (WriteDataByMEMSContext)currentContext;
                            Integer rowIndex = memsCurrentContext.getSheetCurrentWriteRowIndexMap().get(((TplExportConvertData)data).getSheetName());
                            if (rowIndex + ((TplExportConvertData)data).getDataRows().size() <= this.splitExcelMaxRowCount) break;
                            needSplitFile = true;
                            break;
                        }
                        case "MESS": {
                            WriteDataByMESSContext messCurrentContext = (WriteDataByMESSContext)currentContext;
                            if (messCurrentContext.getCurrentWriteRowIndex() + ((TplExportConvertData)data).getDataRows().size() <= this.splitExcelMaxRowCount) break;
                            needSplitFile = true;
                        }
                    }
                    if (needSplitFile) {
                        currentContext = this.startNextContextWrite(currentContext);
                    }
                    super.submitWithTimeOut(new ExcelWriteByTplTask((TplExportConvertData)data, currentContext, this));
                    continue;
                }
                this.throwTimeException();
            }
            catch (Throwable e) {
                log.error(e);
                this.exportStart.writeErrorLog(e);
                super.interruptMainThread();
            }
        }
        try {
            Object syncLock;
            String filePath;
            super.waiteChildFinished();
            WriteDataContext lastContext = this.contextList.get(this.contextList.size() - 1);
            super.submitWithTimeOut(new ExcelGenerateTask(lastContext, this));
            super.end();
            if (this.contextList.size() > 1) {
                List collect = this.contextList.stream().map(de -> de.getFileName()).collect(Collectors.toList());
                String zipName = (String)collect.get(0) + ".zip";
                long start2 = System.currentTimeMillis();
                String zipPath = ImportFileUtil.createZip((String)this.tempDir, collect, (String)zipName);
                this.exportStart.getMonitor().addExpenseStatistics("createZipFile", (Long)(System.currentTimeMillis() - start2), true);
                filePath = this.uploadFile(zipName, zipPath);
            } else {
                filePath = this.uploadFile(this.contextList.get(0).getFileName(), this.contextList.get(0).getFileLocalPath());
            }
            exportContext.setFilePath(filePath);
            Object object = syncLock = this.exportStart.syncLock;
            synchronized (object) {
                syncLock.notifyAll();
            }
        }
        catch (Throwable e) {
            log.error(e);
            this.exportStart.writeErrorLog(e);
            super.interruptMainThread();
        }
        this.exportStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadFile(String fileName, String filePath) throws IOException {
        long start = System.currentTimeMillis();
        File temp = null;
        FileInputStream fis = null;
        try {
            temp = new File(filePath);
            fileName = HIESConstant.SpecCharPattern.matcher(fileName).replaceAll("");
            RequestContext rc = RequestContext.get();
            String path = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)this.exportStart.getExportContext().getAppId(), (String)(this.exportStart.getExportContext().getMainFormId() + UUID.randomUUID().toString()), (String)fileName);
            FileService service = FileServiceFactory.getAttachmentFileService();
            fis = new FileInputStream(temp);
            String filePatch = service.upload(new FileItem(fileName, path, (InputStream)fis));
            this.exportStart.getMonitor().addExpenseStatistics("uploadExcelFile", (Long)(System.currentTimeMillis() - start), true);
            String string = filePatch;
            return string;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                ImportFileUtil.deleteDirectory((String)this.tempDir);
            }
            catch (Throwable e) {
                log.error(e);
                this.exportStart.writeErrorLog(e);
            }
        }
    }

    private void waiteContext() throws InterruptedException {
        if (!this.contextSemaphore.tryAcquire(20L, TimeUnit.MINUTES)) {
            throw new KDException(new ErrorCode("904", "waiteContext_timeout."), new Object[0]);
        }
        ConvertDataDispatcher convertDataDispatcher = (ConvertDataDispatcher)this.exportStart.getWorkers().get(ConvertDataDispatcher.class.getSimpleName());
        this.contextList = convertDataDispatcher.getContextList();
        this.contextSemaphore.release();
    }

    private void throwTimeException() {
        throw new KDException(new ErrorCode("905", "WriteDataDispatcher_task_timeout."), new Object[0]);
    }

    @ExcludeFromJacocoGeneratedReport
    private void editFileNameSeq(WriteDataContext context, int seq) {
        String[] split = StringUtils.split((String)context.getFileName(), (boolean)true, (char[])new char[]{'.'});
        context.setFileName(split[0] + "(" + seq + ")." + split[1]);
    }

    @ExcludeFromJacocoGeneratedReport
    private WriteDataContext startNextContextWrite(WriteDataContext currentContext) throws Exception {
        currentContext.setHasDataFinished(true);
        this.editFileNameSeq(currentContext, 0);
        super.submitWithTimeOut(new ExcelGenerateTask(currentContext, this));
        currentContext.getSemaphore().release();
        ConvertDataDispatcher convertDataDispatcher = (ConvertDataDispatcher)this.exportStart.getWorkers().get(ConvertDataDispatcher.class.getSimpleName());
        WriteDataContext nextContext = convertDataDispatcher.createContext(this.contextList.size());
        this.contextList.add(nextContext);
        if (!nextContext.getSemaphore().tryAcquire(20L, TimeUnit.MINUTES)) {
            this.throwTimeException();
        }
        return nextContext;
    }
}

