/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.formplugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.expt.common.dto.TplInfo;
import kd.hr.expt.common.enu.HiesExportRes;
import kd.hr.expt.common.util.ExportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hies.business.TemplateServiceHelper;
import kd.hr.hies.common.enu.TemplateTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ExptTplSelectPlugin
extends HRDataBaseList
implements FilterContainerInitListener,
AfterSearchClickListener,
AfterBindDataListener {
    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.setBillFormId("hies_diaetplconf");
            filterContainer.setNeedShareScheme(false);
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        String tmplType = (String)formShowParameter.getCustomParam("tmpltype");
        String formTitle = TemplateTypeEnum.EXPT.getCode().equals(tmplType) ? ResManager.loadKDString((String)"\u6309\u5bfc\u51fa\u6a21\u677f\u5bfc\u51fa", (String)HiesExportRes.ExptTplSelectPlugin_3.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa", (String)HiesExportRes.ExptTplSelectPlugin_4.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]);
        formShowParameter.setCaption(formTitle);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
    }

    public void registerListener(EventObject e) {
        FilterContainer filterContainer;
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        BillList list = (BillList)this.getControl("billlistap");
        if (list != null) {
            list.addAfterBindDataListener((AfterBindDataListener)this);
        }
        if ((filterContainer = (FilterContainer)this.getControl("filtercontainerap")) != null) {
            filterContainer.addAfterSearchClickListener((AfterSearchClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            IListView listView = (IListView)view;
            ListSelectedRowCollection listSelectedData = listView.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u677f\u3002", (String)HiesExportRes.ExptTplSelectPlugin_1.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow listSelectedRow = listSelectedData.get(0);
            Long tplPkId = (Long)listSelectedRow.getPrimaryKeyValue();
            TplInfo tplInfo = new TplInfo();
            tplInfo.setTplPkId(tplPkId);
            tplInfo.setTplName(listSelectedRow.getName());
            String formId = (String)view.getFormShowParameter().getCustomParam("formId");
            boolean isEntityEncrypt = ExportUtil.isEntityEncrypt(formId, tplPkId);
            String extParam = (String)view.getFormShowParameter().getCustomParam("extParam");
            if (isEntityEncrypt) {
                ExportUtil.showEntityPwdForm(tplInfo, view, extParam, formId);
            } else {
                ExportUtil.showProgressForm(tplInfo, view, extParam, formId);
            }
            view.close();
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        IFormView view = this.getView();
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Object primaryKeyValue = list.getFocusRowPkId();
        String formId = "hies_diaetplconf";
        HRBaseServiceHelper helper = new HRBaseServiceHelper(formId);
        if (helper.isExists(primaryKeyValue)) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setFormId(formId);
            showParameter.setPageId(String.valueOf(primaryKeyValue) + '_' + RequestContext.get().getGlobalSessionId());
            showParameter.setPkId(primaryKeyValue);
            view.showForm((FormShowParameter)showParameter);
        } else {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\uff0c\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)HiesExportRes.ExptTplSelectPlugin_2.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("modifytime desc");
    }

    public void click(SearchClickEvent searchClickEvent) {
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
    }

    public void afterBindData(AfterBindDataEvent afterBindDataEvent) {
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs evt) {
        super.beforeCreateListDataProvider(evt);
        final BillList billList = (BillList)this.getView().getControl("billlistap");
        evt.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection datas = super.getData(start, limit);
                if (CollectionUtils.isEmpty((Collection)datas)) {
                    return datas;
                }
                if (datas.size() == 1) {
                    DynamicObject dynamicObject = (DynamicObject)datas.get(0);
                    ListSelectedRowCollection collection = new ListSelectedRowCollection();
                    collection.add((Object)new ListSelectedRow(dynamicObject.getPkValue()));
                    billList.putSelectedRows(collection);
                    DynamicObject dyn = TemplateServiceHelper.getTemplateByPkId((long)dynamicObject.getLong("id"));
                    this.dealFullTpl(dyn, dynamicObject);
                } else {
                    Set pkIds = datas.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
                    Object[] dyns = TemplateServiceHelper.getTemplateByPkIds(pkIds);
                    if (ArrayUtils.isNotEmpty((Object[])dyns)) {
                        Optional<DynamicObject> firstFindDyn = Arrays.stream(dyns).filter(item -> "full".equals(item.getString("source"))).findFirst();
                        firstFindDyn.ifPresent(item -> {
                            Optional<DynamicObject> first = datas.stream().filter(dynItem -> item.getLong("id") == dynItem.getLong("id")).findFirst();
                            first.ifPresent(dynamicObject -> this.dealFullTpl((DynamicObject)item, (DynamicObject)dynamicObject));
                        });
                    }
                }
                return datas;
            }

            private void dealFullTpl(DynamicObject dyn, DynamicObject dynamicObject) {
                if (ObjectUtils.isNotEmpty((Object)dyn) && "full".equals(dyn.getString("source"))) {
                    String resFullTemplate = ResManager.loadKDString((String)"\u5168\u91cf\u6a21\u677f", (String)HiesExportRes.ExptTplSelectPlugin_5.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]);
                    dynamicObject.set("name", (Object)resFullTemplate);
                    dynamicObject.set("number", (Object)dyn.getString("entity.number"));
                }
            }
        });
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        evt.setCancel(true);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
    }
}

