/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.formplugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.mservice.ImportPermissionService;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.svc.util.permission.datarule.DataRulePermissionUtil;
import kd.hr.expt.common.dto.TplInfo;
import kd.hr.expt.common.enu.HiesExportRes;
import kd.hr.expt.common.util.ExportUtil;
import kd.hr.expt.mservice.api.IExportService;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hies.business.TemplateApplyScopeServiceHelper;
import kd.hr.hies.business.TemplateServiceHelper;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.enu.OprCategory;
import kd.hr.hies.common.util.MethodUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HRExportCofirmEditPlugin
extends AbstractFormPlugin {
    private final ImportPermissionService importPermissionService = new ImportPermissionService();
    private static final String BTN_OK = "btnok";
    private static final String CONTENT = "content";
    private static final String DISPLAY_NAME = "displayName";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String content = (String)parameter.getCustomParam(CONTENT);
        String displayName = (String)parameter.getCustomParam(DISPLAY_NAME);
        HashMap<String, Object> mapParam = new HashMap<String, Object>(2);
        mapParam.put(CONTENT, content);
        mapParam.put(DISPLAY_NAME, displayName);
        mapParam.put("pageId", parameter.getParentPageId());
        mapParam.put("opPlugins", parameter.getCustomParam("opPlugins"));
        mapParam.put("listPlugins", parameter.getCustomParam("listPlugins"));
        mapParam.put("formId", parameter.getCustomParam("formId"));
        String routeAppId = MethodUtil.getRouteAppId((String)this.getView().getFormShowParameter().getServiceAppId());
        Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hr.expt.servicehelper", (String)routeAppId, (String)IExportService.class.getSimpleName(), (String)"runConfirmPlugin", (Object[])new Object[]{mapParam});
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(result.getMsg());
            return;
        }
        Map data = (Map)result.getData();
        this.getPageCache().put("extParam", (String)data.get("extParam"));
        this.getPageCache().put("formId", (String)data.get("formId"));
        this.getPageCache().put("queryEntityId", (String)data.get("queryEntityId"));
        this.getPageCache().put("isCurrentList", "true");
        String formId = (String)data.get("formId");
        String queryEntityId = (String)data.get("queryEntityId");
        if (StringUtils.isNotEmpty((CharSequence)formId) && !parameter.getCustomParam("formId").equals(formId) || StringUtils.isNotEmpty((CharSequence)queryEntityId) && !parameter.getCustomParam("queryEntityId").equals(queryEntityId)) {
            this.getPageCache().put("isCurrentList", "false");
        }
        String showMsg = String.format((String)data.get(CONTENT), data.get(DISPLAY_NAME));
        Label messageLabel = (Label)this.getControl("message");
        messageLabel.setText(showMsg);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            if (this.notPassPermission()) {
                return;
            }
            this.doExport();
        }
    }

    private void doExport() {
        IFormView view = this.getView();
        FormShowParameter parameter = view.getFormShowParameter();
        parameter.setCustomParam("oprFormId", parameter.getCustomParam("formId"));
        String entityNumber = this.getEntityNumber();
        if ("Tpl".equals(parameter.getCustomParam("exportModle"))) {
            this.showSelectTemplate(entityNumber);
        } else {
            TplInfo tplInfo = new TplInfo();
            boolean isEntityEncrypt = ExportUtil.isEntityEncrypt(entityNumber, null);
            String extParam = this.getPageCache().get("extParam");
            if (isEntityEncrypt) {
                ExportUtil.showEntityPwdForm(tplInfo, view, extParam, entityNumber);
            } else {
                ExportUtil.showProgressForm(tplInfo, view, extParam, entityNumber);
            }
        }
        view.close();
    }

    private Pair<List<TplInfo>, Boolean> queryTmpls(String entityNumber) {
        QFilter currentUserRightTpt = TemplateApplyScopeServiceHelper.getCurrentUserTemplate();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        filters.add(new QFilter("entity.number", "=", (Object)entityNumber));
        filters.add(new QFilter("tmpltype", "=", (Object)this.tplType()));
        filters.add(currentUserRightTpt);
        filters.add(new QFilter("source", "in", Arrays.asList("normal", "external", "")));
        filters.add(HRQFilterHelper.buildEnable());
        IFormView parentView = this.getParentView();
        String appId = parentView.getPageCache().get("CheckRightAppId");
        QFilter dataRule = DataRulePermissionUtil.getDataRule((long)RequestContext.getOrCreate().getCurrUserId(), (String)appId, (String)"hies_diaetplconf");
        if (dataRule != null) {
            filters.add(dataRule);
        }
        DynamicObjectCollection queryCollection = QueryServiceHelper.query((String)"HRExportByTpl", (String)"hies_diaetplconf", (String)"id, name, importtype", (QFilter[])filters.toArray(new QFilter[0]), (String)"", (int)-1);
        boolean isAllDelTpl = true;
        ArrayList<TplInfo> datas = new ArrayList<TplInfo>();
        for (DynamicObject dynamicObject : queryCollection) {
            TplInfo tplInfo = new TplInfo();
            tplInfo.setTplPkId(dynamicObject.getLong("id"));
            tplInfo.setTplName(dynamicObject.getString("name"));
            datas.add(tplInfo);
            if (OprCategory.isDelete((String)dynamicObject.getString("importtype"))) continue;
            isAllDelTpl = false;
        }
        return Pair.of(datas, (Object)isAllDelTpl);
    }

    private IFormView getParentView() {
        return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
    }

    private String tplType() {
        return (String)this.getView().getFormShowParameter().getCustomParam("tmpltype");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showSelectTemplate(String entityNumber) {
        ArrayList qFilters;
        String extParam;
        IPageCache parentPageCache;
        block12: {
            block13: {
                parentPageCache = this.getParentView().getPageCache();
                extParam = this.getPageCache().get("extParam");
                Pair<List<TplInfo>, Boolean> tplListBooleanPair = this.queryTmpls(entityNumber);
                List templates = (List)tplListBooleanPair.getLeft();
                qFilters = Lists.newArrayListWithExpectedSize((int)2);
                if (!CollectionUtils.isNotEmpty((Collection)templates)) break block13;
                List templateIds = templates.stream().map(TplInfo::getTplPkId).collect(Collectors.toList());
                if (Boolean.TRUE.equals(tplListBooleanPair.getRight())) {
                    DynamicObject dynObj = TemplateServiceHelper.getFullTemplate((String)entityNumber, (String)"", (String)this.tplType());
                    if (!ObjectUtils.isEmpty((Object)dynObj)) {
                        templateIds.add(dynObj.getLong("id"));
                    }
                    break block12;
                } else if (templateIds.size() > 1) {
                    qFilters.add(new QFilter("id", "in", templateIds));
                    qFilters.add(new QFilter("tmpltype", "=", (Object)this.tplType()));
                    break block12;
                } else {
                    IFormView view = this.getView();
                    TplInfo tplInfo = (TplInfo)templates.get(0);
                    boolean isEntityEncrypt = ExportUtil.isEntityEncrypt(this.getEntityNumber(), tplInfo.getTplPkId());
                    if (isEntityEncrypt) {
                        ExportUtil.showEntityPwdForm(tplInfo, view, extParam, this.getEntityNumber());
                    } else {
                        ExportUtil.showProgressForm(tplInfo, view, extParam, this.getEntityNumber());
                    }
                    view.close();
                    return;
                }
            }
            DynamicObject dynObj = TemplateServiceHelper.getFullTemplate((String)entityNumber, (String)"", (String)this.tplType());
            if (!ObjectUtils.isEmpty((Object)dynObj)) {
                String resFullTemplate = ResManager.loadKDString((String)"\u5168\u91cf\u6a21\u677f", (String)HiesExportRes.ExptTplSelectPlugin_5.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]);
                IFormView view = this.getView();
                TplInfo tplInfo = new TplInfo();
                tplInfo.setTplPkId(dynObj.getLong("id"));
                tplInfo.setTplName(resFullTemplate);
                boolean isEntityEncrypt = ExportUtil.isEntityEncrypt(this.getEntityNumber(), tplInfo.getTplPkId());
                if (isEntityEncrypt) {
                    ExportUtil.showEntityPwdForm(tplInfo, view, extParam, this.getEntityNumber());
                } else {
                    ExportUtil.showProgressForm(tplInfo, view, extParam, this.getEntityNumber());
                }
                view.close();
                return;
            }
            qFilters.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        }
        FormView view = (FormView)this.getView();
        ListShowParameter showParameter = new ListShowParameter();
        if (OprCategory.isExportByExptpl((String)((String)this.getView().getFormShowParameter().getCustomParam("OprCategory")))) {
            showParameter.setFormId("hies_expttplselectbyexpt");
        } else {
            showParameter.setFormId("hies_expttplselectbyimpt");
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setListFilterParameter(new ListFilterParameter((List)qFilters, null));
        showParameter.setCustomParam("tmpltype", (Object)this.tplType());
        ExportUtil.putPermissionInfo((FormShowParameter)showParameter, parentPageCache);
        showParameter.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        showParameter.setCustomParam("extParam", (Object)extParam);
        showParameter.setCustomParam("formId", (Object)this.getEntityNumber());
        showParameter.setCustomParam("isCurrentList", (Object)(!"false".equals(this.getPageCache().get("isCurrentList")) ? 1 : 0));
        showParameter.setCustomParam("queryEntityId", (Object)this.getQueryEntityId());
        IFormView parentView = this.getParentView();
        parentView.showForm((FormShowParameter)showParameter);
        view.sendFormAction(parentView);
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
    }

    private boolean checkPermission() {
        OperationResult result = new OperationResult();
        IFormView view = this.getView();
        IPageCache pageCache = this.getParentView().getPageCache();
        String orgIdsStr = pageCache.get("MainOrgIds");
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId(pageCache.get("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSONObject.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId(pageCache.get("RealPermissionEntityId")).setCurrentEntityId(pageCache.get("BillFormId")).setOperateName(pageCache.get("OperateName")).setPermissionItemId(pageCache.get("PermissionItemId")).setResult(result);
        if (!this.importPermissionService.validatePermission(importPermissionParamBuidler.build())) {
            this.importPermissionService.doFailCheckRight(view, result);
            return false;
        }
        return true;
    }

    private boolean notPassPermission() {
        try {
            this.handleCancelDataRight();
            this.handleCancelRight();
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return true;
        }
        return !this.checkPermission();
    }

    private void handleCancelRight() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCancelRight() == 0) {
            return;
        }
        FormConfig config = formShowParameter.getFormConfig();
        String formName = config.getCaption().getLocaleValue();
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684%1$s\u529f\u80fd\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)HiesExportRes.HRExportPlugin_1.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), formName));
    }

    private void handleCancelDataRight() {
        if (!this.getView().getFormShowParameter().isCancelDataRight()) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)HiesExportRes.HRExportPlugin_2.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]));
    }

    private String getEntityNumber() {
        String formId = this.getPageCache().get("formId");
        if (StringUtils.isEmpty((CharSequence)formId)) {
            formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        }
        return formId;
    }

    private String getQueryEntityId() {
        String formId = this.getPageCache().get("queryEntityId");
        if (StringUtils.isEmpty((CharSequence)formId)) {
            formId = (String)this.getView().getFormShowParameter().getCustomParam("queryEntityId");
        }
        return formId;
    }
}

