/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.expt.business.ExportCallBack;
import kd.hr.expt.business.ExportProgressHelper;
import kd.hr.expt.business.ExportTaskClick;
import kd.hr.expt.common.enu.HiesExportRes;
import kd.hr.expt.mservice.api.IExportService;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.business.TaskService;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.task.IEGlobalTaskUtil;
import kd.hr.hies.common.util.ExcelUtil;
import kd.hr.hies.common.util.MethodUtil;
import org.apache.commons.collections4.MapUtils;

public class HRExportProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(HRExportProgressPlugin.class);
    public static final String CACHEKEY_JOBFORMINFO = "export_jobforminfo";
    public static final String CACHEKEY_TASKID = "export_taskid";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CACHEKEY_ISFINISHED = "isfinished";
    private static final String BACKGROUND_ACTIONID = "background_actionid";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String CONFIRMED_TOBACKGROUND_OR_SUSPEND = "CLOSE_CONFIRMED_TOBACKGROUND_OR_SUSPEND";
    private static final String CONFIRMED_SUSPEND = "CLOSE_CONFIRMED_SUSPEND";
    private static final String CONFIRMED_TOBACKGROUND = "CLOSE_CONFIRMED_TOBACKGROUND";
    private boolean canClose = false;

    private boolean isSuspending() {
        String suspending = this.getPageCache().get(this.getCurrentAppCacheKey());
        if (StringUtils.isBlank((CharSequence)suspending)) {
            return false;
        }
        return Boolean.parseBoolean(suspending);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(finished));
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel", "tobackgroud", "close", "showhistory", "exportfilename"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.initLabelText();
        this.startBar();
        this.setStart(true);
        this.startExportTask();
    }

    private void initLabelText() {
        String exportFileName = (String)this.getFormShowParameter().getCustomParam("exportFileName");
        ExportProgressHelper.initText(this.getView(), exportFileName);
    }

    private void progressLabelText(Map<String, Object> data) {
        String remainingTime = "";
        String curExecuteNum = "";
        String totalNum = "";
        if (MapUtils.isNotEmpty(data)) {
            Integer timeRemaining = (Integer)data.get("timeRemaining");
            if (timeRemaining != null && timeRemaining > 0) {
                int minute = timeRemaining / 60;
                int second = timeRemaining % 60;
                StringBuilder sb = new StringBuilder();
                if (minute > 0) {
                    sb.append(minute).append(ResManager.loadKDString((String)"\u5206", (String)HiesExportRes.HRExportProgressPlugin_16.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]));
                }
                if (second > 0) {
                    sb.append(second).append(ResManager.loadKDString((String)"\u79d2", (String)HiesExportRes.HRExportProgressPlugin_17.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]));
                }
                remainingTime = sb.toString();
            }
            curExecuteNum = (String)data.get("finishedBillCount");
            totalNum = (String)data.get("totalBillCount");
            Integer progress = (Integer)data.get("progress");
            if (progress == null || progress == 0) {
                progress = 1;
            }
            ExportProgressHelper.progressText(this.getView(), curExecuteNum, totalNum, remainingTime, progress);
        }
    }

    private void completeLabelText(Map<String, String> result) {
        String unKnowMsg = ResManager.loadKDString((String)"\u672a\u77e5", (String)HiesExportRes.HRExportProgressPlugin_2.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]);
        String totalNum = result.containsKey("totalBillCount") ? String.valueOf(result.get("totalBillCount")) : unKnowMsg;
        String totalCostTime = result.containsKey("totalCostStr") ? result.get("totalCostStr") : unKnowMsg;
        ExportProgressHelper.completeText(this.getView(), totalNum, totalCostTime);
    }

    public void onProgress(ProgressEvent progressEvent) {
        String taskId = this.getTaskPKId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        IHRAppCache cache = HRAppCache.get((String)"hies");
        Map result = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.EXPORT, (String)"result"), Map.class);
        try {
            if (result != null) {
                this.complete(result, progressEvent);
            } else {
                Map data = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.EXPORT, (String)"processing"), Map.class);
                if (data == null) {
                    return;
                }
                Integer progress = (Integer)data.get("progress");
                if (progress == null) {
                    return;
                }
                if (progress >= 100) {
                    progress = 99;
                } else if (progress == 0) {
                    progress = 1;
                }
                progressEvent.setProgress(progress.intValue());
                this.progressLabelText(data);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        if (!this.isStart() || this.isSuspending()) {
            beforeClosedEvent.setCancel(true);
            return;
        }
        if (this.canClose || this.isFinished()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTaskPKId())) {
            HashMap<Integer, String> btNameMap = new HashMap<Integer, String>(16);
            btNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u8f6c\u5165\u540e\u53f0", (String)HiesExportRes.HRExportProgressPlugin_3.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]));
            btNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62", (String)HiesExportRes.HRExportProgressPlugin_4.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b63\u5728\u51c6\u5907\u5bfc\u51fa\u6570\u636e\uff0c\u786e\u8ba4\u7ec8\u6b62\u5417\uff1f", (String)HiesExportRes.HRExportProgressPlugin_5.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CONFIRMED_TOBACKGROUND_OR_SUSPEND, (IFormPlugin)this), btNameMap);
            this.stopBar();
            beforeClosedEvent.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "CLOSE_CONFIRMED_TOBACKGROUND_OR_SUSPEND": {
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    this.toBackground();
                    break;
                }
                this.suspendExport();
                break;
            }
            case "CLOSE_CONFIRMED_TOBACKGROUND": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                this.toBackground();
                break;
            }
            case "CLOSE_CONFIRMED_SUSPEND": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                this.suspendExport();
                break;
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        this.getView().close();
    }

    private void startExportTask() {
        this.getPageCache().put("taskTraceId", RequestContext.get().getTraceId());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map params = formShowParameter.getCustomParams();
        String serviceAppId = (String)formShowParameter.getCustomParam("ServiceAppId");
        String queryEntityId = (String)params.get("queryEntityId");
        if (StringUtils.isNotEmpty((CharSequence)queryEntityId)) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)queryEntityId);
            serviceAppId = dataEntityType.getAppId();
        }
        String routeAppId = MethodUtil.getRouteAppId((String)serviceAppId);
        params.put("userStartTime", new Date().getTime());
        params.put("routeAppId", routeAppId);
        params.put("requestContext", SerializationUtils.toJsonString((Object)RequestContext.get()));
        Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hr.expt.servicehelper", (String)routeAppId, (String)IExportService.class.getSimpleName(), (String)"submitNewTask", (Object[])new Object[]{params});
        if (result.isSuccess()) {
            this.getPageCache().put("export_taskPKid", String.valueOf(result.getData()));
        } else {
            this.getView().showMessage(result.getMsg());
            this.stopBar();
            this.closeForm();
        }
    }

    private void complete(Map<String, String> result, ProgressEvent progressEvent) {
        this.setFinished(true);
        this.downLoad(result);
        progressEvent.setProgress(100);
        this.completeLabelText(result);
        this.stopBar();
        this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
        if ("true".equals(result.get("sysTerminator"))) {
            String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u5f02\u5e38\uff01traceId:%s \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRExportProgressPlugin_18", (String)"hrmp-hies-export", (Object[])new Object[0]), this.getPageCache().get("taskTraceId"));
            this.getView().showErrorNotification(tip);
        }
    }

    private void downLoad(Map<String, String> result) {
        if (result.containsKey("filePatch")) {
            String filePatch = result.get("filePatch");
            if (StringUtils.isNotBlank((CharSequence)filePatch)) {
                String url = ExcelUtil.getDownloadUrl((String)filePatch, (String)this.getView().getEntityId(), (String)"4730fc9f000004ae");
                this.getView().download(url);
            }
        } else {
            String fileGenNotice = ResManager.loadKDString((String)"\u6587\u4ef6\u6b63\u5728\u751f\u6210\uff0c\u751f\u6210\u6210\u529f\u540e\u5c06\u4f1a\u81ea\u52a8\u4e0b\u8f7d\u3002", (String)HiesExportRes.HRExportProgressPlugin_11.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]);
            this.getView().showTipNotification(fileGenNotice);
        }
    }

    private IAppCache getCurrentAppCache() {
        return AppCache.get((String)EntityMetadataCache.getDataEntityType((String)this.getEntityNumber()).getAppId());
    }

    private String getCurrentAppCacheKey() {
        String taskId = StringUtils.isNotBlank((CharSequence)this.getTaskPKId()) ? "_" + this.getTaskPKId() : "";
        return "EXPT_SUSPEND_" + this.getEntityNumber() + taskId;
    }

    private void toBackground() {
        this.closeForm();
        String taskPKId = this.getTaskPKId();
        if (!StringUtils.isBlank((CharSequence)taskPKId)) {
            String key = MethodUtil.getTaskCachePath((String)taskPKId, (String)"export", (String)"ball");
            IHRAppCache appCache = HRAppCache.get((String)"hies");
            TaskInfo taskInfo = (TaskInfo)appCache.get(key, TaskInfo.class);
            IHRAppCache cache = HRAppCache.get((String)"hies");
            Map result = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.EXPORT, (String)"result"), Map.class);
            if (taskInfo == null && result == null) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Map params = formShowParameter.getCustomParams();
                String filename = params.getOrDefault("exportFileName", "");
                IEGlobalTaskUtil.createNewGlobalTask((String)"export", (IFormView)this.getView(), (String)taskPKId, (String)filename, (String)ExportTaskClick.class.getName(), (String)ExportCallBack.class.getName());
            }
        }
    }

    private String getTaskPKId() {
        return this.getPageCache().get("export_taskPKid");
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        switch (controlKey) {
            case "btncancel": {
                IHRAppCache cache = HRAppCache.get((String)"hies");
                String status = (String)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.EXPORT, (String)"status"), String.class);
                if ("stop".equals(status)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ec8\u6b62\uff0c\u65e0\u6cd5\u591a\u6b21\u7ec8\u6b62\u3002", (String)HiesExportRes.HRExportProgressPlugin_15.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]));
                    break;
                }
                view.showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u7ec8\u6b62\u5bfc\u51fa\u4efb\u52a1\uff1f", (String)HiesExportRes.HRExportProgressPlugin_9.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMED_SUSPEND, (IFormPlugin)this));
                break;
            }
            case "tobackgroud": {
                view.showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u628a\u5bfc\u51fa\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)HiesExportRes.HRExportProgressPlugin_10.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMED_TOBACKGROUND, (IFormPlugin)this));
                break;
            }
            case "close": {
                this.closeForm();
                break;
            }
            case "showhistory": {
                TaskInfoHelper.showHistory((IFormView)this.getView(), (String)OprType.EXPORT.getValue());
                break;
            }
            case "exportfilename": {
                IHRAppCache cache2 = HRAppCache.get((String)"hies");
                Map result = (Map)cache2.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.EXPORT, (String)"result"), Map.class);
                this.downLoad(result);
            }
        }
    }

    private void suspendExport() {
        boolean terminatorFlag = TaskService.terminatorTask((String)this.getTaskPKId(), (String)ImportCacheKeyType.EXPORT);
        IFormView parentView = this.getView().getParentView();
        if (terminatorFlag) {
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u901a\u77e5\u7cfb\u7edf\u7ec8\u6b62\u5bfc\u51fa\u3002", (String)HiesExportRes.HRExportProgressPlugin_12.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]));
            this.suspendLog();
        } else {
            parentView.showTipNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002\u82e5\u591a\u6b21\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)HiesExportRes.HRExportProgressPlugin_13.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]));
        }
        this.getView().sendFormAction(parentView);
        this.setStart(true);
        this.closeForm();
    }

    private void suspendLog() {
    }

    private FormShowParameter getFormShowParameter() {
        return this.getView().getFormShowParameter();
    }

    private String getEntityNumber() {
        return (String)this.getFormShowParameter().getCustomParam("formId");
    }
}

