/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseDataInfoBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.util.HisModelEditAuditTool;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hies.common.enu.OprCategory;
import kd.hr.hies.common.plugin.BaseAfterQueryRefBdEventArgs;
import kd.hr.hies.common.plugin.BaseBeforeQueryRefBdEventArgs;
import kd.hr.hies.formplugin.hismodel.common.HisModelComHRService;
import kd.hr.hies.formplugin.hismodel.util.HisModelComUtil;
import kd.hr.hies.formplugin.hismodel.util.HisModelTplInfo;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImptPluginContext;
import kd.hr.impt.common.plugin.AfterCallOperationEventArgs;
import kd.hr.impt.common.plugin.AfterConvertDynamicObjectsEventArgs;
import kd.hr.impt.common.plugin.AfterF7MatchedEventArgs;
import kd.hr.impt.common.plugin.AfterInitContextArgs;
import kd.hr.impt.common.plugin.AfterLoadStartPageEventArgs;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HisModelComHRImptPlugin
extends HRDataBaseList
implements HRImportPlugin,
HisModelComHRService {
    private static final Log LOGGER = LogFactory.getLog(HisModelComHRImptPlugin.class);
    private boolean isVersionF7 = false;
    private boolean hasHis = false;
    private String tplType;
    private Set<String> businessF7Fields = new HashSet<String>(8);
    private Set<String> baseDataCtrlFields = new HashSet<String>(8);

    public void afterInitContext(AfterInitContextArgs args) {
        String entityId = (String)args.getMultiEntityDbTranSeq().get(0);
        this.hasHis = ImportServiceHelper.hasHis((String)entityId);
        if (this.hasHis) {
            args.setCallopStandExpense(Integer.valueOf(10000));
        }
    }

    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        this.isVersionF7 = this.beforeQueryRefBdCom((BaseBeforeQueryRefBdEventArgs)args, true);
    }

    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        this.afterQueryRefBdCom((BaseAfterQueryRefBdEventArgs)args, this.isVersionF7);
    }

    public void afterConvertDynamicObjects(AfterConvertDynamicObjectsEventArgs args) {
        QFilter isCurrentQFilter;
        Set ids;
        QFilter idsQFilter;
        HRBaseServiceHelper helper;
        DynamicObjectCollection dataCol;
        boolean isPersonal;
        Map dynamicObjects = args.getDynamicObjects();
        if (MapUtils.isEmpty((Map)dynamicObjects)) {
            LOGGER.warn("\u6682\u4e0d\u652f\u6301\u591a\u5b9e\u4f53\u5355sheet,\u540e\u7eed\u7248\u672c\u518d\u652f\u6301");
            return;
        }
        QFilter defaults = (QFilter)dynamicObjects.get("default");
        DynamicObject dynOne = defaults[0];
        String entityId = dynOne.getDataEntityType().getName();
        HisModelTplInfo hisModelTplInfo = HisModelComUtil.getHisModelTplInfo(entityId);
        this.hasHis = hisModelTplInfo.isExtendHisModelTpl();
        if (!this.hasHis) {
            return;
        }
        ImptPluginContext context = args.getContext();
        String importType = context.getImporttype();
        if (HisModelImportUtil.isNew((String)importType) || HisModelImportUtil.isDelete((String)importType)) {
            return;
        }
        boolean isBaseDataCtrl = Boolean.TRUE.equals(BaseDataServiceHelper.checkBaseDataCtrl((String)entityId));
        if (isBaseDataCtrl && (isPersonal = false)) {
            return;
        }
        String opName = "save";
        boolean needAudit = HisModelEditAuditTool.getNeedAuditForOp((IDataEntityType)dynOne.getDataEntityType());
        boolean isExtendLineTimeSeqTpl = hisModelTplInfo.isExtendLineTimeSeqTpl();
        boolean hasEnable = hisModelTplInfo.isContainEnable();
        Map<Object, Object> enableMap = new HashMap(0);
        if (hasEnable && CollectionUtils.isNotEmpty((Collection)(dataCol = (helper = new HRBaseServiceHelper(entityId)).queryOriginalCollection("id, enable", new QFilter[]{idsQFilter = HRQFilterHelper.buildIn((String)"id", ids = Arrays.stream(defaults).map(item -> item.get("id")).collect(Collectors.toSet())), isCurrentQFilter = HRQFilterHelper.buildEql((String)"iscurrentversion", (Object)Character.valueOf('1'))})))) {
            enableMap = dataCol.stream().collect(Collectors.toMap(v -> v.get("id"), v -> v.getString("enable")));
        }
        HashMap<String, List> tempMap = new HashMap<String, List>();
        Map map = args.initIdAndbillDataMap(args.getImportBillDatas());
        for (QFilter dy : defaults) {
            ImportBillData billData = (ImportBillData)map.get(dy.getPkValue());
            String opType = billData.getOpType();
            if (OprCategory.isNew((String)opType)) {
                opName = "save";
            } else if (OprCategory.isUpdate((String)opType)) {
                String enable = MapUtils.getString(enableMap, (Object)dy.get("id"));
                opName = HRStringUtils.equals((String)enable, (String)"10") ? "save" : (isExtendLineTimeSeqTpl ? (needAudit ? "save" : "confirmchangenoaudit") : (needAudit ? "save" : "confirmchange"));
            }
            List opNameDys = tempMap.computeIfAbsent(opName, val -> new LinkedList());
            opNameDys.add(dy);
        }
        HashMap newMap = new HashMap();
        for (Map.Entry next : tempMap.entrySet()) {
            newMap.put(next.getKey(), ((List)next.getValue()).toArray(new DynamicObject[0]));
        }
        args.setDynamicObjects(newMap);
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        if (!this.hasHis) {
            return;
        }
        ImptPluginContext context = args.getContext();
        String importType = context.getImporttype();
        if (HisModelImportUtil.isNew((String)importType) || HisModelImportUtil.isDelete((String)importType)) {
            return;
        }
        this.tplType = args.getContext().getImporttype();
        Map submitOPs = args.getSubmitOPs();
        String groupName = args.getGroupName();
        submitOPs.put(submitOPs.keySet().stream().findFirst().get(), groupName);
    }

    public void afterCallOperation(AfterCallOperationEventArgs args) {
        if (!this.hasHis) {
            return;
        }
        OperationResult result = args.getResult();
        List successPkIds = result.getSuccessPkIds();
        if (CollectionUtils.isNotEmpty((Collection)successPkIds) && successPkIds.size() > 1) {
            if (OprCategory.isDelete((String)this.tplType)) {
                List distinctSuccessPkIds = successPkIds.stream().distinct().collect(Collectors.toList());
                result.setSuccessPkIds(distinctSuccessPkIds);
            } else {
                Map billNos = result.getBillNos();
                if (MapUtils.isNotEmpty((Map)billNos)) {
                    HashSet collect = new HashSet(billNos.keySet());
                    result.setSuccessPkIds(collect.stream().filter(successPkIds::contains).collect(Collectors.toList()));
                    LOGGER.info("afterCallOperation successPkIds:{} billNos.collect:{}", (Object)successPkIds, collect);
                } else {
                    DynamicObject[] dynamicObjects = args.getDynamicObjects();
                    Set collect = Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                    result.setSuccessPkIds(collect.stream().filter(successPkIds::contains).collect(Collectors.toList()));
                    LOGGER.info("afterCallOperation successPkIds:{} dyn.collect:{}", (Object)successPkIds, collect);
                }
            }
            LOGGER.info("afterCallOperation SuccessPkIds.size:{} BillCount.size:{} AllErrorInfo.size:{}", new Object[]{result.getSuccessPkIds().size(), result.getBillCount(), result.getAllErrorInfo().size()});
        }
    }

    public void afterLoadStartPage(AfterLoadStartPageEventArgs args) {
        super.afterLoadStartPage(args);
        this.hasHis = ImportServiceHelper.hasHis((String)args.getFormId());
        if (this.hasHis) {
            args.setEnableSelectModelItem(false);
            args.setEnableSelectModelView(false);
        }
    }

    public void beforeValidate(BeforeValidateEventArgs args) {
        HashMap f7ExtUniqueValMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)8);
        ImptPluginContext context = args.getContext();
        Set allEntityId = context.getAllEntityId();
        for (String entityId : allEntityId) {
            MainEntityType type;
            try {
                type = EntityMetadataCache.getDataEntityType((String)entityId);
            }
            catch (Exception e) {
                LOGGER.warn(" \u65e0\u6cd5\u83b7\u53d6\u3010{}\u3011\u5143\u6570\u636e\u4fe1\u606f\uff0c\u53ef\u80fd\u662f\u7801\u8868sheet\u9875", (Object)entityId);
                continue;
            }
            Map f7UniqueValMap = f7ExtUniqueValMap.computeIfAbsent(entityId, val -> Maps.newHashMapWithExpectedSize((int)8));
            Map f7UniqueValFieldMap = f7ExtUniqueValFieldMap.computeIfAbsent(entityId, val -> Maps.newHashMapWithExpectedSize((int)8));
            Map allFields = type.getAllFields();
            for (Map.Entry field : allFields.entrySet()) {
                IDataEntityProperty property = (IDataEntityProperty)field.getValue();
                if (!(property instanceof BasedataProp)) continue;
                String baseDataName = ((BasedataProp)property).getBaseEntityId();
                String entityType = HisCommonService.getInstance().entityInhRelation(baseDataName);
                boolean isExtendsHisLineTimeSeq = EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType);
                if (!isExtendsHisLineTimeSeq) continue;
                String fieldId = (String)field.getKey();
                String importEntityType = HisCommonService.getInstance().entityInhRelation(entityId);
                boolean isImportEntityHisLineType = EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(importEntityType);
                HisBaseDataInfoBo hisControlAttribute = HisCommonService.getInstance().getHisControlAttribute(entityId, fieldId);
                String bsedField = isImportEntityHisLineType ? "bsed" : hisControlAttribute.getBsedField();
                LOGGER.info("\u4e1a\u52a1\u751f\u6548\u65e5\u671f\u5173\u8054\u5b57\u6bb5id:{}", (Object)bsedField);
                IDataEntityProperty bsedFieldProperty = (IDataEntityProperty)allFields.get(bsedField);
                if (ObjectUtils.isEmpty((Object)bsedFieldProperty)) continue;
                boolean selData = hisControlAttribute.isSelData();
                if (selData) {
                    this.businessF7Fields.add(fieldId);
                    boolean isBaseDataCtrl = Boolean.TRUE.equals(BaseDataServiceHelper.checkBaseDataCtrl((String)baseDataName));
                    if (!isBaseDataCtrl) continue;
                    f7UniqueValMap.put(fieldId, "firstbsed");
                    Map f7ExtUniqueValFieldMapSub = f7UniqueValFieldMap.computeIfAbsent(fieldId, val -> Maps.newHashMapWithExpectedSize((int)8));
                    f7ExtUniqueValFieldMapSub.put("firstbsed", bsedField);
                    this.baseDataCtrlFields.add(fieldId);
                    continue;
                }
                f7UniqueValMap.put(fieldId, "bsed,bsled");
                Map f7ExtUniqueValFieldMapSub = f7UniqueValFieldMap.computeIfAbsent(fieldId, val -> Maps.newHashMapWithExpectedSize((int)8));
                f7ExtUniqueValFieldMapSub.put("bsed", bsedField);
                f7ExtUniqueValFieldMapSub.put("bsled", bsedField);
            }
        }
        args.setF7ExtUniqueValMap((Map)f7ExtUniqueValMap);
        args.setF7ExtUniqueValFieldMap((Map)f7ExtUniqueValFieldMap);
    }

    public void afterF7Matched(AfterF7MatchedEventArgs args) {
        String fieldId = args.getFieldId();
        if (this.businessF7Fields.contains(fieldId) && !this.baseDataCtrlFields.contains(fieldId)) {
            return;
        }
        String currentF7Key = (String)args.getCurrentF7Key();
        if (StringUtils.isBlank((CharSequence)currentF7Key)) {
            return;
        }
        String[] split = currentF7Key.split(",");
        if (split.length == 1) {
            return;
        }
        String bsedKey = split[1];
        Map f7QueryDataMap = args.getF7QueryDataMap();
        if (MapUtils.isEmpty((Map)f7QueryDataMap)) {
            return;
        }
        ArrayList baseDataDys = new ArrayList(f7QueryDataMap.size());
        for (Map.Entry entry : f7QueryDataMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] split2 = key.split(",");
            String bdKey = split2[0];
            if (!bdKey.equals(split[0])) continue;
            if (this.baseDataCtrlFields.contains(fieldId)) {
                String firstbsed = split2[1];
                if (bsedKey.compareTo(firstbsed) < 0) continue;
                baseDataDys.addAll((Collection)entry.getValue());
                continue;
            }
            String bsed = split2[1];
            String bsled = split2[2];
            if (bsedKey.compareTo(bsed) < 0 || bsedKey.compareTo(bsled) > 0) continue;
            args.setBaseDataDys((List)entry.getValue());
            return;
        }
        if (CollectionUtils.isNotEmpty(baseDataDys)) {
            args.setBaseDataDys(baseDataDys);
        }
    }
}

