/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business.export;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.metadata.form.ControlAp;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.FieldStyle;
import kd.hr.hies.common.util.ExcelStyleUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportSheetStyle {
    public static final String DEFAULT = "default";
    private Table<String, String, CellStyle> customHeadCellStyles;
    private Table<String, String, CellStyle> customContentCellStyles;
    private CellStyle globalHeadCellStyle;
    private CellStyle globalContentCellStyle;
    private Table<String, String, String> customFieldMerges;
    private SXSSFRow entityRow;
    private SXSSFRow nameRow;
    private SXSSFWorkbook wb;
    private Map<String, CellStyle> styleMap = new HashMap<String, CellStyle>();
    private Map<String, DecimalFormat> decimalFormats = new HashMap<String, DecimalFormat>();
    private Font redFont;
    private boolean isTitleRowDefaultStyle;
    private boolean autoLine = true;
    private Table<String, String, String> marksTable = HashBasedTable.create();
    private Table<String, String, String> displayFormatStringTable = HashBasedTable.create();
    private Table<String, String, Boolean> noDisplayScaleZeroTable = HashBasedTable.create();

    public ExportSheetStyle(SXSSFWorkbook wb) {
        this.wb = wb;
        this.redFont = wb.createFont();
        this.redFont.setColor(IndexedColors.RED.getIndex());
    }

    @ExcludeFromJacocoGeneratedReport
    public ExportSheetStyle(Set<String> entitySet, SXSSFWorkbook wb, CellStyle globalHeadCellStyle, CellStyle globalContentCellStyle) {
        this(wb);
        this.globalHeadCellStyle = globalHeadCellStyle;
        this.globalContentCellStyle = globalContentCellStyle;
        if (entitySet == null) {
            return;
        }
        for (String entity : entitySet) {
            Map<String, ControlAp<?>> fieldControlApMap = ExcelStyleUtil.getFieldControlApMap(entity);
            EntityMetadataCache.getDataEntityType((String)entity).getAllFields().values().stream().filter(prop -> prop instanceof TimeProp || prop instanceof DateTimeProp).forEach(prop2 -> {
                String mask = ExcelStyleUtil.getMask(fieldControlApMap, prop2);
                if (StringUtils.isNotBlank((CharSequence)mask)) {
                    this.marksTable.put((Object)entity, (Object)prop2.getName(), (Object)mask);
                }
            });
            EntityMetadataCache.getDataEntityType((String)entity).getAllFields().values().stream().filter(prop -> prop instanceof LongProp || prop instanceof IntegerProp || prop instanceof DecimalProp).forEach(prop2 -> {
                String numberMask = ExcelStyleUtil.getNumberMask(fieldControlApMap, prop2);
                if (StringUtils.isNotBlank((CharSequence)numberMask)) {
                    this.marksTable.put((Object)entity, (Object)prop2.getName(), (Object)numberMask);
                }
            });
            EntityMetadataCache.getDataEntityType((String)entity).getAllFields().values().stream().forEach(prop2 -> {
                boolean noDisplayScaleZero;
                String displayFormatString = ExcelStyleUtil.getDisplayFormatString(fieldControlApMap, prop2);
                if (StringUtils.isNotBlank((CharSequence)displayFormatString)) {
                    this.displayFormatStringTable.put((Object)entity, (Object)prop2.getName(), (Object)displayFormatString);
                }
                if (noDisplayScaleZero = ExcelStyleUtil.getNoDisplayScaleZero(fieldControlApMap, prop2)) {
                    this.noDisplayScaleZeroTable.put((Object)entity, (Object)prop2.getName(), (Object)noDisplayScaleZero);
                }
            });
        }
    }

    public ExportSheetStyle(Set<String> entitySet, SXSSFWorkbook wb, Table<String, String, CellStyle> customHeadCellStyles, Table<String, String, CellStyle> customContentCellStyles) {
        this(wb);
        this.customHeadCellStyles = customHeadCellStyles;
        this.customContentCellStyles = customContentCellStyles;
        for (String entity : entitySet) {
            Map<String, ControlAp<?>> fieldControlApMap = ExcelStyleUtil.getFieldControlApMap(entity);
            EntityMetadataCache.getDataEntityType((String)entity).getAllFields().values().stream().filter(prop -> prop instanceof TimeProp || prop instanceof DateTimeProp).forEach(prop2 -> {
                String mask = ExcelStyleUtil.getMask(fieldControlApMap, prop2);
                if (StringUtils.isNotBlank((CharSequence)mask)) {
                    this.marksTable.put((Object)entity, (Object)prop2.getName(), (Object)mask);
                }
            });
            EntityMetadataCache.getDataEntityType((String)entity).getAllFields().values().stream().filter(prop -> prop instanceof LongProp || prop instanceof IntegerProp || prop instanceof DecimalProp).forEach(prop2 -> {
                String numberMask = ExcelStyleUtil.getNumberMask(fieldControlApMap, prop2);
                if (StringUtils.isNotBlank((CharSequence)numberMask)) {
                    this.marksTable.put((Object)entity, (Object)prop2.getName(), (Object)numberMask);
                }
            });
            EntityMetadataCache.getDataEntityType((String)entity).getAllFields().values().stream().forEach(prop2 -> {
                boolean noDisplayScaleZero;
                String displayFormatString = ExcelStyleUtil.getDisplayFormatString(fieldControlApMap, prop2);
                if (StringUtils.isNotBlank((CharSequence)displayFormatString)) {
                    this.displayFormatStringTable.put((Object)entity, (Object)prop2.getName(), (Object)displayFormatString);
                }
                if (noDisplayScaleZero = ExcelStyleUtil.getNoDisplayScaleZero(fieldControlApMap, prop2)) {
                    this.noDisplayScaleZeroTable.put((Object)entity, (Object)prop2.getName(), (Object)noDisplayScaleZero);
                }
            });
        }
    }

    public boolean isTitleRowDefaultStyle() {
        return this.isTitleRowDefaultStyle;
    }

    public void setTitleRowDefaultStyle(boolean titleRowDefaultStyle) {
        this.isTitleRowDefaultStyle = titleRowDefaultStyle;
    }

    @ExcludeFromJacocoGeneratedReport
    public Table<String, String, String> getCustomFieldMerges() {
        return this.customFieldMerges;
    }

    @ExcludeFromJacocoGeneratedReport
    public void setCustomFieldMerges(Table<String, String, String> customFieldMerges) {
        this.customFieldMerges = customFieldMerges;
    }

    public Map<String, DecimalFormat> getDecimalFormats() {
        return this.decimalFormats;
    }

    public void setGlobalContentCellStyle(CellStyle globalContentCellStyle) {
        this.globalContentCellStyle = globalContentCellStyle;
    }

    public CellStyle getGlobalHeadCellStyle() {
        return this.globalHeadCellStyle;
    }

    public void setGlobalHeadCellStyle(CellStyle globalHeadCellStyle) {
        this.globalHeadCellStyle = globalHeadCellStyle;
    }

    public SXSSFRow getEntityRow() {
        return this.entityRow;
    }

    public void setEntityRow(SXSSFRow entityRow) {
        this.entityRow = entityRow;
    }

    public SXSSFRow getNameRow() {
        return this.nameRow;
    }

    public void setNameRow(SXSSFRow nameRow) {
        this.nameRow = nameRow;
    }

    public void reference(SXSSFRow entityRow, SXSSFRow nameRow) {
        this.setEntityRow(entityRow);
        this.setNameRow(nameRow);
    }

    public CellStyle getTplCodeRowTextStyle() {
        String style = "TplCodeRowTextStyle";
        CellStyle cs = this.styleMap.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setDataFormat(this.wb.createDataFormat().getFormat("@"));
            cs.setWrapText(false);
            Font font = this.wb.createFont();
            font.setColor(IndexedColors.BLUE.getIndex());
            cs.setFont(font);
            this.styleMap.put(style, cs);
        }
        return cs;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getFieldDescRowTextStyle() {
        String style = "FieldDescRowTextStyle";
        CellStyle cs = this.styleMap.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setDataFormat(this.wb.createDataFormat().getFormat("@"));
            cs.setWrapText(this.autoLine);
            Font font = this.wb.createFont();
            font.setColor(IndexedColors.GREY_50_PERCENT.getIndex());
            font.setItalic(true);
            cs.setFont(font);
            this.styleMap.put(style, cs);
        }
        return cs;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getHeadTextStyle(String entityId, String fieldName) {
        CellStyle textStyle = this.getTextStyle(DEFAULT);
        CellStyle cellStyle = this.getHeadCellStyle(entityId, fieldName, "@");
        if (cellStyle == null) {
            cellStyle = textStyle;
        } else {
            cellStyle.setDataFormat(textStyle.getDataFormat());
            cellStyle.setWrapText(textStyle.getWrapText());
            cellStyle.setVerticalAlignment(textStyle.getVerticalAlignment());
            cellStyle.setAlignment(textStyle.getAlignment());
        }
        return cellStyle;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getContentTextStyle(String entityId, String fieldName) {
        CellStyle textStyle = this.getTextStyle("ContentTextStyle");
        CellStyle cellStyle = this.getContentCellStyle(entityId, fieldName, "@");
        if (cellStyle == null) {
            cellStyle = textStyle;
        } else {
            cellStyle.setDataFormat(textStyle.getDataFormat());
            cellStyle.setWrapText(textStyle.getWrapText());
            cellStyle.setVerticalAlignment(textStyle.getVerticalAlignment());
            cellStyle.setAlignment(textStyle.getAlignment());
        }
        return cellStyle;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getDefContentTextStyle(String entityId, String fieldName) {
        String key1 = "ContentTextStyleDef";
        CellStyle cellStyleTemp = this.styleMap.get(key1);
        if (cellStyleTemp == null) {
            cellStyleTemp = new FieldStyle().getCellStyle(this.wb.getXSSFWorkbook());
            CellStyle textStyle = this.getTextStyle("ContentTextStyle");
            cellStyleTemp.setDataFormat(textStyle.getDataFormat());
            cellStyleTemp.setWrapText(textStyle.getWrapText());
            cellStyleTemp.setVerticalAlignment(textStyle.getVerticalAlignment());
            cellStyleTemp.setAlignment(textStyle.getAlignment());
            this.styleMap.put(key1, cellStyleTemp);
        }
        return cellStyleTemp;
    }

    public CellStyle getHeadTextStyle(String align) {
        CellStyle textStyle = this.getTextStyle(align);
        CellStyle cellStyle = this.globalHeadCellStyle;
        if (cellStyle == null) {
            cellStyle = textStyle;
        } else {
            cellStyle.setDataFormat(textStyle.getDataFormat());
            cellStyle.setWrapText(textStyle.getWrapText());
            cellStyle.setVerticalAlignment(textStyle.getVerticalAlignment());
            cellStyle.setAlignment(textStyle.getAlignment());
        }
        return cellStyle;
    }

    public CellStyle getContentTextStyle() {
        CellStyle textStyle = this.getTextStyle();
        CellStyle cellStyle = this.globalContentCellStyle;
        if (cellStyle != null) {
            String style = "ExportByList_getContentTextStyle";
            CellStyle cellStyleTemp = this.styleMap.get(style);
            if (cellStyleTemp == null) {
                cellStyleTemp = this.wb.createCellStyle();
                cellStyleTemp.cloneStyleFrom(cellStyle);
                cellStyleTemp.setDataFormat(textStyle.getDataFormat());
                cellStyleTemp.setWrapText(textStyle.getWrapText());
                cellStyleTemp.setVerticalAlignment(textStyle.getVerticalAlignment());
                cellStyleTemp.setAlignment(textStyle.getAlignment());
                this.styleMap.put(style, cellStyleTemp);
            }
            return cellStyleTemp;
        }
        cellStyle = textStyle;
        return cellStyle;
    }

    public CellStyle getTextStyle() {
        return this.getTextStyle(DEFAULT);
    }

    public CellStyle getTextStyle(String align) {
        String style = "TEXT_" + align;
        CellStyle cs = this.styleMap.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            cs.setDataFormat(this.wb.createDataFormat().getFormat("@"));
            this.styleMap.put(style, cs);
        }
        cs.setWrapText(this.autoLine);
        return cs;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getDefContentDateStyle(String entityId, String fieldName) {
        CellStyle cellStyle;
        String mask = (String)this.marksTable.get((Object)entityId, (Object)fieldName);
        if (StringUtils.isBlank((CharSequence)mask)) {
            mask = "yyyy-MM-dd";
        }
        if ((cellStyle = this.getDefContentTextStyle(entityId, fieldName)) == null) {
            return this.getDateStyle(DEFAULT);
        }
        String align = "left";
        String style = "DATETIME_ " + mask + " " + align;
        CellStyle cellStyleTemp = this.styleMap.get(style);
        if (cellStyleTemp == null) {
            cellStyleTemp = this.wb.createCellStyle();
            cellStyleTemp.cloneStyleFrom(cellStyle);
            if (StringUtils.isBlank((CharSequence)mask)) {
                cellStyleTemp.setDataFormat((short)0);
            } else {
                cellStyleTemp.setDataFormat(this.wb.createDataFormat().getFormat(mask));
            }
            cellStyleTemp.setAlignment(this.getAlignment(align));
            this.styleMap.put(style, cellStyleTemp);
        }
        return cellStyleTemp;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getContentDateStyle(String entityId, String fieldName) {
        CellStyle cellStyle;
        String mask = (String)this.marksTable.get((Object)entityId, (Object)fieldName);
        if (StringUtils.isBlank((CharSequence)mask)) {
            mask = "yyyy-MM-dd";
        }
        if ((cellStyle = this.getContentCellStyle(entityId, fieldName, mask)) == null) {
            return this.getDateStyle(DEFAULT);
        }
        String align = "left";
        String style = "DATETIME_ " + mask + " " + align;
        CellStyle cellStyleTemp = this.styleMap.get(style);
        if (cellStyleTemp == null) {
            cellStyleTemp = this.wb.createCellStyle();
            cellStyleTemp.cloneStyleFrom(cellStyle);
            if (StringUtils.isBlank((CharSequence)mask)) {
                cellStyleTemp.setDataFormat((short)0);
            } else {
                cellStyleTemp.setDataFormat(this.wb.createDataFormat().getFormat(mask));
            }
            cellStyleTemp.setAlignment(this.getAlignment(align));
            this.styleMap.put(style, cellStyleTemp);
        }
        return cellStyleTemp;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getContentDefaultDateStyle() {
        CellStyle dateStyle = this.getDateStyle();
        CellStyle cellStyle = this.globalContentCellStyle;
        if (cellStyle != null) {
            String style = "ExportByList_getContentDefaultDateStyle";
            CellStyle cellStyleTemp = this.styleMap.get(style);
            if (cellStyleTemp == null) {
                cellStyleTemp = this.wb.createCellStyle();
                cellStyleTemp.cloneStyleFrom(cellStyle);
                cellStyleTemp.setDataFormat(dateStyle.getDataFormat());
                cellStyleTemp.setVerticalAlignment(dateStyle.getVerticalAlignment());
                cellStyleTemp.setAlignment(dateStyle.getAlignment());
                this.styleMap.put(style, cellStyleTemp);
            }
            return cellStyleTemp;
        }
        cellStyle = dateStyle;
        return cellStyle;
    }

    public CellStyle getDateStyle() {
        return this.getDateStyle(DEFAULT);
    }

    public CellStyle getDateStyle(String align) {
        String style;
        CellStyle cs;
        if (StringUtils.isBlank((CharSequence)align) || DEFAULT.equalsIgnoreCase(align)) {
            align = "left";
        }
        if ((cs = this.styleMap.get(style = "DATE_" + align)) == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat("yyyy-MM-dd"));
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.styleMap.put(style, cs);
        }
        return cs;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getDefContentDatetimeStyle(String entityId, String fieldName) {
        CellStyle cellStyle;
        String mask = (String)this.marksTable.get((Object)entityId, (Object)fieldName);
        if (StringUtils.isBlank((CharSequence)mask)) {
            mask = "yyyy-MM-dd HH:mm:ss";
        }
        if ((cellStyle = this.getDefContentTextStyle(entityId, fieldName)) == null) {
            return this.getDatetimeStyle(DEFAULT);
        }
        String align = "left";
        String style = "DATETIME_ " + mask + " " + align;
        CellStyle cellStyleTemp = this.styleMap.get(style);
        if (cellStyleTemp == null) {
            cellStyleTemp = this.wb.createCellStyle();
            cellStyleTemp.cloneStyleFrom(cellStyle);
            if (StringUtils.isBlank((CharSequence)mask)) {
                cellStyleTemp.setDataFormat((short)0);
            } else {
                cellStyleTemp.setDataFormat(this.wb.createDataFormat().getFormat(mask));
            }
            cellStyleTemp.setAlignment(this.getAlignment(align));
            this.styleMap.put(style, cellStyleTemp);
        }
        return cellStyleTemp;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getContentDatetimeStyle(String entityId, String fieldName) {
        CellStyle cellStyle;
        String mask = (String)this.marksTable.get((Object)entityId, (Object)fieldName);
        if (StringUtils.isBlank((CharSequence)mask)) {
            mask = "yyyy-MM-dd HH:mm:ss";
        }
        if ((cellStyle = this.getContentCellStyle(entityId, fieldName, mask)) == null) {
            return this.getDatetimeStyle(DEFAULT);
        }
        String align = "left";
        String style = "DATETIME_ " + mask + " " + align;
        CellStyle cellStyleTemp = this.styleMap.get(style);
        if (cellStyleTemp == null) {
            cellStyleTemp = this.wb.createCellStyle();
            cellStyleTemp.cloneStyleFrom(cellStyle);
            if (StringUtils.isBlank((CharSequence)mask)) {
                cellStyleTemp.setDataFormat((short)0);
            } else {
                cellStyleTemp.setDataFormat(this.wb.createDataFormat().getFormat(mask));
            }
            cellStyleTemp.setAlignment(this.getAlignment(align));
            this.styleMap.put(style, cellStyleTemp);
        }
        return cellStyleTemp;
    }

    public CellStyle getContentDefaultDatetimeStyle() {
        CellStyle textStyle = this.getDatetimeStyle();
        CellStyle cellStyle = this.globalContentCellStyle;
        if (cellStyle != null) {
            String style = "ExportByList_getContentDefaultDatetimeStyle";
            CellStyle cellStyleTemp = this.styleMap.get(style);
            if (cellStyleTemp == null) {
                cellStyleTemp = this.wb.createCellStyle();
                cellStyleTemp.cloneStyleFrom(cellStyle);
                cellStyleTemp.setDataFormat(textStyle.getDataFormat());
                cellStyleTemp.setVerticalAlignment(textStyle.getVerticalAlignment());
                cellStyleTemp.setAlignment(textStyle.getAlignment());
                this.styleMap.put(style, cellStyleTemp);
            }
            return cellStyleTemp;
        }
        cellStyle = textStyle;
        return cellStyle;
    }

    public CellStyle getDatetimeStyle() {
        return this.getDatetimeStyle(DEFAULT);
    }

    public CellStyle getDatetimeStyle(String align) {
        String style;
        CellStyle cs;
        if (StringUtils.isBlank((CharSequence)align) || DEFAULT.equalsIgnoreCase(align)) {
            align = "left";
        }
        if ((cs = this.styleMap.get(style = "DATETIME_" + align)) == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat("yyyy-MM-dd HH:mm:ss"));
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.styleMap.put(style, cs);
        }
        return cs;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getContentTimeStyle(String entityId, String fieldName) {
        String mark = (String)this.marksTable.get((Object)entityId, (Object)fieldName);
        CellStyle cellStyle = this.getContentCellStyle(entityId, fieldName, mark);
        if (cellStyle != null) {
            if (StringUtils.isNotBlank((CharSequence)mark)) {
                cellStyle.setDataFormat(this.wb.createDataFormat().getFormat(mark));
            } else {
                cellStyle.setDataFormat(this.wb.createDataFormat().getFormat("HH:mm:ss"));
            }
        } else {
            cellStyle = this.getTimeStyle(DEFAULT);
        }
        return cellStyle;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getTimeStyle(String align) {
        String style;
        CellStyle cs;
        if (StringUtils.isBlank((CharSequence)align) || DEFAULT.equalsIgnoreCase(align)) {
            align = "left";
        }
        if ((cs = this.styleMap.get(style = "TIME_" + align)) == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat("HH:mm:ss"));
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.styleMap.put(style, cs);
        }
        return cs;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getHlinkStyle() {
        return this.getHlinkStyle(DEFAULT);
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getHlinkStyle(String align) {
        String style = "HLINK_" + align;
        CellStyle cs = this.styleMap.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            Font hlink_font = this.wb.createFont();
            hlink_font.setUnderline((byte)1);
            hlink_font.setColor(IndexedColors.BLUE.getIndex());
            cs.setFont(hlink_font);
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.styleMap.put(style, cs);
        }
        return cs;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getExportTitleStyle() {
        CellStyle titleStyle = this.getTitleStyle(DEFAULT);
        titleStyle.setBorderTop(BorderStyle.THIN);
        titleStyle.setBorderRight(BorderStyle.THIN);
        titleStyle.setBorderBottom(BorderStyle.THIN);
        titleStyle.setBorderLeft(BorderStyle.THIN);
        return titleStyle;
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getTitleStyle(String align) {
        String style = "TITLE_" + align;
        CellStyle cs = this.styleMap.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs.setAlignment(this.getAlignment(align));
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            this.styleMap.put(style, cs);
        }
        return cs;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    public CellStyle getTextHighLightStyle() {
        return this.getTextHighLightStyle(DEFAULT);
    }

    private CellStyle getTextHighLightStyle(String align) {
        String style = "TEXTHIGHLIGHT_" + align;
        CellStyle cs = this.styleMap.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat("@"));
            cs.setFont(this.redFont);
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.styleMap.put(style, cs);
        }
        return cs;
    }

    public CellStyle getTitleMustInputStyle() {
        return this.getTitleMustInputStyle(DEFAULT);
    }

    public CellStyle getTitleMustInputStyle(String align) {
        String style = "TITLEMUSTINPUT_" + align;
        CellStyle cs = this.styleMap.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs.setFont(this.redFont);
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.styleMap.put(style, cs);
        }
        return cs;
    }

    public CellStyle getDefContentDecimalStyle(String entityId, String fieldName, String mask) {
        CellStyle cellStyle = this.getDefContentTextStyle(entityId, fieldName);
        String displayFormatString = this.getDisplayFormatString(entityId, fieldName);
        if (StringUtils.isBlank((CharSequence)displayFormatString)) {
            cellStyle = this.setDataFormat(mask, cellStyle, null, DEFAULT);
        }
        return cellStyle;
    }

    public CellStyle getContentDecimalStyle(String entityId, String fieldName, String mask) {
        CellStyle cellStyle = this.getContentTextStyle(entityId, fieldName);
        String displayFormatString = this.getDisplayFormatString(entityId, fieldName);
        if (StringUtils.isBlank((CharSequence)displayFormatString)) {
            cellStyle = this.setDataFormat(mask, cellStyle, null, DEFAULT);
        }
        return cellStyle;
    }

    public CellStyle getDefContentDecimalStyle(String entityId, String fieldName, Map<String, Object> dataMap) {
        CellStyle cellStyle = this.getDefContentTextStyle(entityId, fieldName);
        String mask = (String)this.marksTable.get((Object)entityId, (Object)fieldName);
        String displayFormatString = this.getDisplayFormatString(entityId, fieldName);
        if (StringUtils.isBlank((CharSequence)displayFormatString)) {
            cellStyle = this.setDataFormat(mask, cellStyle, dataMap, DEFAULT);
        }
        return cellStyle;
    }

    public CellStyle getContentDecimalStyle(String entityId, String fieldName, Map<String, Object> dataMap) {
        CellStyle cellStyle = this.getContentTextStyle(entityId, fieldName);
        String mask = (String)this.marksTable.get((Object)entityId, (Object)fieldName);
        String displayFormatString = this.getDisplayFormatString(entityId, fieldName);
        if (StringUtils.isBlank((CharSequence)displayFormatString)) {
            cellStyle = this.setDataFormat(mask, cellStyle, dataMap, DEFAULT);
        }
        return cellStyle;
    }

    private CellStyle setDataFormat(String mask, CellStyle cellStyle, Map<String, Object> dataMap, String align) {
        CellStyle cellStyleTemp;
        if (StringUtils.isBlank((CharSequence)align) || DEFAULT.equalsIgnoreCase(align)) {
            align = "right";
        }
        String styleKey = "DECIMAL";
        if (dataMap == null || dataMap.size() == 0 || dataMap.get("scale") == null) {
            String key = styleKey + " " + mask + " " + align;
            cellStyleTemp = this.styleMap.get(key);
            if (cellStyleTemp == null) {
                cellStyleTemp = this.wb.createCellStyle();
                cellStyleTemp.cloneStyleFrom(cellStyle);
                if (StringUtils.isBlank((CharSequence)mask)) {
                    mask = "#,##0";
                } else if ("#".equals(mask)) {
                    mask = "0";
                } else if ("#,###".equals(mask)) {
                    mask = "#,##0";
                }
                this.dealIntegerDataFormat(mask, cellStyleTemp, mask);
                this.decimalFormats.putIfAbsent(mask, new DecimalFormat(mask));
                cellStyleTemp.setAlignment(this.getAlignment(align));
                this.styleMap.put(key, cellStyleTemp);
            }
        } else {
            String sign = Boolean.TRUE.equals(dataMap.get("showSign")) ? (String)dataMap.get("sign") : "";
            int scale = (Integer)dataMap.get("scale");
            String key = styleKey + " " + sign + " " + scale + " " + mask + " " + align;
            cellStyleTemp = this.styleMap.get(key);
            if (cellStyleTemp == null) {
                if (StringUtils.isBlank((CharSequence)mask)) {
                    mask = "#,##0";
                } else {
                    int dotInx = mask.indexOf(".");
                    if (dotInx > -1) {
                        mask = mask.substring(0, dotInx - 1).concat("0");
                    } else if (mask.endsWith("#")) {
                        mask = mask.substring(0, mask.length() - 1).concat("0");
                    }
                }
                String format = sign.length() == 1 ? "_( #,##0.00_);_( -#,##0.00_)" : "#,##0.00";
                cellStyleTemp = this.wb.createCellStyle();
                cellStyleTemp.cloneStyleFrom(cellStyle);
                if (scale > 0) {
                    format = format.replaceAll("#,##0", mask).replaceAll("\\.00", String.format(".%0" + scale + "d", 0));
                    cellStyleTemp.setDataFormat(this.wb.createDataFormat().getFormat(format));
                } else {
                    this.dealIntegerDataFormat(mask, cellStyleTemp, format);
                }
                cellStyleTemp.setAlignment(this.getAlignment(align));
                this.styleMap.put(key, cellStyleTemp);
                DecimalFormat decimalFormat = new DecimalFormat(format);
                decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                decimalFormat.setMinimumFractionDigits(scale);
                this.decimalFormats.putIfAbsent(format, decimalFormat);
            }
        }
        return cellStyleTemp;
    }

    private void dealIntegerDataFormat(String mask, CellStyle cellStyleTemp, String format) {
        if ("0".equals(mask)) {
            cellStyleTemp.setDataFormat((short)1);
        } else if ("#,##0".equals(mask)) {
            cellStyleTemp.setDataFormat((short)3);
        } else {
            cellStyleTemp.setDataFormat(this.wb.createDataFormat().getFormat(format));
        }
    }

    public CellStyle getContentDecimalStyle(SXSSFWorkbook wb, Map<String, Object> dataMap) {
        CellStyle decimalStyle = this.getDecimalStyle(wb, dataMap);
        CellStyle cellStyle = this.globalContentCellStyle;
        if (cellStyle != null) {
            String style = "ExportByList_getContentDecimalStyle";
            CellStyle cellStyleTemp = this.styleMap.get(style);
            if (cellStyleTemp == null) {
                cellStyleTemp = wb.createCellStyle();
                cellStyleTemp.cloneStyleFrom(cellStyle);
                cellStyleTemp.setDataFormat(decimalStyle.getDataFormat());
                cellStyleTemp.setVerticalAlignment(decimalStyle.getVerticalAlignment());
                cellStyleTemp.setAlignment(decimalStyle.getAlignment());
                this.styleMap.put(style, cellStyleTemp);
            }
            return cellStyleTemp;
        }
        cellStyle = decimalStyle;
        return cellStyle;
    }

    public CellStyle getDecimalStyle(SXSSFWorkbook wb, Map<String, Object> dataMap) {
        return this.getDecimalStyle(wb, dataMap, DEFAULT);
    }

    @ExcludeFromJacocoGeneratedReport
    public CellStyle getDecimalStyle(SXSSFWorkbook wb, Map<String, Object> dataMap, String align) {
        CellStyle style;
        if (StringUtils.isBlank((CharSequence)align) || DEFAULT.equalsIgnoreCase(align)) {
            align = "right";
        }
        String styleKey = "DECIMAL";
        if (dataMap == null) {
            style = this.styleMap.get(styleKey + align);
            if (style == null) {
                style = wb.createCellStyle();
                style.setDataFormat((short)0);
                style.setVerticalAlignment(VerticalAlignment.CENTER);
                style.setAlignment(this.getAlignment(align));
                this.styleMap.put(styleKey + align, style);
            }
        } else if (dataMap.containsKey("sign") || dataMap.containsKey("precision")) {
            String sign = Boolean.TRUE.equals(dataMap.get("showSign")) ? (String)dataMap.get("sign") : "";
            int precision = (Integer)dataMap.get("precision");
            style = this.styleMap.get(sign + " " + precision + " " + align);
            if (style == null) {
                String format = sign.length() == 1 ? "_( #,##0.00_);_( -#,##0.00_)" : "#,##0.00";
                format = format.replaceAll("\\.00", precision > 0 ? String.format(".%0" + precision + "d", 0) : "");
                style = wb.createCellStyle();
                style.setDataFormat(wb.createDataFormat().getFormat(format));
                style.setVerticalAlignment(VerticalAlignment.CENTER);
                style.setAlignment(this.getAlignment(align));
                this.styleMap.put(sign + " " + precision + " " + align, style);
                this.decimalFormats.putIfAbsent(format, new DecimalFormat(format));
            }
        } else {
            int scale = (Integer)dataMap.get("scale");
            String key = styleKey + "#" + scale;
            style = this.styleMap.get(key);
            if (style == null) {
                String format = "0.00".replaceAll("\\.00", scale > 0 ? String.format(".%0" + scale + "d", 0) : "");
                style = wb.createCellStyle();
                style.setDataFormat(wb.createDataFormat().getFormat(format));
                style.setVerticalAlignment(VerticalAlignment.CENTER);
                style.setAlignment(this.getAlignment(align));
                this.styleMap.put(key, style);
                this.decimalFormats.putIfAbsent(format, new DecimalFormat(format));
            }
        }
        return style;
    }

    public CellStyle getDateCusStyle(String key, String entityNum, String fieldNum) {
        String style;
        CellStyle cs;
        String cusStyle = (String)this.marksTable.get((Object)entityNum, (Object)fieldNum);
        if (Objects.isNull(cusStyle)) {
            if ("date".equals(key)) {
                return this.getDateStyle();
            }
            if ("datetime".equals(key)) {
                return this.getDatetimeStyle();
            }
            cusStyle = "HH:mm:ss";
        }
        if ((cs = this.styleMap.get(style = Base64.getEncoder().encodeToString((key + cusStyle).getBytes()))) == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat(cusStyle));
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment("left"));
            this.styleMap.put(style, cs);
        }
        return cs;
    }

    private CellStyle getHeadCellStyle(String entityId, String fieldName, String mask) {
        CellStyle cellStyle = null;
        if (ObjectUtils.isNotEmpty(this.customHeadCellStyles)) {
            cellStyle = (CellStyle)this.customHeadCellStyles.get((Object)entityId, (Object)fieldName);
        }
        if (cellStyle == null && ObjectUtils.isNotEmpty((Object)this.globalHeadCellStyle)) {
            String style = Base64.getEncoder().encodeToString(mask.getBytes());
            CellStyle cellStyleTemp = this.styleMap.get(style);
            if (cellStyleTemp == null) {
                cellStyleTemp = this.wb.createCellStyle();
                cellStyleTemp.cloneStyleFrom(this.globalHeadCellStyle);
                this.styleMap.put(style, cellStyleTemp);
            }
            cellStyle = cellStyleTemp;
        }
        return cellStyle;
    }

    @ExcludeFromJacocoGeneratedReport
    private CellStyle getContentCellStyle(String entityId, String fieldName, String mask) {
        CellStyle cellStyle = null;
        if (ObjectUtils.isNotEmpty(this.customContentCellStyles)) {
            cellStyle = (CellStyle)this.customContentCellStyles.get((Object)entityId, (Object)fieldName);
        }
        if (cellStyle == null && ObjectUtils.isNotEmpty((Object)this.globalContentCellStyle)) {
            String key = "ContentTextStyle" + mask;
            String style = Base64.getEncoder().encodeToString(key.getBytes());
            CellStyle cellStyleTemp = this.styleMap.get(style);
            if (cellStyleTemp == null) {
                cellStyleTemp = this.wb.createCellStyle();
                cellStyleTemp.cloneStyleFrom(this.globalContentCellStyle);
                this.styleMap.put(style, cellStyleTemp);
            }
            cellStyle = cellStyleTemp;
        }
        return cellStyle;
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean isExistMergeCol(String entityName) {
        if (ObjectUtils.isEmpty(this.customFieldMerges)) {
            return false;
        }
        return ObjectUtils.isNotEmpty((Object)this.customFieldMerges.containsColumn((Object)entityName));
    }

    public String getMask(String entityId, String fieldName) {
        return (String)this.marksTable.get((Object)entityId, (Object)fieldName);
    }

    public String getDisplayFormatString(String entityId, String fieldName) {
        return (String)this.displayFormatStringTable.get((Object)entityId, (Object)fieldName);
    }

    public boolean getNoDisplayScaleZero(String entityId, String fieldName) {
        Boolean noDisplayScaleZero = (Boolean)this.noDisplayScaleZeroTable.get((Object)entityId, (Object)fieldName);
        return Boolean.TRUE.equals(noDisplayScaleZero);
    }

    public String parseDecimal(String format, BigDecimal decimalVal) {
        DecimalFormat decimalFormat = this.decimalFormats.get(format);
        if (ObjectUtils.isEmpty((Object)decimalFormat)) {
            decimalFormat = new DecimalFormat(format);
            this.decimalFormats.put(format, decimalFormat);
        }
        return decimalFormat.format(decimalVal);
    }
}

