/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business.export;

import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.export.ExportDataWriterFormat;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;
import kd.hr.hies.business.export.ExportSheetStyle;
import kd.hr.hies.business.export.MergeColBO;
import kd.hr.hies.common.util.ExcelUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

@ExcludeFromJacocoGeneratedReport
public class GenExportTplHeaderWriter {
    private static final Log log = LogFactory.getLog(GenExportTplHeaderWriter.class);

    public static int writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, ExportHeaderWriterFormat format, int preOffset, DynamicObject templateData, ExportDataWriterFormat dataWriterFormat, boolean existMergeCol) {
        int rowIndex = 0;
        String belongEntityName = format.getBelongEntityName();
        int mergeRow = 0;
        if (existMergeCol) {
            mergeRow = rowIndex++;
        }
        boolean needMerge = styles.isExistMergeCol(belongEntityName);
        HashMap<String, MergeColBO> mergeFirstColMap = new HashMap<String, MergeColBO>(4);
        HashMap<String, MergeColBO> mergeLastColMap = new HashMap<String, MergeColBO>(4);
        if (needMerge) {
            Table<String, String, String> customFieldMerges = styles.getCustomFieldMerges();
            Map fieldMap = customFieldMerges.row((Object)belongEntityName);
            for (Map.Entry item : fieldMap.entrySet()) {
                MergeColBO mergeColBO = new MergeColBO((String)item.getKey(), (String)item.getValue(), mergeRow, mergeRow);
                String firstField = mergeColBO.getFirstField();
                String endField = mergeColBO.getEndField();
                mergeFirstColMap.put(firstField, mergeColBO);
                mergeLastColMap.put(endField, mergeColBO);
            }
        }
        SXSSFRow titleRow = ExcelUtil.getRow(sheet, rowIndex);
        int offset = preOffset;
        int titleStartCol = format.getStartColNumber() + offset;
        for (int i = 0; i < format.getFields().size(); ++i) {
            String mask;
            int column = format.getStartColNumber() + offset;
            String displayName = "";
            String fieldName = format.getFields().get(i);
            Map<String, Object> property = format.getProperties().get(fieldName);
            if (property == null) continue;
            Object inputType = property.get("InputType");
            if ("id".equals(inputType) || "pid".equals(inputType)) {
                fieldName = fieldName.replace('.', '_');
                sheet.setDefaultColumnStyle(column, styles.getDefContentTextStyle(belongEntityName, fieldName));
            } else if ("time".equals(inputType)) {
                sheet.setDefaultColumnStyle(column, styles.getDateCusStyle("time", belongEntityName, fieldName));
            } else if ("date".equals(inputType)) {
                mask = styles.getMask(belongEntityName, fieldName);
                if ("yyyy".equalsIgnoreCase(mask)) {
                    sheet.setDefaultColumnStyle(column, styles.getDefContentDecimalStyle(belongEntityName, fieldName, "#"));
                } else {
                    sheet.setDefaultColumnStyle(column, styles.getDefContentDateStyle(belongEntityName, fieldName));
                }
            } else if ("datetime".equals(inputType)) {
                mask = styles.getMask(belongEntityName, fieldName);
                if ("yyyy".equalsIgnoreCase(mask)) {
                    sheet.setDefaultColumnStyle(column, styles.getDefContentDecimalStyle(belongEntityName, fieldName, "#"));
                } else {
                    sheet.setDefaultColumnStyle(column, styles.getDefContentDatetimeStyle(belongEntityName, fieldName));
                }
            } else if ("decimal".equals(inputType)) {
                Map dataMap = (Map)property.get("DecimalFormat");
                if (MapUtils.isNotEmpty((Map)dataMap)) {
                    dataMap.put("scale", dataMap.get("precision"));
                }
                sheet.setDefaultColumnStyle(column, styles.getDefContentDecimalStyle(belongEntityName, fieldName, dataMap));
            } else {
                if (ExcelUtil.multipleColumnsField(inputType).booleanValue()) {
                    offset = GenExportTplHeaderWriter.dealMultipleColumnsField(format, fieldName, offset, column, property, styles, wb, sheet, dataWriterFormat, titleRow, mergeFirstColMap, mergeLastColMap);
                    continue;
                }
                sheet.setDefaultColumnStyle(column, styles.getDefContentTextStyle(belongEntityName, fieldName));
            }
            displayName = ExcelUtil.getFinalFieldDisplayName(property);
            ExcelUtil.buildMergeInfo(column, column, needMerge, mergeFirstColMap, mergeLastColMap, fieldName);
            HashMap<String, Object> field = new HashMap<String, Object>(Maps.newHashMapWithExpectedSize((int)3));
            field.put("PropType", property.get("PropType"));
            field.put("InputType", inputType);
            field.put("ColumnSeq", column);
            field.put("Prop", property.get("Prop"));
            dataWriterFormat.getFields().put(fieldName, field);
            SXSSFCell cell = ExcelUtil.createCell(wb, titleRow, column, styles.getHeadTextStyle(belongEntityName, fieldName));
            cell.setCellValue(displayName);
            Object colWidth = property.get("ColWidth");
            int designatedColWidth = colWidth instanceof Integer ? (Integer)colWidth : 0;
            sheet.setColumnWidth(column, ExcelUtil.calcColumnWidth(displayName, designatedColWidth));
            ++offset;
        }
        int titleEndCol = format.getStartColNumber() + offset - 1;
        ExcelUtil.doMerge(sheet, styles, titleEndCol, mergeFirstColMap, titleRow, titleStartCol, existMergeCol);
        for (ExportHeaderWriterFormat wr : format.getNext()) {
            ExportDataWriterFormat dataWriterFormatnext = new ExportDataWriterFormat();
            dataWriterFormatnext.setEnityName(wr.getEnityName());
            dataWriterFormatnext.setMainEntity(wr.isMainEntity());
            dataWriterFormatnext.setEntryentity(wr.isEntryentity());
            offset += GenExportTplHeaderWriter.writeHeader(wb, sheet, styles, wr, preOffset, templateData, dataWriterFormatnext, existMergeCol);
            dataWriterFormat.getNext().add(dataWriterFormatnext);
        }
        return offset;
    }

    private static int dealMultipleColumnsField(ExportHeaderWriterFormat format, String fieldName, int offset, int column, Map<String, Object> property, ExportSheetStyle styles, SXSSFWorkbook wb, SXSSFSheet sheet, ExportDataWriterFormat dataWriterFormat, SXSSFRow titleRow, Map<String, MergeColBO> mergeFirstColMap, Map<String, MergeColBO> mergeLastColMap) {
        String sourceInputType = (String)property.get("InputType");
        String mainEntityName = format.getBelongEntityName();
        boolean needMerge = styles.isExistMergeCol(mainEntityName);
        List<String> splitCols = format.getFlexColumn().get(fieldName);
        List<String> splitColDisplayNames = format.getFlexColumnDisplay().get(fieldName);
        int splitStartColumn = format.getStartColNumber() + offset;
        if (splitCols != null) {
            for (int j = 0; j < splitCols.size(); ++j) {
                column = format.getStartColNumber() + offset;
                String itemKey = splitCols.get(j);
                String displayName = ExcelUtil.getFinalSplitFieldDisplayName(itemKey, j, property, false, splitColDisplayNames);
                sheet.setDefaultColumnStyle(column, styles.getTextStyle());
                HashMap field = Maps.newHashMapWithExpectedSize((int)16);
                field.put("PropType", property.get("PropType"));
                field.put("InputType", sourceInputType);
                field.put("ColumnSeq", column);
                IDataEntityProperty fldProperty = (IDataEntityProperty)property.get("Prop");
                field.put("Prop", fldProperty);
                if ("basedata".equalsIgnoreCase(sourceInputType)) {
                    GenExportTplHeaderWriter.setF7FieldInputType(field, itemKey, fldProperty, property);
                }
                dataWriterFormat.getFields().put(itemKey, field);
                SXSSFCell cell = ExcelUtil.createCell(wb, titleRow, format.getStartColNumber() + offset, styles.getHeadTextStyle(mainEntityName, fieldName));
                cell.setCellValue(displayName);
                Object colWidth = property.get("ColWidth");
                int designatedColWidth = colWidth instanceof Integer ? (Integer)colWidth : 0;
                sheet.setColumnWidth(column, ExcelUtil.calcColumnWidth(displayName, designatedColWidth));
                ++offset;
            }
        }
        ExcelUtil.buildMergeInfo(splitStartColumn, column, needMerge, mergeFirstColMap, mergeLastColMap, fieldName);
        return offset;
    }

    private static boolean isF7BaseData(IDataEntityProperty fldProperty, String itemKey) {
        String[] split = StringUtils.split((String)itemKey, (String)".");
        String towKey = split[split.length - 1];
        BasedataEntityType type = (BasedataEntityType)((IBasedataField)fldProperty).getComplexType();
        for (IDataEntityProperty refProp : type.getProperties()) {
            if (!(refProp instanceof IBasedataField) || !refProp.getName().equalsIgnoreCase(towKey)) continue;
            return true;
        }
        return false;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void setF7FieldInputType(Map<String, Object> field, String itemKey, IDataEntityProperty fldProperty, Map<String, Object> property) {
        if (GenExportTplHeaderWriter.isF7BaseData(fldProperty, itemKey)) {
            field.put("baseDataFormat", "name");
        } else if (fldProperty.getName().equalsIgnoreCase(itemKey)) {
            field.put("baseDataFormat", "number_name");
        } else {
            String[] split;
            Map f7ReferAttrsProp = (Map)property.get("f7Prop");
            IDataEntityProperty prop = (IDataEntityProperty)f7ReferAttrsProp.get((split = StringUtils.split((String)itemKey, (String)"."))[1]);
            if (prop instanceof TimeProp) {
                field.put("InputType", "time");
            } else if (prop instanceof DateProp) {
                field.put("InputType", "date");
            } else if (prop instanceof DateTimeProp) {
                field.put("InputType", "datetime");
            } else if (prop instanceof ComboProp) {
                field.put("InputType", "dropdownList");
            } else {
                field.put("InputType", "varchar");
            }
        }
    }
}

