/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business.taskinfo;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRAssert;
import kd.hr.hbp.common.util.time.CostTimeHelper;
import kd.hr.hies.business.HiesRedisKey;
import kd.hr.hies.business.taskinfo.IHIESDiaeTaskInfoService;
import kd.hr.hies.common.bo.MetaMenuBO;
import kd.hr.hies.common.dto.TaskInfo;
import kd.hr.hies.common.util.MetaMenuUtil;
import org.apache.commons.beanutils.BeanMap;

public class HIESDiaeTaskInfoService
implements IHIESDiaeTaskInfoService {
    private static final Log LOGGER = LogFactory.getLog(HIESDiaeTaskInfoService.class);
    private final HRBaseServiceHelper dbService = HRBaseServiceHelper.create((String)"hies_taskinfo");
    private static final DistributeSessionlessCache REDIS_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.cacheLock.writeLock();
    private final String taskNoRedisKey = HiesRedisKey.TASK_NUMBER.getValue();
    private final String taskNoRedisLockKey = HiesRedisKey.TASK_NUMBER_LOCK.getValue();
    private static MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"hies_taskinfo");

    @Override
    public boolean doUpdate(TaskInfo taskInfo) {
        HRAssert.notNull((Object)taskInfo, (String)"param[taskInfo] cannot be empty", (Object[])new Object[0]);
        CostTimeHelper costTimeHelper = CostTimeHelper.create();
        Long pkId = taskInfo.getId();
        DynamicObject dynamicObject = this.dbService.generateEmptyDynamicObject();
        BeanMap beanMap = new BeanMap((Object)taskInfo);
        HIESDiaeTaskInfoService.mapTranDyn(dynamicObject, beanMap);
        if (pkId == null) {
            String taskId = taskInfo.getTaskid();
            HRAssert.notBlank((String)taskId, (String)"paramObject[taskInfo] field[taskid] must be not empty", (Object[])new Object[0]);
            dynamicObject.set("id", (Object)this.getFid(taskId));
        }
        SaveServiceHelper.update((DynamicObject)dynamicObject);
        costTimeHelper.logCost("HIESDiaeTaskInfoService#doUpdate");
        return true;
    }

    @Override
    public long doInsert(TaskInfo taskInfo) {
        CostTimeHelper costTimeHelper = CostTimeHelper.create();
        taskInfo.setSerialno(this.genSerialNo());
        DynamicObject dynamicObject = this.dbService.generateEmptyDynamicObject();
        String entityId = taskInfo.getEntityid();
        LOGGER.info("entityId:{} appId:{} serviceAppId:{}", new Object[]{entityId, taskInfo.getAppid(), taskInfo.getServiceAppId()});
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            String appId = taskInfo.getAppid();
            if (StringUtils.isNotBlank((CharSequence)appId)) {
                dynamicObject.set("oprpage", (Object)MetaMenuUtil.warpOprPageInfo(appId, entityId, taskInfo.getServiceAppId()));
                String businessField = MetaMenuUtil.getBusinessField(appId);
                if (StringUtils.isNotBlank((CharSequence)businessField)) {
                    dynamicObject.set("businessfield", (Object)businessField);
                } else {
                    LOGGER.warn("page appId:{} businessfield is null", (Object)appId);
                }
                dynamicObject.set("app", (Object)MetaMenuUtil.getAppId(appId));
            } else {
                MetaMenuBO metaMenuBO = new MetaMenuBO();
                metaMenuBO.setFormId(entityId);
                metaMenuBO.setServiceAppId(taskInfo.getServiceAppId());
                dynamicObject.set("oprpage", (Object)SerializationUtils.toJsonString((Object)metaMenuBO));
                LOGGER.warn("page entityId:{} appId is null", (Object)entityId);
            }
            taskInfo.setEntityid(null);
            taskInfo.setAppid(null);
            taskInfo.setServiceAppId(null);
        }
        BeanMap beanMap = new BeanMap((Object)taskInfo);
        HIESDiaeTaskInfoService.mapTranDyn(dynamicObject, beanMap);
        DynamicObject dynObj = (DynamicObject)this.dbService.saveOne(dynamicObject);
        costTimeHelper.logCost("HIESDiaeTaskInfoService#doInsert");
        return (Long)dynObj.get("id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    private String genSerialNo() {
        String serialNo;
        block21: {
            String todayStartNumber = DateUtils.dateToString((Date)new Date(), (DatePattern)DatePattern.YYYY_MM_DD_PURE).concat("00000");
            try {
                this.readLock.lock();
                String redisVal = (String)REDIS_CACHE.get(this.taskNoRedisKey);
                if (redisVal == null || todayStartNumber.compareTo(redisVal) > 0) {
                    try {
                        this.readLock.unlock();
                        this.writeLock.lock();
                        redisVal = (String)REDIS_CACHE.get(this.taskNoRedisKey);
                        if (redisVal == null || todayStartNumber.compareTo(redisVal) > 0) {
                            try (DLock lock = DLock.create((String)this.taskNoRedisLockKey);){
                                lock.lock();
                                REDIS_CACHE.put(this.taskNoRedisKey, (Object)todayStartNumber);
                            }
                        }
                        serialNo = String.valueOf(REDIS_CACHE.inc(this.taskNoRedisKey));
                        break block21;
                    }
                    finally {
                        this.readLock.lock();
                        this.writeLock.unlock();
                    }
                }
                serialNo = String.valueOf(REDIS_CACHE.inc(this.taskNoRedisKey));
            }
            finally {
                this.readLock.unlock();
            }
        }
        return serialNo;
    }

    private static void mapTranDyn(DynamicObject targetDyn, BeanMap sourceBeanMap) {
        HRAssert.notNull((Object)targetDyn, (String)"param[targetDyn] cannot be empty", (Object[])new Object[0]);
        HRAssert.notNull((Object)sourceBeanMap, (String)"param[sourceBeanMap] cannot be empty", (Object[])new Object[0]);
        for (Object o : sourceBeanMap.entrySet()) {
            Object value;
            Map.Entry entry = (Map.Entry)o;
            if ("class".equals(entry.getKey()) || (value = entry.getValue()) == null) continue;
            targetDyn.set(String.valueOf(entry.getKey()), value);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private Long getFid(String taskId) {
        DynamicObject resultDyn = this.dbService.queryOriginalOne("id", new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        HRAssert.notNull((Object)resultDyn, (String)String.format("query result is null, please check param[taskid=%s] is correct", taskId), (Object[])new Object[0]);
        return resultDyn.getLong("id");
    }

    @Override
    public void showHistory(IFormView view, String oprType) {
        String billFormId;
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hies_taskinfo");
        showParameter.setFormId("bos_list");
        showParameter.setLookUp(false);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("oprtype", (Object)oprType);
        showParameter.setCustomParam("isHyperlink4Oprtype", (Object)Boolean.FALSE);
        showParameter.getCustomParams().putAll(view.getFormShowParameter().getCustomParams());
        showParameter.setCustomParam("checkRightAppId", (Object)"15NPDX/GJFOO");
        IFormView parentView = view.getParentView();
        String queryEntityId = null;
        if (parentView instanceof ListView) {
            MainEntityType mainType;
            IListView listview = (IListView)parentView;
            FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
            billFormId = config.getEntityTypeId();
            if ("list".equalsIgnoreCase(config.getModelType()) && (mainType = EntityMetadataCache.getDataEntityType((String)billFormId)) instanceof QueryEntityType) {
                QueryEntityType queryType = (QueryEntityType)mainType;
                billFormId = queryType.getMainEntityType().getName();
                queryEntityId = ((ListView)parentView).getEntityTypeId();
            }
        } else {
            billFormId = parentView.getEntityId();
        }
        showParameter.setCustomParam("oprFormId", (Object)billFormId);
        view.showForm((FormShowParameter)showParameter);
    }
}

